#ifndef CONTEXT_CSD_EVENT_H_INCLUDED
#define CONTEXT_CSD_EVENT_H_INCLUDED 1

#include <bbdata.h>
#include <concretedata.h>
#include <context_uids.h>

const TTypeName KEventType = { { CONTEXT_UID_SENSORDATAFACTORY }, 10, 1, 0 };
const TTypeName KTupleType = { { CONTEXT_UID_SENSORDATAFACTORY }, 7, 1, 0 };
const TTypeName KSubNameType = { { CONTEXT_UID_SENSORDATAFACTORY }, 8, 1, 0 };
const TTypeName KTupleMetaType = { { CONTEXT_UID_SENSORDATAFACTORY }, 9, 1, 0 };

const TTupleName KAppEventTuple = { { CONTEXT_UID_CONTEXTSENSORS }, 19 };
const TTupleName KCellAnnotationTuple = { { CONTEXT_UID_CONTEXTSENSORS }, 20 };
const TTupleName KWebSearchTuple = { { CONTEXT_UID_CONTEXTSENSORS }, 21 };

const TTupleName KStatusTuple = { { CONTEXT_UID_CONTEXTSENSORS }, 36 };

const TTupleName KAnySensorEvent = { { CONTEXT_UID_CONTEXTSENSORS }, 0 };

_LIT(KStamp, "datetime");
_LIT(KEvent, "event");
_LIT(KPriority, "priority");
_LIT(KId, "id");
_LIT(KMeta, "tuplename");
_LIT(KModuleUid, "module_uid");
_LIT(KModuleId, "module_id");
_LIT(KSubName, "subname");


class CBBSensorEvent : public CBase, public TBBCompoundData {
public:
	enum TPriority {
		INFO,
		DEBUG,
		VALUE,
		UNCHANGED_VALUE,
		ERR
	};

	TBBTime			iStamp;
	TBBInt			iPriority;
	TBBShortString		iName;
	CBBGeneralHolder	iData;

	IMPORT_C const TTupleName& TupleName() const;
        IMPORT_C const TDesC&    Name() const;

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	IMPORT_C static const TTypeName& StaticType();
	IMPORT_C const MBBData* Part(TUint aPartNo) const;

	IMPORT_C CBBSensorEvent(const TDesC& aName, const TTupleName& aTupleName, 
		MBBDataFactory* aFactory=0, TTime aTime=TTime(0), MBBData* iData=0, TPriority aPriority=VALUE);

	IMPORT_C bool operator==(const CBBSensorEvent& aRhs) const;
	IMPORT_C virtual const TDesC& StringSep(TUint aBeforePart) const;

	IMPORT_C CBBSensorEvent& operator=(const CBBSensorEvent& aSensorEvent);
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
private:
	IMPORT_C MBBData* GetPart(const TDesC& aName, const TTypeName& aType, TUint& aPartNoInto);
	MBBDataFactory*	iFactory;
	const TTupleName& iTupleName;
};

class TBBTupleSubName  : public TBBFixedLengthStringBase {
public:
	TBuf<128> iValue;
        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C static const TTypeName& StaticType();

	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	TDes& operator()() { return iValue; }
	const TDesC& operator()() const { return iValue; }

	virtual TDes& Value() { return iValue; }
	virtual const TDesC& Value() const  { return iValue; }
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
public:
	TBBTupleSubName(const TDesC& aName) : TBBFixedLengthStringBase(aName) { }
	TBBTupleSubName(const TDesC& aValue, const TDesC& aName) : TBBFixedLengthStringBase(aName) { iValue=aValue.Left(128); }
	TBBTupleSubName& operator=(const TDesC& aValue) { iValue=aValue.Left(128); return *this; }
	bool operator==(const TBBTupleSubName& aRhs) const { return !(iValue.Compare(aRhs.iValue)); }
};

class TBBTupleMeta : public TBBCompoundData {
public:
	TBBUid			iModuleUid;
	TBBInt			iModuleId;
	TBBTupleSubName		iSubName;

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	IMPORT_C static const TTypeName& StaticType();
	IMPORT_C const MBBData* Part(TUint aPartNo) const;

	IMPORT_C TBBTupleMeta();
	IMPORT_C TBBTupleMeta(TInt aModuleUid, TInt aModuleId,
		const TDesC& aSubName);

	IMPORT_C bool operator==(const TBBTupleMeta& aRhs) const;
	virtual const TDesC& StringSep(TUint aBeforePart) const;
	IMPORT_C TBBTupleMeta& operator=(const TBBTupleMeta& aMetaData);
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
};

class CBBTuple : public CBase, public TBBCompoundData {
public:
	TBBUint			iTupleId;
	TBBTupleMeta		iTupleMeta;
	CBBGeneralHolder	iData;

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	IMPORT_C static const TTypeName& StaticType();
	IMPORT_C const MBBData* Part(TUint aPartNo) const;

	IMPORT_C CBBTuple(MBBDataFactory* aFactory,
		TUint iTupleId=0, TInt aModuleUid=0, TInt aModuleId=0,
		const TDesC& aSubName=KNullDesC, MBBData* aData=0);

	IMPORT_C bool operator==(const CBBTuple& aRhs) const;
	virtual const TDesC& StringSep(TUint aBeforePart) const;

	IMPORT_C CBBTuple& operator=(const CBBTuple& aTuple);
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
private:
	MBBData* GetPart(const TDesC& aName, const TTypeName& aType, TUint& aPartNoInto);
	MBBDataFactory*	iFactory;
};

#endif
