#ifndef CONTEXT_CSD_GPS_H_INCLUDED
#define CONTEXT_CSD_GPS_H_INCLUDED 1

#include <bbdata.h>
#include <concretedata.h>
#include <context_uids.h>

const TTypeName KGpsLineType = { { CONTEXT_UID_SENSORDATAFACTORY }, 12, 1, 0 };
const TTupleName KGpsTuple = { { CONTEXT_UID_CONTEXTSENSORS }, 12 };

_LIT(KGpsLine, "gps.nmea");
_LIT(KGps, "gps");

class TGpsLine : public TBBFixedLengthStringBase {
public:
	TBuf<200> iValue;
        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C static const TTypeName& StaticType();

	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	TDes& operator()() { return iValue; }
	const TDesC& operator()() const { return iValue; }

	virtual TDes& Value() { return iValue; }
	virtual const TDesC& Value() const  { return iValue; }
	IMPORT_C TGpsLine& operator=(const TGpsLine& aGpsLine);
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
public:
	TGpsLine() : TBBFixedLengthStringBase(KGpsLine) { }
	TGpsLine& operator=(const TDesC& aValue) { iValue=aValue.Left(200); return *this; }
	bool operator==(const TGpsLine& aRhs) const { return !(iValue.Compare(aRhs.iValue)); }
};


#endif
