#ifndef CONTEXT_CSD_LOCA_H_INCLUDED
#define CONTEXT_CSD_LOCA_H_INCLUDED 1

#include <bbdata.h>
#include <concretedata.h>
#include <context_uids.h>
#include "csd_bluetooth.h"

const TTypeName KLocaMessageStatusType = { { CONTEXT_UID_SENSORDATAFACTORY }, 35, 1, 0 };

const TTupleName KLocaMessageStatusTuple = { { CONTEXT_UID_CONTEXTSENSORS }, 35 };

_LIT(KLocaMsgStatus, "loca.message_status");

class TBBLocaMsgStatus : public TBBCompoundData  {
public:
	TBBInt			iMessageId;
	TBBBluetoothAddress	iRecipientAddress;
	TBBBool			iSucceeded;
	TBBTime			iAtTime;

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	IMPORT_C static const TTypeName& StaticType();
	IMPORT_C const MBBData* Part(TUint aPartNo) const;

	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
public:
	IMPORT_C TBBLocaMsgStatus();
	IMPORT_C TBBLocaMsgStatus(const TBBLocaMsgStatus& aFrom);
	virtual const TDesC& StringSep(TUint aBeforePart) const;

	IMPORT_C bool operator==(const TBBLocaMsgStatus& aRhs) const;
	IMPORT_C TBBLocaMsgStatus& operator=(const TBBLocaMsgStatus& aRhs);
};

#endif
