#ifndef CONTEXT_CSD_PRESENCE_H_INCLUDED
#define CONTEXT_CSD_PRESENCE_H_INCLUDED 1

#include "csd_cell.h"
#include "csd_base.h"
#include "csd_idle.h"
#include "csd_profile.h"
#include "csd_bluetooth.h"
#include "csd_gps.h"
#include "csd_calendar.h"
#include "csd_unread.h"

const TTypeName KUserGivenType = { { CONTEXT_UID_SENSORDATAFACTORY }, 33, 1, 0 };
const TTupleName KUserGivenContextTuple = { { CONTEXT_UID_CONTEXTSENSORS }, 33 };
_LIT(KPresence, "presencev2");

const TTupleName KAlarmTuple = { { CONTEXT_UID_CONTEXTSENSORS }, 41 };
_LIT(KAlarm, "alarm");

class TBBUserGiven : public TBBCompoundData {
public:
	TBBLongString		iDescription;
	TBBTime			iSince;

	IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	IMPORT_C static const TTypeName& StaticType();
	IMPORT_C const MBBData* Part(TUint aPartNo) const;

	IMPORT_C TBBUserGiven(const TDesC& aName);

	IMPORT_C bool operator==(const TBBUserGiven& aRhs) const;
	virtual const TDesC& StringSep(TUint aBeforePart) const;

	IMPORT_C TBBUserGiven& operator=(const TBBUserGiven& aBattery);
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
};

const TTypeName KPresenceType1 = { { CONTEXT_UID_SENSORDATAFACTORY }, 31, 1, 0 };
const TTypeName KPresenceType = { { CONTEXT_UID_SENSORDATAFACTORY }, 31, 2, 0 };
const TTupleName KPresenceTuple = { { CONTEXT_UID_CONTEXTSENSORS }, 31 };

class CBBPresence : public CBase, public TBBCompoundData {
public:
	TBBCellId	iCellId;
	TBBBaseInfo	iBaseInfo;
	TBBUserActive	iUserActive;
	TBBProfile	iProfile;
	CBBBtDeviceList*	iDevices;
	TGpsLine	iGps;
	TBBNeighbourhoodInfo iNeighbourhoodInfo;
	TBBUserGiven	iUserGiven;
	TBBTime		iSentTimeStamp;
	TBBCalendar	iCalendar;
	TBBUnread	iUnread;
	TBBTime		iAlarm;

	TBool		iSent;

	IMPORT_C void SetDevices(const CBBBtDeviceList* aList); // clones the list

	IMPORT_C void AddRef();
	IMPORT_C void Release();
	IMPORT_C void ConstructL();

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	IMPORT_C static const TTypeName& StaticType();
	IMPORT_C const MBBData* Part(TUint aPartNo) const;
	IMPORT_C CBBPresence();
	IMPORT_C CBBPresence(TUint aVersion);
	IMPORT_C virtual const TDesC& StringSep(TUint aBeforePart) const;

	IMPORT_C bool operator==(const CBBPresence& aRhs) const;
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
	IMPORT_C CBBPresence& operator=(const CBBPresence& aRhs);

	IMPORT_C static CBBPresence* NewL(TUint aVersion);
	IMPORT_C static CBBPresence* NewL();
	IMPORT_C ~CBBPresence();
	IMPORT_C virtual void InternalizeL(RReadStream& aStream);

private:
	TUint	iRefCount;
	TUint	iUseVersion, iCreatedVersion;
};

#endif
