#ifndef CONTEXT_CSD_PROFILE_H_INCLUDED
#define CONTEXT_CSD_PROFILE_H_INCLUDED 1

#include <bbdata.h>
#include <concretedata.h>
#include <context_uids.h>

_LIT(KProfile, "profile");
_LIT(KProfileId, "profile.id");
_LIT(KProfileName, "profile.name");
_LIT(KProfileRingType, "profile.ringtype");
_LIT(KProfileRingVolume, "profile.ringvolume");
_LIT(KProfileVibra, "profile.vibra");

const TTypeName KProfileType = { { CONTEXT_UID_SENSORDATAFACTORY }, 13, 1, 0 };
const TTupleName KProfileTuple = { { CONTEXT_UID_CONTEXTSENSORS }, 13 };

class TBBProfile : public TBBCompoundData  {
public:
	TBBInt	iProfileId;
	TBBShortString iProfileName;
	TBBInt	iRingingType;
	TBBInt	iRingingVolume;
	TBBBool	iVibra;

	enum TRingingTypes
            {
            ERingingTypeRinging = 0,
            ERingingTypeAscending,
            ERingingTypeRingOnce,
            ERingingTypeBeepOnce,
            ERingingTypeSilent
            };

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	IMPORT_C static const TTypeName& StaticType();
	IMPORT_C const MBBData* Part(TUint aPartNo) const;
	IMPORT_C TBBProfile();
	virtual const TDesC& StringSep(TUint aBeforePart) const;

	IMPORT_C bool operator==(const TBBProfile& aRhs) const;
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
	IMPORT_C TBBProfile& operator=(const TBBProfile& aProfile);
};

#endif
