#ifndef CONTEXT_CSD_SYSTEM_H_INCLUDED
#define CONTEXT_CSD_SYSTEM_H_INCLUDED 1

#include <bbdata.h>
#include <concretedata.h>
#include <context_uids.h>

_LIT(KState, "state");

const TTypeName KSysEventType = { { CONTEXT_UID_SENSORDATAFACTORY }, 14, 1, 0 };
const TTupleName KSysEventTuple = { { CONTEXT_UID_CONTEXTSENSORS }, 14 };
const TTupleName KChargerTuple = { { CONTEXT_UID_CONTEXTSENSORS }, 15 };
const TTupleName KNetworkTuple = { { CONTEXT_UID_CONTEXTSENSORS }, 16 };
//const TTupleName KBatteryTuple = { { CONTEXT_UID_CONTEXTSENSORS }, 17 };
const TTupleName KBtConnectionsTuple = { { CONTEXT_UID_CONTEXTSENSORS }, 28 };
const TTupleName KBtSearchTuple = { { CONTEXT_UID_CONTEXTSENSORS }, 29 };

class TBBSysEvent : public TBBCompoundData {
public:
	TBBUid		iUid;
	TBBInt		iState;

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	IMPORT_C static const TTypeName& StaticType();
	IMPORT_C const MBBData* Part(TUint aPartNo) const;

	IMPORT_C TBBSysEvent(const TDesC& aName);

	IMPORT_C bool operator==(const TBBSysEvent& aRhs) const;
	virtual const TDesC& StringSep(TUint aBeforePart) const;
	IMPORT_C TBBSysEvent& operator=(const TBBSysEvent& aSysEvent);
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
};

#endif