#ifndef CONTEXT_CSD_UNREAD_H_INCLUDED
#define CONTEXT_CSD_UNREAD_H_INCLUDED 1

#include <bbdata.h>
#include <concretedata.h>
#include <context_uids.h>

const TTypeName KUnreadType = { { CONTEXT_UID_SENSORDATAFACTORY }, 40, 1, 0 };
const TTupleName KUnreadTuple = { { CONTEXT_UID_CONTEXTSENSORS }, 40 };

_LIT(KUnread, "unread");

class TBBUnread : public TBBCompoundData {
public:
	TBBInt			iUnreadMessages;
	TBBTime			iUnreadSince;
	TBBInt			iUnansweredCalls;
	TBBTime			iUnansweredSince;

	IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	IMPORT_C static const TTypeName& StaticType();
	IMPORT_C const MBBData* Part(TUint aPartNo) const;

	IMPORT_C TBBUnread();

	IMPORT_C bool operator==(const TBBUnread& aRhs) const;
	virtual const TDesC& StringSep(TUint aBeforePart) const;

	IMPORT_C TBBUnread& operator=(const TBBUnread& aRhs);
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
};

#endif
