#ifndef CL_CURRENT_LOC_H_INCLUDED
#define CL_CURRENT_LOC_H_INCLUDED 1

#include <e32std.h>
#include "log_base_impl.h"
#include <app_context.h>
#include "circular.h"
#include <symbian_auto_ptr.h>
#include <symbian_tree.h>
#include <csd_cell.h>

class CCurrentLoc : public CBase, public Mlog_base_impl {
public:
	EXPORT_C static CCurrentLoc* NewL(MApp_context& Context, CGenericIntMap* acellid_names);
	EXPORT_C virtual ~CCurrentLoc();

	virtual CCircularLog*	BaseLog() = 0;
	virtual void now_at_location(const TBBCellId* cellid, TInt id, bool is_base, bool loc_changed, TTime time) = 0;
	virtual void EmptyLog() = 0;
	virtual TInt CurrentBaseId() = 0; // returns -1 if not at base
protected:
	CCurrentLoc(MApp_context& Context);
};

#endif
