/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


// Mlogger.h: interface for the Mlogger class.
//
//////////////////////////////////////////////////////////////////////

#ifndef CL_I_LOGGER_H_INCLUDED
#define CL_I_LOGGER_H_INCLUDED 1

#include <e32std.h>

#include <csd_event.h>
#include <cbbsession.h>

class Mlogger : public MBBObserver
{
public:
	virtual ~Mlogger() { delete iBBSubSessionNotif; };
	virtual void NewSensorEventL(const TTupleName& aName, 
		const TDesC& aSubName, const CBBSensorEvent& aEvent) = 0;
	virtual void SubscribeL(const TTupleName& aTuple) {
		iBBSubSessionNotif->AddNotificationL(aTuple);
	}
protected:
	void ConstructL(MApp_context_access& Context) {
		iBBSubSessionNotif=Context.BBSession()->CreateSubSessionL(this);
	}
	CBBSubSession*	iBBSubSessionNotif;
private:
	virtual void NewValueL(TUint , const TTupleName& aName, const TDesC& aSubName, 
		const TComponentName& /*aComponent*/,
		const MBBData* aData) {
		const CBBSensorEvent* e=bb_cast<CBBSensorEvent>(aData);
		if (e) NewSensorEventL(aName, aSubName, *e);
	}
	virtual void NewValueL(const TComponentName& /*aName*/, const MBBData* /*aData*/) {
		User::Leave(KErrNotSupported);
	}
	friend class Mlog_base_impl;
};

#endif // !defined(CL_I_LOGGER_H_INCLUDED)
