/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef LOG_BASE_IMPL_H_INCLUDED

#define LOG_BASE_IMPL_H_INCLUDED

#include "i_log_source.h"
#include <e32base.h>
#include <f32file.h>
#include "i_logger.h"
#include <app_context.h>

#include <csd_event.h>
#include <cbbsession.h>

class Mlog_base_impl : public i_log_source, public MContextBase {
public:
	IMPORT_C void add_sinkL(Mlogger* sink);
	IMPORT_C virtual void ConstructL();
	IMPORT_C Mlog_base_impl(MApp_context& Context, const TDesC& aName, const TTupleName& aTupleName);
	IMPORT_C virtual ~Mlog_base_impl();
	IMPORT_C virtual const CBBSensorEvent& get_value();
	IMPORT_C void post_new_value(const CBBSensorEvent& aEvent);
	IMPORT_C void post_new_value(CBBSensorEvent& aEvent);
	IMPORT_C void post_error(const TDesC& aMsg, TInt aCode, const TTime& time);
	IMPORT_C void post_error(const TDesC& aMsg, TInt aCode);
	IMPORT_C void post_new_value(MBBData* aData);
	IMPORT_C void post_new_value(MBBData* aData, const TTime& time);
protected:
	//CArrayFixFlat<Mlogger*>* loggers;
	CBBSensorEvent	iEvent;
	CBBSubSession	*iBBSubSession;
};

class Clog_base_impl : public CBase, public Mlog_base_impl {
public:
	IMPORT_C Clog_base_impl(MApp_context& Context, const TDesC& aName, const TTupleName& aTupleName);
	IMPORT_C static Clog_base_impl* NewL(MApp_context& Context, const TDesC& aName, const TTupleName& aTupleName);
};

#endif
