/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#if !defined(LOG_PROFILE_H_INCLUDED)

#define LOG_PROFILE_H_INCLUDED

#include "i_log_source.h"
#include "log_base_impl.h"

#include <saclient.h>
#include <app_context.h>
#include <timeout.h>
#include <csd_profile.h>

class Clog_profile : public CCheckedActive, public Mlog_base_impl, public MTimeOut{
public:
	IMPORT_C ~Clog_profile();

	IMPORT_C static Clog_profile* NewL(MApp_context& Context);
	IMPORT_C int get_current_profile();
	IMPORT_C const CBBSensorEvent& get_value();
private:
	void DoCancel();
	virtual TInt CheckedRunError(TInt aError);
	void CheckedRunL();

	void expired(CBase* Source);

	Clog_profile(MApp_context& Context);
	void ConstructL();


	int prev_profile;
	TBBProfile iProfile;

	CArrayFixFlat<TSysAgentCondition>* aConditions;
	TInt get_profile_via_profilapi();
	TBuf<10> iVibraDescr;
	void listen_for_notification();
	CTimeOut *iWait;
	RSystemAgent	iSysAgent; bool iAgentIsOpen;
	TInt	iErrorCount;
};

#endif
