/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef CL_PICTURE_PUBLISHER_H_INCLUDED
#define CL_PICTURE_PUBLISHER_H_INCLUDED 1

#include "i_logger.h"
#include <app_context.h>
#include <transferdir2.h>

class TOldPrompt : public MUploadPrompt {
public:
	IMPORT_C TOldPrompt(bool Delete=true);
	IMPORT_C virtual void Prompt(const TDesC& FileName, MUploadCallBack* CallBack);
private:
	bool	iDelete;
};



class CPicturePublisher: public CCheckedActive, public Mlogger {
public:
	CPicturePublisher();
	IMPORT_C static CPicturePublisher* NewL(MApp_context& Context, i_status_notif& notif,
		const TDesC& Path, const TDesC& Files, 
		TInt SettingPublish, TInt SettingValue, 
		TInt aUrlSetting, TInt aScriptSetting,
		MUploadPrompt& Prompt, MUploadPrompt& OldPrompt,
		CTransferDir*	aTransferDir,
		const TDesC& AdditionalFiles=KNullDesC);
	virtual void PublishOld() = 0;
	IMPORT_C ~CPicturePublisher();
};

#endif // CL_PICTURE_PUBLISHER_H_INCLUDED
