/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "bases.h"
#ifdef __WINS__
const unsigned short* bases::test_data[10000] [2] = {
	{ L"20030126:114540", L"9006, 90017, RADIOLINJA" },
	//
#if 1
	{ L"20030126:144540", L"9006, 18, RADIOLINJA" },
	// Tktl
	{ L"20030126:154540", L"9006, 90018, RADIOLINJA" },
	// last: Tktl
	{ L"20030126:154840", L"9006, 18, RADIOLINJA" },
	// Tktl, from 1444540
	{ L"20030126:164840", L"9006, 90019, RADIOLINJA" },
	// last: Tktl
	{ L"20030126:165840", L"9006, 15300, RADIOLINJA" },
	// Home:
	{ L"20030126:172840", L"9006, 90020, RADIOLINJA" },
	// last: Home
	{ L"20030126:173840", L"9112, 40627, RADIOLINJA" },
	// P&j
	{ L"20030126:184840", L"9006, 90021, RADIOLINJA" },
	// last P&j
	{ L"20030126:185840", L"9006, 18, RADIOLINJA" },
	// Tktl
	{ L"20030126:190240", L"9006, 15300, RADIOLINJA" },
	// Home, last: P&j
#else
	{ L"20030126:144540", L"SWITCH" },
	{ L"20030126:180946", L"9006, 399, RADIOLINJA" },
	{ L"20030126:182200", L"0, 0, RADIOLINJA" },
	{ L"20030126:182419", L"9006, 601, RADIOLINJA" },
	{ L"20030126:182507", L"9006, 1493, RADIOLINJA" },
	{ L"20030126:182516", L"9006, 601, RADIOLINJA" },
	{ L"20030126:182657", L"0, 0, " },
	{ L"20030126:182722", L"9006, 601, RADIOLINJA" },
	{ L"20030126:182736", L"9006, 1493, RADIOLINJA" },
	{ L"20030126:182748", L"9006, 550, RADIOLINJA" },
#endif
	{ L"20030126:183031", L"9006, 38583, RADIOLINJA" },
	{ L"20030126:183040", L"9006, 232, RADIOLINJA" },
	{ L"20030126:183154", L"9006, 233, RADIOLINJA" },
	{ L"20030126:183257", L"9006, 3900, RADIOLINJA" },
	{ L"20030126:183340", L"9006, 511, RADIOLINJA" },
	{ L"20030126:183514", L"9006, 67, RADIOLINJA" },
	{ L"20030126:183721", L"9000, 15128, RADIOLINJA" },
	{ L"20030126:183815", L"9006, 67, RADIOLINJA" },
	{ L"20030126:183830", L"9000, 35781, RADIOLINJA" },
	{ L"20030126:183849", L"9000, 168, RADIOLINJA" },
	{ L"20030126:183903", L"9000, 62019, RADIOLINJA" },
	{ L"20030126:183953", L"9000, 440, RADIOLINJA" },
	{ L"20030126:184013", L"9000, 188, RADIOLINJA" },
	{ L"20030126:184153", L"9000, 35318, RADIOLINJA" },
	{ L"20030126:184310", L"9000, 62993, RADIOLINJA" },
	{ L"20030126:184400", L"9000, 35318, RADIOLINJA" },
	{ L"20030126:184418", L"9000, 4401, RADIOLINJA" },
	{ L"20030126:184526", L"9000, 62098, RADIOLINJA" },
	{ L"20030126:184631", L"9000, 4402, RADIOLINJA" },
	{ L"20030126:184925", L"9000, 3854, RADIOLINJA" },
	{ L"20030126:195640", L"9000, 62098, RADIOLINJA" },
	{ L"20030126:195652", L"9000, 4402, RADIOLINJA" },
	{ L"20030126:195851", L"9000, 62098, RADIOLINJA" },
	{ L"20030126:195920", L"9000, 215, RADIOLINJA" },
	{ L"20030126:195937", L"9000, 62098, RADIOLINJA" },
	{ L"20030126:200004", L"9000, 4401, RADIOLINJA" },
	{ L"20030126:200154", L"9000, 4402, RADIOLINJA" },
	{ L"20030126:200218", L"9000, 4401, RADIOLINJA" },
	{ L"20030126:200235", L"9000, 4402, RADIOLINJA" },
	{ L"20030126:200303", L"9000, 4401, RADIOLINJA" },
	{ L"20030126:200530", L"9000, 4402, RADIOLINJA" },
	{ L"20030126:200547", L"9000, 62098, RADIOLINJA" },
	{ L"20030126:200601", L"9000, 4402, RADIOLINJA" },
	{ L"20030126:200611", L"9000, 4401, RADIOLINJA" },
	{ L"20030126:200651", L"9000, 4402, RADIOLINJA" },
	{ L"20030126:200942", L"9000, 4401, RADIOLINJA" },
	{ L"20030126:201003", L"9000, 4402, RADIOLINJA" },
	{ L"20030126:201111", L"9000, 4401, RADIOLINJA" },
	{ L"20030126:201127", L"9000, 4402, RADIOLINJA" },
	{ L"20030126:201449", L"9000, 4401, RADIOLINJA" },
	{ L"20030126:201604", L"9000, 4402, RADIOLINJA" },
	{ L"20030126:201640", L"9000, 4401, RADIOLINJA" },
	{ L"20030126:202247", L"9000, 4402, RADIOLINJA" },
	{ L"20030126:202327", L"9000, 4401, RADIOLINJA" },
	{ L"20030126:202522", L"9000, 4402, RADIOLINJA" },
	{ L"20030126:202540", L"9000, 4401, RADIOLINJA" },
	{ L"20030126:202610", L"9000, 4402, RADIOLINJA" },
	{ L"20030126:202627", L"9000, 4401, RADIOLINJA" },
	{ L"20030126:202737", L"9000, 4402, RADIOLINJA" },
	{ L"20030126:203615", L"9000, 4401, RADIOLINJA" },
	{ L"20030126:204215", L"9000, 4402, RADIOLINJA" },
	{ L"20030126:204233", L"9000, 4401, RADIOLINJA" },
	{ L"20030126:204458", L"9000, 4402, RADIOLINJA" },
	{ L"20030126:204511", L"9000, 4401, RADIOLINJA" },
	{ L"20030126:204604", L"9000, 4402, RADIOLINJA" },
	{ L"20030126:204625", L"9000, 4401, RADIOLINJA" },
	{ L"20030126:204625", L"SWITCH" },
	{ L"20030200:154901", L"9006, 15300, RADIOLINJA" },
	{ L"20030200:161807", L"9006, 62067, RADIOLINJA" },
	{ L"20030200:161845", L"9006, 233, RADIOLINJA" },
	{ L"20030200:162206", L"9006, 441, RADIOLINJA" },
	{ L"20030200:163533", L"9006, 35313, RADIOLINJA" },
	{ L"20030200:163556", L"9006, 174, RADIOLINJA" },
	{ L"20030200:163629", L"9006, 35245, RADIOLINJA" },
	{ L"20030200:163716", L"9006, 15397, RADIOLINJA" },
	{ L"20030200:163740", L"9006, 35245, RADIOLINJA" },
	{ L"20030200:163750", L"9112, 35775, RADIOLINJA" },
	{ L"20030200:163831", L"9112, 35582, RADIOLINJA" },
	{ L"20030200:163851", L"9112, 62077, RADIOLINJA" },
	{ L"20030200:163927", L"9112, 9892, RADIOLINJA" },
	{ L"20030200:163950", L"9112, 39883, RADIOLINJA" },
	{ L"20030200:164033", L"9112, 182, RADIOLINJA" },
	{ L"20030200:164059", L"9112, 42340, RADIOLINJA" },
	{ L"20030200:164114", L"9112, 101, RADIOLINJA" },
	{ L"20030200:164126", L"9112, 39882, RADIOLINJA" },
	{ L"20030200:164237", L"9112, 1423, RADIOLINJA" },
	{ L"20030200:164246", L"9112, 1383, RADIOLINJA" },
	{ L"20030200:164301", L"9112, 3508, RADIOLINJA" },
	{ L"20030200:164315", L"9112, 62084, RADIOLINJA" },
	{ L"20030200:164359", L"9112, 15022, RADIOLINJA" },
	{ L"20030200:164431", L"9112, 39396, RADIOLINJA" },
	{ L"20030200:164504", L"9112, 62084, RADIOLINJA" },
	{ L"20030200:164758", L"9112, 436, RADIOLINJA" },
	{ L"20030200:164913", L"9112, 62084, RADIOLINJA" },
	{ L"20030200:165023", L"9112, 436, RADIOLINJA" },
	{ L"20030200:165039", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:165055", L"9112, 62084, RADIOLINJA" },
	{ L"20030200:165123", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:165145", L"9112, 436, RADIOLINJA" },
	{ L"20030200:165225", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:165232", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:165317", L"9112, 431, RADIOLINJA" },
	{ L"20030200:165325", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:170036", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:170210", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:170306", L"9112, 62084, RADIOLINJA" },
	{ L"20030200:170350", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:170431", L"9112, 62084, RADIOLINJA" },
	{ L"20030200:170511", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:170529", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:170627", L"9112, 62084, RADIOLINJA" },
	{ L"20030200:170813", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:171335", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:171351", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:172318", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:172336", L"9112, 436, RADIOLINJA" },
	{ L"20030200:172352", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:172409", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:172519", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:172725", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:172742", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:172848", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:172904", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:174926", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:174956", L"9112, 431, RADIOLINJA" },
	{ L"20030200:175132", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:184603", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:184620", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:184639", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:184708", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:184737", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:184813", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:184839", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:184856", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:215049", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:215105", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:215234", L"9112, 431, RADIOLINJA" },
	{ L"20030200:215341", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:221137", L"9112, 62084, RADIOLINJA" },
	{ L"20030200:221213", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:222859", L"9112, 62084, RADIOLINJA" },
	{ L"20030200:222916", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:222932", L"9112, 62084, RADIOLINJA" },
	{ L"20030200:223007", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:223837", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:223853", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:223924", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:224104", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:224145", L"9112, 431, RADIOLINJA" },
	{ L"20030200:224154", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:225051", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:225110", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:225600", L"9112, 431, RADIOLINJA" },
	{ L"20030200:225628", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:225656", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:225716", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:225838", L"9112, 431, RADIOLINJA" },
	{ L"20030200:225943", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:230010", L"9112, 431, RADIOLINJA" },
	{ L"20030200:230019", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:230105", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:230119", L"9112, 436, RADIOLINJA" },
	{ L"20030200:230139", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:230156", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:230238", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:230247", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:230356", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:230525", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:232049", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:232053", L"9112, 62084, RADIOLINJA" },
	{ L"20030200:232101", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:232334", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:232344", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:232810", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:233007", L"9112, 431, RADIOLINJA" },
	{ L"20030200:233031", L"9112, 431, RADIOLINJA" },
	{ L"20030200:233036", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:233150", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:233206", L"9112, 62084, RADIOLINJA" },
	{ L"20030200:233229", L"9112, 431, RADIOLINJA" },
	{ L"20030200:233315", L"9112, 62084, RADIOLINJA" },
	{ L"20030200:233425", L"9112, 431, RADIOLINJA" },
	{ L"20030200:233442", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:233458", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:233616", L"9112, 62084, RADIOLINJA" },
	{ L"20030200:233646", L"9112, 431, RADIOLINJA" },
	{ L"20030200:233735", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:234430", L"9112, 431, RADIOLINJA" },
	{ L"20030200:234517", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:234941", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:234954", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:235328", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:235328", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:235529", L"9112, 431, RADIOLINJA" },
	{ L"20030200:235556", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:235645", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:235657", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:235714", L"9112, 431, RADIOLINJA" },
	{ L"20030200:235723", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:235757", L"9112, 431, RADIOLINJA" },
	{ L"20030200:235813", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:235830", L"9112, 62083, RADIOLINJA" },
	{ L"20030200:235916", L"9112, 40627, RADIOLINJA" },
	{ L"20030200:235946", L"9112, 62083, RADIOLINJA" },
	{ L"20030201:000002", L"9112, 62084, RADIOLINJA" },
	{ L"20030201:000108", L"9112, 431, RADIOLINJA" },
	{ L"20030201:000128", L"9112, 62084, RADIOLINJA" },
	{ L"20030201:000322", L"9112, 436, RADIOLINJA" },
	{ L"20030201:000424", L"9112, 62084, RADIOLINJA" },
	{ L"20030201:000440", L"9112, 436, RADIOLINJA" },
	{ L"20030201:000456", L"9112, 62084, RADIOLINJA" },
	{ L"20030201:000707", L"9112, 39396, RADIOLINJA" },
	{ L"20030201:000721", L"9112, 62084, RADIOLINJA" },
	{ L"20030201:000841", L"9112, 62084, RADIOLINJA" },
	{ L"20030201:001150", L"9112, 39396, RADIOLINJA" },
	{ L"20030201:001211", L"9112, 39396, RADIOLINJA" },
	{ L"20030201:001351", L"9112, 62084, RADIOLINJA" },
	{ L"20030201:001412", L"9112, 39396, RADIOLINJA" },
	{ L"20030201:001545", L"9112, 62084, RADIOLINJA" },
	{ L"20030201:001556", L"9112, 39396, RADIOLINJA" },
	{ L"20030201:001653", L"9112, 62084, RADIOLINJA" },
	{ L"20030201:001709", L"9112, 39396, RADIOLINJA" },
	{ L"20030201:001903", L"9112, 62084, RADIOLINJA" },
	{ L"20030201:001957", L"9112, 3508, RADIOLINJA" },
	{ L"20030201:002007", L"9112, 1383, RADIOLINJA" },
	{ L"20030201:002020", L"9112, 1423, RADIOLINJA" },
	{ L"20030201:002039", L"9112, 39882, RADIOLINJA" },
	{ L"20030201:002120", L"9112, 101, RADIOLINJA" },
	{ L"20030201:002130", L"9112, 42340, RADIOLINJA" },
	{ L"20030201:002141", L"9112, 182, RADIOLINJA" },
	{ L"20030201:002213", L"9112, 39883, RADIOLINJA" },
	{ L"20030201:002230", L"9112, 9892, RADIOLINJA" },
	{ L"20030201:002341", L"9112, 15076, RADIOLINJA" },
	{ L"20030201:002351", L"9112, 62077, RADIOLINJA" },
	{ L"20030201:002426", L"9112, 35775, RADIOLINJA" },
	{ L"20030201:002507", L"9112, 207, RADIOLINJA" },
	{ L"20030201:002517", L"9006, 35245, RADIOLINJA" },
	{ L"20030201:002539", L"9006, 15397, RADIOLINJA" },
	{ L"20030201:002548", L"9006, 35245, RADIOLINJA" },
	{ L"20030201:002601", L"9006, 174, RADIOLINJA" },
	{ L"20030201:003146", L"9006, 232, RADIOLINJA" },
	{ L"20030201:003349", L"9006, 233, RADIOLINJA" },
	{ L"20030201:003810", L"9006, 62067, RADIOLINJA" },
	{ L"20030201:003947", L"9006, 15300, RADIOLINJA" },
	{ L"20030201:113620", L"9006, 216, RADIOLINJA" },
	{ L"20030201:113629", L"9006, 15300, RADIOLINJA" },
	{ L"20030201:113732", L"9006, 62067, RADIOLINJA" },
	{ L"20030201:113741", L"9006, 15300, RADIOLINJA" },
	{ L"20030201:114043", L"9006, 216, RADIOLINJA" },
	{ L"20030201:114225", L"9006, 217, RADIOLINJA" },
	{ L"20030201:114400", L"9006, 37204, RADIOLINJA" },
	{ L"20030201:114536", L"9006, 41723, RADIOLINJA" },
	{ L"20030201:114718", L"9006, 35324, RADIOLINJA" },
	{ L"20030201:114838", L"9006, 349, RADIOLINJA" },
	{ L"20030201:114914", L"9006, 35324, RADIOLINJA" },
	{ L"20030201:115003", L"9000, 766, RADIOLINJA" },
	{ L"20030201:115415", L"9000, 37887, RADIOLINJA" },
	{ L"20030201:115431", L"9000, 766, RADIOLINJA" },
	{ L"20030201:115502", L"9000, 35781, RADIOLINJA" },
	{ L"20030201:115518", L"9000, 766, RADIOLINJA" },
	{ L"20030201:115529", L"9000, 35781, RADIOLINJA" },
	{ L"20030201:115753", L"9000, 37887, RADIOLINJA" },
	{ L"20030201:115803", L"9000, 35781, RADIOLINJA" },
	{ L"20030201:115842", L"9000, 37887, RADIOLINJA" },
	{ L"20030201:120156", L"9000, 62991, RADIOLINJA" },
	{ L"20030201:120247", L"9000, 37887, RADIOLINJA" },
	{ L"20030201:120400", L"9000, 62991, RADIOLINJA" },
	{ L"20030201:120414", L"9000, 37887, RADIOLINJA" },
	{ L"20030201:120441", L"9000, 42054, RADIOLINJA" },
	{ L"20030201:120625", L"9000, 188, RADIOLINJA" },
	{ L"20030201:120846", L"9000, 9637, RADIOLINJA" },
	{ L"20030201:120913", L"9000, 188, RADIOLINJA" },
	{ L"20030201:120942", L"9000, 294, RADIOLINJA" },
	{ L"20030201:121151", L"9000, 15206, RADIOLINJA" },
	{ L"20030201:121856", L"9000, 396, RADIOLINJA" },
	{ L"20030201:121905", L"9000, 15206, RADIOLINJA" },
	{ L"20030201:122111", L"9000, 396, RADIOLINJA" },
	{ L"20030201:122143", L"9000, 15206, RADIOLINJA" },
	{ L"20030201:122215", L"9000, 396, RADIOLINJA" },
	{ L"20030201:122245", L"9000, 15206, RADIOLINJA" },
	{ L"20030201:122544", L"9000, 396, RADIOLINJA" },
	{ L"20030201:122755", L"9000, 62035, RADIOLINJA" },
	{ L"20030201:122804", L"9000, 622, RADIOLINJA" },
	{ L"20030201:122821", L"9000, 396, RADIOLINJA" },
	{ L"20030201:122842", L"9000, 62035, RADIOLINJA" },
	{ L"20030201:123009", L"9000, 622, RADIOLINJA" },
	{ L"20030201:123018", L"9000, 37227, RADIOLINJA" },
	{ L"20030201:123106", L"9000, 62034, RADIOLINJA" },
	{ L"20030201:123322", L"9000, 1969, RADIOLINJA" },
	{ L"20030201:123555", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:123617", L"9000, 350, RADIOLINJA" },
	{ L"20030201:123645", L"9000, 62124, RADIOLINJA" },
	{ L"20030201:123713", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:123945", L"9000, 62124, RADIOLINJA" },
	{ L"20030201:124029", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:124103", L"9000, 62124, RADIOLINJA" },
	{ L"20030201:124318", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:124450", L"9000, 62124, RADIOLINJA" },
	{ L"20030201:124552", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:124608", L"9000, 62124, RADIOLINJA" },
	{ L"20030201:124719", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:125804", L"9000, 15227, RADIOLINJA" },
	{ L"20030201:125817", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:125856", L"9000, 15227, RADIOLINJA" },
	{ L"20030201:125905", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:125928", L"9000, 15227, RADIOLINJA" },
	{ L"20030201:125941", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:130010", L"9000, 15227, RADIOLINJA" },
	{ L"20030201:130019", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:130151", L"9000, 62124, RADIOLINJA" },
	{ L"20030201:130221", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:130329", L"9000, 15227, RADIOLINJA" },
	{ L"20030201:130338", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:131238", L"9000, 62124, RADIOLINJA" },
	{ L"20030201:131248", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:131311", L"9000, 15227, RADIOLINJA" },
	{ L"20030201:131320", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:132612", L"9000, 15227, RADIOLINJA" },
	{ L"20030201:132632", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:133451", L"9000, 15227, RADIOLINJA" },
	{ L"20030201:133504", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:133513", L"9000, 15227, RADIOLINJA" },
	{ L"20030201:133524", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:134043", L"9000, 62124, RADIOLINJA" },
	{ L"20030201:134054", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:134111", L"9000, 62124, RADIOLINJA" },
	{ L"20030201:134124", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:134217", L"9000, 15227, RADIOLINJA" },
	{ L"20030201:134230", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:134308", L"9000, 15227, RADIOLINJA" },
	{ L"20030201:134317", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:134729", L"9000, 15227, RADIOLINJA" },
	{ L"20030201:134738", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:134810", L"9000, 62124, RADIOLINJA" },
	{ L"20030201:134834", L"9000, 15227, RADIOLINJA" },
	{ L"20030201:134844", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:134937", L"9000, 15227, RADIOLINJA" },
	{ L"20030201:135121", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:135140", L"9000, 15227, RADIOLINJA" },
	{ L"20030201:135223", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:135308", L"9000, 15227, RADIOLINJA" },
	{ L"20030201:135321", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:135711", L"9000, 15227, RADIOLINJA" },
	{ L"20030201:135721", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:135823", L"9000, 62124, RADIOLINJA" },
	{ L"20030201:135928", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:135945", L"9000, 62124, RADIOLINJA" },
	{ L"20030201:135954", L"9000, 15227, RADIOLINJA" },
	{ L"20030201:140004", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:140014", L"9000, 62124, RADIOLINJA" },
	{ L"20030201:140031", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:140055", L"9000, 62124, RADIOLINJA" },
	{ L"20030201:140155", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:140252", L"9000, 62124, RADIOLINJA" },
	{ L"20030201:140302", L"9000, 15227, RADIOLINJA" },
	{ L"20030201:140312", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:140328", L"9000, 62124, RADIOLINJA" },
	{ L"20030201:140344", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:140437", L"9000, 62124, RADIOLINJA" },
	{ L"20030201:140454", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:141158", L"9000, 15227, RADIOLINJA" },
	{ L"20030201:141207", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:141309", L"9000, 62124, RADIOLINJA" },
	{ L"20030201:141330", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:141347", L"9000, 62124, RADIOLINJA" },
	{ L"20030201:141403", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:141443", L"9000, 62124, RADIOLINJA" },
	{ L"20030201:141500", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:141610", L"9000, 62124, RADIOLINJA" },
	{ L"20030201:141630", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:141748", L"9000, 15227, RADIOLINJA" },
	{ L"20030201:141831", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:142404", L"9000, 15227, RADIOLINJA" },
	{ L"20030201:142655", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:143213", L"9000, 62124, RADIOLINJA" },
	{ L"20030201:143251", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:143412", L"9000, 62124, RADIOLINJA" },
	{ L"20030201:143503", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:143519", L"9000, 62124, RADIOLINJA" },
	{ L"20030201:143631", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:143907", L"9000, 62124, RADIOLINJA" },
	{ L"20030201:144028", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:144028", L"SWITCH" },
	{ L"20030201:144509", L"9000, 26, RADIOLINJA" },
	{ L"20030201:144533", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:144656", L"9000, 1969, RADIOLINJA" },
	{ L"20030201:144727", L"9000, 26, RADIOLINJA" },
	{ L"20030201:144745", L"9000, 1969, RADIOLINJA" },
	{ L"20030201:144803", L"9000, 622, RADIOLINJA" },
	{ L"20030201:144838", L"9000, 62035, RADIOLINJA" },
	{ L"20030201:144905", L"9000, 41281, RADIOLINJA" },
	{ L"20030201:144921", L"9000, 622, RADIOLINJA" },
	{ L"20030201:145150", L"9000, 62035, RADIOLINJA" },
	{ L"20030201:145231", L"9000, 622, RADIOLINJA" },
	{ L"20030201:145315", L"9000, 62035, RADIOLINJA" },
	{ L"20030201:145332", L"9000, 622, RADIOLINJA" },
	{ L"20030201:145341", L"9000, 1969, RADIOLINJA" },
	{ L"20030201:145430", L"9000, 15135, RADIOLINJA" },
	{ L"20030201:145509", L"9000, 62125, RADIOLINJA" },
	{ L"20030201:145519", L"9000, 62034, RADIOLINJA" },
	{ L"20030201:145535", L"9000, 15135, RADIOLINJA" },
	{ L"20030201:145551", L"9000, 62034, RADIOLINJA" },
	{ L"20030201:145727", L"9000, 15135, RADIOLINJA" },
	{ L"20030201:145819", L"9000, 62034, RADIOLINJA" },
	{ L"20030201:150001", L"9000, 15135, RADIOLINJA" },
	{ L"20030201:150018", L"9000, 1969, RADIOLINJA" },
	{ L"20030201:150027", L"9000, 62034, RADIOLINJA" },
	{ L"20030201:150042", L"9000, 15135, RADIOLINJA" },
	{ L"20030201:150059", L"9000, 1969, RADIOLINJA" },
	{ L"20030201:150205", L"9000, 62034, RADIOLINJA" },
	{ L"20030201:150214", L"9000, 1969, RADIOLINJA" },
	{ L"20030201:150258", L"9000, 15135, RADIOLINJA" },
	{ L"20030201:150409", L"9000, 62034, RADIOLINJA" },
	{ L"20030201:150424", L"9000, 15135, RADIOLINJA" },
	{ L"20030201:150556", L"9000, 62034, RADIOLINJA" },
	{ L"20030201:150606", L"9000, 15135, RADIOLINJA" },
	{ L"20030201:150742", L"9000, 62034, RADIOLINJA" },
	{ L"20030201:150803", L"9000, 15135, RADIOLINJA" },
	{ L"20030201:150838", L"9000, 62034, RADIOLINJA" },
	{ L"20030201:150852", L"9000, 15135, RADIOLINJA" },
	{ L"20030201:151009", L"9000, 62034, RADIOLINJA" },
	{ L"20030201:151026", L"9000, 15135, RADIOLINJA" },
	{ L"20030201:151040", L"9000, 1969, RADIOLINJA" },
	{ L"20030201:151050", L"9000, 62034, RADIOLINJA" },
	{ L"20030201:151209", L"9000, 15135, RADIOLINJA" },
	{ L"20030201:151225", L"9000, 62034, RADIOLINJA" },
	{ L"20030201:151506", L"9000, 15135, RADIOLINJA" },
	{ L"20030201:151524", L"9000, 1969, RADIOLINJA" },
	{ L"20030201:151603", L"9000, 62034, RADIOLINJA" },
	{ L"20030201:151856", L"9000, 15135, RADIOLINJA" },
	{ L"20030201:151913", L"9000, 1969, RADIOLINJA" },
	{ L"20030201:151956", L"9000, 62034, RADIOLINJA" },
	{ L"20030201:152057", L"9000, 1969, RADIOLINJA" },
	{ L"20030201:152134", L"9000, 62034, RADIOLINJA" },
	{ L"20030201:152238", L"9000, 15135, RADIOLINJA" },
	{ L"20030201:152247", L"9000, 62034, RADIOLINJA" },
	{ L"20030201:152304", L"9000, 1969, RADIOLINJA" },
	{ L"20030201:152355", L"9000, 15135, RADIOLINJA" },
	{ L"20030201:152410", L"9000, 62034, RADIOLINJA" },
	{ L"20030201:153211", L"9000, 1969, RADIOLINJA" },
	{ L"20030201:153410", L"9000, 62034, RADIOLINJA" },
	{ L"20030201:153434", L"9000, 15135, RADIOLINJA" },
	{ L"20030201:153502", L"9000, 1969, RADIOLINJA" },
	{ L"20030201:153622", L"9000, 62034, RADIOLINJA" },
	{ L"20030201:153640", L"9000, 1969, RADIOLINJA" },
	{ L"20030201:153701", L"9000, 62034, RADIOLINJA" },
	{ L"20030201:153922", L"9000, 15135, RADIOLINJA" },
	{ L"20030201:153949", L"9000, 62034, RADIOLINJA" },
	{ L"20030201:154108", L"9000, 15135, RADIOLINJA" },
	{ L"20030201:154227", L"9000, 62034, RADIOLINJA" },
	{ L"20030201:154416", L"9000, 15135, RADIOLINJA" },
	{ L"20030201:154425", L"9000, 62034, RADIOLINJA" },
	{ L"20030201:155109", L"9000, 396, RADIOLINJA" },
	{ L"20030201:155417", L"9000, 62035, RADIOLINJA" },
	{ L"20030201:155427", L"9000, 363, RADIOLINJA" },
	{ L"20030201:155625", L"9000, 15276, RADIOLINJA" },
	{ L"20030201:155907", L"9000, 215, RADIOLINJA" },
	{ L"20030201:155936", L"9000, 62993, RADIOLINJA" },
	{ L"20030201:160015", L"9000, 215, RADIOLINJA" },
	{ L"20030201:160129", L"9000, 62993, RADIOLINJA" },
	{ L"20030201:160817", L"9000, 490, RADIOLINJA" },
	{ L"20030201:160828", L"9000, 62993, RADIOLINJA" },
	{ L"20030201:160946", L"9000, 490, RADIOLINJA" },
	{ L"20030201:160956", L"9000, 62993, RADIOLINJA" },
	{ L"20030201:161133", L"9000, 490, RADIOLINJA" },
	{ L"20030201:161202", L"9000, 62993, RADIOLINJA" },
	{ L"20030201:161243", L"9000, 490, RADIOLINJA" },
	{ L"20030201:161312", L"9000, 62993, RADIOLINJA" },
	{ L"20030201:161333", L"9000, 490, RADIOLINJA" },
	{ L"20030201:161351", L"9000, 62993, RADIOLINJA" },
	{ L"20030201:161403", L"9000, 490, RADIOLINJA" },
	{ L"20030201:161414", L"9000, 62993, RADIOLINJA" },
	{ L"20030201:161536", L"9000, 490, RADIOLINJA" },
	{ L"20030201:161620", L"9000, 62993, RADIOLINJA" },
	{ L"20030201:161634", L"9000, 490, RADIOLINJA" },
	{ L"20030201:161715", L"9000, 62993, RADIOLINJA" },
	{ L"20030201:161744", L"9000, 490, RADIOLINJA" },
	{ L"20030201:161805", L"9000, 62993, RADIOLINJA" },
	{ L"20030201:162128", L"9000, 490, RADIOLINJA" },
	{ L"20030201:162157", L"9000, 62993, RADIOLINJA" },
	{ L"20030201:162224", L"9000, 490, RADIOLINJA" },
	{ L"20030201:162312", L"9000, 62993, RADIOLINJA" },
	{ L"20030201:162324", L"9000, 490, RADIOLINJA" },
	{ L"20030201:162335", L"9000, 62993, RADIOLINJA" },
	{ L"20030201:162421", L"9000, 490, RADIOLINJA" },
	{ L"20030201:162654", L"9000, 62993, RADIOLINJA" },
	{ L"20030201:162818", L"9000, 490, RADIOLINJA" },
	{ L"20030201:162836", L"9000, 62993, RADIOLINJA" },
	{ L"20030201:162926", L"9000, 490, RADIOLINJA" },
	{ L"20030201:162951", L"9000, 62993, RADIOLINJA" },
	{ L"20030201:163143", L"9000, 490, RADIOLINJA" },
	{ L"20030201:163200", L"9000, 62993, RADIOLINJA" },
	{ L"20030201:163538", L"9000, 490, RADIOLINJA" },
	{ L"20030201:164038", L"9000, 62993, RADIOLINJA" },
	{ L"20030201:164134", L"9000, 39713, RADIOLINJA" },
	{ L"20030201:164302", L"9000, 42338, RADIOLINJA" },
	{ L"20030201:164455", L"9000, 8, RADIOLINJA" },
	{ L"20030201:164812", L"9000, 15308, RADIOLINJA" },
	{ L"20030201:164927", L"9000, 8, RADIOLINJA" },
	{ L"20030201:164943", L"9000, 15308, RADIOLINJA" },
	{ L"20030201:165000", L"9000, 8, RADIOLINJA" },
	{ L"20030201:165042", L"9000, 15308, RADIOLINJA" },
	{ L"20030201:165054", L"9000, 62110, RADIOLINJA" },
	{ L"20030201:165135", L"9000, 62112, RADIOLINJA" },
	{ L"20030201:165253", L"9000, 62110, RADIOLINJA" },
	{ L"20030201:165343", L"9000, 62112, RADIOLINJA" },
	{ L"20030201:165412", L"9000, 62111, RADIOLINJA" },
	{ L"20030201:165421", L"9000, 9814, RADIOLINJA" },
	{ L"20030201:165440", L"9000, 179, RADIOLINJA" },
	{ L"20030201:165502", L"9000, 62112, RADIOLINJA" },
	{ L"20030201:165511", L"9000, 179, RADIOLINJA" },
	{ L"20030201:172417", L"9000, 178, RADIOLINJA" },
	{ L"20030201:172433", L"9000, 39679, RADIOLINJA" },
	{ L"20030201:172449", L"9000, 62111, RADIOLINJA" },
	{ L"20030201:172715", L"9000, 179, RADIOLINJA" },
	{ L"20030201:172814", L"9000, 178, RADIOLINJA" },
	{ L"20030201:172854", L"9000, 179, RADIOLINJA" },
	{ L"20030201:172910", L"9000, 178, RADIOLINJA" },
	{ L"20030201:172946", L"9000, 179, RADIOLINJA" },
	{ L"20030201:173132", L"9000, 178, RADIOLINJA" },
	{ L"20030201:173219", L"9000, 179, RADIOLINJA" },
	{ L"20030201:173536", L"9000, 62111, RADIOLINJA" },
	{ L"20030201:174001", L"9000, 179, RADIOLINJA" },
	{ L"20030201:174018", L"9000, 62111, RADIOLINJA" },
	{ L"20030201:174601", L"9000, 179, RADIOLINJA" },
	{ L"20030201:175503", L"9000, 62111, RADIOLINJA" },
	{ L"20030201:175533", L"9000, 179, RADIOLINJA" },
	{ L"20030201:180316", L"9000, 62111, RADIOLINJA" },
	{ L"20030201:181112", L"9000, 179, RADIOLINJA" },
	{ L"20030201:191132", L"9000, 178, RADIOLINJA" },
	{ L"20030201:191153", L"9000, 179, RADIOLINJA" },
	{ L"20030201:193134", L"9000, 62111, RADIOLINJA" },
	{ L"20030201:193204", L"9000, 179, RADIOLINJA" },
	{ L"20030201:193258", L"9000, 178, RADIOLINJA" },
	{ L"20030201:193314", L"9000, 179, RADIOLINJA" },
	{ L"20030201:193342", L"9000, 62111, RADIOLINJA" },
	{ L"20030201:193433", L"9000, 179, RADIOLINJA" },
	{ L"20030201:193552", L"9000, 62111, RADIOLINJA" },
	{ L"20030201:193728", L"9000, 179, RADIOLINJA" },
	{ L"20030201:193811", L"9000, 62111, RADIOLINJA" },
	{ L"20030201:194028", L"9000, 179, RADIOLINJA" },
	{ L"20030201:200425", L"9000, 62111, RADIOLINJA" },
	{ L"20030201:200449", L"9000, 179, RADIOLINJA" },
	{ L"20030201:200621", L"9000, 62111, RADIOLINJA" },
	{ L"20030201:200746", L"9000, 179, RADIOLINJA" },
	{ L"20030201:201147", L"9000, 62111, RADIOLINJA" },
	{ L"20030201:201205", L"9000, 179, RADIOLINJA" },
	{ L"20030201:201331", L"9000, 62111, RADIOLINJA" },
	{ L"20030201:201517", L"9000, 179, RADIOLINJA" },
	{ L"20030201:201730", L"9000, 62111, RADIOLINJA" },
	{ L"20030201:201805", L"9000, 179, RADIOLINJA" },
	{ L"20030201:202239", L"9000, 178, RADIOLINJA" },
	{ L"20030201:203740", L"9000, 179, RADIOLINJA" },
	{ L"20030201:203844", L"9000, 178, RADIOLINJA" },
	{ L"20030201:203924", L"9000, 179, RADIOLINJA" },
	{ L"20030201:203948", L"9000, 178, RADIOLINJA" },
	{ L"20030201:204041", L"9000, 179, RADIOLINJA" },
	{ L"20030201:204058", L"9000, 178, RADIOLINJA" },
	{ L"20030201:204158", L"9000, 179, RADIOLINJA" },
	{ L"20030201:204313", L"9000, 178, RADIOLINJA" },
	{ L"20030201:204329", L"9000, 179, RADIOLINJA" },
	{ L"20030201:204404", L"9000, 178, RADIOLINJA" },
	{ L"20030201:204420", L"9000, 179, RADIOLINJA" },
	{ L"20030201:204438", L"9000, 178, RADIOLINJA" },
	{ L"20030201:204508", L"9000, 179, RADIOLINJA" },
	{ L"20030201:204631", L"9000, 178, RADIOLINJA" },
	{ L"20030201:204714", L"9000, 179, RADIOLINJA" },
	{ L"20030201:205215", L"9000, 178, RADIOLINJA" },
	{ L"20030201:205255", L"9000, 179, RADIOLINJA" },
	{ L"20030201:205427", L"9000, 62111, RADIOLINJA" },
	{ L"20030201:205530", L"9000, 179, RADIOLINJA" },
	{ L"20030201:205555", L"9000, 62111, RADIOLINJA" },
	{ L"20030201:205613", L"9000, 179, RADIOLINJA" },
	{ L"20030201:205655", L"9000, 62111, RADIOLINJA" },
	{ L"20030201:205719", L"9000, 179, RADIOLINJA" },
	{ L"20030201:205744", L"9000, 62111, RADIOLINJA" },
	{ L"20030201:205802", L"9000, 179, RADIOLINJA" },
	{ L"20030201:211622", L"9000, 62111, RADIOLINJA" },
	{ L"20030201:212055", L"9000, 179, RADIOLINJA" },
	{ L"20030201:212335", L"9000, 62111, RADIOLINJA" },
	{ L"20030201:212353", L"9000, 179, RADIOLINJA" },
	{ L"20030201:212718", L"9000, 178, RADIOLINJA" },
	{ L"20030201:214511", L"9000, 179, RADIOLINJA" },
	{ L"20030201:214528", L"9000, 178, RADIOLINJA" },
	{ L"20030201:214800", L"9000, 179, RADIOLINJA" },
	{ L"20030201:214817", L"9000, 178, RADIOLINJA" },
	{ L"20030201:220553", L"9000, 179, RADIOLINJA" },
	{ L"20030201:220859", L"9000, 178, RADIOLINJA" },
	{ L"20030201:221037", L"9000, 179, RADIOLINJA" },
	{ L"20030201:221332", L"9000, 178, RADIOLINJA" },
	{ L"20030201:221742", L"9000, 179, RADIOLINJA" },
	{ L"20030201:221803", L"9000, 178, RADIOLINJA" },
	{ L"20030201:222313", L"9000, 179, RADIOLINJA" },
	{ L"20030201:222329", L"9000, 178, RADIOLINJA" },
	{ L"20030201:222603", L"9000, 179, RADIOLINJA" },
	{ L"20030201:222627", L"9000, 178, RADIOLINJA" },
	{ L"20030201:222905", L"9000, 179, RADIOLINJA" },
	{ L"20030201:222926", L"9000, 178, RADIOLINJA" },
	{ L"20030201:223055", L"9000, 179, RADIOLINJA" },
	{ L"20030201:223117", L"9000, 178, RADIOLINJA" },
	{ L"20030201:223133", L"9000, 179, RADIOLINJA" },
	{ L"20030201:225755", L"9000, 178, RADIOLINJA" },
	{ L"20030201:230410", L"9000, 179, RADIOLINJA" },
	{ L"20030201:230503", L"9000, 178, RADIOLINJA" },
	{ L"20030201:230529", L"9000, 179, RADIOLINJA" },
	{ L"20030201:233157", L"9000, 178, RADIOLINJA" },
	{ L"20030201:234506", L"9000, 179, RADIOLINJA" },
	{ L"20030201:235216", L"9000, 9814, RADIOLINJA" },
	{ L"20030201:235253", L"9000, 179, RADIOLINJA" },
	{ L"20030202:001307", L"9000, 178, RADIOLINJA" },
	{ L"20030202:001641", L"9000, 9814, RADIOLINJA" },
	{ L"20030202:001657", L"9000, 179, RADIOLINJA" },
	{ L"20030202:002351", L"9000, 178, RADIOLINJA" },
	{ L"20030202:002407", L"9000, 179, RADIOLINJA" },
	{ L"20030202:003509", L"9000, 62111, RADIOLINJA" },
	{ L"20030202:003559", L"9000, 179, RADIOLINJA" },
	{ L"20030202:011832", L"9000, 178, RADIOLINJA" },
	{ L"20030202:011953", L"9000, 179, RADIOLINJA" },
	{ L"20030202:012445", L"9000, 178, RADIOLINJA" },
	{ L"20030202:014205", L"9000, 179, RADIOLINJA" },
	{ L"20030202:014440", L"9000, 178, RADIOLINJA" },
	{ L"20030202:014457", L"9000, 179, RADIOLINJA" },
	{ L"20030202:015801", L"9000, 178, RADIOLINJA" },
	{ L"20030202:015914", L"9000, 179, RADIOLINJA" },
	{ L"20030202:030555", L"9000, 178, RADIOLINJA" },
	{ L"20030202:030638", L"9000, 9814, RADIOLINJA" },
	{ L"20030202:030716", L"9000, 178, RADIOLINJA" },
	{ L"20030202:030732", L"9000, 179, RADIOLINJA" },
	{ L"20030202:030748", L"9000, 178, RADIOLINJA" },
	{ L"20030202:030858", L"9000, 179, RADIOLINJA" },
	{ L"20030202:030915", L"9000, 178, RADIOLINJA" },
	{ L"20030202:030948", L"9000, 9814, RADIOLINJA" },
	{ L"20030202:031003", L"9000, 179, RADIOLINJA" },
	{ L"20030202:033822", L"9000, 178, RADIOLINJA" },
	{ L"20030202:033958", L"9000, 179, RADIOLINJA" },
	{ L"20030202:034219", L"9000, 178, RADIOLINJA" },
	{ L"20030202:034957", L"9000, 179, RADIOLINJA" },
	{ L"20030202:040833", L"9000, 9814, RADIOLINJA" },
	{ L"20030202:042636", L"9000, 179, RADIOLINJA" },
	{ L"20030202:062616", L"9000, 178, RADIOLINJA" },
	{ L"20030202:062632", L"9000, 179, RADIOLINJA" },
	{ L"20030202:062932", L"9000, 178, RADIOLINJA" },
	{ L"20030202:063517", L"9000, 179, RADIOLINJA" },
	{ L"20030202:063541", L"9000, 178, RADIOLINJA" },
	{ L"20030202:063557", L"9000, 179, RADIOLINJA" },
	{ L"20030202:063716", L"9000, 9814, RADIOLINJA" },
	{ L"20030202:063726", L"9000, 179, RADIOLINJA" },
	{ L"20030202:065906", L"9000, 9814, RADIOLINJA" },
	{ L"20030202:065916", L"9000, 179, RADIOLINJA" },
	{ L"20030202:070024", L"9000, 178, RADIOLINJA" },
	{ L"20030202:070512", L"9000, 179, RADIOLINJA" },
	{ L"20030202:070913", L"9000, 178, RADIOLINJA" },
	{ L"20030202:070930", L"9000, 179, RADIOLINJA" },
	{ L"20030202:071410", L"9000, 178, RADIOLINJA" },
	{ L"20030202:072025", L"9000, 179, RADIOLINJA" },
	{ L"20030202:091545", L"9000, 178, RADIOLINJA" },
	{ L"20030202:091554", L"9000, 179, RADIOLINJA" },
	{ L"20030202:091701", L"9000, 9814, RADIOLINJA" },
	{ L"20030202:091904", L"9000, 62111, RADIOLINJA" },
	{ L"20030202:091922", L"9000, 9814, RADIOLINJA" },
	{ L"20030202:091955", L"9000, 62111, RADIOLINJA" },
	{ L"20030202:092012", L"9000, 9814, RADIOLINJA" },
	{ L"20030202:092032", L"9000, 62111, RADIOLINJA" },
	{ L"20030202:092050", L"9000, 9814, RADIOLINJA" },
	{ L"20030202:092155", L"9000, 35600, RADIOLINJA" },
	{ L"20030202:092304", L"9000, 42335, RADIOLINJA" },
	{ L"20030202:092424", L"9000, 62105, RADIOLINJA" },
	{ L"20030202:092457", L"9000, 15164, RADIOLINJA" },
	{ L"20030202:092514", L"9000, 62105, RADIOLINJA" },
	{ L"20030202:092523", L"9000, 15164, RADIOLINJA" },
	{ L"20030202:092540", L"9000, 599, RADIOLINJA" },
	{ L"20030202:092549", L"9000, 42336, RADIOLINJA" },
	{ L"20030202:092602", L"9000, 4402, RADIOLINJA" },
	{ L"20030202:092925", L"9000, 62098, RADIOLINJA" },
	{ L"20030202:093000", L"9000, 15276, RADIOLINJA" },
	{ L"20030202:093020", L"9000, 260, RADIOLINJA" },
	{ L"20030202:093041", L"9000, 15206, RADIOLINJA" },
	{ L"20030202:093117", L"9000, 188, RADIOLINJA" },
	{ L"20030202:093334", L"9000, 440, RADIOLINJA" },
	{ L"20030202:093352", L"9000, 62019, RADIOLINJA" },
	{ L"20030202:093435", L"9000, 440, RADIOLINJA" },
	{ L"20030202:093445", L"9000, 62019, RADIOLINJA" },
	{ L"20030202:093519", L"9000, 62018, RADIOLINJA" },
	{ L"20030202:093538", L"9000, 62017, RADIOLINJA" },
	{ L"20030202:093654", L"9000, 15128, RADIOLINJA" },
	{ L"20030202:093812", L"9000, 144, RADIOLINJA" },
	{ L"20030202:093901", L"9006, 67, RADIOLINJA" },
	{ L"20030202:093919", L"9006, 217, RADIOLINJA" },
	{ L"20030202:094025", L"9006, 15300, RADIOLINJA" },
	{ L"20030202:094224", L"9006, 62067, RADIOLINJA" },
	{ L"20030202:094242", L"9006, 15300, RADIOLINJA" },
	{ L"20030202:094611", L"9006, 62067, RADIOLINJA" },
	{ L"20030202:094620", L"9006, 15300, RADIOLINJA" },
	{ L"20030202:094804", L"9006, 62067, RADIOLINJA" },
	{ L"20030202:094813", L"9006, 15300, RADIOLINJA" },
	{ L"20030202:094919", L"9006, 62067, RADIOLINJA" },
	{ L"20030202:094936", L"9006, 15300, RADIOLINJA" },
	{ L"20030202:095010", L"9006, 62067, RADIOLINJA" },
	{ L"20030202:095026", L"9006, 38583, RADIOLINJA" },
	{ L"20030202:095255", L"9006, 18, RADIOLINJA" },
	{ L"20030202:095311", L"9006, 376, RADIOLINJA" },
	{ L"20030202:095353", L"9006, 18, RADIOLINJA" },
	{ L"20030202:095421", L"9006, 399, RADIOLINJA" },
	{ L"20030202:100221", L"9006, 376, RADIOLINJA" },
	{ L"20030202:100237", L"9006, 15306, RADIOLINJA" },
	{ L"20030202:100252", L"9006, 399, RADIOLINJA" },
	{ L"20030202:100359", L"9006, 18, RADIOLINJA" },
	{ L"20030202:100634", L"9006, 62032, RADIOLINJA" },
	{ L"20030202:100655", L"9006, 18, RADIOLINJA" },
	{ L"20030202:101115", L"9006, 376, RADIOLINJA" },
	{ L"20030202:101130", L"9006, 18, RADIOLINJA" },
	{ L"20030202:101205", L"9006, 62032, RADIOLINJA" },
	{ L"20030202:101451", L"9006, 18, RADIOLINJA" },
	{ L"20030202:101558", L"9006, 399, RADIOLINJA" },
	{ L"20030202:101646", L"9006, 18, RADIOLINJA" },
	{ L"20030202:101702", L"9006, 376, RADIOLINJA" },
	{ L"20030202:101732", L"9006, 399, RADIOLINJA" },
	{ L"20030202:101741", L"9006, 376, RADIOLINJA" },
	{ L"20030202:101758", L"9006, 18, RADIOLINJA" },
	{ L"20030202:102057", L"9006, 376, RADIOLINJA" },
	{ L"20030202:102127", L"9006, 18, RADIOLINJA" },
	{ L"20030202:102151", L"9006, 376, RADIOLINJA" },
	{ L"20030202:102323", L"9006, 18, RADIOLINJA" },
	{ L"20030202:102339", L"9006, 376, RADIOLINJA" },
	{ L"20030202:102441", L"9006, 18, RADIOLINJA" },
	{ L"20030202:104033", L"9006, 399, RADIOLINJA" },
	{ L"20030202:104100", L"9006, 18, RADIOLINJA" },
	{ L"20030202:104741", L"9006, 376, RADIOLINJA" },
	{ L"20030202:104837", L"9006, 399, RADIOLINJA" },
	{ L"20030202:104854", L"9006, 18, RADIOLINJA" },
	{ L"20030202:105157", L"9006, 376, RADIOLINJA" },
	{ L"20030202:105214", L"9006, 399, RADIOLINJA" },
	{ L"20030202:110303", L"9006, 376, RADIOLINJA" },
	{ L"20030202:110328", L"9006, 399, RADIOLINJA" },
	{ L"20030202:110410", L"9006, 18, RADIOLINJA" },
	{ L"20030202:110433", L"9006, 376, RADIOLINJA" },
	{ L"20030202:110444", L"9006, 18, RADIOLINJA" },
	{ L"20030202:110500", L"9006, 376, RADIOLINJA" },
	{ L"20030202:110516", L"9006, 18, RADIOLINJA" },
	{ L"20030202:110827", L"9006, 376, RADIOLINJA" },
	{ L"20030202:110836", L"9006, 18, RADIOLINJA" },
	{ L"20030202:111228", L"9006, 376, RADIOLINJA" },
	{ L"20030202:111237", L"9006, 399, RADIOLINJA" },
	{ L"20030202:111854", L"9006, 376, RADIOLINJA" },
	{ L"20030202:111906", L"9006, 18, RADIOLINJA" },
	{ L"20030202:111943", L"9006, 62032, RADIOLINJA" },
	{ L"20030202:111959", L"9006, 399, RADIOLINJA" },
	{ L"20030202:112235", L"9006, 376, RADIOLINJA" },
	{ L"20030202:112311", L"9006, 399, RADIOLINJA" },
	{ L"20030202:113340", L"9006, 62032, RADIOLINJA" },
	{ L"20030202:113507", L"9006, 399, RADIOLINJA" },
	{ L"20030202:113525", L"9006, 18, RADIOLINJA" },
	{ L"20030202:113539", L"9006, 62032, RADIOLINJA" },
	{ L"20030202:113649", L"9006, 18, RADIOLINJA" },
	{ L"20030202:114404", L"9006, 399, RADIOLINJA" },
	{ L"20030202:114421", L"9006, 18, RADIOLINJA" },
	{ L"20030202:114437", L"9006, 399, RADIOLINJA" },
	{ L"20030202:114519", L"9006, 18, RADIOLINJA" },
	{ L"20030202:114722", L"9006, 376, RADIOLINJA" },
	{ L"20030202:114750", L"9006, 18, RADIOLINJA" },
	{ L"20030202:115040", L"9006, 376, RADIOLINJA" },
	{ L"20030202:115632", L"9006, 18, RADIOLINJA" },
	{ L"20030202:115844", L"9006, 376, RADIOLINJA" },
	{ L"20030202:120133", L"9006, 18, RADIOLINJA" },
	{ L"20030202:120256", L"9006, 376, RADIOLINJA" },
	{ L"20030202:120305", L"9006, 399, RADIOLINJA" },
	{ L"20030202:120459", L"9006, 1493, RADIOLINJA" },
	{ L"20030202:120515", L"9006, 399, RADIOLINJA" },
	{ L"20030202:120545", L"9006, 376, RADIOLINJA" },
	{ L"20030202:120647", L"9006, 399, RADIOLINJA" },
	{ L"20030202:120710", L"9006, 376, RADIOLINJA" },
	{ L"20030202:120726", L"9006, 399, RADIOLINJA" },
	{ L"20030202:120726", L"SWITCH" },
	{ L"20030202:122247", L"9006, 399, RADIOLINJA" },
	{ L"20030202:125009", L"9006, 1493, RADIOLINJA" },
	{ L"20030202:125020", L"9006, 399, RADIOLINJA" },
	{ L"20030202:125333", L"9006, 399, RADIOLINJA" },
	{ L"20030202:125423", L"9006, 399, RADIOLINJA" },
	{ L"20030202:131755", L"9006, 1493, RADIOLINJA" },
	{ L"20030202:131820", L"9006, 399, RADIOLINJA" },
	{ L"20030202:132040", L"9006, 1493, RADIOLINJA" },
	{ L"20030202:132109", L"9006, 399, RADIOLINJA" },
	{ L"20030202:132250", L"9006, 1493, RADIOLINJA" },
	{ L"20030202:132306", L"9006, 399, RADIOLINJA" },
	{ L"20030202:132326", L"9006, 1493, RADIOLINJA" },
	{ L"20030202:132357", L"9006, 399, RADIOLINJA" },
	{ L"20030202:133131", L"9006, 376, RADIOLINJA" },
	{ L"20030202:133140", L"9006, 399, RADIOLINJA" },
	{ L"20030202:133203", L"9006, 1493, RADIOLINJA" },
	{ L"20030202:133219", L"9006, 399, RADIOLINJA" },
	{ L"20030202:133716", L"9006, 1493, RADIOLINJA" },
	{ L"20030202:133732", L"9006, 399, RADIOLINJA" },
	{ L"20030202:133746", L"9006, 1493, RADIOLINJA" },
	{ L"20030202:133802", L"9006, 399, RADIOLINJA" },
	{ L"20030202:134018", L"9006, 1493, RADIOLINJA" },
	{ L"20030202:134116", L"9006, 399, RADIOLINJA" },
	{ L"20030202:134430", L"9006, 1493, RADIOLINJA" },
	{ L"20030202:134441", L"9006, 399, RADIOLINJA" },
	{ L"20030202:134554", L"9006, 1493, RADIOLINJA" },
	{ L"20030202:134610", L"9006, 399, RADIOLINJA" },
	{ L"20030202:135421", L"9006, 376, RADIOLINJA" },
	{ L"20030202:135449", L"9006, 399, RADIOLINJA" },
	{ L"20030202:135650", L"9006, 376, RADIOLINJA" },
	{ L"20030202:135659", L"9006, 18, RADIOLINJA" },
	{ L"20030202:135726", L"9006, 376, RADIOLINJA" },
	{ L"20030202:135741", L"9006, 18, RADIOLINJA" },
	{ L"20030202:135757", L"9006, 399, RADIOLINJA" },
	{ L"20030202:135819", L"9006, 18, RADIOLINJA" },
	{ L"20030202:135835", L"9006, 376, RADIOLINJA" },
	{ L"20030202:135852", L"9006, 18, RADIOLINJA" },
	{ L"20030202:135907", L"9006, 376, RADIOLINJA" },
	{ L"20030202:135924", L"9006, 399, RADIOLINJA" },
	{ L"20030202:135940", L"9006, 376, RADIOLINJA" },
	{ L"20030202:140047", L"9006, 399, RADIOLINJA" },
	{ L"20030202:140102", L"9006, 376, RADIOLINJA" },
	{ L"20030202:140147", L"9006, 399, RADIOLINJA" },
	{ L"20030202:140203", L"9006, 18, RADIOLINJA" },
	{ L"20030202:140219", L"9006, 376, RADIOLINJA" },
	{ L"20030202:140433", L"9006, 399, RADIOLINJA" },
	{ L"20030202:140505", L"9006, 376, RADIOLINJA" },
	{ L"20030202:140641", L"9006, 15306, RADIOLINJA" },
	{ L"20030202:140711", L"9006, 376, RADIOLINJA" },
	{ L"20030202:140722", L"9006, 399, RADIOLINJA" },
	{ L"20030202:140828", L"9006, 62032, RADIOLINJA" },
	{ L"20030202:140905", L"9006, 399, RADIOLINJA" },
	{ L"20030202:140926", L"9006, 376, RADIOLINJA" },
	{ L"20030202:140945", L"9006, 18, RADIOLINJA" },
	{ L"20030202:141130", L"9006, 376, RADIOLINJA" },
	{ L"20030202:141158", L"9006, 399, RADIOLINJA" },
	{ L"20030202:141233", L"9006, 62032, RADIOLINJA" },
	{ L"20030202:141321", L"9006, 18, RADIOLINJA" },
	{ L"20030202:141427", L"9006, 399, RADIOLINJA" },
	{ L"20030202:141640", L"9006, 18, RADIOLINJA" },
	{ L"20030202:141728", L"9006, 399, RADIOLINJA" },
	{ L"20030202:141929", L"9006, 18, RADIOLINJA" },
	{ L"20030202:142010", L"9006, 15306, RADIOLINJA" },
	{ L"20030202:142030", L"9006, 62032, RADIOLINJA" },
	{ L"20030202:142056", L"9006, 4707, RADIOLINJA" },
	{ L"20030202:142134", L"9006, 376, RADIOLINJA" },
	{ L"20030202:142155", L"9006, 18, RADIOLINJA" },
	{ L"20030202:142335", L"9006, 399, RADIOLINJA" },
	{ L"20030202:142533", L"9006, 376, RADIOLINJA" },
	{ L"20030202:142546", L"9006, 18, RADIOLINJA" },
	{ L"20030202:142615", L"9006, 399, RADIOLINJA" },
	{ L"20030202:142627", L"9006, 18, RADIOLINJA" },
	{ L"20030202:142936", L"9006, 376, RADIOLINJA" },
	{ L"20030202:143013", L"9006, 18, RADIOLINJA" },
	{ L"20030202:143032", L"9006, 376, RADIOLINJA" },
	{ L"20030202:143158", L"9006, 399, RADIOLINJA" },
	{ L"20030202:143232", L"9006, 399, RADIOLINJA" },
	{ L"20030202:143238", L"9006, 18, RADIOLINJA" },
	{ L"20030202:143402", L"9006, 18, RADIOLINJA" },
	{ L"20030202:143430", L"9006, 376, RADIOLINJA" },
	{ L"20030202:143432", L"9006, 376, RADIOLINJA" },
	{ L"20030202:143448", L"9006, 18, RADIOLINJA" },
	{ L"20030202:143550", L"9006, 376, RADIOLINJA" },
	{ L"20030202:143626", L"9006, 18, RADIOLINJA" },
	{ L"20030202:143810", L"9006, 376, RADIOLINJA" },
	{ L"20030202:143931", L"9006, 399, RADIOLINJA" },
	{ L"20030202:143946", L"9006, 376, RADIOLINJA" },
	{ L"20030202:144006", L"9006, 18, RADIOLINJA" },
	{ L"20030202:144059", L"9006, 376, RADIOLINJA" },
	{ L"20030202:144140", L"9006, 18, RADIOLINJA" },
	{ L"20030202:144235", L"9006, 62032, RADIOLINJA" },
	{ L"20030202:144250", L"9006, 18, RADIOLINJA" },
	{ L"20030202:144306", L"9006, 62032, RADIOLINJA" },
	{ L"20030202:144348", L"9006, 18, RADIOLINJA" },
	{ L"20030202:144411", L"9006, 376, RADIOLINJA" },
	{ L"20030202:144426", L"9006, 18, RADIOLINJA" },
	{ L"20030202:144618", L"9006, 376, RADIOLINJA" },
	{ L"20030202:144635", L"9006, 18, RADIOLINJA" },
	{ L"20030202:144906", L"9006, 18, RADIOLINJA" },
	{ L"20030202:144910", L"9006, 18, RADIOLINJA" },
	{ L"20030202:145753", L"9006, 18, RADIOLINJA" },
	{ L"20030202:145824", L"9006, 18, RADIOLINJA" },
	{ L"20030202:145834", L"9006, 18, RADIOLINJA" },
	{ L"20030202:145842", L"9006, 399, RADIOLINJA" },
	{ L"20030202:145842", L"9006, 399, RADIOLINJA" },
	{ L"20030202:145855", L"9006, 62032, RADIOLINJA" },
	{ L"20030202:150329", L"9006, 18, RADIOLINJA" },
	{ L"20030202:150356", L"9006, 18, RADIOLINJA" },
	{ L"20030202:150428", L"9006, 62032, RADIOLINJA" },
	{ L"20030202:150505", L"9006, 62032, RADIOLINJA" },
	{ L"20030202:150508", L"9006, 62032, RADIOLINJA" },
	{ L"20030202:150508", L"9006, 62032, RADIOLINJA" },
	{ L"20030202:150539", L"9006, 18, RADIOLINJA" },
	{ L"20030202:150600", L"9006, 18, RADIOLINJA" },
	{ L"20030202:150615", L"9006, 18, RADIOLINJA" },
	{ L"20030202:150615", L"9006, 18, RADIOLINJA" },
	{ L"20030202:150631", L"9006, 376, RADIOLINJA" },
	{ L"20030202:150631", L"9006, 376, RADIOLINJA" },
	{ L"20030202:150651", L"9006, 376, RADIOLINJA" },
	{ L"20030202:150657", L"9006, 62032, RADIOLINJA" },
	{ L"20030202:150707", L"9006, 62032, RADIOLINJA" },
	{ L"20030202:150728", L"9006, 399, RADIOLINJA" },
	{ L"20030202:150826", L"9006, 399, RADIOLINJA" },
	{ L"20030202:150900", L"9006, 18, RADIOLINJA" },
	{ L"20030202:150938", L"9006, 399, RADIOLINJA" },
	{ L"20030202:150954", L"9006, 376, RADIOLINJA" },
	{ L"20030202:151014", L"9006, 399, RADIOLINJA" },
	{ L"20030202:151031", L"9006, 18, RADIOLINJA" },
	{ L"20030202:151153", L"9006, 376, RADIOLINJA" },
	{ L"20030202:151154", L"9006, 376, RADIOLINJA" },
	{ L"20030202:151206", L"9006, 18, RADIOLINJA" },
	{ L"20030202:151348", L"9006, 376, RADIOLINJA" },
	{ L"20030202:151409", L"9006, 18, RADIOLINJA" },
	{ L"20030202:151418", L"9006, 376, RADIOLINJA" },
	{ L"20030202:151441", L"9006, 399, RADIOLINJA" },
	{ L"20030202:152555", L"9006, 376, RADIOLINJA" },
	{ L"20030202:152604", L"9006, 399, RADIOLINJA" },
	{ L"20030202:154225", L"9006, 376, RADIOLINJA" },
	{ L"20030202:154253", L"9006, 399, RADIOLINJA" },
	{ L"20030202:161048", L"9006, 376, RADIOLINJA" },
	{ L"20030202:161120", L"9006, 1493, RADIOLINJA" },
	{ L"20030202:161129", L"9006, 399, RADIOLINJA" },
	{ L"20030202:164431", L"9006, 376, RADIOLINJA" },
	{ L"20030202:164441", L"9006, 399, RADIOLINJA" },
	{ L"20030202:164513", L"9006, 376, RADIOLINJA" },
	{ L"20030202:164531", L"9006, 399, RADIOLINJA" },
	{ L"20030202:164802", L"9006, 376, RADIOLINJA" },
	{ L"20030202:164818", L"9006, 399, RADIOLINJA" },
	{ L"20030202:165148", L"9006, 376, RADIOLINJA" },
	{ L"20030202:165211", L"9006, 399, RADIOLINJA" },
	{ L"20030202:165901", L"9006, 376, RADIOLINJA" },
	{ L"20030202:165941", L"9006, 399, RADIOLINJA" },
	{ L"20030202:165941", L"SWITCH" },
	{ L"20030203:175930", L"9006, 232, RADIOLINJA" },
	{ L"20030203:175930", L"9006, 233, RADIOLINJA" },
	{ L"20030203:180009", L"9006, 232, RADIOLINJA" },
	{ L"20030203:180147", L"9006, 233, RADIOLINJA" },
	{ L"20030203:180312", L"9006, 62143, RADIOLINJA" },
	{ L"20030203:180321", L"9006, 15300, RADIOLINJA" },
	{ L"20030203:180529", L"9006, 216, RADIOLINJA" },
	{ L"20030203:180538", L"9006, 37204, RADIOLINJA" },
	{ L"20030203:180703", L"9006, 41723, RADIOLINJA" },
	{ L"20030203:180722", L"9006, 349, RADIOLINJA" },
	{ L"20030203:180755", L"9006, 41723, RADIOLINJA" },
	{ L"20030203:180809", L"9006, 377, RADIOLINJA" },
	{ L"20030203:180954", L"9006, 62054, RADIOLINJA" },
	{ L"20030203:181006", L"9006, 354, RADIOLINJA" },
	{ L"20030203:181120", L"9006, 39705, RADIOLINJA" },
	{ L"20030203:181129", L"9006, 62119, RADIOLINJA" },
	{ L"20030203:181144", L"9006, 196, RADIOLINJA" },
	{ L"20030203:181228", L"9006, 41823, RADIOLINJA" },
	{ L"20030203:181357", L"9006, 176, RADIOLINJA" },
	{ L"20030203:181537", L"9006, 177, RADIOLINJA" },
	{ L"20030203:181617", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:181624", L"9006, 62075, RADIOLINJA" },
	{ L"20030203:181640", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:181729", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:181901", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:181917", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:181926", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:181942", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:182013", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:182100", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:182136", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:182308", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:182608", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:182749", L"9000, 15227, RADIOLINJA" },
	{ L"20030203:182758", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:182809", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:183045", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:183219", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:183242", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:183403", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:183800", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:184010", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:184231", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:184305", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:184348", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:184414", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:184452", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:184722", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:184736", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:184756", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:184832", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:184853", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:185229", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:185441", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:185550", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:185823", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:185917", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:185933", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:190037", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:190239", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:190303", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:190313", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:190433", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:190457", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:190512", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:191023", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:191034", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:191149", L"9000, 15227, RADIOLINJA" },
	{ L"20030203:191225", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:191506", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:191523", L"9000, 15227, RADIOLINJA" },
	{ L"20030203:191535", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:191758", L"9000, 15227, RADIOLINJA" },
	{ L"20030203:191807", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:192621", L"9000, 15227, RADIOLINJA" },
	{ L"20030203:192630", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:193651", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:193711", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:193747", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:193814", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:193847", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:193910", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:194012", L"9000, 15227, RADIOLINJA" },
	{ L"20030203:194022", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:194156", L"9000, 15227, RADIOLINJA" },
	{ L"20030203:194205", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:194543", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:194608", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:194719", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:194728", L"9000, 15227, RADIOLINJA" },
	{ L"20030203:194924", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:195020", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:195054", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:195115", L"9000, 15227, RADIOLINJA" },
	{ L"20030203:195124", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:195139", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:195148", L"9000, 15227, RADIOLINJA" },
	{ L"20030203:195158", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:195209", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:195419", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:195646", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:195655", L"9000, 15227, RADIOLINJA" },
	{ L"20030203:195720", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:195731", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:195742", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:195756", L"9000, 15227, RADIOLINJA" },
	{ L"20030203:195816", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:200533", L"9000, 15227, RADIOLINJA" },
	{ L"20030203:200543", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:200908", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:200919", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:201225", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:201312", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:201348", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:201404", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:201443", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:201456", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:201507", L"9000, 15227, RADIOLINJA" },
	{ L"20030203:201517", L"9000, 62125, RADIOLINJA" },
	{ L"20030203:201645", L"9000, 350, RADIOLINJA" },
	{ L"20030203:201728", L"9000, 62124, RADIOLINJA" },
	{ L"20030203:201755", L"9000, 350, RADIOLINJA" },
	{ L"20030203:201815", L"9000, 1969, RADIOLINJA" },
	{ L"20030203:201852", L"9000, 350, RADIOLINJA" },
	{ L"20030203:201944", L"9000, 1969, RADIOLINJA" },
	{ L"20030203:202001", L"9000, 350, RADIOLINJA" },
	{ L"20030203:202016", L"9000, 1969, RADIOLINJA" },
	{ L"20030203:202237", L"9000, 62034, RADIOLINJA" },
	{ L"20030203:202632", L"9000, 396, RADIOLINJA" },
	{ L"20030203:203327", L"9000, 396, RADIOLINJA" },
	{ L"20030203:203604", L"9000, 396, RADIOLINJA" },
	{ L"20030203:205944", L"9000, 503, RADIOLINJA" },
	{ L"20030203:210011", L"9000, 62110, RADIOLINJA" },
	{ L"20030203:210214", L"9000, 62112, RADIOLINJA" },
	{ L"20030203:210246", L"9000, 9814, RADIOLINJA" },
	{ L"20030203:210304", L"9000, 179, RADIOLINJA" },
	{ L"20030203:211620", L"9000, 178, RADIOLINJA" },
	{ L"20030203:211629", L"9000, 179, RADIOLINJA" },
	{ L"20030203:214920", L"9000, 178, RADIOLINJA" },
	{ L"20030203:214939", L"9000, 179, RADIOLINJA" },
	{ L"20030203:220647", L"9000, 178, RADIOLINJA" },
	{ L"20030203:221401", L"9000, 179, RADIOLINJA" },
	{ L"20030204:082550", L"9000, 178, RADIOLINJA" },
	{ L"20030204:082606", L"9000, 179, RADIOLINJA" },
	{ L"20030204:082856", L"9000, 178, RADIOLINJA" },
	{ L"20030204:082920", L"9000, 179, RADIOLINJA" },
	{ L"20030204:083148", L"9000, 9814, RADIOLINJA" },
	{ L"20030204:083206", L"9000, 62112, RADIOLINJA" },
	{ L"20030204:083219", L"9000, 62110, RADIOLINJA" },
	{ L"20030204:083236", L"9000, 62112, RADIOLINJA" },
	{ L"20030204:083303", L"9000, 62116, RADIOLINJA" },
	{ L"20030204:083329", L"9000, 35600, RADIOLINJA" },
	{ L"20030204:083339", L"9000, 62116, RADIOLINJA" },
	{ L"20030204:083450", L"9000, 62112, RADIOLINJA" },
	{ L"20030204:083511", L"9000, 62116, RADIOLINJA" },
	{ L"20030204:083613", L"9000, 62112, RADIOLINJA" },
	{ L"20030204:083625", L"9000, 62110, RADIOLINJA" },
	{ L"20030204:083723", L"9000, 503, RADIOLINJA" },
	{ L"20030204:083747", L"9000, 495, RADIOLINJA" },
	{ L"20030204:084116", L"9000, 35302, RADIOLINJA" },
	{ L"20030204:084131", L"9000, 62462, RADIOLINJA" },
	{ L"20030204:084157", L"9000, 35302, RADIOLINJA" },
	{ L"20030204:084206", L"9000, 167, RADIOLINJA" },
	{ L"20030204:084233", L"9000, 35332, RADIOLINJA" },
	{ L"20030204:084243", L"9000, 168, RADIOLINJA" },
	{ L"20030204:084259", L"9000, 62109, RADIOLINJA" },
	{ L"20030204:084331", L"9000, 168, RADIOLINJA" },
	{ L"20030204:084444", L"9000, 35781, RADIOLINJA" },
	{ L"20030204:084458", L"9000, 62017, RADIOLINJA" },
	{ L"20030204:084538", L"9000, 15128, RADIOLINJA" },
	{ L"20030204:084707", L"9000, 144, RADIOLINJA" },
	{ L"20030204:084723", L"9000, 15128, RADIOLINJA" },
	{ L"20030204:084744", L"9000, 144, RADIOLINJA" },
	{ L"20030204:084813", L"9006, 67, RADIOLINJA" },
	{ L"20030204:084852", L"9006, 511, RADIOLINJA" },
	{ L"20030204:084924", L"9006, 217, RADIOLINJA" },
	{ L"20030204:084957", L"9006, 216, RADIOLINJA" },
	{ L"20030204:085126", L"9006, 37204, RADIOLINJA" },
	{ L"20030204:085235", L"9006, 216, RADIOLINJA" },
	{ L"20030204:085255", L"9006, 35779, RADIOLINJA" },
	{ L"20030204:085338", L"9006, 376, RADIOLINJA" },
	{ L"20030204:085410", L"9006, 18, RADIOLINJA" },
	{ L"20030204:085430", L"9006, 38583, RADIOLINJA" },
	{ L"20030204:085532", L"9006, 550, RADIOLINJA" },
	{ L"20030204:085712", L"9006, 1493, RADIOLINJA" },
	{ L"20030204:085729", L"9006, 601, RADIOLINJA" },
	{ L"20030204:085812", L"9006, 1493, RADIOLINJA" },
	{ L"20030204:085922", L"9006, 399, RADIOLINJA" },
	{ L"20030204:091907", L"9006, 376, RADIOLINJA" },
	{ L"20030204:091926", L"9006, 399, RADIOLINJA" },
	{ L"20030204:091943", L"9006, 376, RADIOLINJA" },
	{ L"20030204:091959", L"9006, 399, RADIOLINJA" },
	{ L"20030204:092015", L"9006, 376, RADIOLINJA" },
	{ L"20030204:092028", L"9006, 18, RADIOLINJA" },
	{ L"20030204:092111", L"9006, 15306, RADIOLINJA" },
	{ L"20030204:092143", L"9006, 18, RADIOLINJA" },
	{ L"20030204:092539", L"9006, 62032, RADIOLINJA" },
	{ L"20030204:092627", L"9006, 18, RADIOLINJA" },
	{ L"20030204:092702", L"9006, 62032, RADIOLINJA" },
	{ L"20030204:092716", L"9006, 18, RADIOLINJA" },
	{ L"20030204:092735", L"9006, 18, RADIOLINJA" },
	{ L"20030204:092742", L"9006, 18, RADIOLINJA" },
	{ L"20030204:093057", L"9006, 62032, RADIOLINJA" },
	{ L"20030204:093113", L"9006, 18, RADIOLINJA" },
	{ L"20030204:093510", L"9006, 376, RADIOLINJA" },
	{ L"20030204:093548", L"9006, 18, RADIOLINJA" },
	{ L"20030204:093615", L"9006, 62032, RADIOLINJA" },
	{ L"20030204:093856", L"9006, 18, RADIOLINJA" },
	{ L"20030204:094059", L"9006, 376, RADIOLINJA" },
	{ L"20030204:094728", L"9006, 18, RADIOLINJA" },
	{ L"20030204:094745", L"9006, 376, RADIOLINJA" },
	{ L"20030204:095006", L"9006, 18, RADIOLINJA" },
	{ L"20030204:095107", L"9006, 62032, RADIOLINJA" },
	{ L"20030204:095157", L"9006, 18, RADIOLINJA" },
	{ L"20030204:100603", L"9006, 62032, RADIOLINJA" },
	{ L"20030204:100659", L"9006, 399, RADIOLINJA" },
	{ L"20030204:100946", L"9006, 376, RADIOLINJA" },
	{ L"20030204:101001", L"9006, 399, RADIOLINJA" },
	{ L"20030204:101216", L"9006, 1493, RADIOLINJA" },
	{ L"20030204:101341", L"9006, 399, RADIOLINJA" },
	{ L"20030204:101341", L"SWITCH" },
	{ L"20030204:115448", L"9006, 399, RADIOLINJA" },
	{ L"20030204:121250", L"9006, 376, RADIOLINJA" },
	{ L"20030204:121305", L"9006, 399, RADIOLINJA" },
	{ L"20030204:121344", L"9006, 376, RADIOLINJA" },
	{ L"20030204:121359", L"9006, 399, RADIOLINJA" },
	{ L"20030204:121415", L"9006, 376, RADIOLINJA" },
	{ L"20030204:121435", L"9006, 399, RADIOLINJA" },
	{ L"20030204:121452", L"9006, 18, RADIOLINJA" },
	{ L"20030204:121520", L"9006, 399, RADIOLINJA" },
	{ L"20030204:121758", L"9006, 376, RADIOLINJA" },
	{ L"20030204:121814", L"9006, 399, RADIOLINJA" },
	{ L"20030204:122333", L"9006, 376, RADIOLINJA" },
	{ L"20030204:122409", L"9006, 399, RADIOLINJA" },
	{ L"20030204:122434", L"9006, 376, RADIOLINJA" },
	{ L"20030204:122447", L"9006, 399, RADIOLINJA" },
	{ L"20030204:122502", L"9006, 376, RADIOLINJA" },
	{ L"20030204:122518", L"9006, 18, RADIOLINJA" },
	{ L"20030204:122638", L"9006, 376, RADIOLINJA" },
	{ L"20030204:122654", L"9006, 18, RADIOLINJA" },
	{ L"20030204:122829", L"9006, 399, RADIOLINJA" },
	{ L"20030204:122917", L"9006, 18, RADIOLINJA" },
	{ L"20030204:122939", L"9006, 376, RADIOLINJA" },
	{ L"20030204:123005", L"9006, 18, RADIOLINJA" },
	{ L"20030204:123105", L"9006, 399, RADIOLINJA" },
	{ L"20030204:123120", L"9006, 376, RADIOLINJA" },
	{ L"20030204:123200", L"9006, 399, RADIOLINJA" },
	{ L"20030204:123215", L"9006, 18, RADIOLINJA" },
	{ L"20030204:123408", L"9006, 62032, RADIOLINJA" },
	{ L"20030204:123434", L"9006, 399, RADIOLINJA" },
	{ L"20030204:123445", L"9006, 376, RADIOLINJA" },
	{ L"20030204:123532", L"9006, 18, RADIOLINJA" },
	{ L"20030204:123549", L"9006, 62032, RADIOLINJA" },
	{ L"20030204:123632", L"9006, 399, RADIOLINJA" },
	{ L"20030204:123644", L"9006, 376, RADIOLINJA" },
	{ L"20030204:123701", L"9006, 399, RADIOLINJA" },
	{ L"20030204:123718", L"9006, 376, RADIOLINJA" },
	{ L"20030204:123736", L"9006, 18, RADIOLINJA" },
	{ L"20030204:123752", L"9006, 376, RADIOLINJA" },
	{ L"20030204:123814", L"9006, 399, RADIOLINJA" },
	{ L"20030204:123846", L"9006, 376, RADIOLINJA" },
	{ L"20030204:124148", L"9006, 18, RADIOLINJA" },
	{ L"20030204:124200", L"9006, 62032, RADIOLINJA" },
	{ L"20030204:124224", L"9006, 399, RADIOLINJA" },
	{ L"20030204:124240", L"9006, 62032, RADIOLINJA" },
	{ L"20030204:124254", L"9006, 18, RADIOLINJA" },
	{ L"20030204:124310", L"9006, 376, RADIOLINJA" },
	{ L"20030204:124353", L"9006, 399, RADIOLINJA" },
	{ L"20030204:124407", L"9006, 18, RADIOLINJA" },
	{ L"20030204:124506", L"9006, 376, RADIOLINJA" },
	{ L"20030204:124646", L"9006, 399, RADIOLINJA" },
	{ L"20030204:124737", L"9006, 18, RADIOLINJA" },
	{ L"20030204:124752", L"9006, 376, RADIOLINJA" },
	{ L"20030204:125050", L"9006, 399, RADIOLINJA" },
	{ L"20030204:125106", L"9006, 376, RADIOLINJA" },
	{ L"20030204:125123", L"9006, 399, RADIOLINJA" },
	{ L"20030204:125153", L"9006, 376, RADIOLINJA" },
	{ L"20030204:125209", L"9006, 399, RADIOLINJA" },
	{ L"20030204:125225", L"9006, 376, RADIOLINJA" },
	{ L"20030204:125310", L"9006, 399, RADIOLINJA" },
	{ L"20030204:125327", L"9006, 376, RADIOLINJA" },
	{ L"20030204:125504", L"9006, 18, RADIOLINJA" },
	{ L"20030204:125820", L"9006, 376, RADIOLINJA" },
	{ L"20030204:125911", L"9006, 18, RADIOLINJA" },
	{ L"20030204:130321", L"9006, 399, RADIOLINJA" },
	{ L"20030204:130549", L"9006, 376, RADIOLINJA" },
	{ L"20030204:130625", L"9006, 399, RADIOLINJA" },
	{ L"20030204:130651", L"9006, 376, RADIOLINJA" },
	{ L"20030204:130732", L"9006, 399, RADIOLINJA" },
	{ L"20030204:130818", L"9006, 18, RADIOLINJA" },
	{ L"20030204:130832", L"9006, 399, RADIOLINJA" },
	{ L"20030204:131000", L"9006, 18, RADIOLINJA" },
	{ L"20030204:131020", L"9006, 376, RADIOLINJA" },
	{ L"20030204:131031", L"9006, 18, RADIOLINJA" },
	{ L"20030204:131109", L"9006, 376, RADIOLINJA" },
	{ L"20030204:131458", L"9006, 399, RADIOLINJA" },
	{ L"20030204:131646", L"9006, 18, RADIOLINJA" },
	{ L"20030204:131842", L"9006, 376, RADIOLINJA" },
	{ L"20030204:132317", L"9006, 399, RADIOLINJA" },
	{ L"20030204:132333", L"9006, 376, RADIOLINJA" },
	{ L"20030204:132911", L"9006, 399, RADIOLINJA" },
	{ L"20030204:132950", L"9006, 376, RADIOLINJA" },
	{ L"20030204:133423", L"9006, 399, RADIOLINJA" },
	{ L"20030204:133439", L"9006, 376, RADIOLINJA" },
	{ L"20030204:133455", L"9006, 399, RADIOLINJA" },
	{ L"20030204:133550", L"9006, 376, RADIOLINJA" },
	{ L"20030204:133629", L"9006, 399, RADIOLINJA" },
	{ L"20030204:133650", L"9006, 376, RADIOLINJA" },
	{ L"20030204:133659", L"9006, 399, RADIOLINJA" },
	{ L"20030204:134824", L"9006, 376, RADIOLINJA" },
	{ L"20030204:134841", L"9006, 399, RADIOLINJA" },
	{ L"20030204:134902", L"9006, 376, RADIOLINJA" },
	{ L"20030204:134921", L"9006, 18, RADIOLINJA" },
	{ L"20030204:134942", L"9006, 376, RADIOLINJA" },
	{ L"20030204:135017", L"9006, 399, RADIOLINJA" },
	{ L"20030204:135516", L"9006, 376, RADIOLINJA" },
	{ L"20030204:135533", L"9006, 399, RADIOLINJA" },
	{ L"20030204:140341", L"9006, 376, RADIOLINJA" },
	{ L"20030204:140614", L"9006, 399, RADIOLINJA" },
	{ L"20030204:140651", L"9006, 376, RADIOLINJA" },
	{ L"20030204:140731", L"9006, 399, RADIOLINJA" },
	{ L"20030204:140929", L"9006, 376, RADIOLINJA" },
	{ L"20030204:140945", L"9006, 399, RADIOLINJA" },
	{ L"20030204:141002", L"9006, 376, RADIOLINJA" },
	{ L"20030204:141030", L"9006, 399, RADIOLINJA" },
	{ L"20030204:141204", L"9006, 376, RADIOLINJA" },
	{ L"20030204:141249", L"9006, 399, RADIOLINJA" },
	{ L"20030204:142122", L"9006, 376, RADIOLINJA" },
	{ L"20030204:142139", L"9006, 18, RADIOLINJA" },
	{ L"20030204:142902", L"9006, 62032, RADIOLINJA" },
	{ L"20030204:142924", L"9006, 62032, RADIOLINJA" },
	{ L"20030204:142935", L"9006, 18, RADIOLINJA" },
	{ L"20030204:143000", L"9006, 18, RADIOLINJA" },
	{ L"20030204:143001", L"9006, 18, RADIOLINJA" },
	{ L"20030204:143002", L"9006, 18, RADIOLINJA" },
	{ L"20030204:143024", L"9006, 399, RADIOLINJA" },
	{ L"20030204:143137", L"9006, 18, RADIOLINJA" },
	{ L"20030204:143247", L"9006, 376, RADIOLINJA" },
	{ L"20030204:143303", L"9006, 18, RADIOLINJA" },
	{ L"20030204:143356", L"9006, 62032, RADIOLINJA" },
	{ L"20030204:143408", L"9006, 18, RADIOLINJA" },
	{ L"20030204:144515", L"9006, 62032, RADIOLINJA" },
	{ L"20030204:144529", L"9006, 399, RADIOLINJA" },
	{ L"20030204:144544", L"9006, 376, RADIOLINJA" },
	{ L"20030204:144652", L"9006, 399, RADIOLINJA" },
	{ L"20030204:144714", L"9006, 62032, RADIOLINJA" },
	{ L"20030204:144743", L"9006, 18, RADIOLINJA" },
	{ L"20030204:144806", L"9006, 376, RADIOLINJA" },
	{ L"20030204:144830", L"9006, 399, RADIOLINJA" },
	{ L"20030204:154602", L"9006, 1493, RADIOLINJA" },
	{ L"20030204:154624", L"9006, 399, RADIOLINJA" },
	{ L"20030204:155921", L"9006, 376, RADIOLINJA" },
	{ L"20030204:155937", L"9006, 399, RADIOLINJA" },
	{ L"20030204:162640", L"9006, 1493, RADIOLINJA" },
	{ L"20030204:162710", L"9006, 399, RADIOLINJA" },
	{ L"20030204:162744", L"9006, 1493, RADIOLINJA" },
	{ L"20030204:162829", L"9006, 399, RADIOLINJA" },
	{ L"20030204:163037", L"9006, 1493, RADIOLINJA" },
	{ L"20030204:163048", L"9006, 399, RADIOLINJA" },
	{ L"20030204:163342", L"9006, 18, RADIOLINJA" },
	{ L"20030204:163359", L"9006, 399, RADIOLINJA" },
	{ L"20030204:165643", L"9006, 376, RADIOLINJA" },
	{ L"20030204:165705", L"9006, 399, RADIOLINJA" },
	{ L"20030204:165808", L"9006, 18, RADIOLINJA" },
	{ L"20030204:165827", L"9006, 62032, RADIOLINJA" },
	{ L"20030204:165911", L"9006, 18, RADIOLINJA" },
	{ L"20030204:165942", L"9006, 62032, RADIOLINJA" },
	{ L"20030204:165952", L"9006, 18, RADIOLINJA" },
	{ L"20030204:170149", L"9006, 62032, RADIOLINJA" },
	{ L"20030204:170158", L"9006, 18, RADIOLINJA" },
	{ L"20030204:170214", L"9006, 376, RADIOLINJA" },
	{ L"20030204:170257", L"9006, 38583, RADIOLINJA" },
	{ L"20030204:170321", L"9006, 508, RADIOLINJA" },
	{ L"20030204:170333", L"9006, 15300, RADIOLINJA" },
	{ L"20030204:170350", L"9006, 62067, RADIOLINJA" },
	{ L"20030204:170417", L"9006, 15300, RADIOLINJA" },
	{ L"20030204:170629", L"9006, 62067, RADIOLINJA" },
	{ L"20030204:170655", L"9006, 15300, RADIOLINJA" },
	{ L"20030204:172111", L"9006, 35265, RADIOLINJA" },
	{ L"20030204:172145", L"9006, 15300, RADIOLINJA" },
	{ L"20030204:172234", L"9006, 35265, RADIOLINJA" },
	{ L"20030204:172256", L"9006, 15300, RADIOLINJA" },
	{ L"20030204:174227", L"9006, 35265, RADIOLINJA" },
	{ L"20030204:174512", L"9006, 15300, RADIOLINJA" },
	{ L"20030204:174529", L"9006, 35265, RADIOLINJA" },
	{ L"20030204:174623", L"9006, 15300, RADIOLINJA" },
	{ L"20030204:174857", L"9006, 35265, RADIOLINJA" },
	{ L"20030204:175004", L"9006, 15300, RADIOLINJA" },
	{ L"20030204:175808", L"9006, 35265, RADIOLINJA" },
	{ L"20030204:175835", L"9006, 15300, RADIOLINJA" },
	{ L"20030204:180040", L"9006, 35265, RADIOLINJA" },
	{ L"20030204:180134", L"9006, 15300, RADIOLINJA" },
	{ L"20030204:180350", L"9006, 62067, RADIOLINJA" },
	{ L"20030204:180403", L"9006, 62143, RADIOLINJA" },
	{ L"20030204:180418", L"9006, 62067, RADIOLINJA" },
	{ L"20030204:180435", L"9006, 15300, RADIOLINJA" },
	{ L"20030204:180523", L"9006, 62067, RADIOLINJA" },
	{ L"20030204:180535", L"9006, 35779, RADIOLINJA" },
	{ L"20030204:180607", L"9006, 36020, RADIOLINJA" },
	{ L"20030204:180632", L"9006, 4707, RADIOLINJA" },
	{ L"20030204:180652", L"9006, 35561, RADIOLINJA" },
	{ L"20030204:180818", L"9006, 15092, RADIOLINJA" },
	{ L"20030204:180858", L"9006, 15158, RADIOLINJA" },
	{ L"20030204:181009", L"9006, 86, RADIOLINJA" },
	{ L"20030204:181153", L"9006, 41265, RADIOLINJA" },
	{ L"20030204:181202", L"9006, 62671, RADIOLINJA" },
	{ L"20030204:181219", L"9006, 86, RADIOLINJA" },
	{ L"20030204:181235", L"9006, 62671, RADIOLINJA" },
	{ L"20030204:181247", L"9007, 35764, RADIOLINJA" },
	{ L"20030204:181309", L"9007, 35765, RADIOLINJA" },
	{ L"20030204:181336", L"9007, 57, RADIOLINJA" },
	{ L"20030204:181355", L"9007, 35765, RADIOLINJA" },
	{ L"20030204:181432", L"9007, 57, RADIOLINJA" },
	{ L"20030204:181535", L"9007, 510, RADIOLINJA" },
	{ L"20030204:181545", L"9007, 35765, RADIOLINJA" },
	{ L"20030204:181700", L"9007, 321, RADIOLINJA" },
	{ L"20030204:220150", L"9007, 321, RADIOLINJA" },
	{ L"20030204:220235", L"9007, 321, RADIOLINJA" },
	{ L"20030204:220235", L"9007, 321, RADIOLINJA" },
	{ L"20030204:220257", L"9007, 321, RADIOLINJA" },
	{ L"20030204:220257", L"9007, 321, RADIOLINJA" },
	{ L"20030205:011326", L"9007, 321, RADIOLINJA" },
	{ L"20030205:011627", L"9007, 321, RADIOLINJA" },
	{ L"20030205:013128", L"9007, 35765, RADIOLINJA" },
	{ L"20030205:013311", L"9007, 35596, RADIOLINJA" },
	{ L"20030205:013326", L"9007, 35765, RADIOLINJA" },
	{ L"20030205:013407", L"9007, 9813, RADIOLINJA" },
	{ L"20030205:013416", L"9007, 35764, RADIOLINJA" },
	{ L"20030205:013432", L"9006, 86, RADIOLINJA" },
	{ L"20030205:013648", L"9006, 15158, RADIOLINJA" },
	{ L"20030205:013846", L"9006, 40943, RADIOLINJA" },
	{ L"20030205:013926", L"9006, 62054, RADIOLINJA" },
	{ L"20030205:013943", L"9006, 63010, RADIOLINJA" },
	{ L"20030205:013959", L"9006, 354, RADIOLINJA" },
	{ L"20030205:014036", L"9006, 197, RADIOLINJA" },
	{ L"20030205:014052", L"9000, 35769, RADIOLINJA" },
	{ L"20030205:014220", L"9000, 62034, RADIOLINJA" },
	{ L"20030205:014248", L"9000, 396, RADIOLINJA" },
	{ L"20030205:014308", L"9000, 15276, RADIOLINJA" },
	{ L"20030205:014420", L"9000, 62098, RADIOLINJA" },
	{ L"20030205:014545", L"9000, 4402, RADIOLINJA" },
	{ L"20030205:014703", L"9000, 15276, RADIOLINJA" },
	{ L"20030205:014922", L"9000, 396, RADIOLINJA" },
	{ L"20030205:015026", L"9000, 15276, RADIOLINJA" },
	{ L"20030205:015143", L"9000, 62098, RADIOLINJA" },
	{ L"20030205:015200", L"9000, 194, RADIOLINJA" },
	{ L"20030205:015218", L"9000, 15277, RADIOLINJA" },
	{ L"20030205:015325", L"9000, 62014, RADIOLINJA" },
	{ L"20030205:015436", L"9000, 36004, RADIOLINJA" },
	{ L"20030205:015452", L"9000, 62014, RADIOLINJA" },
	{ L"20030205:015510", L"9000, 36004, RADIOLINJA" },
	{ L"20030205:015531", L"9000, 599, RADIOLINJA" },
	{ L"20030205:015614", L"9000, 283, RADIOLINJA" },
	{ L"20030205:015631", L"9000, 599, RADIOLINJA" },
	{ L"20030205:015844", L"9000, 62104, RADIOLINJA" },
	{ L"20030205:015900", L"9000, 62105, RADIOLINJA" },
	{ L"20030205:015927", L"9000, 62104, RADIOLINJA" },
	{ L"20030205:015937", L"9000, 62105, RADIOLINJA" },
	{ L"20030205:015950", L"9000, 62104, RADIOLINJA" },
	{ L"20030205:020253", L"9000, 15088, RADIOLINJA" },
	{ L"20030205:020302", L"9000, 42335, RADIOLINJA" },
	{ L"20030205:020312", L"9000, 62112, RADIOLINJA" },
	{ L"20030205:020429", L"9000, 42335, RADIOLINJA" },
	{ L"20030205:020450", L"9000, 62112, RADIOLINJA" },
	{ L"20030205:020515", L"9000, 42335, RADIOLINJA" },
	{ L"20030205:020559", L"9000, 35600, RADIOLINJA" },
	{ L"20030205:020615", L"9000, 62116, RADIOLINJA" },
	{ L"20030205:020637", L"9000, 35600, RADIOLINJA" },
	{ L"20030205:020800", L"9000, 178, RADIOLINJA" },
	{ L"20030205:021124", L"9000, 179, RADIOLINJA" },
	{ L"20030205:091820", L"9000, 178, RADIOLINJA" },
	{ L"20030205:091836", L"9000, 179, RADIOLINJA" },
	{ L"20030205:092855", L"9000, 62112, RADIOLINJA" },
	{ L"20030205:092919", L"9000, 9814, RADIOLINJA" },
	{ L"20030205:093036", L"9000, 9814, RADIOLINJA" },
	{ L"20030205:093058", L"9000, 9814, RADIOLINJA" },
	{ L"20030205:093117", L"9000, 9814, RADIOLINJA" },
	{ L"20030205:093445", L"9000, 35600, RADIOLINJA" },
	{ L"20030205:093452", L"9000, 35600, RADIOLINJA" },
	{ L"20030205:093550", L"9000, 42335, RADIOLINJA" },
	{ L"20030205:093702", L"9000, 62105, RADIOLINJA" },
	{ L"20030205:093739", L"9000, 62105, RADIOLINJA" },
	{ L"20030205:093832", L"9000, 42336, RADIOLINJA" },
	{ L"20030205:093844", L"9000, 4402, RADIOLINJA" },
	{ L"20030205:094023", L"9000, 62098, RADIOLINJA" },
	{ L"20030205:094109", L"9000, 15276, RADIOLINJA" },
	{ L"20030205:094137", L"9000, 396, RADIOLINJA" },
	{ L"20030205:094149", L"9000, 15206, RADIOLINJA" },
	{ L"20030205:094207", L"9000, 188, RADIOLINJA" },
	{ L"20030205:094358", L"9000, 440, RADIOLINJA" },
	{ L"20030205:094415", L"9000, 62019, RADIOLINJA" },
	{ L"20030205:094509", L"9000, 62019, RADIOLINJA" },
	{ L"20030205:094531", L"9000, 168, RADIOLINJA" },
	{ L"20030205:094552", L"9006, 67, RADIOLINJA" },
	{ L"20030205:094739", L"9000, 15128, RADIOLINJA" },
	{ L"20030205:094910", L"9000, 144, RADIOLINJA" },
	{ L"20030205:094938", L"9006, 67, RADIOLINJA" },
	{ L"20030205:094957", L"9006, 511, RADIOLINJA" },
	{ L"20030205:095055", L"9006, 217, RADIOLINJA" },
	{ L"20030205:095116", L"9006, 15300, RADIOLINJA" },
	{ L"20030205:095300", L"9006, 62067, RADIOLINJA" },
	{ L"20030205:095343", L"9006, 15300, RADIOLINJA" },
	{ L"20030205:101553", L"9006, 62067, RADIOLINJA" },
	{ L"20030205:101650", L"9006, 15300, RADIOLINJA" },
	{ L"20030205:101820", L"9006, 62067, RADIOLINJA" },
	{ L"20030205:101841", L"9006, 38583, RADIOLINJA" },
	{ L"20030205:102006", L"9006, 18, RADIOLINJA" },
	{ L"20030205:102026", L"9006, 62032, RADIOLINJA" },
	{ L"20030205:102127", L"9006, 18, RADIOLINJA" },
	{ L"20030205:102143", L"9006, 376, RADIOLINJA" },
	{ L"20030205:102252", L"9006, 18, RADIOLINJA" },
	{ L"20030205:102315", L"9006, 62032, RADIOLINJA" },
	{ L"20030205:102326", L"9006, 18, RADIOLINJA" },
	{ L"20030205:102436", L"9006, 399, RADIOLINJA" },
	{ L"20030205:102523", L"9006, 376, RADIOLINJA" },
	{ L"20030205:102555", L"9006, 399, RADIOLINJA" },
	{ L"20030205:104524", L"9006, 1493, RADIOLINJA" },
	{ L"20030205:104557", L"9006, 399, RADIOLINJA" },
	{ L"20030205:104621", L"9006, 1493, RADIOLINJA" },
	{ L"20030205:104709", L"9006, 399, RADIOLINJA" },
	{ L"20030205:110222", L"9006, 376, RADIOLINJA" },
	{ L"20030205:110237", L"9006, 399, RADIOLINJA" },
	{ L"20030205:110839", L"9006, 18, RADIOLINJA" },
	{ L"20030205:110855", L"9006, 399, RADIOLINJA" },
	{ L"20030205:111031", L"9006, 376, RADIOLINJA" },
	{ L"20030205:111103", L"9006, 15306, RADIOLINJA" },
	{ L"20030205:111130", L"9006, 376, RADIOLINJA" },
	{ L"20030205:111254", L"9006, 15306, RADIOLINJA" },
	{ L"20030205:111444", L"9006, 376, RADIOLINJA" },
	{ L"20030205:111508", L"9006, 399, RADIOLINJA" },
	{ L"20030205:111523", L"9006, 376, RADIOLINJA" },
	{ L"20030205:111559", L"9006, 399, RADIOLINJA" },
	{ L"20030205:111615", L"9006, 18, RADIOLINJA" },
	{ L"20030205:111632", L"9006, 15306, RADIOLINJA" },
	{ L"20030205:111708", L"9006, 18, RADIOLINJA" },
	{ L"20030205:111724", L"9006, 15306, RADIOLINJA" },
	{ L"20030205:111923", L"9006, 376, RADIOLINJA" },
	{ L"20030205:111943", L"9006, 399, RADIOLINJA" },
	{ L"20030205:112124", L"9006, 376, RADIOLINJA" },
	{ L"20030205:112134", L"9006, 399, RADIOLINJA" },
	{ L"20030205:112236", L"9006, 376, RADIOLINJA" },
	{ L"20030205:112252", L"9006, 15306, RADIOLINJA" },
	{ L"20030205:112503", L"9006, 376, RADIOLINJA" },
	{ L"20030205:112625", L"9006, 15306, RADIOLINJA" },
	{ L"20030205:112656", L"9006, 376, RADIOLINJA" },
	{ L"20030205:112839", L"9006, 15306, RADIOLINJA" },
	{ L"20030205:112856", L"9006, 376, RADIOLINJA" },
	{ L"20030205:112931", L"9006, 18, RADIOLINJA" },
	{ L"20030205:112947", L"9006, 376, RADIOLINJA" },
	{ L"20030205:113058", L"9006, 399, RADIOLINJA" },
	{ L"20030205:113145", L"9006, 376, RADIOLINJA" },
	{ L"20030205:113204", L"9006, 399, RADIOLINJA" },
	{ L"20030205:125319", L"9006, 376, RADIOLINJA" },
	{ L"20030205:125335", L"9006, 18, RADIOLINJA" },
	{ L"20030205:125404", L"9006, 376, RADIOLINJA" },
	{ L"20030205:125413", L"9006, 18, RADIOLINJA" },
	{ L"20030205:125433", L"9006, 62032, RADIOLINJA" },
	{ L"20030205:125500", L"9006, 18, RADIOLINJA" },
	{ L"20030205:125523", L"9006, 62032, RADIOLINJA" },
	{ L"20030205:125636", L"9006, 18, RADIOLINJA" },
	{ L"20030205:125747", L"9006, 62032, RADIOLINJA" },
	{ L"20030205:125842", L"9006, 18, RADIOLINJA" },
	{ L"20030205:130036", L"9006, 62032, RADIOLINJA" },
	{ L"20030205:130122", L"9006, 18, RADIOLINJA" },
	{ L"20030205:130223", L"9006, 62032, RADIOLINJA" },
	{ L"20030205:130254", L"9006, 18, RADIOLINJA" },
	{ L"20030205:130346", L"9006, 62032, RADIOLINJA" },
	{ L"20030205:130447", L"9006, 62032, RADIOLINJA" },
	{ L"20030205:130449", L"9006, 15306, RADIOLINJA" },
	{ L"20030205:130449", L"9006, 15306, RADIOLINJA" },
	{ L"20030205:130458", L"9006, 376, RADIOLINJA" },
	{ L"20030205:130643", L"9006, 376, RADIOLINJA" },
	{ L"20030205:130646", L"9006, 18, RADIOLINJA" },
	{ L"20030205:130725", L"9006, 62032, RADIOLINJA" },
	{ L"20030205:130826", L"9006, 18, RADIOLINJA" },
	{ L"20030205:130841", L"9006, 376, RADIOLINJA" },
	{ L"20030205:131108", L"9006, 4707, RADIOLINJA" },
	{ L"20030205:131109", L"9006, 4707, RADIOLINJA" },
	{ L"20030205:131158", L"9006, 4707, RADIOLINJA" },
	{ L"20030205:131205", L"9006, 4707, RADIOLINJA" },
	{ L"20030205:131205", L"9006, 4707, RADIOLINJA" },
	{ L"20030205:131225", L"9006, 4707, RADIOLINJA" },
	{ L"20030205:131225", L"9006, 4707, RADIOLINJA" },
	{ L"20030205:131257", L"9006, 376, RADIOLINJA" },
	{ L"20030205:131258", L"9006, 376, RADIOLINJA" },
	{ L"20030205:131305", L"9006, 399, RADIOLINJA" },
	{ L"20030205:131314", L"9006, 376, RADIOLINJA" },
	{ L"20030205:131350", L"9006, 18, RADIOLINJA" },
	{ L"20030205:131405", L"9006, 376, RADIOLINJA" },
	{ L"20030205:131503", L"9006, 18, RADIOLINJA" },
	{ L"20030205:131747", L"9006, 399, RADIOLINJA" },
	{ L"20030205:131804", L"9006, 62032, RADIOLINJA" },
	{ L"20030205:131819", L"9006, 18, RADIOLINJA" },
	{ L"20030205:131902", L"9006, 376, RADIOLINJA" },
	{ L"20030205:131919", L"9006, 18, RADIOLINJA" },
	{ L"20030205:132002", L"9006, 376, RADIOLINJA" },
	{ L"20030205:132012", L"9006, 399, RADIOLINJA" },
	{ L"20030205:132048", L"9006, 376, RADIOLINJA" },
	{ L"20030205:132057", L"9006, 399, RADIOLINJA" },
	{ L"20030205:132929", L"9006, 376, RADIOLINJA" },
	{ L"20030205:132950", L"9006, 399, RADIOLINJA" },
	{ L"20030205:143125", L"9006, 1493, RADIOLINJA" },
	{ L"20030205:143305", L"9006, 601, RADIOLINJA" },
	{ L"20030205:143429", L"9006, 1493, RADIOLINJA" },
	{ L"20030205:143458", L"9006, 550, RADIOLINJA" },
	{ L"20030205:143715", L"9006, 38583, RADIOLINJA" },
	{ L"20030205:143739", L"9006, 550, RADIOLINJA" },
	{ L"20030205:143749", L"9006, 232, RADIOLINJA" },
	{ L"20030205:143930", L"9006, 233, RADIOLINJA" },
	{ L"20030205:144004", L"9006, 232, RADIOLINJA" },
	{ L"20030205:144017", L"9006, 233, RADIOLINJA" },
	{ L"20030205:144106", L"9006, 441, RADIOLINJA" },
	{ L"20030205:144232", L"9006, 174, RADIOLINJA" },
	{ L"20030205:144244", L"9006, 35313, RADIOLINJA" },
	{ L"20030205:144305", L"9006, 174, RADIOLINJA" },
	{ L"20030205:144356", L"9006, 35245, RADIOLINJA" },
	{ L"20030205:144417", L"9006, 62089, RADIOLINJA" },
	{ L"20030205:144428", L"9006, 35245, RADIOLINJA" },
	{ L"20030205:144444", L"9006, 15397, RADIOLINJA" },
	{ L"20030205:144500", L"9112, 207, RADIOLINJA" },
	{ L"20030205:144517", L"9112, 35775, RADIOLINJA" },
	{ L"20030205:144540", L"9112, 35582, RADIOLINJA" },
	{ L"20030205:144611", L"9112, 62077, RADIOLINJA" },
	{ L"20030205:144656", L"9112, 62076, RADIOLINJA" },
	{ L"20030205:144705", L"9112, 39883, RADIOLINJA" },
	{ L"20030205:144726", L"9112, 182, RADIOLINJA" },
	{ L"20030205:144826", L"9112, 42340, RADIOLINJA" },
	{ L"20030205:144840", L"9112, 101, RADIOLINJA" },
	{ L"20030205:144853", L"9112, 39882, RADIOLINJA" },
	{ L"20030205:144955", L"9112, 1423, RADIOLINJA" },
	{ L"20030205:145004", L"9112, 1383, RADIOLINJA" },
	{ L"20030205:145023", L"9112, 431, RADIOLINJA" },
	{ L"20030205:145044", L"9112, 62084, RADIOLINJA" },
	{ L"20030205:145118", L"9112, 39396, RADIOLINJA" },
	{ L"20030205:145128", L"9112, 15022, RADIOLINJA" },
	{ L"20030205:145237", L"9112, 62084, RADIOLINJA" },
	{ L"20030205:145529", L"9112, 436, RADIOLINJA" },
	{ L"20030205:145551", L"9112, 62084, RADIOLINJA" },
	{ L"20030205:145801", L"9112, 40627, RADIOLINJA" },
	{ L"20030205:145815", L"9112, 431, RADIOLINJA" },
	{ L"20030205:145826", L"9112, 40627, RADIOLINJA" },
	{ L"20030205:145902", L"9112, 431, RADIOLINJA" },
	{ L"20030205:145917", L"9112, 40627, RADIOLINJA" },
	{ L"20030205:145957", L"9112, 62083, RADIOLINJA" },
	{ L"20030205:150010", L"9112, 40627, RADIOLINJA" },
	{ L"20030205:151141", L"9112, 62083, RADIOLINJA" },
	{ L"20030205:151151", L"9112, 40627, RADIOLINJA" },
	{ L"20030205:151716", L"9112, 62083, RADIOLINJA" },
	{ L"20030205:151726", L"9112, 40627, RADIOLINJA" },
	{ L"20030205:151748", L"9112, 62083, RADIOLINJA" },
	{ L"20030205:152148", L"9112, 40627, RADIOLINJA" },
	{ L"20030205:152212", L"9112, 62083, RADIOLINJA" },
	{ L"20030205:152718", L"9112, 40627, RADIOLINJA" },
	{ L"20030205:152913", L"9112, 62083, RADIOLINJA" },
	{ L"20030205:152929", L"9112, 40627, RADIOLINJA" },
	{ L"20030205:152957", L"9112, 62084, RADIOLINJA" },
	{ L"20030205:153024", L"9112, 436, RADIOLINJA" },
	{ L"20030205:153056", L"9112, 62084, RADIOLINJA" },
	{ L"20030205:153140", L"9112, 40627, RADIOLINJA" },
	{ L"20030205:153157", L"9112, 431, RADIOLINJA" },
	{ L"20030205:153206", L"9112, 40627, RADIOLINJA" },
	{ L"20030205:153242", L"9112, 62084, RADIOLINJA" },
	{ L"20030205:153436", L"9112, 62083, RADIOLINJA" },
	{ L"20030205:153507", L"9112, 40626, RADIOLINJA" },
	{ L"20030205:153516", L"9112, 62084, RADIOLINJA" },
	{ L"20030205:153619", L"9112, 3508, RADIOLINJA" },
	{ L"20030205:153633", L"9112, 1383, RADIOLINJA" },
	{ L"20030205:153652", L"9112, 39882, RADIOLINJA" },
	{ L"20030205:153730", L"9112, 101, RADIOLINJA" },
	{ L"20030205:153739", L"9112, 42340, RADIOLINJA" },
	{ L"20030205:153749", L"9112, 182, RADIOLINJA" },
	{ L"20030205:153819", L"9112, 9892, RADIOLINJA" },
	{ L"20030205:153845", L"9112, 15076, RADIOLINJA" },
	{ L"20030205:153859", L"9112, 62077, RADIOLINJA" },
	{ L"20030205:153915", L"9112, 35582, RADIOLINJA" },
	{ L"20030205:153929", L"9112, 35775, RADIOLINJA" },
	{ L"20030205:154003", L"9006, 35245, RADIOLINJA" },
	{ L"20030205:154056", L"9006, 174, RADIOLINJA" },
	{ L"20030205:154152", L"9006, 232, RADIOLINJA" },
	{ L"20030205:154233", L"9006, 38583, RADIOLINJA" },
	{ L"20030205:154242", L"9006, 38584, RADIOLINJA" },
	{ L"20030205:154252", L"9006, 38583, RADIOLINJA" },
	{ L"20030205:154323", L"9006, 376, RADIOLINJA" },
	{ L"20030205:154345", L"9006, 18, RADIOLINJA" },
	{ L"20030205:154355", L"9006, 399, RADIOLINJA" },
	{ L"20030205:154517", L"9006, 18, RADIOLINJA" },
	{ L"20030205:154536", L"9006, 376, RADIOLINJA" },
	{ L"20030205:154550", L"9006, 399, RADIOLINJA" },
	{ L"20030205:154633", L"9006, 62032, RADIOLINJA" },
	{ L"20030205:154644", L"9006, 18, RADIOLINJA" },
	{ L"20030205:154654", L"9006, 399, RADIOLINJA" },
	{ L"20030205:155427", L"9006, 376, RADIOLINJA" },
	{ L"20030205:155507", L"9006, 399, RADIOLINJA" },
	{ L"20030205:155531", L"9006, 376, RADIOLINJA" },
	{ L"20030205:155555", L"9006, 18, RADIOLINJA" },
	{ L"20030205:155609", L"9006, 376, RADIOLINJA" },
	{ L"20030205:155707", L"9006, 38583, RADIOLINJA" },
	{ L"20030205:155732", L"9006, 62067, RADIOLINJA" },
	{ L"20030205:155744", L"9006, 15300, RADIOLINJA" },
	{ L"20030205:155815", L"9006, 62067, RADIOLINJA" },
	{ L"20030205:155827", L"9006, 15300, RADIOLINJA" },
	{ L"20030205:155921", L"9006, 233, RADIOLINJA" },
	{ L"20030205:160121", L"9006, 232, RADIOLINJA" },
	{ L"20030205:160240", L"9006, 174, RADIOLINJA" },
	{ L"20030205:160317", L"9006, 35313, RADIOLINJA" },
	{ L"20030205:160408", L"9006, 174, RADIOLINJA" },
	{ L"20030205:160426", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:160523", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:160527", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:160537", L"9006, 171, RADIOLINJA" },
	{ L"20030205:160558", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:160628", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:160637", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:160637", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:161228", L"9006, 174, RADIOLINJA" },
	{ L"20030205:161237", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:161840", L"9006, 174, RADIOLINJA" },
	{ L"20030205:161902", L"9006, 62088, RADIOLINJA" },
	{ L"20030205:161918", L"9006, 174, RADIOLINJA" },
	{ L"20030205:161931", L"9006, 171, RADIOLINJA" },
	{ L"20030205:161944", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:162009", L"9006, 62088, RADIOLINJA" },
	{ L"20030205:162024", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:162051", L"9006, 62088, RADIOLINJA" },
	{ L"20030205:162111", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:162132", L"9006, 174, RADIOLINJA" },
	{ L"20030205:162148", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:162211", L"9006, 171, RADIOLINJA" },
	{ L"20030205:162239", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:162308", L"9006, 171, RADIOLINJA" },
	{ L"20030205:162336", L"9006, 174, RADIOLINJA" },
	{ L"20030205:162353", L"9006, 171, RADIOLINJA" },
	{ L"20030205:162500", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:162718", L"9006, 171, RADIOLINJA" },
	{ L"20030205:162735", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:162829", L"9006, 174, RADIOLINJA" },
	{ L"20030205:162846", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:162902", L"9006, 171, RADIOLINJA" },
	{ L"20030205:162929", L"9006, 171, RADIOLINJA" },
	{ L"20030205:162945", L"9006, 171, RADIOLINJA" },
	{ L"20030205:162945", L"9006, 171, RADIOLINJA" },
	{ L"20030205:163011", L"9006, 171, RADIOLINJA" },
	{ L"20030205:163011", L"9006, 171, RADIOLINJA" },
	{ L"20030205:163036", L"9006, 174, RADIOLINJA" },
	{ L"20030205:163202", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:163221", L"9006, 174, RADIOLINJA" },
	{ L"20030205:163327", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:163535", L"9006, 174, RADIOLINJA" },
	{ L"20030205:163553", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:163608", L"9006, 174, RADIOLINJA" },
	{ L"20030205:163659", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:163716", L"9006, 174, RADIOLINJA" },
	{ L"20030205:163807", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:163837", L"9006, 174, RADIOLINJA" },
	{ L"20030205:163915", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:163939", L"9006, 174, RADIOLINJA" },
	{ L"20030205:163949", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:164021", L"9006, 174, RADIOLINJA" },
	{ L"20030205:164041", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:164125", L"9006, 174, RADIOLINJA" },
	{ L"20030205:164230", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:164246", L"9006, 174, RADIOLINJA" },
	{ L"20030205:164302", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:164348", L"9006, 174, RADIOLINJA" },
	{ L"20030205:164420", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:164442", L"9006, 174, RADIOLINJA" },
	{ L"20030205:164459", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:164539", L"9006, 174, RADIOLINJA" },
	{ L"20030205:164555", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:164624", L"9006, 174, RADIOLINJA" },
	{ L"20030205:164731", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:164747", L"9006, 174, RADIOLINJA" },
	{ L"20030205:164809", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:164818", L"9006, 174, RADIOLINJA" },
	{ L"20030205:164835", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:165013", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:165015", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:165037", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:165054", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:165054", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:165055", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:165441", L"9006, 174, RADIOLINJA" },
	{ L"20030205:165454", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:165546", L"9006, 174, RADIOLINJA" },
	{ L"20030205:165704", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:165809", L"9006, 174, RADIOLINJA" },
	{ L"20030205:165824", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:165918", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:165936", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:165936", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:165937", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:165945", L"9006, 174, RADIOLINJA" },
	{ L"20030205:170059", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:170131", L"9006, 174, RADIOLINJA" },
	{ L"20030205:170214", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:170254", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:170255", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:170255", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:170414", L"9006, 174, RADIOLINJA" },
	{ L"20030205:170424", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:170518", L"9006, 174, RADIOLINJA" },
	{ L"20030205:170657", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:170812", L"9006, 174, RADIOLINJA" },
	{ L"20030205:170829", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:170844", L"9006, 174, RADIOLINJA" },
	{ L"20030205:170907", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:171637", L"9006, 62088, RADIOLINJA" },
	{ L"20030205:171650", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:171737", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:171742", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:171926", L"9006, 171, RADIOLINJA" },
	{ L"20030205:171937", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:172933", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:172934", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:172934", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:173337", L"9006, 171, RADIOLINJA" },
	{ L"20030205:173346", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:174547", L"9006, 174, RADIOLINJA" },
	{ L"20030205:174556", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:174639", L"9006, 174, RADIOLINJA" },
	{ L"20030205:174655", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:174817", L"9006, 171, RADIOLINJA" },
	{ L"20030205:174847", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:180415", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:180415", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:180708", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:180712", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:180744", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:180748", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:180827", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:180827", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:181225", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:181327", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:181327", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:181355", L"9006, 171, RADIOLINJA" },
	{ L"20030205:181423", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:181518", L"9006, 35313, RADIOLINJA" },
	{ L"20030205:181534", L"9006, 36606, RADIOLINJA" },
	{ L"20030205:181542", L"9006, 35313, RADIOLINJA" },
	{ L"20030205:181622", L"9006, 174, RADIOLINJA" },
	{ L"20030205:181739", L"9006, 232, RADIOLINJA" },
	{ L"20030205:181751", L"9006, 15130, RADIOLINJA" },
	{ L"20030205:181828", L"9006, 15425, RADIOLINJA" },
	{ L"20030205:181907", L"9006, 15386, RADIOLINJA" },
	{ L"20030205:181951", L"9000, 62121, RADIOLINJA" },
	{ L"20030205:182105", L"9000, 40519, RADIOLINJA" },
	{ L"20030205:182211", L"9000, 495, RADIOLINJA" },
	{ L"20030205:182247", L"9000, 39713, RADIOLINJA" },
	{ L"20030205:182304", L"9000, 507, RADIOLINJA" },
	{ L"20030205:182344", L"9000, 495, RADIOLINJA" },
	{ L"20030205:182427", L"9000, 503, RADIOLINJA" },
	{ L"20030205:182446", L"9000, 62110, RADIOLINJA" },
	{ L"20030205:182534", L"9000, 62112, RADIOLINJA" },
	{ L"20030205:182544", L"9000, 62116, RADIOLINJA" },
	{ L"20030205:182550", L"9000, 35600, RADIOLINJA" },
	{ L"20030205:182617", L"9000, 178, RADIOLINJA" },
	{ L"20030205:182642", L"9000, 126, RADIOLINJA" },
	{ L"20030205:182801", L"9000, 39906, RADIOLINJA" },
	{ L"20030205:182811", L"9000, 62116, RADIOLINJA" },
	{ L"20030205:182826", L"9000, 15060, RADIOLINJA" },
	{ L"20030205:182840", L"9000, 35762, RADIOLINJA" },
	{ L"20030205:183103", L"9000, 62107, RADIOLINJA" },
	{ L"20030205:183121", L"9000, 62097, RADIOLINJA" },
	{ L"20030205:183145", L"9000, 62107, RADIOLINJA" },
	{ L"20030205:183201", L"9000, 62097, RADIOLINJA" },
	{ L"20030205:183214", L"9000, 62096, RADIOLINJA" },
	{ L"20030205:183229", L"9000, 62107, RADIOLINJA" },
	{ L"20030205:183240", L"9000, 203, RADIOLINJA" },
	{ L"20030205:183350", L"9000, 15236, RADIOLINJA" },
	{ L"20030205:183405", L"9000, 4482, RADIOLINJA" },
	{ L"20030205:183452", L"9000, 15236, RADIOLINJA" },
	{ L"20030205:183502", L"9000, 4482, RADIOLINJA" },
	{ L"20030205:183517", L"9000, 4361, RADIOLINJA" },
	{ L"20030205:183841", L"9000, 15230, RADIOLINJA" },
	{ L"20030205:185412", L"9000, 4361, RADIOLINJA" },
	{ L"20030205:185826", L"9000, 4482, RADIOLINJA" },
	{ L"20030205:185909", L"9000, 15236, RADIOLINJA" },
	{ L"20030205:190001", L"9000, 203, RADIOLINJA" },
	{ L"20030205:190105", L"9000, 62107, RADIOLINJA" },
	{ L"20030205:190122", L"9000, 62096, RADIOLINJA" },
	{ L"20030205:190138", L"9000, 62107, RADIOLINJA" },
	{ L"20030205:190148", L"9000, 39711, RADIOLINJA" },
	{ L"20030205:190159", L"9000, 2879, RADIOLINJA" },
	{ L"20030205:190215", L"9000, 15227, RADIOLINJA" },
	{ L"20030205:190224", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:190618", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:190631", L"9000, 15227, RADIOLINJA" },
	{ L"20030205:190641", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:190656", L"9000, 15227, RADIOLINJA" },
	{ L"20030205:190705", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:190753", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:190805", L"9000, 15227, RADIOLINJA" },
	{ L"20030205:190815", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:190834", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:190902", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:190936", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:190949", L"9000, 15227, RADIOLINJA" },
	{ L"20030205:190959", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:191029", L"9000, 15227, RADIOLINJA" },
	{ L"20030205:191038", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:191054", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:191127", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:191314", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:191331", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:191347", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:191539", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:191621", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:191639", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:191953", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:192003", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:192107", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:192140", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:192211", L"9000, 15227, RADIOLINJA" },
	{ L"20030205:192246", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:192328", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:192814", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:192950", L"9000, 15227, RADIOLINJA" },
	{ L"20030205:192959", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:193944", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:194544", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:194553", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:194614", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:194627", L"9000, 15227, RADIOLINJA" },
	{ L"20030205:194640", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:194729", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:195013", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:195029", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:195045", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:195126", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:195135", L"9000, 15227, RADIOLINJA" },
	{ L"20030205:195145", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:195201", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:195215", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:195236", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:195323", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:195444", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:195550", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:195718", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:195746", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:195822", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:195854", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:195934", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:200206", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:200219", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:200236", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:200553", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:200613", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:201150", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:201201", L"9000, 15227, RADIOLINJA" },
	{ L"20030205:201330", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:201346", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:201404", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:201420", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:201527", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:202353", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:202408", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:202519", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:202725", L"9006, 390, RADIOLINJA" },
	{ L"20030205:202742", L"9006, 372, RADIOLINJA" },
	{ L"20030205:202755", L"9006, 15121, RADIOLINJA" },
	{ L"20030205:202815", L"9006, 35264, RADIOLINJA" },
	{ L"20030205:202833", L"9006, 35532, RADIOLINJA" },
	{ L"20030205:202847", L"9006, 176, RADIOLINJA" },
	{ L"20030205:202900", L"9006, 269, RADIOLINJA" },
	{ L"20030205:202909", L"9006, 40944, RADIOLINJA" },
	{ L"20030205:202927", L"9006, 62054, RADIOLINJA" },
	{ L"20030205:202938", L"9006, 354, RADIOLINJA" },
	{ L"20030205:203112", L"9006, 62054, RADIOLINJA" },
	{ L"20030205:203154", L"9000, 35769, RADIOLINJA" },
	{ L"20030205:203236", L"9000, 320, RADIOLINJA" },
	{ L"20030205:203253", L"9006, 35560, RADIOLINJA" },
	{ L"20030205:203339", L"9000, 35769, RADIOLINJA" },
	{ L"20030205:203359", L"9006, 35560, RADIOLINJA" },
	{ L"20030205:203414", L"9000, 35769, RADIOLINJA" },
	{ L"20030205:203429", L"9006, 62054, RADIOLINJA" },
	{ L"20030205:203445", L"9006, 354, RADIOLINJA" },
	{ L"20030205:203501", L"9006, 62054, RADIOLINJA" },
	{ L"20030205:203526", L"9006, 41130, RADIOLINJA" },
	{ L"20030205:203536", L"9006, 377, RADIOLINJA" },
	{ L"20030205:203649", L"9006, 37204, RADIOLINJA" },
	{ L"20030205:203659", L"9006, 41723, RADIOLINJA" },
	{ L"20030205:203716", L"9006, 37204, RADIOLINJA" },
	{ L"20030205:203755", L"9006, 15300, RADIOLINJA" },
	{ L"20030205:203817", L"9006, 233, RADIOLINJA" },
	{ L"20030205:203826", L"9006, 62067, RADIOLINJA" },
	{ L"20030205:203851", L"9006, 233, RADIOLINJA" },
	{ L"20030205:203900", L"9006, 38584, RADIOLINJA" },
	{ L"20030205:203955", L"9006, 232, RADIOLINJA" },
	{ L"20030205:204012", L"9006, 174, RADIOLINJA" },
	{ L"20030205:204100", L"9006, 35245, RADIOLINJA" },
	{ L"20030205:204132", L"9006, 15397, RADIOLINJA" },
	{ L"20030205:204149", L"9006, 35245, RADIOLINJA" },
	{ L"20030205:204200", L"9112, 35775, RADIOLINJA" },
	{ L"20030205:204227", L"9112, 62077, RADIOLINJA" },
	{ L"20030205:204311", L"9112, 62076, RADIOLINJA" },
	{ L"20030205:204320", L"9112, 9892, RADIOLINJA" },
	{ L"20030205:204337", L"9112, 182, RADIOLINJA" },
	{ L"20030205:204407", L"9112, 42340, RADIOLINJA" },
	{ L"20030205:204424", L"9112, 101, RADIOLINJA" },
	{ L"20030205:204434", L"9112, 39882, RADIOLINJA" },
	{ L"20030205:204451", L"9112, 1423, RADIOLINJA" },
	{ L"20030205:204511", L"9112, 1383, RADIOLINJA" },
	{ L"20030205:204523", L"9112, 62084, RADIOLINJA" },
	{ L"20030205:204616", L"9112, 62083, RADIOLINJA" },
	{ L"20030205:204635", L"9112, 62084, RADIOLINJA" },
	{ L"20030205:204953", L"9112, 431, RADIOLINJA" },
	{ L"20030205:205012", L"9112, 40627, RADIOLINJA" },
	{ L"20030205:212820", L"9112, 62084, RADIOLINJA" },
	{ L"20030205:212946", L"9112, 436, RADIOLINJA" },
	{ L"20030205:212955", L"9112, 62084, RADIOLINJA" },
	{ L"20030205:213307", L"9112, 39396, RADIOLINJA" },
	{ L"20030205:213317", L"9112, 15022, RADIOLINJA" },
	{ L"20030205:213806", L"9112, 62084, RADIOLINJA" },
	{ L"20030205:213846", L"9112, 3508, RADIOLINJA" },
	{ L"20030205:213900", L"9112, 431, RADIOLINJA" },
	{ L"20030205:213915", L"9112, 1383, RADIOLINJA" },
	{ L"20030205:213926", L"9112, 39882, RADIOLINJA" },
	{ L"20030205:214041", L"9112, 101, RADIOLINJA" },
	{ L"20030205:214051", L"9112, 42340, RADIOLINJA" },
	{ L"20030205:214106", L"9112, 182, RADIOLINJA" },
	{ L"20030205:214132", L"9112, 39883, RADIOLINJA" },
	{ L"20030205:214219", L"9112, 9892, RADIOLINJA" },
	{ L"20030205:214232", L"9112, 62077, RADIOLINJA" },
	{ L"20030205:214323", L"9112, 35582, RADIOLINJA" },
	{ L"20030205:214919", L"9000, 35783, RADIOLINJA" },
	{ L"20030205:214953", L"9000, 442, RADIOLINJA" },
	{ L"20030205:215215", L"9000, 294, RADIOLINJA" },
	{ L"20030205:215450", L"9000, 396, RADIOLINJA" },
	{ L"20030205:215718", L"9000, 62034, RADIOLINJA" },
	{ L"20030205:220024", L"9000, 1969, RADIOLINJA" },
	{ L"20030205:220229", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:220300", L"9000, 350, RADIOLINJA" },
	{ L"20030205:220316", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:220351", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:220443", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:220532", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:220603", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:220650", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:220743", L"9000, 15227, RADIOLINJA" },
	{ L"20030205:221115", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:221208", L"9000, 15227, RADIOLINJA" },
	{ L"20030205:221314", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:221439", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:221452", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:221542", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:221558", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:221631", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:221648", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:222600", L"9000, 15227, RADIOLINJA" },
	{ L"20030205:222617", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:222815", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:222830", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:223118", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:223133", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:223547", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:223608", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:223929", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:223959", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:224228", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:224256", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:224434", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:224443", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:224508", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:224854", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:224918", L"9000, 15227, RADIOLINJA" },
	{ L"20030205:224942", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:225037", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:225236", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:225412", L"9000, 15227, RADIOLINJA" },
	{ L"20030205:225425", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:225531", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:225618", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:225817", L"9000, 15227, RADIOLINJA" },
	{ L"20030205:225859", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:230255", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:230637", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:231331", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:231347", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:231502", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:231552", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:232025", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:232042", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:232052", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:232205", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:232528", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:232708", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:232742", L"9000, 15227, RADIOLINJA" },
	{ L"20030205:232944", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:233005", L"9000, 15227, RADIOLINJA" },
	{ L"20030205:233044", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:233126", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:233150", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:233321", L"9000, 15227, RADIOLINJA" },
	{ L"20030205:233341", L"9000, 62125, RADIOLINJA" },
	{ L"20030205:233638", L"9000, 62124, RADIOLINJA" },
	{ L"20030205:233746", L"9006, 177, RADIOLINJA" },
	{ L"20030205:233838", L"9006, 176, RADIOLINJA" },
	{ L"20030205:233943", L"9006, 41823, RADIOLINJA" },
	{ L"20030205:233959", L"9006, 196, RADIOLINJA" },
	{ L"20030205:234029", L"9006, 39705, RADIOLINJA" },
	{ L"20030205:234038", L"9006, 354, RADIOLINJA" },
	{ L"20030205:234136", L"9006, 62054, RADIOLINJA" },
	{ L"20030205:234148", L"9006, 377, RADIOLINJA" },
	{ L"20030205:234253", L"9006, 41723, RADIOLINJA" },
	{ L"20030205:234312", L"9006, 349, RADIOLINJA" },
	{ L"20030205:234321", L"9006, 41723, RADIOLINJA" },
	{ L"20030205:234341", L"9006, 37204, RADIOLINJA" },
	{ L"20030205:234431", L"9006, 216, RADIOLINJA" },
	{ L"20030205:234440", L"9006, 15300, RADIOLINJA" },
	{ L"20030205:234636", L"9006, 62067, RADIOLINJA" },
	{ L"20030205:234727", L"9006, 4280, RADIOLINJA" },
	{ L"20030205:234743", L"9006, 15300, RADIOLINJA" },
	{ L"20030205:235004", L"9006, 35265, RADIOLINJA" },
	{ L"20030205:235015", L"9006, 15300, RADIOLINJA" },
	{ L"20030205:235015", L"SWITCH" },
	{ L"20030206:123157", L"9006, 399, RADIOLINJA" },
	{ L"20030206:123157", L"SWITCH" },
	{ L"20030206:140624", L"9006, 62032, RADIOLINJA" },
	{ L"20030206:140625", L"9006, 399, RADIOLINJA" },
	{ L"20030206:140648", L"9006, 376, RADIOLINJA" },
	{ L"20030206:140705", L"9006, 18, RADIOLINJA" },
	{ L"20030206:140737", L"9006, 376, RADIOLINJA" },
	{ L"20030206:140812", L"9006, 376, RADIOLINJA" },
	{ L"20030206:140823", L"9006, 376, RADIOLINJA" },
	{ L"20030206:140823", L"9006, 376, RADIOLINJA" },
	{ L"20030206:140844", L"9006, 62032, RADIOLINJA" },
	{ L"20030206:141224", L"9006, 18, RADIOLINJA" },
	{ L"20030206:141401", L"9006, 62032, RADIOLINJA" },
	{ L"20030206:141429", L"9006, 18, RADIOLINJA" },
	{ L"20030206:141509", L"9006, 376, RADIOLINJA" },
	{ L"20030206:141556", L"9006, 399, RADIOLINJA" },
	{ L"20030206:141843", L"9006, 376, RADIOLINJA" },
	{ L"20030206:141923", L"9006, 399, RADIOLINJA" },
	{ L"20030206:142125", L"9006, 376, RADIOLINJA" },
	{ L"20030206:142323", L"9006, 399, RADIOLINJA" },
	{ L"20030206:144415", L"9006, 376, RADIOLINJA" },
	{ L"20030206:144431", L"9006, 399, RADIOLINJA" },
	{ L"20030206:144510", L"9006, 376, RADIOLINJA" },
	{ L"20030206:144617", L"9006, 399, RADIOLINJA" },
	{ L"20030206:150501", L"9006, 376, RADIOLINJA" },
	{ L"20030206:150517", L"9006, 399, RADIOLINJA" },
	{ L"20030206:150605", L"9006, 376, RADIOLINJA" },
	{ L"20030206:150715", L"9006, 399, RADIOLINJA" },
	{ L"20030206:150751", L"9006, 376, RADIOLINJA" },
	{ L"20030206:150830", L"9006, 399, RADIOLINJA" },
	{ L"20030206:151114", L"9006, 376, RADIOLINJA" },
	{ L"20030206:151133", L"9006, 399, RADIOLINJA" },
	{ L"20030206:151813", L"9006, 376, RADIOLINJA" },
	{ L"20030206:151849", L"9006, 399, RADIOLINJA" },
	{ L"20030206:151902", L"9006, 376, RADIOLINJA" },
	{ L"20030206:151944", L"9006, 399, RADIOLINJA" },
	{ L"20030206:161617", L"9006, 376, RADIOLINJA" },
	{ L"20030206:161647", L"9006, 399, RADIOLINJA" },
	{ L"20030206:161714", L"9006, 376, RADIOLINJA" },
	{ L"20030206:161740", L"9006, 399, RADIOLINJA" },
	{ L"20030206:162202", L"9006, 1493, RADIOLINJA" },
	{ L"20030206:162226", L"9006, 399, RADIOLINJA" },
	{ L"20030206:162243", L"9006, 1493, RADIOLINJA" },
	{ L"20030206:162419", L"9006, 601, RADIOLINJA" },
	{ L"20030206:162541", L"9006, 1493, RADIOLINJA" },
	{ L"20030206:162558", L"9006, 550, RADIOLINJA" },
	{ L"20030206:162809", L"9006, 38583, RADIOLINJA" },
	{ L"20030206:162833", L"9006, 232, RADIOLINJA" },
	{ L"20030206:163039", L"9006, 233, RADIOLINJA" },
	{ L"20030206:163117", L"9006, 232, RADIOLINJA" },
	{ L"20030206:163130", L"9006, 233, RADIOLINJA" },
	{ L"20030206:163223", L"9006, 441, RADIOLINJA" },
	{ L"20030206:163348", L"9000, 35783, RADIOLINJA" },
	{ L"20030206:163500", L"9000, 442, RADIOLINJA" },
	{ L"20030206:163744", L"9000, 294, RADIOLINJA" },
	{ L"20030206:164007", L"9000, 15206, RADIOLINJA" },
	{ L"20030206:164131", L"9000, 396, RADIOLINJA" },
	{ L"20030206:164259", L"9000, 15206, RADIOLINJA" },
	{ L"20030206:164320", L"9000, 396, RADIOLINJA" },
	{ L"20030206:164345", L"9000, 15206, RADIOLINJA" },
	{ L"20030206:164409", L"9000, 396, RADIOLINJA" },
	{ L"20030206:164519", L"9000, 15206, RADIOLINJA" },
	{ L"20030206:164536", L"9000, 37887, RADIOLINJA" },
	{ L"20030206:164546", L"9000, 645, RADIOLINJA" },
	{ L"20030206:164715", L"9000, 35822, RADIOLINJA" },
	{ L"20030206:165131", L"9000, 37887, RADIOLINJA" },
	{ L"20030206:165147", L"9000, 645, RADIOLINJA" },
	{ L"20030206:165209", L"9000, 15206, RADIOLINJA" },
	{ L"20030206:165252", L"9000, 396, RADIOLINJA" },
	{ L"20030206:165337", L"9000, 15206, RADIOLINJA" },
	{ L"20030206:165422", L"9000, 396, RADIOLINJA" },
	{ L"20030206:165704", L"9000, 15206, RADIOLINJA" },
	{ L"20030206:170018", L"9000, 37887, RADIOLINJA" },
	{ L"20030206:170028", L"9000, 15206, RADIOLINJA" },
	{ L"20030206:170205", L"9000, 188, RADIOLINJA" },
	{ L"20030206:170245", L"9000, 15206, RADIOLINJA" },
	{ L"20030206:170332", L"9000, 188, RADIOLINJA" },
	{ L"20030206:170347", L"9000, 396, RADIOLINJA" },
	{ L"20030206:170654", L"9000, 15206, RADIOLINJA" },
	{ L"20030206:170715", L"9000, 396, RADIOLINJA" },
	{ L"20030206:170809", L"9000, 15206, RADIOLINJA" },
	{ L"20030206:170836", L"9000, 396, RADIOLINJA" },
	{ L"20030206:170900", L"9000, 15206, RADIOLINJA" },
	{ L"20030206:172424", L"9000, 396, RADIOLINJA" },
	{ L"20030206:172815", L"9000, 62034, RADIOLINJA" },
	{ L"20030206:172824", L"9000, 396, RADIOLINJA" },
	{ L"20030206:172841", L"9000, 62034, RADIOLINJA" },
	{ L"20030206:172936", L"9000, 15135, RADIOLINJA" },
	{ L"20030206:172950", L"9000, 62034, RADIOLINJA" },
	{ L"20030206:173003", L"9000, 1969, RADIOLINJA" },
	{ L"20030206:173040", L"9000, 350, RADIOLINJA" },
	{ L"20030206:173124", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:173140", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:173245", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:173307", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:173317", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:173729", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:173837", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:173846", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:173859", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:174232", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:174651", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:174701", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:174958", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:175427", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:175552", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:175646", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:175707", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:175724", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:175804", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:175813", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:175900", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:175916", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:175925", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:175945", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:180157", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:180220", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:180235", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:180600", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:181024", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:181033", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:181133", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:181152", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:181211", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:181252", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:181317", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:181500", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:181555", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:181635", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:181735", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:181801", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:181835", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:181851", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:182015", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:182032", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:182048", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:182243", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:182404", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:182425", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:182459", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:182508", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:182529", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:182620", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:182636", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:182654", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:182710", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:183053", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:183217", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:183233", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:183821", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:183834", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:183904", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:183913", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:184354", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:184522", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:184732", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:184910", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:184921", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:185004", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:185016", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:185029", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:185138", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:185152", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:185311", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:185348", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:185428", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:185443", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:185456", L"9000, 350, RADIOLINJA" },
	{ L"20030206:185509", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:185600", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:185638", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:185651", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:185711", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:185855", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:190436", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:190453", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:190659", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:190741", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:191704", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:191713", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:191845", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:191858", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:192420", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:192433", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:192507", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:192516", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:192554", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:192603", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:192641", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:192650", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:192832", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:192843", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:193044", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:193101", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:193848", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:193857", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:194022", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:194059", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:195334", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:195343", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:195833", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:195842", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:195852", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:200355", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:200404", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:200433", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:200520", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:200529", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:200559", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:200902", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:200919", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:200928", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:200943", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:202051", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:202107", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:202335", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:202345", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:202419", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:202443", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:202504", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:202513", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:202523", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:202621", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:203009", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:203037", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:203137", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:203150", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:203254", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:203319", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:203629", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:203712", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:203901", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:203923", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:203924", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:204052", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:204200", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:204425", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:204512", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:204542", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:204612", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:204628", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:205717", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:205726", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:205819", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:205839", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:205851", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:205915", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:210343", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:210352", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:210517", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:210526", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:210546", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:210609", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:210647", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:210704", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:210901", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:210910", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:211137", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:211220", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:211236", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:211246", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:211447", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:211503", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:212755", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:212822", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:213050", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:213111", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:213332", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:213348", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:214718", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:214728", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:215147", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:215204", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:215715", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:215726", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:215828", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:215855", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:220816", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:220855", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:221404", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:221540", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:221657", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:221736", L"9000, 62125, RADIOLINJA" },
	{ L"20030206:221758", L"9000, 15227, RADIOLINJA" },
	{ L"20030206:221812", L"9000, 41097, RADIOLINJA" },
	{ L"20030206:221824", L"9000, 62124, RADIOLINJA" },
	{ L"20030206:221854", L"9006, 177, RADIOLINJA" },
	{ L"20030206:221934", L"9006, 176, RADIOLINJA" },
	{ L"20030206:222039", L"9006, 41823, RADIOLINJA" },
	{ L"20030206:222056", L"9006, 196, RADIOLINJA" },
	{ L"20030206:222133", L"9006, 39705, RADIOLINJA" },
	{ L"20030206:222144", L"9006, 354, RADIOLINJA" },
	{ L"20030206:222238", L"9006, 62054, RADIOLINJA" },
	{ L"20030206:222248", L"9006, 377, RADIOLINJA" },
	{ L"20030206:222402", L"9006, 35324, RADIOLINJA" },
	{ L"20030206:222408", L"9006, 41723, RADIOLINJA" },
	{ L"20030206:222453", L"9006, 37204, RADIOLINJA" },
	{ L"20030206:222558", L"9006, 216, RADIOLINJA" },
	{ L"20030206:222607", L"9006, 15300, RADIOLINJA" },
	{ L"20030206:222825", L"9006, 62067, RADIOLINJA" },
	{ L"20030206:222903", L"9006, 15300, RADIOLINJA" },
	{ L"20030206:223247", L"9006, 15300, RADIOLINJA" },
	{ L"20030206:223250", L"9006, 15300, RADIOLINJA" },
	{ L"20030206:223250", L"9006, 15300, RADIOLINJA" },
	{ L"20030206:223308", L"9006, 15300, RADIOLINJA" },
	{ L"20030206:223309", L"9006, 15300, RADIOLINJA" },
	{ L"20030206:223309", L"SWITCH" },
	{ L"20030206:223746", L"9006, 15300, RADIOLINJA" },
	{ L"20030206:225124", L"9006, 4280, RADIOLINJA" },
	{ L"20030206:225133", L"9006, 15300, RADIOLINJA" },
	{ L"20030207:073332", L"9006, 216, RADIOLINJA" },
	{ L"20030207:073343", L"9006, 15300, RADIOLINJA" },
	{ L"20030207:083715", L"9006, 35265, RADIOLINJA" },
	{ L"20030207:083725", L"9006, 15300, RADIOLINJA" },
	{ L"20030207:084247", L"9006, 15300, RADIOLINJA" },
	{ L"20030207:084252", L"9006, 15300, RADIOLINJA" },
	{ L"20030207:084252", L"9006, 15300, RADIOLINJA" },
	{ L"20030207:084307", L"9006, 15300, RADIOLINJA" },
	{ L"20030207:084307", L"9006, 15300, RADIOLINJA" },
	{ L"20030207:084335", L"9006, 15300, RADIOLINJA" },
	{ L"20030207:084335", L"9006, 15300, RADIOLINJA" },
	{ L"20030207:084406", L"9006, 15300, RADIOLINJA" },
	{ L"20030207:084406", L"9006, 15300, RADIOLINJA" },
	{ L"20030207:084450", L"9006, 15300, RADIOLINJA" },
	{ L"20030207:085305", L"9006, 217, RADIOLINJA" },
	{ L"20030207:085331", L"9006, 511, RADIOLINJA" },
	{ L"20030207:085341", L"9006, 67, RADIOLINJA" },
	{ L"20030207:085431", L"9000, 144, RADIOLINJA" },
	{ L"20030207:085451", L"9000, 15128, RADIOLINJA" },
	{ L"20030207:085607", L"9006, 67, RADIOLINJA" },
	{ L"20030207:085621", L"9000, 35781, RADIOLINJA" },
	{ L"20030207:085637", L"9000, 168, RADIOLINJA" },
	{ L"20030207:085703", L"9000, 62019, RADIOLINJA" },
	{ L"20030207:085726", L"9000, 440, RADIOLINJA" },
	{ L"20030207:085744", L"9000, 188, RADIOLINJA" },
	{ L"20030207:085914", L"9000, 294, RADIOLINJA" },
	{ L"20030207:090117", L"9000, 15206, RADIOLINJA" },
	{ L"20030207:090928", L"9000, 396, RADIOLINJA" },
	{ L"20030207:090941", L"9000, 15206, RADIOLINJA" },
	{ L"20030207:090958", L"9000, 396, RADIOLINJA" },
	{ L"20030207:091009", L"9000, 15206, RADIOLINJA" },
	{ L"20030207:091130", L"9000, 396, RADIOLINJA" },
	{ L"20030207:091149", L"9000, 15206, RADIOLINJA" },
	{ L"20030207:091713", L"9000, 396, RADIOLINJA" },
	{ L"20030207:092417", L"9000, 62034, RADIOLINJA" },
	{ L"20030207:092541", L"9000, 1969, RADIOLINJA" },
	{ L"20030207:092622", L"9000, 350, RADIOLINJA" },
	{ L"20030207:092640", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:092725", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:092836", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:092859", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:093150", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:093232", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:093315", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:093334", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:093350", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:093407", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:093417", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:093438", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:093451", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:093515", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:093625", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:093842", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:093858", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:093959", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:094043", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:094054", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:094105", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:094130", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:094251", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:094300", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:094343", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:094359", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:094423", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:094440", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:094833", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:094842", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:095141", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:095258", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:101757", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:101840", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:101907", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:101924", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:102816", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:102844", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:102911", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:102927", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:103217", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:103226", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:103612", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:103629", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:103719", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:103728", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:104422", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:104435", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:104454", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:104503", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:104600", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:104635", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:104819", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:104828", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:105152", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:105201", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:105226", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:105242", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:105337", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:105435", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:110901", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:111011", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:111102", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:111122", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:111631", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:111640", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:111946", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:112002", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:112232", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:112300", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:113106", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:113204", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:113321", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:113334", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:113607", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:113631", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:113646", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:113709", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:113725", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:113735", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:113945", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:114221", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:114236", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:114310", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:114326", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:114530", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:114546", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:114626", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:114717", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:114828", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:115023", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:115048", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:115107", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:115116", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:115745", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:115802", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:120612", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:120635", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:120758", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:120833", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:120947", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:121015", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:121410", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:121427", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:121555", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:121643", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:121703", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:121730", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:121800", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:121832", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:121854", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:121909", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:121939", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:122015", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:122031", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:122049", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:122105", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:122142", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:122248", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:122303", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:122314", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:122416", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:122726", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:122742", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:123150", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:123206", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:123240", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:123309", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:123337", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:123353", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:123647", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:123708", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:123828", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:123845", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:124003", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:124025", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:124311", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:124343", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:124430", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:124615", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:124708", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:124717", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:124736", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:124901", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:124917", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:124935", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:124959", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:125050", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:125120", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:125141", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:125205", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:125315", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:125402", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:125426", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:125517", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:125547", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:125557", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:125632", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:125805", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:125825", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:130005", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:130022", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:130237", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:130247", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:130410", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:130423", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:130815", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:130836", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:131008", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:131108", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:131238", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:131254", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:131311", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:131325", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:131709", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:131721", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:132127", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:132140", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:132433", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:132500", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:132553", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:132606", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:132731", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:132740", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:133740", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:133750", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:133838", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:133958", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:134022", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:134043", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:134616", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:134625", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:135809", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:135837", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:135847", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:135903", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:140238", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:140259", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:140832", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:140842", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:142132", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:142141", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:143234", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:143302", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:143535", L"9000, 350, RADIOLINJA" },
	{ L"20030207:143557", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:143616", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:143633", L"9000, 350, RADIOLINJA" },
	{ L"20030207:143642", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:143735", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:143850", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:143900", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:143917", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:143926", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:144052", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:144117", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:144221", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:144232", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:144257", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:144330", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:144349", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:144400", L"9000, 350, RADIOLINJA" },
	{ L"20030207:144414", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:144605", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:144644", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:144653", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:144716", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:144741", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:144852", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:144905", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:144922", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:144950", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:145002", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:145018", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:145058", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:145138", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:145302", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:145535", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:145714", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:145728", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:150008", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:150102", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:150301", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:150310", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:150327", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:150440", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:150503", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:150503", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:150511", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:151122", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:151827", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:151843", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:152122", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:152204", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:152220", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:152315", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:152359", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:152449", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:152520", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:152535", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:152657", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:152713", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:152803", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:152843", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:152859", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:152915", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:153026", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:153110", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:153158", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:153208", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:153234", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:153253", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:153309", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:153344", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:153450", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:153507", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:153529", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:153559", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:153732", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:153845", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:154147", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:154157", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:155628", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:155648", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:155851", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:155907", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:155951", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:160301", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:160451", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:160554", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:160648", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:160704", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:160714", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:160746", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:160839", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:160855", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:160926", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:161226", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:161242", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:161310", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:161323", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:161417", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:161433", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:161544", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:161618", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:161731", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:161811", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:162058", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:162208", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:162224", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:162255", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:162331", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:162353", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:162412", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:162532", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:162542", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:162824", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:162849", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:163524", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:163541", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:164018", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:164112", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:164154", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:164222", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:164339", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:164445", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:164500", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:164513", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:164527", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:164536", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:165024", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:165059", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:165633", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:165644", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:165700", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:165813", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:165824", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:170007", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:170031", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:170103", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:170119", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:170716", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:170731", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:170847", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:170903", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:170934", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:170953", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:171136", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:171158", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:171221", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:171237", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:171249", L"9000, 15227, RADIOLINJA" },
	{ L"20030207:171352", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:171414", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:171435", L"9000, 62125, RADIOLINJA" },
	{ L"20030207:171541", L"9000, 350, RADIOLINJA" },
	{ L"20030207:171607", L"9000, 62124, RADIOLINJA" },
	{ L"20030207:171733", L"9000, 35565, RADIOLINJA" },
	{ L"20030207:171759", L"9000, 35565, RADIOLINJA" },
	{ L"20030207:171814", L"9000, 35565, RADIOLINJA" },
	{ L"20030207:171814", L"9000, 35565, RADIOLINJA" },
	{ L"20030207:171826", L"9000, 41532, RADIOLINJA" },
	{ L"20030207:171838", L"9006, 176, RADIOLINJA" },
	{ L"20030207:172029", L"9006, 41823, RADIOLINJA" },
	{ L"20030207:172044", L"9006, 196, RADIOLINJA" },
	{ L"20030207:172124", L"9006, 197, RADIOLINJA" },
	{ L"20030207:172134", L"9006, 354, RADIOLINJA" },
	{ L"20030207:172252", L"9006, 62054, RADIOLINJA" },
	{ L"20030207:172302", L"9006, 377, RADIOLINJA" },
	{ L"20030207:172445", L"9006, 41723, RADIOLINJA" },
	{ L"20030207:172515", L"9006, 35779, RADIOLINJA" },
	{ L"20030207:172553", L"9006, 376, RADIOLINJA" },
	{ L"20030207:172649", L"9006, 38583, RADIOLINJA" },
	{ L"20030207:172718", L"9006, 550, RADIOLINJA" },
	{ L"20030207:172815", L"9006, 40239, RADIOLINJA" },
	{ L"20030207:173021", L"9006, 40238, RADIOLINJA" },
	{ L"20030207:173044", L"9006, 41710, RADIOLINJA" },
	{ L"20030207:173054", L"9006, 40238, RADIOLINJA" },
	{ L"20030207:173134", L"9006, 15147, RADIOLINJA" },
	{ L"20030207:173153", L"9006, 39445, RADIOLINJA" },
	{ L"20030207:173216", L"9006, 39444, RADIOLINJA" },
	{ L"20030207:173312", L"9111, 40741, RADIOLINJA" },
	{ L"20030207:173333", L"9111, 4314, RADIOLINJA" },
	{ L"20030207:173550", L"9111, 62456, RADIOLINJA" },
	{ L"20030207:173608", L"9111, 429, RADIOLINJA" },
	{ L"20030207:173617", L"9111, 15123, RADIOLINJA" },
	{ L"20030207:235332", L"9111, 4314, RADIOLINJA" },
	{ L"20030207:235411", L"9111, 62456, RADIOLINJA" },
	{ L"20030207:235451", L"9111, 62457, RADIOLINJA" },
	{ L"20030207:235632", L"9111, 62457, RADIOLINJA" },
	{ L"20030207:235636", L"9006, 39445, RADIOLINJA" },
	{ L"20030207:235637", L"9006, 39445, RADIOLINJA" },
	{ L"20030207:235808", L"9006, 41710, RADIOLINJA" },
	{ L"20030207:235820", L"9006, 40238, RADIOLINJA" },
	{ L"20030207:235904", L"9006, 40239, RADIOLINJA" },
	{ L"20030207:235947", L"9006, 550, RADIOLINJA" },
	{ L"20030208:000030", L"9006, 38583, RADIOLINJA" },
	{ L"20030208:000054", L"9006, 376, RADIOLINJA" },
	{ L"20030208:000158", L"9006, 36020, RADIOLINJA" },
	{ L"20030208:000208", L"9006, 35779, RADIOLINJA" },
	{ L"20030208:000233", L"9006, 41723, RADIOLINJA" },
	{ L"20030208:000253", L"9006, 377, RADIOLINJA" },
	{ L"20030208:000355", L"9006, 354, RADIOLINJA" },
	{ L"20030208:000407", L"9006, 39705, RADIOLINJA" },
	{ L"20030208:000416", L"9006, 196, RADIOLINJA" },
	{ L"20030208:000507", L"9006, 41823, RADIOLINJA" },
	{ L"20030208:000522", L"9006, 176, RADIOLINJA" },
	{ L"20030208:000648", L"9000, 41532, RADIOLINJA" },
	{ L"20030208:000706", L"9000, 36095, RADIOLINJA" },
	{ L"20030208:000716", L"9000, 350, RADIOLINJA" },
	{ L"20030208:000818", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:000829", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:000950", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:001004", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:001030", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:001115", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:001154", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:001204", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:001228", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:001247", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:001355", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:001408", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:001452", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:001655", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:001724", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:001737", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:001900", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:001909", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:002036", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:002104", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:002230", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:002240", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:002340", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:002427", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:002548", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:002612", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:002748", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:002804", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:002820", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:002858", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:003019", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:003035", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:003055", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:003115", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:003902", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:004012", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:004131", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:004225", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:004241", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:004257", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:004458", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:004507", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:004526", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:004628", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:004704", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:004713", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:004804", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:004813", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:004905", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:004929", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:005029", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:005038", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:005133", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:005150", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:005702", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:005755", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:005829", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:005845", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:005923", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:010122", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:010144", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:010211", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:010308", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:010354", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:010451", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:010500", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:011223", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:011232", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:011253", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:011303", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:011422", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:012059", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:012428", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:012441", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:012538", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:012547", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:012726", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:012743", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:013055", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:013114", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:013318", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:013333", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:013616", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:013759", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:013823", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:013903", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:014001", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:014145", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:014200", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:014209", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:014222", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:014258", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:014406", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:014500", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:014510", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:014521", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:014638", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:014706", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:014746", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:014905", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:015043", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:015200", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:015222", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:015325", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:015646", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:015733", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:015745", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:015928", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:015939", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:015948", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:020111", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:020217", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:021645", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:021655", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:021931", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:022035", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:022203", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:022351", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:022511", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:022606", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:022716", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:022825", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:023058", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:023126", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:023228", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:023251", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:023330", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:023406", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:023415", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:023459", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:023508", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:023548", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:023954", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:024009", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:024107", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:024117", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:024215", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:024703", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:024712", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:024824", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:024901", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:024911", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:025026", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:025121", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:025138", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:025329", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:025947", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:030013", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:030051", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:030227", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:030448", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:030509", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:030528", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:030550", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:030604", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:031057", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:031430", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:031439", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:031453", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:031502", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:031854", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:031937", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:032024", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:032033", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:032211", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:032254", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:032341", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:032400", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:032410", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:032448", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:032500", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:032720", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:032803", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:032913", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:032922", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:033049", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:033058", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:033505", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:033514", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:033641", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:033739", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:033802", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:033848", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:034006", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:034019", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:035335", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:035428", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:035446", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:035503", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:035537", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:035548", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:035643", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:035721", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:035730", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:040101", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:040117", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:040125", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:040239", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:040354", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:040433", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:040941", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:040956", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:041024", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:041133", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:041232", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:041249", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:041404", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:041432", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:042106", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:042122", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:042227", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:042249", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:042611", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:042627", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:042730", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:042746", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:043312", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:043329", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:043524", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:043548", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:043916", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:043932", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:044220", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:044235", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:044556", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:044622", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:044649", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:044724", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:044854", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:044944", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:045031", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:045040", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:045103", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:045147", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:045157", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:045601", L"9000, 26, RADIOLINJA" },
	{ L"20030208:045610", L"9000, 27, RADIOLINJA" },
	{ L"20030208:045623", L"9000, 41281, RADIOLINJA" },
	{ L"20030208:045636", L"9000, 62102, RADIOLINJA" },
	{ L"20030208:045656", L"9000, 194, RADIOLINJA" },
	{ L"20030208:045707", L"9000, 195, RADIOLINJA" },
	{ L"20030208:045718", L"9000, 36004, RADIOLINJA" },
	{ L"20030208:045731", L"9000, 283, RADIOLINJA" },
	{ L"20030208:045746", L"9000, 599, RADIOLINJA" },
	{ L"20030208:045815", L"9000, 62105, RADIOLINJA" },
	{ L"20030208:045858", L"9000, 42335, RADIOLINJA" },
	{ L"20030208:045908", L"9000, 62112, RADIOLINJA" },
	{ L"20030208:045937", L"9000, 62110, RADIOLINJA" },
	{ L"20030208:045948", L"9000, 62112, RADIOLINJA" },
	{ L"20030208:045959", L"9000, 179, RADIOLINJA" },
	{ L"20030208:050604", L"9000, 62111, RADIOLINJA" },
	{ L"20030208:050629", L"9000, 179, RADIOLINJA" },
	{ L"20030208:091014", L"9000, 178, RADIOLINJA" },
	{ L"20030208:091051", L"9000, 179, RADIOLINJA" },
	{ L"20030208:091754", L"9000, 62112, RADIOLINJA" },
	{ L"20030208:091803", L"9000, 9814, RADIOLINJA" },
	{ L"20030208:091821", L"9000, 62112, RADIOLINJA" },
	{ L"20030208:091918", L"9000, 62116, RADIOLINJA" },
	{ L"20030208:091957", L"9000, 62112, RADIOLINJA" },
	{ L"20030208:092026", L"9000, 62116, RADIOLINJA" },
	{ L"20030208:092251", L"9000, 62112, RADIOLINJA" },
	{ L"20030208:092351", L"9000, 62116, RADIOLINJA" },
	{ L"20030208:092531", L"9000, 62112, RADIOLINJA" },
	{ L"20030208:092625", L"9000, 62116, RADIOLINJA" },
	{ L"20030208:093058", L"9000, 62112, RADIOLINJA" },
	{ L"20030208:093120", L"9000, 62110, RADIOLINJA" },
	{ L"20030208:093233", L"9000, 503, RADIOLINJA" },
	{ L"20030208:093344", L"9000, 495, RADIOLINJA" },
	{ L"20030208:093450", L"9000, 35302, RADIOLINJA" },
	{ L"20030208:093506", L"9000, 495, RADIOLINJA" },
	{ L"20030208:093615", L"9000, 35302, RADIOLINJA" },
	{ L"20030208:093646", L"9000, 62462, RADIOLINJA" },
	{ L"20030208:093654", L"9000, 62993, RADIOLINJA" },
	{ L"20030208:093817", L"9000, 215, RADIOLINJA" },
	{ L"20030208:093903", L"9000, 15276, RADIOLINJA" },
	{ L"20030208:093955", L"9000, 396, RADIOLINJA" },
	{ L"20030208:094146", L"9000, 62034, RADIOLINJA" },
	{ L"20030208:094251", L"9000, 1969, RADIOLINJA" },
	{ L"20030208:094317", L"9000, 350, RADIOLINJA" },
	{ L"20030208:094359", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:094416", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:094527", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:094611", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:095310", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:095331", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:095414", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:095429", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:095605", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:095649", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:095717", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:095756", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:095917", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:095931", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:100059", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:100123", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:100923", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:101058", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:102452", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:102502", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:102745", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:102801", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:102818", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:102834", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:102901", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:102936", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:103129", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:103157", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:103526", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:103553", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:103854", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:103906", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:103927", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:104003", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:104052", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:104114", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:104130", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:104154", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:104233", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:104252", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:104559", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:104642", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:105245", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:105319", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:105436", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:105445", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:105603", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:105621", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:105637", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:105659", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:105715", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:105733", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:110124", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:110139", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:110334", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:110347", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:110422", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:110431", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:110516", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:110525", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:110806", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:110823", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:110858", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:110917", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:111740", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:111751", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:111908", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:111924", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:112005", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:112038", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:112129", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:112141", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:112149", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:112206", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:112214", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:112217", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:112221", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:112227", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:112244", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:112250", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:112342", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:112422", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:112437", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:112632", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:112656", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:112734", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:112749", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:112844", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:112847", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:112852", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:113331", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:113340", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:113420", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:113429", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:114523", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:114532", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:114846", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:114855", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:115009", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:115018", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:115400", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:115415", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:115657", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:115716", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:115735", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:115748", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:115905", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:120009", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:120215", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:120232", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:120306", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:120319", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:120345", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:120358", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:120419", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:120428", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:120457", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:120818", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:120831", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:120937", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:121003", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:121029", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:121039", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:121351", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:121411", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:121812", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:121937", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:122030", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:122045", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:122238", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:122254", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:122315", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:122325", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:122412", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:122440", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:122538", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:122603", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:122648", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:122705", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:122735", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:122752", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:123128", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:123144", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:123202", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:123234", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:123319", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:123347", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:123546", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:123603", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:123835", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:123856", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:123919", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:123927", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:123937", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:123949", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:124002", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:124204", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:124259", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:124405", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:124425", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:124505", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:124618", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:124919", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:124958", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:125602", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:125630", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:125646", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:125656", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:125719", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:125732", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:125825", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:130316", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:130332", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:130345", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:130402", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:130418", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:130432", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:130452", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:131109", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:131122", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:131631", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:131646", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:132338", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:132350", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:132529", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:132550", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:132800", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:132816", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:132906", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:132926", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:132942", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:133021", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:133112", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:133155", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:133327", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:133342", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:133414", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:133433", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:133452", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:133501", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:133513", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:133529", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:133611", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:133652", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:133756", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:133812", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:134129", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:134205", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:134543", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:134602", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:134623", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:134658", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:135200", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:135209", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:135228", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:135237", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:135305", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:135315", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:135345", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:135354", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:135410", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:135443", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:135545", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:135601", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:135759", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:140024", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:140050", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:140103", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:140253", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:140317", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:140446", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:140455", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:140550", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:140617", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:140629", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:140639", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:140649", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:141131", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:141217", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:141234", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:141259", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:141315", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:141336", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:141424", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:141440", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:141735", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:141821", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:142047", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:142102", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:142539", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:142733", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:142755", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:142812", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:142827", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:143003", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:143045", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:143337", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:143434", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:143447", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:143503", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:143626", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:143658", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:143719", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:143736", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:143810", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:143819", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:143845", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:143855", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:143916", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:143928", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:143950", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:144029", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:144146", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:144205", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:144226", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:144339", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:144625", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:144649", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:144706", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:144727", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:144736", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:144746", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:144802", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:144819", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:144844", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:144903", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:145001", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:145011", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:145043", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:145059", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:145128", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:150334", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:150401", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:150548", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:150657", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:150906", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:150922", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:151019", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:151136", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:151152", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:151210", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:151341", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:151349", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:151359", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:151604", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:151632", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:151648", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:151709", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:151726", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:151800", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:151920", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:151932", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:151949", L"9000, 15227, RADIOLINJA" },
	{ L"20030208:152029", L"9000, 62125, RADIOLINJA" },
	{ L"20030208:152050", L"9000, 62124, RADIOLINJA" },
	{ L"20030208:152153", L"9000, 35565, RADIOLINJA" },
	{ L"20030208:152214", L"9000, 41532, RADIOLINJA" },
	{ L"20030208:152226", L"9006, 176, RADIOLINJA" },
	{ L"20030208:152458", L"9006, 41823, RADIOLINJA" },
	{ L"20030208:152513", L"9006, 196, RADIOLINJA" },
	{ L"20030208:152601", L"9006, 197, RADIOLINJA" },
	{ L"20030208:152614", L"9006, 196, RADIOLINJA" },
	{ L"20030208:152624", L"9006, 354, RADIOLINJA" },
	{ L"20030208:152708", L"9006, 62054, RADIOLINJA" },
	{ L"20030208:152724", L"9006, 377, RADIOLINJA" },
	{ L"20030208:152839", L"9006, 62119, RADIOLINJA" },
	{ L"20030208:152855", L"9006, 377, RADIOLINJA" },
	{ L"20030208:152923", L"9006, 37204, RADIOLINJA" },
	{ L"20030208:152942", L"9006, 41723, RADIOLINJA" },
	{ L"20030208:152957", L"9006, 37204, RADIOLINJA" },
	{ L"20030208:153133", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:153412", L"9006, 62067, RADIOLINJA" },
	{ L"20030208:153505", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:153529", L"9006, 62067, RADIOLINJA" },
	{ L"20030208:153547", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:153724", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:153728", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:153728", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:153751", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:153801", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:153812", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:153814", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:153840", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:153840", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:153908", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:153908", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:153942", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:153943", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:154009", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:154009", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:154115", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:154115", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:154252", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:154252", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:154427", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:154427", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:154603", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:154603", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:154740", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:154740", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:154830", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:154830", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:154921", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:154921", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:155058", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:155058", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:155234", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:155234", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:155234", L"SWITCH" },
	{ L"20030208:165435", L"9006, 37204, RADIOLINJA" },
	{ L"20030208:165447", L"9006, 41723, RADIOLINJA" },
	{ L"20030208:165538", L"9006, 35324, RADIOLINJA" },
	{ L"20030208:165851", L"9006, 349, RADIOLINJA" },
	{ L"20030208:165935", L"9006, 35324, RADIOLINJA" },
	{ L"20030208:170033", L"9006, 35551, RADIOLINJA" },
	{ L"20030208:170054", L"9006, 35324, RADIOLINJA" },
	{ L"20030208:170111", L"9000, 766, RADIOLINJA" },
	{ L"20030208:170458", L"9000, 37887, RADIOLINJA" },
	{ L"20030208:170519", L"9000, 766, RADIOLINJA" },
	{ L"20030208:170536", L"9000, 35781, RADIOLINJA" },
	{ L"20030208:170553", L"9000, 37887, RADIOLINJA" },
	{ L"20030208:170610", L"9000, 766, RADIOLINJA" },
	{ L"20030208:170710", L"9000, 37887, RADIOLINJA" },
	{ L"20030208:170729", L"9000, 766, RADIOLINJA" },
	{ L"20030208:170748", L"9000, 62017, RADIOLINJA" },
	{ L"20030208:170919", L"9000, 766, RADIOLINJA" },
	{ L"20030208:170950", L"9000, 144, RADIOLINJA" },
	{ L"20030208:171010", L"9000, 766, RADIOLINJA" },
	{ L"20030208:171020", L"9000, 62017, RADIOLINJA" },
	{ L"20030208:171301", L"9000, 766, RADIOLINJA" },
	{ L"20030208:171317", L"9000, 144, RADIOLINJA" },
	{ L"20030208:171436", L"9000, 168, RADIOLINJA" },
	{ L"20030208:171456", L"9000, 144, RADIOLINJA" },
	{ L"20030208:171512", L"9000, 168, RADIOLINJA" },
	{ L"20030208:171533", L"9000, 35781, RADIOLINJA" },
	{ L"20030208:171545", L"9000, 62017, RADIOLINJA" },
	{ L"20030208:171602", L"9000, 35781, RADIOLINJA" },
	{ L"20030208:171621", L"9000, 62017, RADIOLINJA" },
	{ L"20030208:171918", L"9000, 35781, RADIOLINJA" },
	{ L"20030208:171930", L"9000, 37887, RADIOLINJA" },
	{ L"20030208:171952", L"9000, 766, RADIOLINJA" },
	{ L"20030208:172009", L"9000, 35781, RADIOLINJA" },
	{ L"20030208:172026", L"9000, 37887, RADIOLINJA" },
	{ L"20030208:172143", L"9006, 35551, RADIOLINJA" },
	{ L"20030208:172225", L"9000, 37887, RADIOLINJA" },
	{ L"20030208:172341", L"9000, 766, RADIOLINJA" },
	{ L"20030208:172417", L"9000, 37887, RADIOLINJA" },
	{ L"20030208:172447", L"9000, 35781, RADIOLINJA" },
	{ L"20030208:172551", L"9000, 62017, RADIOLINJA" },
	{ L"20030208:172613", L"9000, 766, RADIOLINJA" },
	{ L"20030208:172701", L"9000, 144, RADIOLINJA" },
	{ L"20030208:173010", L"9006, 35551, RADIOLINJA" },
	{ L"20030208:173102", L"9000, 144, RADIOLINJA" },
	{ L"20030208:173454", L"9006, 67, RADIOLINJA" },
	{ L"20030208:173544", L"9000, 15128, RADIOLINJA" },
	{ L"20030208:174112", L"9000, 35783, RADIOLINJA" },
	{ L"20030208:174304", L"9000, 442, RADIOLINJA" },
	{ L"20030208:174536", L"9000, 294, RADIOLINJA" },
	{ L"20030208:174940", L"9000, 188, RADIOLINJA" },
	{ L"20030208:175136", L"9000, 215, RADIOLINJA" },
	{ L"20030208:180144", L"9000, 62993, RADIOLINJA" },
	{ L"20030208:180200", L"9000, 215, RADIOLINJA" },
	{ L"20030208:181200", L"9000, 62993, RADIOLINJA" },
	{ L"20030208:181209", L"9000, 215, RADIOLINJA" },
	{ L"20030208:181640", L"9000, 188, RADIOLINJA" },
	{ L"20030208:181835", L"9000, 294, RADIOLINJA" },
	{ L"20030208:182128", L"9000, 442, RADIOLINJA" },
	{ L"20030208:182740", L"9000, 35783, RADIOLINJA" },
	{ L"20030208:182842", L"9006, 441, RADIOLINJA" },
	{ L"20030208:183034", L"9006, 233, RADIOLINJA" },
	{ L"20030208:183425", L"9006, 62067, RADIOLINJA" },
	{ L"20030208:183456", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:183524", L"9006, 62067, RADIOLINJA" },
	{ L"20030208:183539", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:221348", L"9006, 232, RADIOLINJA" },
	{ L"20030208:221357", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:222845", L"9006, 4280, RADIOLINJA" },
	{ L"20030208:223649", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:224026", L"9006, 233, RADIOLINJA" },
	{ L"20030208:224044", L"9006, 15300, RADIOLINJA" },
	{ L"20030208:233403", L"9006, 232, RADIOLINJA" },
	{ L"20030208:233420", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:000035", L"9006, 232, RADIOLINJA" },
	{ L"20030209:000052", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:002125", L"9006, 232, RADIOLINJA" },
	{ L"20030209:003236", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:003415", L"9006, 232, RADIOLINJA" },
	{ L"20030209:003605", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:003619", L"9006, 4280, RADIOLINJA" },
	{ L"20030209:003732", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:004042", L"9006, 232, RADIOLINJA" },
	{ L"20030209:004100", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:004144", L"9006, 232, RADIOLINJA" },
	{ L"20030209:004216", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:010232", L"9006, 232, RADIOLINJA" },
	{ L"20030209:010538", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:010550", L"9006, 232, RADIOLINJA" },
	{ L"20030209:010625", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:010642", L"9006, 232, RADIOLINJA" },
	{ L"20030209:011005", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:011038", L"9006, 232, RADIOLINJA" },
	{ L"20030209:011726", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:011800", L"9006, 232, RADIOLINJA" },
	{ L"20030209:011824", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:011947", L"9006, 232, RADIOLINJA" },
	{ L"20030209:012026", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:012105", L"9006, 35265, RADIOLINJA" },
	{ L"20030209:012134", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:012203", L"9006, 35265, RADIOLINJA" },
	{ L"20030209:012238", L"9006, 35265, RADIOLINJA" },
	{ L"20030209:012239", L"9006, 35265, RADIOLINJA" },
	{ L"20030209:012239", L"9006, 35265, RADIOLINJA" },
	{ L"20030209:012357", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:012415", L"9006, 35265, RADIOLINJA" },
	{ L"20030209:012518", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:012547", L"9006, 232, RADIOLINJA" },
	{ L"20030209:012915", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:012938", L"9006, 232, RADIOLINJA" },
	{ L"20030209:013144", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:013203", L"9006, 232, RADIOLINJA" },
	{ L"20030209:015224", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:015312", L"9006, 232, RADIOLINJA" },
	{ L"20030209:015425", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:015514", L"9006, 232, RADIOLINJA" },
	{ L"20030209:015549", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:015839", L"9006, 232, RADIOLINJA" },
	{ L"20030209:015856", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:015912", L"9006, 232, RADIOLINJA" },
	{ L"20030209:015937", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:020049", L"9006, 232, RADIOLINJA" },
	{ L"20030209:020105", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:020223", L"9006, 35265, RADIOLINJA" },
	{ L"20030209:020306", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:020344", L"9006, 232, RADIOLINJA" },
	{ L"20030209:020457", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:020630", L"9006, 232, RADIOLINJA" },
	{ L"20030209:020645", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:022018", L"9006, 232, RADIOLINJA" },
	{ L"20030209:022034", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:023226", L"9006, 232, RADIOLINJA" },
	{ L"20030209:023617", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:023711", L"9006, 232, RADIOLINJA" },
	{ L"20030209:023850", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:023918", L"9006, 232, RADIOLINJA" },
	{ L"20030209:024020", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:024049", L"9006, 35265, RADIOLINJA" },
	{ L"20030209:024226", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:024244", L"9006, 232, RADIOLINJA" },
	{ L"20030209:024300", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:024945", L"9006, 232, RADIOLINJA" },
	{ L"20030209:025247", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:025509", L"9006, 232, RADIOLINJA" },
	{ L"20030209:025525", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:030651", L"9006, 232, RADIOLINJA" },
	{ L"20030209:030707", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:034418", L"9006, 35265, RADIOLINJA" },
	{ L"20030209:034518", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:035504", L"9006, 232, RADIOLINJA" },
	{ L"20030209:035520", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:035853", L"9006, 232, RADIOLINJA" },
	{ L"20030209:040059", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:040116", L"9006, 232, RADIOLINJA" },
	{ L"20030209:040910", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:040941", L"9006, 232, RADIOLINJA" },
	{ L"20030209:043034", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:043123", L"9006, 35265, RADIOLINJA" },
	{ L"20030209:045153", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:051934", L"9006, 232, RADIOLINJA" },
	{ L"20030209:051951", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:054820", L"9006, 232, RADIOLINJA" },
	{ L"20030209:054925", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:060700", L"9006, 232, RADIOLINJA" },
	{ L"20030209:060716", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:060806", L"9006, 35265, RADIOLINJA" },
	{ L"20030209:060835", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:060912", L"9006, 232, RADIOLINJA" },
	{ L"20030209:060929", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:062829", L"9006, 232, RADIOLINJA" },
	{ L"20030209:062846", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:063005", L"9006, 232, RADIOLINJA" },
	{ L"20030209:064241", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:064259", L"9006, 232, RADIOLINJA" },
	{ L"20030209:064338", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:064406", L"9006, 232, RADIOLINJA" },
	{ L"20030209:064432", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:064457", L"9006, 232, RADIOLINJA" },
	{ L"20030209:064755", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:064822", L"9006, 232, RADIOLINJA" },
	{ L"20030209:064839", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:064855", L"9006, 232, RADIOLINJA" },
	{ L"20030209:065009", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:065140", L"9006, 232, RADIOLINJA" },
	{ L"20030209:065442", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:065503", L"9006, 232, RADIOLINJA" },
	{ L"20030209:065720", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:065808", L"9006, 232, RADIOLINJA" },
	{ L"20030209:065823", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:070027", L"9006, 232, RADIOLINJA" },
	{ L"20030209:070043", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:070120", L"9006, 232, RADIOLINJA" },
	{ L"20030209:070136", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:070153", L"9006, 232, RADIOLINJA" },
	{ L"20030209:070210", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:070301", L"9006, 232, RADIOLINJA" },
	{ L"20030209:070340", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:070955", L"9006, 232, RADIOLINJA" },
	{ L"20030209:071034", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:071916", L"9006, 232, RADIOLINJA" },
	{ L"20030209:072044", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:073656", L"9006, 232, RADIOLINJA" },
	{ L"20030209:073713", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:073845", L"9006, 35265, RADIOLINJA" },
	{ L"20030209:073901", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:074641", L"9006, 232, RADIOLINJA" },
	{ L"20030209:074743", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:074825", L"9006, 232, RADIOLINJA" },
	{ L"20030209:075238", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:075346", L"9006, 232, RADIOLINJA" },
	{ L"20030209:075414", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:075445", L"9006, 232, RADIOLINJA" },
	{ L"20030209:075624", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:075717", L"9006, 232, RADIOLINJA" },
	{ L"20030209:075734", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:080954", L"9006, 232, RADIOLINJA" },
	{ L"20030209:081048", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:081325", L"9006, 35265, RADIOLINJA" },
	{ L"20030209:081354", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:081644", L"9006, 232, RADIOLINJA" },
	{ L"20030209:081701", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:082853", L"9006, 232, RADIOLINJA" },
	{ L"20030209:082935", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:083134", L"9006, 232, RADIOLINJA" },
	{ L"20030209:083213", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:084055", L"9006, 232, RADIOLINJA" },
	{ L"20030209:084125", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:084146", L"9006, 232, RADIOLINJA" },
	{ L"20030209:084221", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:084246", L"9006, 232, RADIOLINJA" },
	{ L"20030209:084329", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:084346", L"9006, 232, RADIOLINJA" },
	{ L"20030209:084707", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:084744", L"9006, 232, RADIOLINJA" },
	{ L"20030209:084801", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:084840", L"9006, 232, RADIOLINJA" },
	{ L"20030209:084856", L"9006, 233, RADIOLINJA" },
	{ L"20030209:084912", L"9006, 232, RADIOLINJA" },
	{ L"20030209:084936", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:085016", L"9006, 232, RADIOLINJA" },
	{ L"20030209:085032", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:085050", L"9006, 232, RADIOLINJA" },
	{ L"20030209:085229", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:085311", L"9006, 232, RADIOLINJA" },
	{ L"20030209:085327", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:090349", L"9006, 233, RADIOLINJA" },
	{ L"20030209:090405", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:090648", L"9006, 4280, RADIOLINJA" },
	{ L"20030209:090704", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:090834", L"9006, 4280, RADIOLINJA" },
	{ L"20030209:090842", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:091030", L"9006, 62067, RADIOLINJA" },
	{ L"20030209:091040", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:091613", L"9006, 62067, RADIOLINJA" },
	{ L"20030209:091632", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:091649", L"9006, 4280, RADIOLINJA" },
	{ L"20030209:091733", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:091839", L"9006, 508, RADIOLINJA" },
	{ L"20030209:091853", L"9006, 15300, RADIOLINJA" },
	{ L"20030209:091909", L"9006, 376, RADIOLINJA" },
	{ L"20030209:091924", L"9006, 38583, RADIOLINJA" },
	{ L"20030209:092409", L"9006, 18, RADIOLINJA" },
	{ L"20030209:092452", L"9006, 62032, RADIOLINJA" },
	{ L"20030209:092532", L"9006, 18, RADIOLINJA" },
	{ L"20030209:092544", L"9006, 376, RADIOLINJA" },
	{ L"20030209:092716", L"9006, 18, RADIOLINJA" },
	{ L"20030209:092841", L"9006, 399, RADIOLINJA" },
	{ L"20030209:092900", L"9006, 376, RADIOLINJA" },
	{ L"20030209:092930", L"9006, 18, RADIOLINJA" },
	{ L"20030209:092945", L"9006, 376, RADIOLINJA" },
	{ L"20030209:093011", L"9006, 18, RADIOLINJA" },
	{ L"20030209:093029", L"9006, 62032, RADIOLINJA" },
	{ L"20030209:093039", L"9006, 18, RADIOLINJA" },
	{ L"20030209:093140", L"9006, 376, RADIOLINJA" },
	{ L"20030209:093215", L"9006, 18, RADIOLINJA" },
	{ L"20030209:094220", L"9006, 15306, RADIOLINJA" },
	{ L"20030209:094228", L"9006, 376, RADIOLINJA" },
	{ L"20030209:094425", L"9006, 18, RADIOLINJA" },
	{ L"20030209:094446", L"9006, 376, RADIOLINJA" },
	{ L"20030209:094507", L"9006, 18, RADIOLINJA" },
	{ L"20030209:094507", L"SWITCH" },
	{ L"20030212:170343", L"9006, 399, RADIOLINJA" },
	{ L"20030212:171035", L"9006, 376, RADIOLINJA" },
	{ L"20030212:171133", L"9006, 38583, RADIOLINJA" },
	{ L"20030212:171232", L"9006, 508, RADIOLINJA" },
	{ L"20030212:171242", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:171301", L"9006, 4280, RADIOLINJA" },
	{ L"20030212:171328", L"9006, 508, RADIOLINJA" },
	{ L"20030212:171651", L"9006, 4280, RADIOLINJA" },
	{ L"20030212:171711", L"9006, 62067, RADIOLINJA" },
	{ L"20030212:171808", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:171818", L"9006, 508, RADIOLINJA" },
	{ L"20030212:172053", L"9006, 508, RADIOLINJA" },
	{ L"20030212:172057", L"9006, 508, RADIOLINJA" },
	{ L"20030212:172057", L"9006, 508, RADIOLINJA" },
	{ L"20030212:172123", L"9006, 508, RADIOLINJA" },
	{ L"20030212:172124", L"9006, 508, RADIOLINJA" },
	{ L"20030212:172550", L"9006, 4280, RADIOLINJA" },
	{ L"20030212:172607", L"9006, 508, RADIOLINJA" },
	{ L"20030212:172802", L"9006, 4280, RADIOLINJA" },
	{ L"20030212:172830", L"9006, 508, RADIOLINJA" },
	{ L"20030212:173021", L"9006, 4280, RADIOLINJA" },
	{ L"20030212:173030", L"9006, 508, RADIOLINJA" },
	{ L"20030212:173047", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:173103", L"9006, 4280, RADIOLINJA" },
	{ L"20030212:173120", L"9006, 62067, RADIOLINJA" },
	{ L"20030212:173136", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:173237", L"9006, 4280, RADIOLINJA" },
	{ L"20030212:173253", L"9006, 62067, RADIOLINJA" },
	{ L"20030212:173422", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:173526", L"9006, 62067, RADIOLINJA" },
	{ L"20030212:173545", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:173658", L"9006, 62067, RADIOLINJA" },
	{ L"20030212:173721", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:175130", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:175237", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:175313", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:175637", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:180052", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:180715", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:180748", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:180817", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:180835", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:181142", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:181245", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:181337", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:181551", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:181608", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:181712", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:181729", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:182321", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:182432", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:182520", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:182901", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:182928", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:183024", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:184123", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:184334", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:184403", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:184419", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:184643", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:184733", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:184750", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:184918", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:185033", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:185202", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:185244", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:185516", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:192225", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:192228", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:193125", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:193155", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:193243", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:193253", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:193746", L"9006, 4280, RADIOLINJA" },
	{ L"20030212:193814", L"9006, 62067, RADIOLINJA" },
	{ L"20030212:193833", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:194107", L"9006, 4280, RADIOLINJA" },
	{ L"20030212:194131", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:194239", L"9006, 4280, RADIOLINJA" },
	{ L"20030212:194316", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:194343", L"9006, 62067, RADIOLINJA" },
	{ L"20030212:194357", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:194710", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:194726", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:195331", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:195337", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:195417", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:195422", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:195545", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:195552", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:195714", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:195836", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:200306", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:200323", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:200727", L"9006, 4280, RADIOLINJA" },
	{ L"20030212:200737", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:200737", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:202608", L"9006, 4280, RADIOLINJA" },
	{ L"20030212:202625", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:202708", L"9006, 4280, RADIOLINJA" },
	{ L"20030212:202726", L"9006, 4280, RADIOLINJA" },
	{ L"20030212:202737", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:202908", L"9006, 62067, RADIOLINJA" },
	{ L"20030212:202926", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:203012", L"9006, 62067, RADIOLINJA" },
	{ L"20030212:203219", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:203249", L"9006, 62067, RADIOLINJA" },
	{ L"20030212:203304", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:203907", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:203923", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:204001", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:204055", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:204126", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:204322", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:204815", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:204906", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:204948", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:204950", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:205046", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:205129", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:205153", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:205201", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:205938", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:210009", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:210554", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:210610", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:211112", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:211206", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:211315", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:211425", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:211949", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:211952", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:211957", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:212818", L"9006, 62067, RADIOLINJA" },
	{ L"20030212:212848", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:213438", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:213455", L"9006, 233, RADIOLINJA" },
	{ L"20030212:213701", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:213743", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:213834", L"9006, 233, RADIOLINJA" },
	{ L"20030212:214236", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:214452", L"9006, 233, RADIOLINJA" },
	{ L"20030212:214819", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:214836", L"9006, 233, RADIOLINJA" },
	{ L"20030212:215414", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:215454", L"9006, 233, RADIOLINJA" },
	{ L"20030212:215559", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:215637", L"9006, 233, RADIOLINJA" },
	{ L"20030212:215733", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:215756", L"9006, 233, RADIOLINJA" },
	{ L"20030212:215820", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:215837", L"9006, 233, RADIOLINJA" },
	{ L"20030212:220450", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:220523", L"9006, 233, RADIOLINJA" },
	{ L"20030212:220736", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:220852", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:221522", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:221546", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:221607", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:221750", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:221806", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:222052", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:222356", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:222446", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:222504", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:223501", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:223534", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:225220", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:225938", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:230623", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:230640", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:230741", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:231311", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:233901", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:233943", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:234852", L"9006, 35265, RADIOLINJA" },
	{ L"20030212:235645", L"9006, 15300, RADIOLINJA" },
	{ L"20030212:235822", L"9006, 35265, RADIOLINJA" },
	{ L"20030213:000126", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:001231", L"9006, 35265, RADIOLINJA" },
	{ L"20030213:001612", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:001629", L"9006, 35265, RADIOLINJA" },
	{ L"20030213:001705", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:001804", L"9006, 35265, RADIOLINJA" },
	{ L"20030213:002421", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:002539", L"9006, 35265, RADIOLINJA" },
	{ L"20030213:002847", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:002912", L"9006, 35265, RADIOLINJA" },
	{ L"20030213:003142", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:053943", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:053943", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:054302", L"9006, 35265, RADIOLINJA" },
	{ L"20030213:055807", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:071122", L"9006, 35265, RADIOLINJA" },
	{ L"20030213:071248", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:074740", L"9006, 35265, RADIOLINJA" },
	{ L"20030213:074756", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:075623", L"9006, 35265, RADIOLINJA" },
	{ L"20030213:075708", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:080022", L"9006, 35265, RADIOLINJA" },
	{ L"20030213:080322", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:080342", L"9006, 35265, RADIOLINJA" },
	{ L"20030213:080415", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:081030", L"9006, 35265, RADIOLINJA" },
	{ L"20030213:081156", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:081342", L"9006, 35265, RADIOLINJA" },
	{ L"20030213:081430", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:083020", L"9006, 35265, RADIOLINJA" },
	{ L"20030213:083527", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:083727", L"9006, 35265, RADIOLINJA" },
	{ L"20030213:083811", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:101501", L"9006, 232, RADIOLINJA" },
	{ L"20030213:101501", L"9006, 399, RADIOLINJA" },
	{ L"20030213:101501", L"9006, 376, RADIOLINJA" },
	{ L"20030213:101501", L"9006, 399, RADIOLINJA" },
	{ L"20030213:101501", L"9006, 18, RADIOLINJA" },
	{ L"20030213:101501", L"9006, 399, RADIOLINJA" },
	{ L"20030213:101501", L"SWITCH" },
	{ L"20030213:143206", L"9006, 399, RADIOLINJA" },
	{ L"20030213:143332", L"9006, 376, RADIOLINJA" },
	{ L"20030213:143411", L"9006, 399, RADIOLINJA" },
	{ L"20030213:143649", L"9006, 376, RADIOLINJA" },
	{ L"20030213:143705", L"9006, 399, RADIOLINJA" },
	{ L"20030213:143722", L"9006, 376, RADIOLINJA" },
	{ L"20030213:143757", L"9006, 18, RADIOLINJA" },
	{ L"20030213:144420", L"9006, 62032, RADIOLINJA" },
	{ L"20030213:144450", L"9006, 62032, RADIOLINJA" },
	{ L"20030213:144451", L"9006, 18, RADIOLINJA" },
	{ L"20030213:145339", L"9006, 18, RADIOLINJA" },
	{ L"20030213:145351", L"9006, 18, RADIOLINJA" },
	{ L"20030213:145351", L"9006, 18, RADIOLINJA" },
	{ L"20030213:151103", L"9006, 376, RADIOLINJA" },
	{ L"20030213:151120", L"9006, 399, RADIOLINJA" },
	{ L"20030213:151554", L"9006, 376, RADIOLINJA" },
	{ L"20030213:151619", L"9006, 399, RADIOLINJA" },
	{ L"20030213:151619", L"SWITCH" },
	{ L"20030213:155909", L"9006, 399, RADIOLINJA" },
	{ L"20030213:162821", L"9006, 399, RADIOLINJA" },
	{ L"20030213:163200", L"9006, 1493, RADIOLINJA" },
	{ L"20030213:163226", L"9006, 399, RADIOLINJA" },
	{ L"20030213:163937", L"9006, 376, RADIOLINJA" },
	{ L"20030213:163954", L"9006, 399, RADIOLINJA" },
	{ L"20030213:164004", L"9006, 18, RADIOLINJA" },
	{ L"20030213:164018", L"9006, 399, RADIOLINJA" },
	{ L"20030213:164037", L"9006, 376, RADIOLINJA" },
	{ L"20030213:170210", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:170557", L"9006, 35265, RADIOLINJA" },
	{ L"20030213:170641", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:172633", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:172949", L"9006, 35265, RADIOLINJA" },
	{ L"20030213:173010", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:184252", L"9006, 35265, RADIOLINJA" },
	{ L"20030213:184336", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:184417", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:184424", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:184424", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:184456", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:185833", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:185911", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:190251", L"9006, 216, RADIOLINJA" },
	{ L"20030213:190309", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:190415", L"9006, 62067, RADIOLINJA" },
	{ L"20030213:190440", L"9006, 15300, RADIOLINJA" },
	{ L"20030213:190455", L"9006, 62067, RADIOLINJA" },
	{ L"20030213:190828", L"9006, 62143, RADIOLINJA" },
	{ L"20030213:190838", L"9006, 233, RADIOLINJA" },
	{ L"20030213:190838", L"SWITCH" },
	{ L"20030213:192215", L"9006, 600, RADIOLINJA" },
	{ L"20030213:192230", L"9006, 15175, RADIOLINJA" },
	{ L"20030213:192302", L"9006, 393, RADIOLINJA" },
	{ L"20030213:192335", L"9006, 42111, RADIOLINJA" },
	{ L"20030213:192408", L"9006, 15330, RADIOLINJA" },
	{ L"20030213:192434", L"9005, 4518, RADIOLINJA" },
	{ L"20030213:192508", L"9005, 4517, RADIOLINJA" },
	{ L"20030213:192517", L"9005, 78, RADIOLINJA" },
	{ L"20030213:192601", L"9005, 15311, RADIOLINJA" },
	{ L"20030213:192625", L"9005, 33, RADIOLINJA" },
	{ L"20030213:192659", L"9005, 36030, RADIOLINJA" },
	{ L"20030213:192709", L"9005, 36031, RADIOLINJA" },
	{ L"20030213:192737", L"9005, 36028, RADIOLINJA" },
	{ L"20030213:192805", L"9005, 36027, RADIOLINJA" },
	{ L"20030213:192822", L"9113, 62523, RADIOLINJA" },
	{ L"20030213:192837", L"9113, 40743, RADIOLINJA" },
	{ L"20030213:192858", L"9113, 62523, RADIOLINJA" },
	{ L"20030213:192956", L"9113, 127, RADIOLINJA" },
	{ L"20030213:193010", L"9113, 62524, RADIOLINJA" },
	{ L"20030213:193028", L"9113, 41712, RADIOLINJA" },
	{ L"20030213:193051", L"9113, 62524, RADIOLINJA" },
	{ L"20030213:193107", L"9113, 208, RADIOLINJA" },
	{ L"20030213:193127", L"9113, 62524, RADIOLINJA" },
	{ L"20030213:193145", L"9113, 3533, RADIOLINJA" },
	{ L"20030213:193203", L"9113, 40625, RADIOLINJA" },
	{ L"20030213:193212", L"9113, 62524, RADIOLINJA" },
	{ L"20030213:193243", L"9113, 3533, RADIOLINJA" },
	{ L"20030213:193405", L"9113, 40122, RADIOLINJA" },
	{ L"20030213:193415", L"9113, 3802, RADIOLINJA" },
	{ L"20030213:193431", L"9113, 347, RADIOLINJA" },
	{ L"20030213:193618", L"9113, 444, RADIOLINJA" },
	{ L"20030213:193741", L"9113, 62094, RADIOLINJA" },
	{ L"20030213:194008", L"9113, 14, RADIOLINJA" },
	{ L"20030213:194022", L"9113, 62094, RADIOLINJA" },
	{ L"20030213:194248", L"9113, 148, RADIOLINJA" },
	{ L"20030213:194505", L"9113, 62094, RADIOLINJA" },
	{ L"20030213:194611", L"9113, 148, RADIOLINJA" },
	{ L"20030213:195827", L"9113, 62094, RADIOLINJA" },
	{ L"20030213:195857", L"9113, 148, RADIOLINJA" },
	{ L"20030213:195955", L"9113, 62094, RADIOLINJA" },
	{ L"20030213:200004", L"9113, 148, RADIOLINJA" },
	{ L"20030213:200125", L"9113, 62094, RADIOLINJA" },
	{ L"20030213:200142", L"9113, 148, RADIOLINJA" },
	{ L"20030213:200402", L"9113, 62094, RADIOLINJA" },
	{ L"20030213:200435", L"9113, 148, RADIOLINJA" },
	{ L"20030213:200444", L"9170, 850, RADIOLINJA" },
	{ L"20030213:200840", L"9113, 148, RADIOLINJA" },
	{ L"20030213:200934", L"9170, 850, RADIOLINJA" },
	{ L"20030213:201056", L"9113, 148, RADIOLINJA" },
	{ L"20030213:201914", L"9113, 62094, RADIOLINJA" },
	{ L"20030213:201937", L"9113, 148, RADIOLINJA" },
	{ L"20030213:201937", L"SWITCH" },
	{ L"20030213:221622", L"28, 21193, S Vodafone" },
	{ L"20030213:221701", L"28, 13, S Vodafone" },
	{ L"20030213:221745", L"28, 21192, S Vodafone" },
	{ L"20030213:221804", L"28, 12, S Vodafone" },
	{ L"20030213:221932", L"28, 21192, S Vodafone" },
	{ L"20030213:221942", L"28, 12, S Vodafone" },
	{ L"20030213:222022", L"28, 21192, S Vodafone" },
	{ L"20030213:222119", L"28, 12, S Vodafone" },
	{ L"20030213:222139", L"28, 21192, S Vodafone" },
	{ L"20030213:222206", L"28, 12192, S Vodafone" },
	{ L"20030213:222216", L"28, 21192, S Vodafone" },
	{ L"20030213:222314", L"28, 13201, S Vodafone" },
	{ L"20030213:222331", L"28, 22641, S Vodafone" },
	{ L"20030213:222357", L"28, 13201, S Vodafone" },
	{ L"20030213:222416", L"28, 22641, S Vodafone" },
	{ L"20030213:222442", L"28, 13201, S Vodafone" },
	{ L"20030213:222454", L"28, 8671, S Vodafone" },
	{ L"20030213:222514", L"28, 21431, S Vodafone" },
	{ L"20030213:222533", L"28, 22641, S Vodafone" },
	{ L"20030213:222634", L"28, 21193, S Vodafone" },
	{ L"20030213:222645", L"28, 11661, S Vodafone" },
	{ L"20030213:222706", L"28, 8671, S Vodafone" },
	{ L"20030213:222715", L"28, 21193, S Vodafone" },
	{ L"20030213:222730", L"28, 11661, S Vodafone" },
	{ L"20030213:222742", L"28, 1311, S Vodafone" },
	{ L"20030213:223237", L"19, 182, S Vodafone" },
	{ L"20030213:223456", L"19, 181, S Vodafone" },
	{ L"20030213:223758", L"19, 17731, S Vodafone" },
	{ L"20030213:223850", L"19, 17732, S Vodafone" },
	{ L"20030213:223916", L"19, 12821, S Vodafone" },
	{ L"20030213:224016", L"19, 511, S Vodafone" },
	{ L"20030213:224104", L"19, 12823, S Vodafone" },
	{ L"20030213:224124", L"19, 13582, S Vodafone" },
	{ L"20030213:224304", L"19, 22151, S Vodafone" },
	{ L"20030213:224406", L"19, 511, S Vodafone" },
	{ L"20030213:224417", L"19, 9031, S Vodafone" },
	{ L"20030213:224509", L"19, 9033, S Vodafone" },
	{ L"20030213:224541", L"19, 23852, S Vodafone" },
	{ L"20030213:224624", L"19, 23851, S Vodafone" },
	{ L"20030213:224658", L"19, 30061, S Vodafone" },
	{ L"20030213:224707", L"19, 20252, S Vodafone" },
	{ L"20030213:225058", L"19, 11182, S Vodafone" },
	{ L"20030213:225135", L"19, 23112, S Vodafone" },
	{ L"20030213:225146", L"19, 20252, S Vodafone" },
	{ L"20030213:225154", L"19, 23121, S Vodafone" },
	{ L"20030213:225206", L"19, 15881, S Vodafone" },
	{ L"20030213:225222", L"19, 20252, S Vodafone" },
	{ L"20030213:225238", L"19, 23122, S Vodafone" },
	{ L"20030213:225255", L"19, 20252, S Vodafone" },
	{ L"20030213:225313", L"19, 20253, S Vodafone" },
	{ L"20030213:225342", L"19, 20252, S Vodafone" },
	{ L"20030213:225359", L"19, 23853, S Vodafone" },
	{ L"20030213:225452", L"19, 30063, S Vodafone" },
	{ L"20030213:225514", L"19, 23853, S Vodafone" },
	{ L"20030213:225545", L"19, 23853, S Vodafone" },
	{ L"20030213:225550", L"61448, 63852, COMVIQ" },
	{ L"20030213:225748", L"61448, 63867, COMVIQ" },
	{ L"20030213:225950", L"61448, 24731, COMVIQ" },
	{ L"20030213:230124", L"61448, 24732, COMVIQ" },
	{ L"20030213:230201", L"61448, 24730, COMVIQ" },
	{ L"20030213:230229", L"61448, 24732, COMVIQ" },
	{ L"20030213:230239", L"61448, 63802, COMVIQ" },
	{ L"20030213:230259", L"61448, 24732, COMVIQ" },
	{ L"20030213:230359", L"61448, 63756, COMVIQ" },
	{ L"20030213:230451", L"61448, 63627, COMVIQ" },
	{ L"20030213:230500", L"61448, 63756, COMVIQ" },
	{ L"20030213:230500", L"SWITCH" },
	{ L"20030214:072459", L"61448, 63756, COMVIQ" },
	{ L"20030214:072555", L"61448, 41564, COMVIQ" },
	{ L"20030214:072556", L"61448, 41564, COMVIQ" },
	{ L"20030214:072625", L"61448, 24732, COMVIQ" },
	{ L"20030214:073253", L"61448, 41564, COMVIQ" },
	{ L"20030214:073304", L"61448, 63756, COMVIQ" },
	{ L"20030214:073404", L"61448, 41564, COMVIQ" },
	{ L"20030214:073442", L"61448, 63756, COMVIQ" },
	{ L"20030214:073859", L"61448, 24732, COMVIQ" },
	{ L"20030214:073909", L"61448, 63756, COMVIQ" },
	{ L"20030214:074730", L"61448, 63804, COMVIQ" },
	{ L"20030214:074746", L"61448, 24732, COMVIQ" },
	{ L"20030214:074924", L"61448, 63802, COMVIQ" },
	{ L"20030214:075101", L"61448, 24730, COMVIQ" },
	{ L"20030214:075109", L"61448, 24732, COMVIQ" },
	{ L"20030214:075126", L"61448, 24730, COMVIQ" },
	{ L"20030214:075223", L"61448, 63868, COMVIQ" },
	{ L"20030214:075304", L"61448, 24730, COMVIQ" },
	{ L"20030214:075325", L"61448, 63868, COMVIQ" },
	{ L"20030214:075359", L"61448, 24730, COMVIQ" },
	{ L"20030214:075459", L"61448, 54060, COMVIQ" },
	{ L"20030214:075608", L"61448, 63866, COMVIQ" },
	{ L"20030214:080023", L"61448, 63867, COMVIQ" },
	{ L"20030214:080113", L"61448, 63868, COMVIQ" },
	{ L"20030214:080340", L"61448, 63867, COMVIQ" },
	{ L"20030214:080440", L"61448, 24731, COMVIQ" },
	{ L"20030214:081148", L"61448, 63803, COMVIQ" },
	{ L"20030214:081213", L"61448, 24731, COMVIQ" },
	{ L"20030214:081230", L"61448, 63803, COMVIQ" },
	{ L"20030214:081330", L"61448, 24731, COMVIQ" },
	{ L"20030214:081417", L"61448, 63803, COMVIQ" },
	{ L"20030214:081427", L"61448, 24731, COMVIQ" },
	{ L"20030214:081454", L"61448, 63803, COMVIQ" },
	{ L"20030214:081508", L"61448, 24731, COMVIQ" },
	{ L"20030214:081620", L"61448, 63868, COMVIQ" },
	{ L"20030214:081637", L"61448, 24731, COMVIQ" },
	{ L"20030214:081739", L"61448, 63868, COMVIQ" },
	{ L"20030214:082321", L"61448, 24730, COMVIQ" },
	{ L"20030214:082429", L"61448, 54060, COMVIQ" },
	{ L"20030214:082619", L"61448, 63866, COMVIQ" },
	{ L"20030214:083234", L"61448, 54060, COMVIQ" },
	{ L"20030214:083250", L"61448, 63866, COMVIQ" },
	{ L"20030214:083401", L"61448, 54060, COMVIQ" },
	{ L"20030214:083539", L"61448, 63866, COMVIQ" },
	{ L"20030214:083552", L"61448, 54060, COMVIQ" },
	{ L"20030214:083957", L"61448, 54059, COMVIQ" },
	{ L"20030214:084034", L"61448, 54058, COMVIQ" },
	{ L"20030214:084050", L"61448, 37100, COMVIQ" },
	{ L"20030214:084102", L"61448, 37099, COMVIQ" },
	{ L"20030214:084114", L"61448, 63883, COMVIQ" },
	{ L"20030214:084208", L"61448, 63882, COMVIQ" },
	{ L"20030214:084228", L"61448, 34026, COMVIQ" },
	{ L"20030214:084323", L"61448, 30523, COMVIQ" },
	{ L"20030214:084356", L"61448, 30522, COMVIQ" },
	{ L"20030214:084515", L"61460, 33996, COMVIQ" },
	{ L"20030214:084635", L"61460, 20864, COMVIQ" },
	{ L"20030214:085056", L"61460, 33995, COMVIQ" },
	{ L"20030214:085119", L"61460, 20864, COMVIQ" },
	{ L"20030214:085143", L"61460, 33995, COMVIQ" },
	{ L"20030214:085206", L"61460, 17050, COMVIQ" },
	{ L"20030214:085206", L"61460, 17050, COMVIQ" },
	{ L"20030214:085218", L"61460, 30528, COMVIQ" },
	{ L"20030214:085250", L"61460, 30528, COMVIQ" },
	{ L"20030214:085250", L"SWITCH" },
	{ L"20030214:092300", L"2512, 43700, TELIA" },
	{ L"20030214:092346", L"2512, 11760, TELIA" },
	{ L"20030214:092509", L"2512, 43700, TELIA" },
	{ L"20030214:092524", L"2512, 11760, TELIA" },
	{ L"20030214:092558", L"2512, 11650, TELIA" },
	{ L"20030214:092710", L"2512, 11662, TELIA" },
	{ L"20030214:092720", L"2512, 51240, TELIA" },
	{ L"20030214:092737", L"2512, 11662, TELIA" },
	{ L"20030214:092901", L"2512, 47790, TELIA" },
	{ L"20030214:092917", L"2512, 11662, TELIA" },
	{ L"20030214:092953", L"2512, 4367, TELIA" },
	{ L"20030214:093003", L"2512, 11741, TELIA" },
	{ L"20030214:093020", L"2512, 4367, TELIA" },
	{ L"20030214:093037", L"2512, 11641, TELIA" },
	{ L"20030214:093047", L"2512, 4367, TELIA" },
	{ L"20030214:093109", L"2512, 11741, TELIA" },
	{ L"20030214:093242", L"2512, 11641, TELIA" },
	{ L"20030214:093258", L"2512, 4367, TELIA" },
	{ L"20030214:093319", L"2512, 11641, TELIA" },
	{ L"20030214:093402", L"2512, 4708, TELIA" },
	{ L"20030214:093423", L"2512, 11640, TELIA" },
	{ L"20030214:093859", L"6512, 11863, TELIA" },
	{ L"20030214:093918", L"2512, 11640, TELIA" },
	{ L"20030214:093953", L"6512, 11632, TELIA" },
	{ L"20030214:094115", L"2512, 4864, TELIA" },
	{ L"20030214:094156", L"6512, 11632, TELIA" },
	{ L"20030214:094533", L"6512, 11631, TELIA" },
	{ L"20030214:094558", L"1512, 10440, TELIA" },
	{ L"20030214:094614", L"1512, 10490, TELIA" },
	{ L"20030214:094645", L"1512, 10440, TELIA" },
	{ L"20030214:094722", L"1512, 10490, TELIA" },
	{ L"20030214:094807", L"1512, 10440, TELIA" },
	{ L"20030214:094855", L"1512, 10490, TELIA" },
	{ L"20030214:094908", L"1512, 10440, TELIA" },
	{ L"20030214:095022", L"1512, 49460, TELIA" },
	{ L"20030214:095348", L"1512, 10491, TELIA" },
	{ L"20030214:095404", L"1512, 10490, TELIA" },
	{ L"20030214:095448", L"1512, 45400, TELIA" },
	{ L"20030214:095513", L"1512, 10462, TELIA" },
	{ L"20030214:095533", L"1512, 10460, TELIA" },
	{ L"20030214:095554", L"1512, 45400, TELIA" },
	{ L"20030214:095622", L"1512, 10460, TELIA" },
	{ L"20030214:095641", L"1512, 4307, TELIA" },
	{ L"20030214:095849", L"1512, 4852, TELIA" },
	{ L"20030214:095902", L"1512, 4307, TELIA" },
	{ L"20030214:095929", L"1512, 4406, TELIA" },
	{ L"20030214:095941", L"1512, 10170, TELIA" },
	{ L"20030214:100022", L"1512, 4406, TELIA" },
	{ L"20030214:100034", L"1512, 51050, TELIA" },
	{ L"20030214:100211", L"1512, 10170, TELIA" },
	{ L"20030214:100247", L"1512, 51050, TELIA" },
	{ L"20030214:100327", L"1512, 50000, TELIA" },
	{ L"20030214:100525", L"1512, 50200, TELIA" },
	{ L"20030214:100726", L"2512, 11592, TELIA" },
	{ L"20030214:100744", L"2512, 4775, TELIA" },
	{ L"20030214:100829", L"2512, 11753, TELIA" },
	{ L"20030214:100855", L"2512, 4775, TELIA" },
	{ L"20030214:100952", L"2512, 11753, TELIA" },
	{ L"20030214:101007", L"2512, 11601, TELIA" },
	{ L"20030214:101109", L"2512, 4777, TELIA" },
	{ L"20030214:101202", L"2512, 11791, TELIA" },
	{ L"20030214:101215", L"2512, 4777, TELIA" },
	{ L"20030214:102742", L"2512, 11791, TELIA" },
	{ L"20030214:102803", L"2512, 4777, TELIA" },
	{ L"20030214:102908", L"2512, 11791, TELIA" },
	{ L"20030214:102937", L"2512, 4777, TELIA" },
	{ L"20030214:103021", L"2512, 11791, TELIA" },
	{ L"20030214:103150", L"2512, 4777, TELIA" },
	{ L"20030214:103908", L"2512, 11791, TELIA" },
	{ L"20030214:103929", L"2512, 4777, TELIA" },
	{ L"20030214:104031", L"2512, 11601, TELIA" },
	{ L"20030214:104141", L"2512, 11672, TELIA" },
	{ L"20030214:104151", L"2512, 4775, TELIA" },
	{ L"20030214:104209", L"2512, 11753, TELIA" },
	{ L"20030214:104248", L"2512, 4775, TELIA" },
	{ L"20030214:104600", L"2512, 11570, TELIA" },
	{ L"20030214:104627", L"2512, 11571, TELIA" },
	{ L"20030214:104646", L"2512, 11741, TELIA" },
	{ L"20030214:104759", L"2512, 4367, TELIA" },
	{ L"20030214:104906", L"2512, 11741, TELIA" },
	{ L"20030214:104916", L"2512, 4367, TELIA" },
	{ L"20030214:104931", L"2512, 11641, TELIA" },
	{ L"20030214:105013", L"2512, 4708, TELIA" },
	{ L"20030214:105108", L"2512, 11640, TELIA" },
	{ L"20030214:110326", L"6512, 50170, TELIA" },
	{ L"20030214:110407", L"2512, 11640, TELIA" },
	{ L"20030214:110641", L"6512, 50170, TELIA" },
	{ L"20030214:110656", L"6512, 11863, TELIA" },
	{ L"20030214:110815", L"6512, 11502, TELIA" },
	{ L"20030214:110942", L"6512, 11501, TELIA" },
	{ L"20030214:111029", L"6512, 46800, TELIA" },
	{ L"20030214:111044", L"6512, 11500, TELIA" },
	{ L"20030214:111107", L"6512, 51430, TELIA" },
	{ L"20030214:111140", L"6512, 11500, TELIA" },
	{ L"20030214:111235", L"6512, 12060, TELIA" },
	{ L"20030214:111410", L"6512, 12301, TELIA" },
	{ L"20030214:111430", L"6512, 12060, TELIA" },
	{ L"20030214:111455", L"6512, 12062, TELIA" },
	{ L"20030214:111507", L"6512, 12301, TELIA" },
	{ L"20030214:111538", L"6512, 12302, TELIA" },
	{ L"20030214:111554", L"6512, 12301, TELIA" },
	{ L"20030214:111617", L"6512, 12060, TELIA" },
	{ L"20030214:111648", L"6512, 12301, TELIA" },
	{ L"20030214:112000", L"6512, 12302, TELIA" },
	{ L"20030214:112013", L"6512, 51480, TELIA" },
	{ L"20030214:112726", L"6512, 12302, TELIA" },
	{ L"20030214:112735", L"6512, 51480, TELIA" },
	{ L"20030214:113630", L"6512, 12302, TELIA" },
	{ L"20030214:113652", L"6512, 51480, TELIA" },
	{ L"20030214:113710", L"6512, 12271, TELIA" },
	{ L"20030214:113722", L"6512, 12302, TELIA" },
	{ L"20030214:113732", L"6512, 51480, TELIA" },
	{ L"20030214:113808", L"6512, 12302, TELIA" },
	{ L"20030214:113817", L"6512, 51480, TELIA" },
	{ L"20030214:121308", L"6512, 12302, TELIA" },
	{ L"20030214:121319", L"6512, 12301, TELIA" },
	{ L"20030214:121514", L"6512, 51540, TELIA" },
	{ L"20030214:121530", L"6512, 12301, TELIA" },
	{ L"20030214:121611", L"6512, 51540, TELIA" },
	{ L"20030214:121720", L"6512, 12301, TELIA" },
	{ L"20030214:121737", L"6512, 51540, TELIA" },
	{ L"20030214:121809", L"6512, 12301, TELIA" },
	{ L"20030214:121911", L"6512, 51540, TELIA" },
	{ L"20030214:122104", L"6512, 51540, TELIA" },
	{ L"20030214:122104", L"6512, 46800, TELIA" },
	{ L"20030214:122218", L"6512, 51540, TELIA" },
	{ L"20030214:122309", L"6512, 12301, TELIA" },
	{ L"20030214:122326", L"6512, 51540, TELIA" },
	{ L"20030214:122428", L"6512, 12301, TELIA" },
	{ L"20030214:122450", L"6512, 51540, TELIA" },
	{ L"20030214:123100", L"6512, 12301, TELIA" },
	{ L"20030214:123155", L"6512, 11501, TELIA" },
	{ L"20030214:123259", L"6512, 46800, TELIA" },
	{ L"20030214:123443", L"6512, 51540, TELIA" },
	{ L"20030214:123724", L"6512, 51430, TELIA" },
	{ L"20030214:123737", L"6512, 12301, TELIA" },
	{ L"20030214:123806", L"6512, 11501, TELIA" },
	{ L"20030214:123822", L"6512, 46800, TELIA" },
	{ L"20030214:123910", L"6512, 51540, TELIA" },
	{ L"20030214:123957", L"6512, 12301, TELIA" },
	{ L"20030214:124029", L"6512, 51540, TELIA" },
	{ L"20030214:124056", L"6512, 12301, TELIA" },
	{ L"20030214:124150", L"6512, 11501, TELIA" },
	{ L"20030214:124211", L"6512, 46800, TELIA" },
	{ L"20030214:124319", L"6512, 51540, TELIA" },
	{ L"20030214:124426", L"6512, 12301, TELIA" },
	{ L"20030214:124534", L"6512, 51540, TELIA" },
	{ L"20030214:124550", L"6512, 12301, TELIA" },
	{ L"20030214:124759", L"6512, 51540, TELIA" },
	{ L"20030214:124859", L"6512, 51430, TELIA" },
	{ L"20030214:124915", L"6512, 11501, TELIA" },
	{ L"20030214:124929", L"6512, 46800, TELIA" },
	{ L"20030214:124942", L"6512, 51540, TELIA" },
	{ L"20030214:125034", L"6512, 4818, TELIA" },
	{ L"20030214:125044", L"6512, 11500, TELIA" },
	{ L"20030214:125111", L"6512, 46800, TELIA" },
	{ L"20030214:125128", L"6512, 11500, TELIA" },
	{ L"20030214:125157", L"6512, 46800, TELIA" },
	{ L"20030214:125236", L"6512, 11500, TELIA" },
	{ L"20030214:125253", L"6512, 12061, TELIA" },
	{ L"20030214:125302", L"6512, 12301, TELIA" },
	{ L"20030214:125340", L"6512, 11500, TELIA" },
	{ L"20030214:125429", L"6512, 12301, TELIA" },
	{ L"20030214:125446", L"6512, 11500, TELIA" },
	{ L"20030214:125503", L"6512, 12301, TELIA" },
	{ L"20030214:125520", L"6512, 11500, TELIA" },
	{ L"20030214:125536", L"6512, 12301, TELIA" },
	{ L"20030214:125608", L"6512, 51540, TELIA" },
	{ L"20030214:125802", L"6512, 12301, TELIA" },
	{ L"20030214:125907", L"6512, 51540, TELIA" },
	{ L"20030214:130101", L"6512, 51540, TELIA" },
	{ L"20030214:130101", L"6512, 51540, TELIA" },
	{ L"20030214:130101", L"6512, 51540, TELIA" },
	{ L"20030214:130437", L"6512, 12301, TELIA" },
	{ L"20030214:130522", L"6512, 51540, TELIA" },
	{ L"20030214:130604", L"6512, 12301, TELIA" },
	{ L"20030214:130834", L"6512, 51540, TELIA" },
	{ L"20030214:131010", L"6512, 51540, TELIA" },
	{ L"20030214:131013", L"6512, 46800, TELIA" },
	{ L"20030214:131055", L"6512, 46800, TELIA" },
	{ L"20030214:131056", L"61445, 64282, COMVIQ" },
	{ L"20030214:132545", L"61445, 64284, COMVIQ" },
	{ L"20030214:132615", L"61445, 64282, COMVIQ" },
	{ L"20030214:132740", L"61445, 64284, COMVIQ" },
	{ L"20030214:132749", L"61445, 64282, COMVIQ" },
	{ L"20030214:133003", L"61445, 13596, COMVIQ" },
	{ L"20030214:133030", L"61445, 64282, COMVIQ" },
	{ L"20030214:133146", L"61445, 13596, COMVIQ" },
	{ L"20030214:133258", L"61445, 64282, COMVIQ" },
	{ L"20030214:133314", L"61445, 13596, COMVIQ" },
	{ L"20030214:133400", L"61445, 64282, COMVIQ" },
	{ L"20030214:133732", L"61445, 64284, COMVIQ" },
	{ L"20030214:133758", L"61445, 64282, COMVIQ" },
	{ L"20030214:133956", L"61445, 64284, COMVIQ" },
	{ L"20030214:134004", L"61445, 29196, COMVIQ" },
	{ L"20030214:134017", L"61445, 64282, COMVIQ" },
	{ L"20030214:134036", L"61445, 64284, COMVIQ" },
	{ L"20030214:134113", L"61445, 64282, COMVIQ" },
	{ L"20030214:134138", L"61445, 64284, COMVIQ" },
	{ L"20030214:134158", L"61445, 64282, COMVIQ" },
	{ L"20030214:134302", L"61445, 64284, COMVIQ" },
	{ L"20030214:134314", L"61445, 64282, COMVIQ" },
	{ L"20030214:134357", L"61445, 64284, COMVIQ" },
	{ L"20030214:134408", L"61445, 64282, COMVIQ" },
	{ L"20030214:134736", L"61445, 29196, COMVIQ" },
	{ L"20030214:134750", L"61445, 64282, COMVIQ" },
	{ L"20030214:135106", L"61445, 64284, COMVIQ" },
	{ L"20030214:135127", L"61445, 64282, COMVIQ" },
	{ L"20030214:135327", L"61445, 64284, COMVIQ" },
	{ L"20030214:135336", L"61445, 64282, COMVIQ" },
	{ L"20030214:135802", L"61445, 29196, COMVIQ" },
	{ L"20030214:135814", L"61445, 64282, COMVIQ" },
	{ L"20030214:135902", L"61445, 13595, COMVIQ" },
	{ L"20030214:135918", L"61445, 29210, COMVIQ" },
	{ L"20030214:143528", L"61445, 29201, COMVIQ" },
	{ L"20030214:143539", L"61445, 29210, COMVIQ" },
	{ L"20030214:144519", L"61445, 29201, COMVIQ" },
	{ L"20030214:144530", L"61445, 29210, COMVIQ" },
	{ L"20030214:144729", L"61445, 13579, COMVIQ" },
	{ L"20030214:144746", L"61445, 29210, COMVIQ" },
	{ L"20030214:144855", L"61445, 29212, COMVIQ" },
	{ L"20030214:144945", L"61445, 50186, COMVIQ" },
	{ L"20030214:145227", L"61445, 17882, COMVIQ" },
	{ L"20030214:145243", L"61445, 50186, COMVIQ" },
	{ L"20030214:145305", L"61445, 64251, COMVIQ" },
	{ L"20030214:145444", L"61445, 17706, COMVIQ" },
	{ L"20030214:145500", L"61445, 64251, COMVIQ" },
	{ L"20030214:145548", L"61445, 17706, COMVIQ" },
	{ L"20030214:145604", L"61445, 64251, COMVIQ" },
	{ L"20030214:145656", L"61445, 17706, COMVIQ" },
	{ L"20030214:145828", L"61445, 17708, COMVIQ" },
	{ L"20030214:145845", L"61445, 29212, COMVIQ" },
	{ L"20030214:150259", L"61445, 17706, COMVIQ" },
	{ L"20030214:150405", L"61445, 17723, COMVIQ" },
	{ L"20030214:150957", L"61445, 18026, COMVIQ" },
	{ L"20030214:151401", L"61445, 40986, COMVIQ" },
	{ L"20030214:152302", L"61445, 63066, COMVIQ" },
	{ L"20030214:152903", L"61445, 63018, COMVIQ" },
	{ L"20030214:153432", L"61445, 21034, COMVIQ" },
	{ L"20030214:154033", L"61445, 42314, COMVIQ" },
	{ L"20030214:154144", L"61445, 62748, COMVIQ" },
	{ L"20030214:154244", L"61445, 42314, COMVIQ" },
	{ L"20030214:154705", L"61445, 42315, COMVIQ" },
	{ L"20030214:154902", L"61445, 62586, COMVIQ" },
	{ L"20030214:154931", L"61445, 42315, COMVIQ" },
	{ L"20030214:154947", L"61445, 62586, COMVIQ" },
	{ L"20030214:155000", L"61445, 42315, COMVIQ" },
	{ L"20030214:155023", L"61445, 62586, COMVIQ" },
	{ L"20030214:155212", L"61445, 42315, COMVIQ" },
	{ L"20030214:155229", L"61445, 62586, COMVIQ" },
	{ L"20030214:155516", L"61445, 42315, COMVIQ" },
	{ L"20030214:155525", L"61445, 62586, COMVIQ" },
	{ L"20030214:155618", L"61445, 42315, COMVIQ" },
	{ L"20030214:155627", L"61445, 62586, COMVIQ" },
	{ L"20030214:155650", L"61445, 42315, COMVIQ" },
	{ L"20030214:155705", L"61445, 18396, COMVIQ" },
	{ L"20030214:155739", L"61445, 42315, COMVIQ" },
	{ L"20030214:155752", L"61445, 62586, COMVIQ" },
	{ L"20030214:160227", L"61445, 42315, COMVIQ" },
	{ L"20030214:160242", L"61445, 62586, COMVIQ" },
	{ L"20030214:161719", L"61445, 42315, COMVIQ" },
	{ L"20030214:161736", L"61445, 62586, COMVIQ" },
	{ L"20030214:161828", L"61445, 42315, COMVIQ" },
	{ L"20030214:161841", L"61445, 62586, COMVIQ" },
	{ L"20030214:162040", L"61445, 42315, COMVIQ" },
	{ L"20030214:162100", L"61445, 62586, COMVIQ" },
	{ L"20030214:162527", L"61445, 18396, COMVIQ" },
	{ L"20030214:162537", L"61445, 18394, COMVIQ" },
	{ L"20030214:162630", L"61445, 18396, COMVIQ" },
	{ L"20030214:162642", L"61445, 55962, COMVIQ" },
	{ L"20030214:163016", L"61445, 55866, COMVIQ" },
	{ L"20030214:163149", L"61445, 55866, COMVIQ" },
	{ L"20030214:163151", L"61445, 21034, COMVIQ" },
	{ L"20030214:163204", L"61445, 63035, COMVIQ" },
	{ L"20030214:163225", L"61445, 21034, COMVIQ" },
	{ L"20030214:163250", L"61445, 63035, COMVIQ" },
	{ L"20030214:163322", L"61445, 17290, COMVIQ" },
	{ L"20030214:163405", L"61445, 55835, COMVIQ" },
	{ L"20030214:163629", L"61445, 55834, COMVIQ" },
	{ L"20030214:163744", L"61445, 17739, COMVIQ" },
	{ L"20030214:163949", L"61445, 17754, COMVIQ" },
	{ L"20030214:164029", L"61445, 17739, COMVIQ" },
	{ L"20030214:164413", L"61445, 63498, COMVIQ" },
	{ L"20030214:164457", L"61445, 18028, COMVIQ" },
	{ L"20030214:164619", L"61445, 63514, COMVIQ" },
	{ L"20030214:170837", L"61445, 17723, COMVIQ" },
	{ L"20030214:170929", L"61445, 63514, COMVIQ" },
	{ L"20030214:171027", L"61445, 17723, COMVIQ" },
	{ L"20030214:171044", L"61445, 63514, COMVIQ" },
	{ L"20030214:171058", L"61445, 17723, COMVIQ" },
	{ L"20030214:171129", L"61445, 63514, COMVIQ" },
	{ L"20030214:171212", L"61445, 17723, COMVIQ" },
	{ L"20030214:171246", L"61445, 63514, COMVIQ" },
	{ L"20030214:171353", L"61445, 63505, COMVIQ" },
	{ L"20030214:171416", L"61445, 63514, COMVIQ" },
	{ L"20030214:174407", L"61445, 18028, COMVIQ" },
	{ L"20030214:174446", L"61445, 63514, COMVIQ" },
	{ L"20030214:174753", L"61445, 17738, COMVIQ" },
	{ L"20030214:174801", L"61445, 63514, COMVIQ" },
	{ L"20030214:175012", L"61445, 17723, COMVIQ" },
	{ L"20030214:175103", L"61445, 63514, COMVIQ" },
	{ L"20030214:175511", L"61445, 18028, COMVIQ" },
	{ L"20030214:175602", L"61445, 63498, COMVIQ" },
	{ L"20030214:175701", L"61445, 17739, COMVIQ" },
	{ L"20030214:175757", L"61445, 17754, COMVIQ" },
	{ L"20030214:175808", L"61445, 17739, COMVIQ" },
	{ L"20030214:175907", L"61445, 17754, COMVIQ" },
	{ L"20030214:175939", L"61445, 17739, COMVIQ" },
	{ L"20030214:175953", L"61445, 17754, COMVIQ" },
	{ L"20030214:180008", L"61445, 17739, COMVIQ" },
	{ L"20030214:180027", L"61445, 17754, COMVIQ" },
	{ L"20030214:180335", L"61445, 17756, COMVIQ" },
	{ L"20030214:180520", L"61445, 59658, COMVIQ" },
	{ L"20030214:180654", L"61445, 41018, COMVIQ" },
	{ L"20030214:181131", L"61445, 59660, COMVIQ" },
	{ L"20030214:181140", L"61445, 59658, COMVIQ" },
	{ L"20030214:181244", L"61445, 17755, COMVIQ" },
	{ L"20030214:181300", L"61445, 59658, COMVIQ" },
	{ L"20030214:181317", L"61445, 17756, COMVIQ" },
	{ L"20030214:181403", L"61445, 17739, COMVIQ" },
	{ L"20030214:181436", L"61445, 17756, COMVIQ" },
	{ L"20030214:181657", L"61445, 41035, COMVIQ" },
	{ L"20030214:181723", L"61445, 17756, COMVIQ" },
	{ L"20030214:181733", L"61445, 41035, COMVIQ" },
	{ L"20030214:181927", L"61445, 17819, COMVIQ" },
	{ L"20030214:181955", L"61445, 41034, COMVIQ" },
	{ L"20030214:182120", L"61445, 17818, COMVIQ" },
	{ L"20030214:182150", L"61445, 41034, COMVIQ" },
	{ L"20030214:182243", L"61445, 17740, COMVIQ" },
	{ L"20030214:182313", L"61445, 41034, COMVIQ" },
	{ L"20030214:182325", L"61445, 17740, COMVIQ" },
	{ L"20030214:182511", L"61445, 41034, COMVIQ" },
	{ L"20030214:191433", L"61445, 17740, COMVIQ" },
	{ L"20030214:191449", L"61445, 41034, COMVIQ" },
	{ L"20030214:191515", L"61445, 17740, COMVIQ" },
	{ L"20030214:191609", L"61445, 41034, COMVIQ" },
	{ L"20030214:192537", L"61445, 17740, COMVIQ" },
	{ L"20030214:192840", L"61445, 41034, COMVIQ" },
	{ L"20030214:192924", L"61445, 17740, COMVIQ" },
	{ L"20030214:192933", L"61445, 41034, COMVIQ" },
	{ L"20030214:193021", L"61445, 17819, COMVIQ" },
	{ L"20030214:193030", L"61445, 41034, COMVIQ" },
	{ L"20030214:193735", L"61445, 17740, COMVIQ" },
	{ L"20030214:193818", L"61445, 41034, COMVIQ" },
	{ L"20030214:193942", L"61445, 17740, COMVIQ" },
	{ L"20030214:194002", L"61445, 41034, COMVIQ" },
	{ L"20030214:194328", L"61445, 17740, COMVIQ" },
	{ L"20030214:194438", L"61445, 41034, COMVIQ" },
	{ L"20030214:194629", L"61445, 17740, COMVIQ" },
	{ L"20030214:194845", L"61445, 41034, COMVIQ" },
	{ L"20030214:194950", L"61445, 17740, COMVIQ" },
	{ L"20030214:195008", L"61445, 41034, COMVIQ" },
	{ L"20030214:195304", L"61445, 17740, COMVIQ" },
	{ L"20030214:195315", L"61445, 41034, COMVIQ" },
	{ L"20030214:195440", L"61445, 17740, COMVIQ" },
	{ L"20030214:195457", L"61445, 41034, COMVIQ" },
	{ L"20030214:195817", L"61445, 17740, COMVIQ" },
	{ L"20030214:195840", L"61445, 41034, COMVIQ" },
	{ L"20030214:200400", L"61445, 17740, COMVIQ" },
	{ L"20030214:200636", L"61445, 41034, COMVIQ" },
	{ L"20030214:201344", L"61445, 41025, COMVIQ" },
	{ L"20030214:201353", L"61445, 17819, COMVIQ" },
	{ L"20030214:201354", L"61445, 17819, COMVIQ" },
	{ L"20030214:201402", L"61445, 41034, COMVIQ" },
	{ L"20030214:202609", L"61445, 17740, COMVIQ" },
	{ L"20030214:202624", L"61445, 41034, COMVIQ" },
	{ L"20030214:202915", L"61445, 17740, COMVIQ" },
	{ L"20030214:203031", L"61445, 41034, COMVIQ" },
	{ L"20030214:204015", L"61445, 17740, COMVIQ" },
	{ L"20030214:204028", L"61445, 41034, COMVIQ" },
	{ L"20030214:204134", L"61445, 17740, COMVIQ" },
	{ L"20030214:204249", L"61445, 41034, COMVIQ" },
	{ L"20030214:204324", L"61445, 17740, COMVIQ" },
	{ L"20030214:204534", L"61445, 41034, COMVIQ" },
	{ L"20030214:204559", L"61445, 17740, COMVIQ" },
	{ L"20030214:204615", L"61445, 41034, COMVIQ" },
	{ L"20030214:204641", L"61445, 17740, COMVIQ" },
	{ L"20030214:204701", L"61445, 41034, COMVIQ" },
	{ L"20030214:204718", L"61445, 17740, COMVIQ" },
	{ L"20030214:205156", L"61445, 41034, COMVIQ" },
	{ L"20030214:205218", L"61445, 17740, COMVIQ" },
	{ L"20030214:205324", L"61445, 17739, COMVIQ" },
	{ L"20030214:205344", L"61445, 17740, COMVIQ" },
	{ L"20030214:205410", L"61445, 41034, COMVIQ" },
	{ L"20030214:205420", L"61445, 17740, COMVIQ" },
	{ L"20030214:205530", L"61445, 41034, COMVIQ" },
	{ L"20030214:205555", L"61445, 17740, COMVIQ" },
	{ L"20030214:205710", L"61445, 41034, COMVIQ" },
	{ L"20030214:205937", L"61445, 17740, COMVIQ" },
	{ L"20030214:210031", L"61445, 41034, COMVIQ" },
	{ L"20030214:210047", L"61445, 17740, COMVIQ" },
	{ L"20030214:210142", L"61445, 41034, COMVIQ" },
	{ L"20030214:210527", L"61445, 17740, COMVIQ" },
	{ L"20030214:210757", L"61445, 41034, COMVIQ" },
	{ L"20030214:211629", L"61445, 17740, COMVIQ" },
	{ L"20030214:211648", L"61445, 41034, COMVIQ" },
	{ L"20030214:211717", L"61445, 17740, COMVIQ" },
	{ L"20030214:211807", L"61445, 41034, COMVIQ" },
	{ L"20030214:211829", L"61445, 17740, COMVIQ" },
	{ L"20030214:211900", L"61445, 41034, COMVIQ" },
	{ L"20030214:212110", L"61445, 17740, COMVIQ" },
	{ L"20030214:212126", L"61445, 17739, COMVIQ" },
	{ L"20030214:212141", L"61445, 56602, COMVIQ" },
	{ L"20030214:212536", L"61445, 56618, COMVIQ" },
	{ L"20030214:212652", L"61445, 56634, COMVIQ" },
	{ L"20030214:212920", L"61445, 29243, COMVIQ" },
	{ L"20030214:213002", L"61445, 64171, COMVIQ" },
	{ L"20030214:213039", L"61445, 29243, COMVIQ" },
	{ L"20030214:213122", L"61445, 29244, COMVIQ" },
	{ L"20030214:213149", L"61445, 64171, COMVIQ" },
	{ L"20030214:213220", L"61445, 29242, COMVIQ" },
	{ L"20030214:213352", L"61445, 64172, COMVIQ" },
	{ L"20030214:213423", L"61445, 29244, COMVIQ" },
	{ L"20030214:213439", L"61445, 64172, COMVIQ" },
	{ L"20030214:213526", L"61445, 29244, COMVIQ" },
	{ L"20030214:213539", L"61445, 64172, COMVIQ" },
	{ L"20030214:213611", L"61445, 29244, COMVIQ" },
	{ L"20030214:213611", L"SWITCH" },
	{ L"20030214:214137", L"61445, 64172, COMVIQ" },
	{ L"20030214:214143", L"61445, 29244, COMVIQ" },
	{ L"20030214:214528", L"61445, 64172, COMVIQ" },
	{ L"20030214:214545", L"61445, 29244, COMVIQ" },
	{ L"20030214:214606", L"61445, 64172, COMVIQ" },
	{ L"20030214:214623", L"61445, 29244, COMVIQ" },
	{ L"20030214:214719", L"61445, 64172, COMVIQ" },
	{ L"20030214:214730", L"61445, 29244, COMVIQ" },
	{ L"20030214:214803", L"61445, 64172, COMVIQ" },
	{ L"20030214:214812", L"61445, 29244, COMVIQ" },
	{ L"20030214:214901", L"61445, 64172, COMVIQ" },
	{ L"20030214:215014", L"61445, 29244, COMVIQ" },
	{ L"20030214:215307", L"61445, 64172, COMVIQ" },
	{ L"20030214:215325", L"61445, 29244, COMVIQ" },
	{ L"20030214:215905", L"61445, 64172, COMVIQ" },
	{ L"20030214:220004", L"61445, 29244, COMVIQ" },
	{ L"20030214:222314", L"61445, 64172, COMVIQ" },
	{ L"20030214:222344", L"61445, 29244, COMVIQ" },
	{ L"20030214:222836", L"61445, 64172, COMVIQ" },
	{ L"20030214:223233", L"61445, 29244, COMVIQ" },
	{ L"20030214:223305", L"61445, 64172, COMVIQ" },
	{ L"20030214:223326", L"61445, 29244, COMVIQ" },
	{ L"20030214:224917", L"61445, 64172, COMVIQ" },
	{ L"20030214:224959", L"61445, 29244, COMVIQ" },
	{ L"20030214:225041", L"61445, 64172, COMVIQ" },
	{ L"20030214:225103", L"61445, 29244, COMVIQ" },
	{ L"20030214:225130", L"61445, 64172, COMVIQ" },
	{ L"20030214:225143", L"61445, 29244, COMVIQ" },
	{ L"20030214:225227", L"61445, 64172, COMVIQ" },
	{ L"20030214:225248", L"61445, 29244, COMVIQ" },
	{ L"20030214:225410", L"61445, 64172, COMVIQ" },
	{ L"20030214:225456", L"61445, 29244, COMVIQ" },
	{ L"20030214:230140", L"61445, 64172, COMVIQ" },
	{ L"20030214:230154", L"61445, 29244, COMVIQ" },
	{ L"20030214:230223", L"61445, 64172, COMVIQ" },
	{ L"20030214:230641", L"61445, 29244, COMVIQ" },
	{ L"20030214:230923", L"61445, 64172, COMVIQ" },
	{ L"20030214:230957", L"61445, 29244, COMVIQ" },
	{ L"20030214:231018", L"61445, 64172, COMVIQ" },
	{ L"20030214:231038", L"61445, 29244, COMVIQ" },
	{ L"20030214:231429", L"61445, 64172, COMVIQ" },
	{ L"20030214:231455", L"61445, 29244, COMVIQ" },
	{ L"20030214:231547", L"61445, 64172, COMVIQ" },
	{ L"20030214:231707", L"61445, 29244, COMVIQ" },
	{ L"20030214:231738", L"61445, 64172, COMVIQ" },
	{ L"20030214:231757", L"61445, 29244, COMVIQ" },
	{ L"20030214:231857", L"61445, 64172, COMVIQ" },
	{ L"20030214:232033", L"61445, 29244, COMVIQ" },
	{ L"20030214:233112", L"61445, 64172, COMVIQ" },
	{ L"20030214:233154", L"61445, 29244, COMVIQ" },
	{ L"20030214:233902", L"61445, 64172, COMVIQ" },
	{ L"20030214:233919", L"61445, 29244, COMVIQ" },
	{ L"20030214:234059", L"61445, 64172, COMVIQ" },
	{ L"20030214:234201", L"61445, 29244, COMVIQ" },
	{ L"20030214:234425", L"61445, 64172, COMVIQ" },
	{ L"20030214:234504", L"61445, 29244, COMVIQ" },
	{ L"20030214:234722", L"61445, 64172, COMVIQ" },
	{ L"20030214:234850", L"61445, 29244, COMVIQ" },
	{ L"20030214:234902", L"61445, 64172, COMVIQ" },
	{ L"20030214:235028", L"61445, 29244, COMVIQ" },
	{ L"20030214:235309", L"61445, 64172, COMVIQ" },
	{ L"20030214:235322", L"61445, 29244, COMVIQ" },
	{ L"20030214:235339", L"61445, 64172, COMVIQ" },
	{ L"20030214:235410", L"61445, 29244, COMVIQ" },
	{ L"20030214:235443", L"61445, 64172, COMVIQ" },
	{ L"20030214:235451", L"61445, 29244, COMVIQ" },
	{ L"20030214:235647", L"61445, 64172, COMVIQ" },
	{ L"20030214:235703", L"61445, 29244, COMVIQ" },
	{ L"20030214:235800", L"61445, 64172, COMVIQ" },
	{ L"20030214:235812", L"61445, 29244, COMVIQ" },
	{ L"20030215:000006", L"61445, 64172, COMVIQ" },
	{ L"20030215:000015", L"61445, 29244, COMVIQ" },
	{ L"20030215:000046", L"61445, 64172, COMVIQ" },
	{ L"20030215:000118", L"61445, 29244, COMVIQ" },
	{ L"20030215:000153", L"61445, 64172, COMVIQ" },
	{ L"20030215:000210", L"61445, 29242, COMVIQ" },
	{ L"20030215:000406", L"61445, 64171, COMVIQ" },
	{ L"20030215:000612", L"61445, 29243, COMVIQ" },
	{ L"20030215:000820", L"61445, 42298, COMVIQ" },
	{ L"20030215:001255", L"61445, 17772, COMVIQ" },
	{ L"20030215:001705", L"61445, 17770, COMVIQ" },
	{ L"20030215:001735", L"61445, 17756, COMVIQ" },
	{ L"20030215:001805", L"61445, 17770, COMVIQ" },
	{ L"20030215:001840", L"61445, 17756, COMVIQ" },
	{ L"20030215:002147", L"61445, 53642, COMVIQ" },
	{ L"20030215:002208", L"61445, 59660, COMVIQ" },
	{ L"20030215:002227", L"61445, 59658, COMVIQ" },
	{ L"20030215:002304", L"61445, 59660, COMVIQ" },
	{ L"20030215:003107", L"61445, 17771, COMVIQ" },
	{ L"20030215:003156", L"61443, 54298, COMVIQ" },
	{ L"20030215:003223", L"61443, 54299, COMVIQ" },
	{ L"20030215:003249", L"61443, 26186, COMVIQ" },
	{ L"20030215:003258", L"61443, 64059, COMVIQ" },
	{ L"20030215:003315", L"61443, 26188, COMVIQ" },
	{ L"20030215:003348", L"61443, 17963, COMVIQ" },
	{ L"20030215:003356", L"61443, 64092, COMVIQ" },
	{ L"20030215:003432", L"61443, 21772, COMVIQ" },
	{ L"20030215:003524", L"61443, 41082, COMVIQ" },
	{ L"20030215:003541", L"61443, 41083, COMVIQ" },
	{ L"20030215:003604", L"61443, 41082, COMVIQ" },
	{ L"20030215:003612", L"61443, 41084, COMVIQ" },
	{ L"20030215:003633", L"61443, 63274, COMVIQ" },
	{ L"20030215:003649", L"61443, 63275, COMVIQ" },
	{ L"20030215:003727", L"61443, 16458, COMVIQ" },
	{ L"20030215:003749", L"61443, 16460, COMVIQ" },
	{ L"20030215:003835", L"61443, 28938, COMVIQ" },
	{ L"20030215:003900", L"61443, 28940, COMVIQ" },
	{ L"20030215:004004", L"61443, 20763, COMVIQ" },
	{ L"20030215:004040", L"61443, 41514, COMVIQ" },
	{ L"20030215:004202", L"61443, 41516, COMVIQ" },
	{ L"20030215:004243", L"61443, 63259, COMVIQ" },
	{ L"20030215:004351", L"61443, 17147, COMVIQ" },
	{ L"20030215:004402", L"61443, 16428, COMVIQ" },
	{ L"20030215:004427", L"61443, 59898, COMVIQ" },
	{ L"20030215:004442", L"61443, 59899, COMVIQ" },
	{ L"20030215:004511", L"61443, 17147, COMVIQ" },
	{ L"20030215:004520", L"61443, 30091, COMVIQ" },
	{ L"20030215:004558", L"61443, 17147, COMVIQ" },
	{ L"20030215:004625", L"61443, 17146, COMVIQ" },
	{ L"20030215:004713", L"61443, 30091, COMVIQ" },
	{ L"20030215:004751", L"61443, 30090, COMVIQ" },
	{ L"20030215:004858", L"61443, 22187, COMVIQ" },
	{ L"20030215:004921", L"61443, 22186, COMVIQ" },
	{ L"20030215:004936", L"61443, 22298, COMVIQ" },
	{ L"20030215:005011", L"61443, 22300, COMVIQ" },
	{ L"20030215:005356", L"61460, 29339, COMVIQ" },
	{ L"20030215:005608", L"61460, 29338, COMVIQ" },
	{ L"20030215:005735", L"61460, 29274, COMVIQ" },
	{ L"20030215:005835", L"61460, 20507, COMVIQ" },
	{ L"20030215:005847", L"61460, 29276, COMVIQ" },
	{ L"20030215:005915", L"61460, 30528, COMVIQ" },
	{ L"20030215:010232", L"61460, 33995, COMVIQ" },
	{ L"20030215:010251", L"61460, 30528, COMVIQ" },
	{ L"20030215:010349", L"61460, 33995, COMVIQ" },
	{ L"20030215:010532", L"61460, 33994, COMVIQ" },
	{ L"20030215:010720", L"61460, 33996, COMVIQ" },
	{ L"20030215:010933", L"61448, 30522, COMVIQ" },
	{ L"20030215:010952", L"61448, 34026, COMVIQ" },
	{ L"20030215:011312", L"61448, 63882, COMVIQ" },
	{ L"20030215:011329", L"61448, 37098, COMVIQ" },
	{ L"20030215:011355", L"61448, 63882, COMVIQ" },
	{ L"20030215:011441", L"61448, 63883, COMVIQ" },
	{ L"20030215:011519", L"61448, 37098, COMVIQ" },
	{ L"20030215:011610", L"61448, 37099, COMVIQ" },
	{ L"20030215:011642", L"61448, 37100, COMVIQ" },
	{ L"20030215:011734", L"61448, 54059, COMVIQ" },
	{ L"20030215:011821", L"61448, 54060, COMVIQ" },
	{ L"20030215:011857", L"61448, 63866, COMVIQ" },
	{ L"20030215:011922", L"61448, 54060, COMVIQ" },
	{ L"20030215:011957", L"61448, 63866, COMVIQ" },
	{ L"20030215:012105", L"61448, 24730, COMVIQ" },
	{ L"20030215:012120", L"61448, 63866, COMVIQ" },
	{ L"20030215:012133", L"61448, 54060, COMVIQ" },
	{ L"20030215:012634", L"61448, 24730, COMVIQ" },
	{ L"20030215:012938", L"61448, 63819, COMVIQ" },
	{ L"20030215:013000", L"61448, 24730, COMVIQ" },
	{ L"20030215:013238", L"61448, 24732, COMVIQ" },
	{ L"20030215:013247", L"61448, 24730, COMVIQ" },
	{ L"20030215:013302", L"61448, 63819, COMVIQ" },
	{ L"20030215:013311", L"61448, 24730, COMVIQ" },
	{ L"20030215:013337", L"61448, 63820, COMVIQ" },
	{ L"20030215:014200", L"61448, 24732, COMVIQ" },
	{ L"20030215:014216", L"61448, 63755, COMVIQ" },
	{ L"20030215:014228", L"61448, 63820, COMVIQ" },
	{ L"20030215:014350", L"61448, 24732, COMVIQ" },
	{ L"20030215:014436", L"61448, 63755, COMVIQ" },
	{ L"20030215:014454", L"61448, 63820, COMVIQ" },
	{ L"20030215:014515", L"61448, 63802, COMVIQ" },
	{ L"20030215:014531", L"61448, 24732, COMVIQ" },
	{ L"20030215:014603", L"61448, 63802, COMVIQ" },
	{ L"20030215:014619", L"61448, 63820, COMVIQ" },
	{ L"20030215:014627", L"61448, 63802, COMVIQ" },
	{ L"20030215:014657", L"61448, 63755, COMVIQ" },
	{ L"20030215:014731", L"61448, 63802, COMVIQ" },
	{ L"20030215:014811", L"61448, 63755, COMVIQ" },
	{ L"20030215:014832", L"61448, 63820, COMVIQ" },
	{ L"20030215:014911", L"61448, 63755, COMVIQ" },
	{ L"20030215:015212", L"61448, 63756, COMVIQ" },
	{ L"20030215:015353", L"61448, 24732, COMVIQ" },
	{ L"20030215:015409", L"61448, 63756, COMVIQ" },
	{ L"20030215:110850", L"61448, 63627, COMVIQ" },
	{ L"20030215:110905", L"61448, 63756, COMVIQ" },
	{ L"20030215:111034", L"61448, 63627, COMVIQ" },
	{ L"20030215:111103", L"61448, 63756, COMVIQ" },
	{ L"20030215:111246", L"61448, 63627, COMVIQ" },
	{ L"20030215:111300", L"61448, 63756, COMVIQ" },
	{ L"20030215:111416", L"61448, 63627, COMVIQ" },
	{ L"20030215:111424", L"61448, 63756, COMVIQ" },
	{ L"20030215:111452", L"61448, 63627, COMVIQ" },
	{ L"20030215:111506", L"61448, 63756, COMVIQ" },
	{ L"20030215:111609", L"61448, 63627, COMVIQ" },
	{ L"20030215:111630", L"61448, 63756, COMVIQ" },
	{ L"20030215:111735", L"61448, 24732, COMVIQ" },
	{ L"20030215:111838", L"61448, 63756, COMVIQ" },
	{ L"20030215:111900", L"61448, 24732, COMVIQ" },
	{ L"20030215:112132", L"61448, 63802, COMVIQ" },
	{ L"20030215:112452", L"61448, 24732, COMVIQ" },
	{ L"20030215:112540", L"61448, 63802, COMVIQ" },
	{ L"20030215:112556", L"61448, 24732, COMVIQ" },
	{ L"20030215:112716", L"61448, 63802, COMVIQ" },
	{ L"20030215:112731", L"61448, 24732, COMVIQ" },
	{ L"20030215:112747", L"61448, 24731, COMVIQ" },
	{ L"20030215:113045", L"61448, 63803, COMVIQ" },
	{ L"20030215:113114", L"61448, 24731, COMVIQ" },
	{ L"20030215:114716", L"61448, 63803, COMVIQ" },
	{ L"20030215:114732", L"61448, 24731, COMVIQ" },
	{ L"20030215:114903", L"61448, 63803, COMVIQ" },
	{ L"20030215:114914", L"61448, 24731, COMVIQ" },
	{ L"20030215:120502", L"61448, 63803, COMVIQ" },
	{ L"20030215:120518", L"61448, 24731, COMVIQ" },
	{ L"20030215:122922", L"61448, 63803, COMVIQ" },
	{ L"20030215:122931", L"61448, 24731, COMVIQ" },
	{ L"20030215:123305", L"61448, 63803, COMVIQ" },
	{ L"20030215:123319", L"61448, 24731, COMVIQ" },
	{ L"20030215:124152", L"61448, 63803, COMVIQ" },
	{ L"20030215:124208", L"61448, 24731, COMVIQ" },
	{ L"20030215:124221", L"61448, 63803, COMVIQ" },
	{ L"20030215:124239", L"61448, 24731, COMVIQ" },
	{ L"20030215:131308", L"61448, 63803, COMVIQ" },
	{ L"20030215:131325", L"61448, 24731, COMVIQ" },
	{ L"20030215:131733", L"61448, 63803, COMVIQ" },
	{ L"20030215:131829", L"61448, 24731, COMVIQ" },
	{ L"20030215:131845", L"61448, 63803, COMVIQ" },
	{ L"20030215:131913", L"61448, 24731, COMVIQ" },
	{ L"20030215:132419", L"61448, 63803, COMVIQ" },
	{ L"20030215:132434", L"61448, 24731, COMVIQ" },
	{ L"20030215:134957", L"61448, 63803, COMVIQ" },
	{ L"20030215:135013", L"61448, 24731, COMVIQ" },
	{ L"20030215:135136", L"61448, 63803, COMVIQ" },
	{ L"20030215:135201", L"61448, 24731, COMVIQ" },
	{ L"20030215:135221", L"61448, 63803, COMVIQ" },
	{ L"20030215:140005", L"61448, 24731, COMVIQ" },
	{ L"20030215:145427", L"61448, 63803, COMVIQ" },
	{ L"20030215:150931", L"61448, 24731, COMVIQ" },
	{ L"20030215:150947", L"61448, 63803, COMVIQ" },
	{ L"20030215:151247", L"61448, 24731, COMVIQ" },
	{ L"20030215:151356", L"61448, 63803, COMVIQ" },
	{ L"20030215:151415", L"61448, 24731, COMVIQ" },
	{ L"20030215:151447", L"61448, 63803, COMVIQ" },
	{ L"20030215:151554", L"61448, 24731, COMVIQ" },
	{ L"20030215:151617", L"61448, 63803, COMVIQ" },
	{ L"20030215:151634", L"61448, 24731, COMVIQ" },
	{ L"20030215:152412", L"61448, 63868, COMVIQ" },
	{ L"20030215:152425", L"61448, 63867, COMVIQ" },
	{ L"20030215:152525", L"61448, 63868, COMVIQ" },
	{ L"20030215:152612", L"61448, 63867, COMVIQ" },
	{ L"20030215:152629", L"61448, 63868, COMVIQ" },
	{ L"20030215:152637", L"61448, 63867, COMVIQ" },
	{ L"20030215:152724", L"61448, 63868, COMVIQ" },
	{ L"20030215:152737", L"61448, 63867, COMVIQ" },
	{ L"20030215:155325", L"61448, 63852, COMVIQ" },
	{ L"20030215:155404", L"61448, 63867, COMVIQ" },
	{ L"20030215:155443", L"61448, 63852, COMVIQ" },
	{ L"20030215:155642", L"61448, 24731, COMVIQ" },
	{ L"20030215:155836", L"61448, 54059, COMVIQ" },
	{ L"20030215:155845", L"61448, 63852, COMVIQ" },
	{ L"20030215:155950", L"61448, 54059, COMVIQ" },
	{ L"20030215:160008", L"61448, 63852, COMVIQ" },
	{ L"20030215:160106", L"61448, 54042, COMVIQ" },
	{ L"20030215:160121", L"61448, 63852, COMVIQ" },
	{ L"20030215:160147", L"61448, 33930, COMVIQ" },
	{ L"20030215:160345", L"61448, 24731, COMVIQ" },
	{ L"20030215:160416", L"61448, 33930, COMVIQ" },
	{ L"20030215:160427", L"61448, 24731, COMVIQ" },
	{ L"20030215:160446", L"61448, 63819, COMVIQ" },
	{ L"20030215:160507", L"61448, 24731, COMVIQ" },
	{ L"20030215:160813", L"61448, 63867, COMVIQ" },
	{ L"20030215:160906", L"61448, 24731, COMVIQ" },
	{ L"20030215:160923", L"61448, 63867, COMVIQ" },
	{ L"20030215:160938", L"61448, 63852, COMVIQ" },
	{ L"20030215:160955", L"61448, 63867, COMVIQ" },
	{ L"20030215:161101", L"61448, 24731, COMVIQ" },
	{ L"20030215:161117", L"61448, 63867, COMVIQ" },
	{ L"20030215:161133", L"61448, 63852, COMVIQ" },
	{ L"20030215:161149", L"61448, 24731, COMVIQ" },
	{ L"20030215:161236", L"61448, 63819, COMVIQ" },
	{ L"20030215:161248", L"61448, 63852, COMVIQ" },
	{ L"20030215:161305", L"61448, 63867, COMVIQ" },
	{ L"20030215:161314", L"61448, 63852, COMVIQ" },
	{ L"20030215:161343", L"61448, 63819, COMVIQ" },
	{ L"20030215:161353", L"61448, 24731, COMVIQ" },
	{ L"20030215:161518", L"61448, 63867, COMVIQ" },
	{ L"20030215:161548", L"61448, 24731, COMVIQ" },
	{ L"20030215:161707", L"61448, 63867, COMVIQ" },
	{ L"20030215:161730", L"61448, 24731, COMVIQ" },
	{ L"20030215:161812", L"61448, 63819, COMVIQ" },
	{ L"20030215:161825", L"61448, 63867, COMVIQ" },
	{ L"20030215:161838", L"61448, 24731, COMVIQ" },
	{ L"20030215:161846", L"61448, 63819, COMVIQ" },
	{ L"20030215:161930", L"61448, 24731, COMVIQ" },
	{ L"20030215:162157", L"61448, 63868, COMVIQ" },
	{ L"20030215:162213", L"61448, 24731, COMVIQ" },
	{ L"20030215:162222", L"61448, 63867, COMVIQ" },
	{ L"20030215:162307", L"61448, 63868, COMVIQ" },
	{ L"20030215:162326", L"61448, 24731, COMVIQ" },
	{ L"20030215:162335", L"61448, 63868, COMVIQ" },
	{ L"20030215:162539", L"61448, 24731, COMVIQ" },
	{ L"20030215:162556", L"61448, 63868, COMVIQ" },
	{ L"20030215:162613", L"61448, 24730, COMVIQ" },
	{ L"20030215:162621", L"61448, 24731, COMVIQ" },
	{ L"20030215:162737", L"61448, 63868, COMVIQ" },
	{ L"20030215:162825", L"61448, 24730, COMVIQ" },
	{ L"20030215:162848", L"61448, 24731, COMVIQ" },
	{ L"20030215:162910", L"61448, 63868, COMVIQ" },
	{ L"20030215:162923", L"61448, 24731, COMVIQ" },
	{ L"20030215:163126", L"61448, 63868, COMVIQ" },
	{ L"20030215:163256", L"61448, 24731, COMVIQ" },
	{ L"20030215:163313", L"61448, 63868, COMVIQ" },
	{ L"20030215:165600", L"61448, 24730, COMVIQ" },
	{ L"20030215:170143", L"61448, 24732, COMVIQ" },
	{ L"20030215:170253", L"61448, 63802, COMVIQ" },
	{ L"20030215:170302", L"61448, 24732, COMVIQ" },
	{ L"20030215:170418", L"61448, 63802, COMVIQ" },
	{ L"20030215:170824", L"61448, 24732, COMVIQ" },
	{ L"20030215:171015", L"61448, 63756, COMVIQ" },
	{ L"20030215:171024", L"61448, 24732, COMVIQ" },
	{ L"20030215:171037", L"61448, 63756, COMVIQ" },
	{ L"20030215:171054", L"61448, 24732, COMVIQ" },
	{ L"20030215:171137", L"61448, 63756, COMVIQ" },
	{ L"20030215:171254", L"61448, 24732, COMVIQ" },
	{ L"20030215:171314", L"61448, 63756, COMVIQ" },
	{ L"20030215:171553", L"61448, 41564, COMVIQ" },
	{ L"20030215:171701", L"61448, 63756, COMVIQ" },
	{ L"20030215:171717", L"61448, 24732, COMVIQ" },
	{ L"20030215:171751", L"61448, 41564, COMVIQ" },
	{ L"20030215:171822", L"61448, 63756, COMVIQ" },
	{ L"20030215:172337", L"61448, 41564, COMVIQ" },
	{ L"20030215:172404", L"61448, 63756, COMVIQ" },
	{ L"20030215:172607", L"61448, 24732, COMVIQ" },
	{ L"20030215:172623", L"61448, 41564, COMVIQ" },
	{ L"20030215:172911", L"61448, 63756, COMVIQ" },
	{ L"20030215:173238", L"61448, 41564, COMVIQ" },
	{ L"20030215:173308", L"61448, 63756, COMVIQ" },
	{ L"20030215:182554", L"61448, 63756, COMVIQ" },
	{ L"20030215:183559", L"61448, 41564, COMVIQ" },
	{ L"20030215:185051", L"61448, 63756, COMVIQ" },
	{ L"20030215:192859", L"61448, 41564, COMVIQ" },
	{ L"20030215:192909", L"61448, 63756, COMVIQ" },
	{ L"20030215:192940", L"61448, 41564, COMVIQ" },
	{ L"20030215:193057", L"61448, 63756, COMVIQ" },
	{ L"20030215:193619", L"61448, 41564, COMVIQ" },
	{ L"20030215:193619", L"61448, 41564, COMVIQ" },
	{ L"20030215:193721", L"61448, 63756, COMVIQ" },
	{ L"20030215:194043", L"61448, 41564, COMVIQ" },
	{ L"20030215:194100", L"61448, 63756, COMVIQ" },
	{ L"20030215:194211", L"61448, 41564, COMVIQ" },
	{ L"20030215:194442", L"61448, 63756, COMVIQ" },
	{ L"20030215:194551", L"61448, 41564, COMVIQ" },
	{ L"20030215:194606", L"61448, 24732, COMVIQ" },
	{ L"20030215:194627", L"61448, 41564, COMVIQ" },
	{ L"20030215:194741", L"61448, 63756, COMVIQ" },
	{ L"20030215:194757", L"61448, 41564, COMVIQ" },
	{ L"20030215:195456", L"61448, 63756, COMVIQ" },
	{ L"20030215:195634", L"61448, 41564, COMVIQ" },
	{ L"20030215:202733", L"61448, 63756, COMVIQ" },
	{ L"20030215:205257", L"61448, 24732, COMVIQ" },
	{ L"20030215:205313", L"61448, 41564, COMVIQ" },
	{ L"20030215:205649", L"61448, 63756, COMVIQ" },
	{ L"20030215:205819", L"61448, 41564, COMVIQ" },
	{ L"20030215:205842", L"61448, 63756, COMVIQ" },
	{ L"20030215:211534", L"61448, 63755, COMVIQ" },
	{ L"20030215:212049", L"61448, 63820, COMVIQ" },
	{ L"20030215:212058", L"61448, 63755, COMVIQ" },
	{ L"20030215:212136", L"61448, 63820, COMVIQ" },
	{ L"20030215:213135", L"61448, 63819, COMVIQ" },
	{ L"20030215:214331", L"61448, 63818, COMVIQ" },
	{ L"20030215:214559", L"61448, 63819, COMVIQ" },
	{ L"20030215:214624", L"61448, 63818, COMVIQ" },
	{ L"20030215:214655", L"61448, 54060, COMVIQ" },
	{ L"20030215:214728", L"61448, 63818, COMVIQ" },
	{ L"20030215:214827", L"61448, 54058, COMVIQ" },
	{ L"20030215:214858", L"61448, 63818, COMVIQ" },
	{ L"20030215:214958", L"61448, 54058, COMVIQ" },
	{ L"20030215:215014", L"61448, 63818, COMVIQ" },
	{ L"20030215:215052", L"61448, 54058, COMVIQ" },
	{ L"20030215:215530", L"61448, 41563, COMVIQ" },
	{ L"20030215:215608", L"61448, 54058, COMVIQ" },
	{ L"20030215:220010", L"61448, 63866, COMVIQ" },
	{ L"20030215:220020", L"61448, 24730, COMVIQ" },
	{ L"20030215:220035", L"61448, 41563, COMVIQ" },
	{ L"20030215:220053", L"61448, 63818, COMVIQ" },
	{ L"20030215:220109", L"61448, 24730, COMVIQ" },
	{ L"20030215:220125", L"61448, 54058, COMVIQ" },
	{ L"20030215:220246", L"61448, 63818, COMVIQ" },
	{ L"20030215:220301", L"61448, 24730, COMVIQ" },
	{ L"20030215:220313", L"61448, 41563, COMVIQ" },
	{ L"20030215:220339", L"61448, 54058, COMVIQ" },
	{ L"20030215:220347", L"61448, 41563, COMVIQ" },
	{ L"20030215:220402", L"61448, 54058, COMVIQ" },
	{ L"20030215:220500", L"61448, 63770, COMVIQ" },
	{ L"20030215:220509", L"61448, 63818, COMVIQ" },
	{ L"20030215:220757", L"61448, 54060, COMVIQ" },
	{ L"20030215:220807", L"61448, 54058, COMVIQ" },
	{ L"20030215:221118", L"61448, 54060, COMVIQ" },
	{ L"20030215:221135", L"61448, 54058, COMVIQ" },
	{ L"20030215:221151", L"61448, 63818, COMVIQ" },
	{ L"20030215:221203", L"61448, 54058, COMVIQ" },
	{ L"20030215:221222", L"61448, 63818, COMVIQ" },
	{ L"20030215:221239", L"61448, 41563, COMVIQ" },
	{ L"20030215:221307", L"61448, 54058, COMVIQ" },
	{ L"20030215:221327", L"61448, 63818, COMVIQ" },
	{ L"20030215:221410", L"61448, 54060, COMVIQ" },
	{ L"20030215:221431", L"61448, 63818, COMVIQ" },
	{ L"20030215:221441", L"61448, 54058, COMVIQ" },
	{ L"20030215:221510", L"61448, 54060, COMVIQ" },
	{ L"20030215:221537", L"61448, 54058, COMVIQ" },
	{ L"20030215:221554", L"61448, 54060, COMVIQ" },
	{ L"20030215:221623", L"61448, 54058, COMVIQ" },
	{ L"20030215:221639", L"61448, 63818, COMVIQ" },
	{ L"20030215:221733", L"61448, 54060, COMVIQ" },
	{ L"20030215:221811", L"61448, 24730, COMVIQ" },
	{ L"20030215:222929", L"61448, 24732, COMVIQ" },
	{ L"20030215:223100", L"61448, 63802, COMVIQ" },
	{ L"20030215:223258", L"61448, 24732, COMVIQ" },
	{ L"20030215:223417", L"61448, 24732, COMVIQ" },
	{ L"20030215:223430", L"61448, 63756, COMVIQ" },
	{ L"20030215:223530", L"61448, 24732, COMVIQ" },
	{ L"20030215:223601", L"61448, 63756, COMVIQ" },
	{ L"20030215:223753", L"61448, 41564, COMVIQ" },
	{ L"20030215:223814", L"61448, 63756, COMVIQ" },
	{ L"20030215:224141", L"61448, 41564, COMVIQ" },
	{ L"20030215:224153", L"61448, 63756, COMVIQ" },
	{ L"20030215:224322", L"61448, 41564, COMVIQ" },
	{ L"20030215:224346", L"61448, 63756, COMVIQ" },
	{ L"20030215:224425", L"61448, 24732, COMVIQ" },
	{ L"20030215:224436", L"61448, 41564, COMVIQ" },
	{ L"20030215:224451", L"61448, 63756, COMVIQ" },
	{ L"20030215:224523", L"61448, 41564, COMVIQ" },
	{ L"20030215:224539", L"61448, 63756, COMVIQ" },
	{ L"20030215:224618", L"61448, 24732, COMVIQ" },
	{ L"20030215:224631", L"61448, 63756, COMVIQ" },
	{ L"20030215:224653", L"61448, 41564, COMVIQ" },
	{ L"20030215:224817", L"61448, 63756, COMVIQ" },
	{ L"20030215:224939", L"61448, 41564, COMVIQ" },
	{ L"20030215:224947", L"61448, 63756, COMVIQ" },
	{ L"20030215:225037", L"61448, 41564, COMVIQ" },
	{ L"20030215:225139", L"61448, 63756, COMVIQ" },
	{ L"20030215:225208", L"61448, 63756, COMVIQ" },
	{ L"20030215:225208", L"61448, 63756, COMVIQ" },
	{ L"20030215:225927", L"61448, 41564, COMVIQ" },
	{ L"20030215:225947", L"61448, 63756, COMVIQ" },
	{ L"20030215:230002", L"61448, 41564, COMVIQ" },
	{ L"20030215:230002", L"SWITCH" },
	{ L"20030216:103348", L"61448, 63756, COMVIQ" },
	{ L"20030216:105453", L"61448, 63820, COMVIQ" },
	{ L"20030216:105514", L"61448, 63756, COMVIQ" },
	{ L"20030216:110243", L"61448, 63820, COMVIQ" },
	{ L"20030216:110252", L"61448, 63756, COMVIQ" },
	{ L"20030216:110627", L"61448, 41564, COMVIQ" },
	{ L"20030216:110719", L"61448, 63756, COMVIQ" },
	{ L"20030216:110736", L"61448, 41564, COMVIQ" },
	{ L"20030216:110827", L"61448, 63756, COMVIQ" },
	{ L"20030216:111749", L"61448, 63820, COMVIQ" },
	{ L"20030216:111805", L"61448, 63756, COMVIQ" },
	{ L"20030216:112012", L"61448, 63820, COMVIQ" },
	{ L"20030216:112236", L"61448, 63756, COMVIQ" },
	{ L"20030216:112326", L"61448, 63820, COMVIQ" },
	{ L"20030216:112342", L"61448, 63756, COMVIQ" },
	{ L"20030216:112546", L"61448, 24732, COMVIQ" },
	{ L"20030216:112608", L"61448, 63756, COMVIQ" },
	{ L"20030216:112836", L"61448, 24732, COMVIQ" },
	{ L"20030216:112845", L"61448, 63756, COMVIQ" },
	{ L"20030216:113312", L"61448, 41564, COMVIQ" },
	{ L"20030216:113321", L"61448, 63756, COMVIQ" },
	{ L"20030216:114223", L"61448, 63627, COMVIQ" },
	{ L"20030216:115005", L"61448, 63756, COMVIQ" },
	{ L"20030216:115026", L"61448, 63627, COMVIQ" },
	{ L"20030216:115046", L"61448, 63756, COMVIQ" },
	{ L"20030216:115243", L"61448, 24732, COMVIQ" },
	{ L"20030216:115529", L"61448, 63802, COMVIQ" },
	{ L"20030216:115555", L"61448, 24732, COMVIQ" },
	{ L"20030216:115653", L"61448, 24730, COMVIQ" },
	{ L"20030216:120012", L"61448, 54060, COMVIQ" },
	{ L"20030216:120316", L"61448, 63866, COMVIQ" },
	{ L"20030216:120428", L"61448, 54060, COMVIQ" },
	{ L"20030216:120834", L"61448, 63866, COMVIQ" },
	{ L"20030216:120842", L"61448, 54060, COMVIQ" },
	{ L"20030216:121051", L"61448, 54059, COMVIQ" },
	{ L"20030216:121115", L"61448, 54058, COMVIQ" },
	{ L"20030216:121146", L"61448, 54059, COMVIQ" },
	{ L"20030216:121154", L"61448, 37100, COMVIQ" },
	{ L"20030216:121204", L"61448, 37099, COMVIQ" },
	{ L"20030216:121217", L"61448, 37098, COMVIQ" },
	{ L"20030216:121242", L"61448, 63883, COMVIQ" },
	{ L"20030216:121324", L"61448, 63883, COMVIQ" },
	{ L"20030216:121352", L"1007, 17990, TELIA" },
	{ L"20030216:121419", L"1007, 17990, TELIA" },
	{ L"20030216:121420", L"61448, 43739, COMVIQ" },
	{ L"20030216:121430", L"61448, 43739, COMVIQ" },
	{ L"20030216:121436", L"61448, 30523, COMVIQ" },
	{ L"20030216:121452", L"61448, 30522, COMVIQ" },
	{ L"20030216:121452", L"61448, 30522, COMVIQ" },
	{ L"20030216:121502", L"61448, 30522, COMVIQ" },
	{ L"20030216:121513", L"61448, 30522, COMVIQ" },
	{ L"20030216:121725", L"61460, 20864, COMVIQ" },
	{ L"20030216:121924", L"61460, 20864, COMVIQ" },
	{ L"20030216:121933", L"2027, 57250, TELIA" },
	{ L"20030216:122243", L"2027, 57250, TELIA" },
	{ L"20030216:122243", L"2027, 57250, TELIA" },
	{ L"20030216:122506", L"8012, 51792, TELIA" },
	{ L"20030216:122544", L"8012, 49750, TELIA" },
	{ L"20030216:122556", L"8012, 49751, TELIA" },
	{ L"20030216:122649", L"8012, 4239, TELIA" },
	{ L"20030216:122704", L"8012, 49751, TELIA" },
	{ L"20030216:122818", L"8012, 4239, TELIA" },
	{ L"20030216:122926", L"8012, 4239, TELIA" },
	{ L"20030216:122942", L"61460, 29274, COMVIQ" },
	{ L"20030216:122947", L"61460, 29275, COMVIQ" },
	{ L"20030216:123007", L"61460, 29275, COMVIQ" },
	{ L"20030216:123010", L"8012, 4239, TELIA" },
	{ L"20030216:123018", L"8012, 4240, TELIA" },
	{ L"20030216:123020", L"8012, 4240, TELIA" },
	{ L"20030216:123023", L"8012, 4240, TELIA" },
	{ L"20030216:123111", L"8012, 4240, TELIA" },
	{ L"20030216:123111", L"SWITCH" },
	{ L"20030216:125406", L"1, 12392, S Vodafone" },
	{ L"20030216:125426", L"1, 12391, S Vodafone" },
	{ L"20030216:125442", L"1, 12392, S Vodafone" },
	{ L"20030216:125525", L"1, 12391, S Vodafone" },
	{ L"20030216:125538", L"1, 12931, S Vodafone" },
	{ L"20030216:125619", L"1, 21481, S Vodafone" },
	{ L"20030216:125641", L"1, 8782, S Vodafone" },
	{ L"20030216:125705", L"1, 21481, S Vodafone" },
	{ L"20030216:125723", L"1, 12931, S Vodafone" },
	{ L"20030216:125811", L"1, 4632, S Vodafone" },
	{ L"20030216:125820", L"1, 7421, S Vodafone" },
	{ L"20030216:125853", L"1, 21481, S Vodafone" },
	{ L"20030216:125909", L"1, 21572, S Vodafone" },
	{ L"20030216:125926", L"1, 4632, S Vodafone" },
	{ L"20030216:125936", L"1, 21572, S Vodafone" },
	{ L"20030216:130016", L"1, 7422, S Vodafone" },
	{ L"20030216:130039", L"1, 21572, S Vodafone" },
	{ L"20030216:130214", L"1, 7422, S Vodafone" },
	{ L"20030216:130255", L"1, 21572, S Vodafone" },
	{ L"20030216:130328", L"1, 7422, S Vodafone" },
	{ L"20030216:130427", L"1, 21572, S Vodafone" },
	{ L"20030216:130524", L"1, 13631, S Vodafone" },
	{ L"20030216:140705", L"1, 8781, S Vodafone" },
	{ L"20030216:140732", L"1, 4632, S Vodafone" },
	{ L"20030216:140749", L"1, 8781, S Vodafone" },
	{ L"20030216:140912", L"1, 21481, S Vodafone" },
	{ L"20030216:140931", L"1, 4632, S Vodafone" },
	{ L"20030216:140947", L"1, 8781, S Vodafone" },
	{ L"20030216:141003", L"1, 21481, S Vodafone" },
	{ L"20030216:141059", L"1, 4632, S Vodafone" },
	{ L"20030216:141122", L"1, 8782, S Vodafone" },
	{ L"20030216:141133", L"1, 12931, S Vodafone" },
	{ L"20030216:141308", L"1, 8782, S Vodafone" },
	{ L"20030216:141324", L"1, 20622, S Vodafone" },
	{ L"20030216:141333", L"1, 21572, S Vodafone" },
	{ L"20030216:141403", L"1, 7422, S Vodafone" },
	{ L"20030216:141422", L"1, 21481, S Vodafone" },
	{ L"20030216:141438", L"1, 7421, S Vodafone" },
	{ L"20030216:141623", L"1, 7422, S Vodafone" },
	{ L"20030216:141709", L"1, 21572, S Vodafone" },
	{ L"20030216:141745", L"1, 7421, S Vodafone" },
	{ L"20030216:141753", L"1, 12971, S Vodafone" },
	{ L"20030216:141939", L"1, 13531, S Vodafone" },
	{ L"20030216:142144", L"1, 10203, S Vodafone" },
	{ L"20030216:142200", L"1, 10201, S Vodafone" },
	{ L"20030216:142256", L"1, 20713, S Vodafone" },
	{ L"20030216:142304", L"1, 10201, S Vodafone" },
	{ L"20030216:142406", L"1, 20713, S Vodafone" },
	{ L"20030216:142423", L"1, 10201, S Vodafone" },
	{ L"20030216:142437", L"1, 20713, S Vodafone" },
	{ L"20030216:142454", L"1, 10201, S Vodafone" },
	{ L"20030216:142529", L"1, 4632, S Vodafone" },
	{ L"20030216:142608", L"1, 20622, S Vodafone" },
	{ L"20030216:142636", L"1, 4632, S Vodafone" },
	{ L"20030216:142725", L"1, 20622, S Vodafone" },
	{ L"20030216:142748", L"1, 4632, S Vodafone" },
	{ L"20030216:143441", L"1, 20622, S Vodafone" },
	{ L"20030216:143515", L"1, 4632, S Vodafone" },
	{ L"20030216:143559", L"1, 20622, S Vodafone" },
	{ L"20030216:143620", L"1, 4632, S Vodafone" },
	{ L"20030216:143637", L"1, 20622, S Vodafone" },
	{ L"20030216:143654", L"1, 4632, S Vodafone" },
	{ L"20030216:143847", L"1, 20622, S Vodafone" },
	{ L"20030216:143906", L"1, 4632, S Vodafone" },
	{ L"20030216:143922", L"1, 20622, S Vodafone" },
	{ L"20030216:144056", L"1, 4632, S Vodafone" },
	{ L"20030216:144338", L"1, 20622, S Vodafone" },
	{ L"20030216:144611", L"1, 4632, S Vodafone" },
	{ L"20030216:144653", L"1, 20622, S Vodafone" },
	{ L"20030216:144809", L"1, 4632, S Vodafone" },
	{ L"20030216:145517", L"1, 20622, S Vodafone" },
	{ L"20030216:145546", L"1, 4632, S Vodafone" },
	{ L"20030216:145745", L"1, 20622, S Vodafone" },
	{ L"20030216:145802", L"1, 4632, S Vodafone" },
	{ L"20030216:145952", L"1, 20622, S Vodafone" },
	{ L"20030216:150017", L"1, 4632, S Vodafone" },
	{ L"20030216:150208", L"1, 20622, S Vodafone" },
	{ L"20030216:150223", L"1, 4632, S Vodafone" },
	{ L"20030216:150808", L"1, 20622, S Vodafone" },
	{ L"20030216:150926", L"1, 4632, S Vodafone" },
	{ L"20030216:151304", L"1, 20622, S Vodafone" },
	{ L"20030216:151416", L"1, 4632, S Vodafone" },
	{ L"20030216:151610", L"1, 20622, S Vodafone" },
	{ L"20030216:151720", L"1, 4632, S Vodafone" },
	{ L"20030216:151747", L"1, 20622, S Vodafone" },
	{ L"20030216:151804", L"1, 4632, S Vodafone" },
	{ L"20030216:151950", L"1, 20622, S Vodafone" },
	{ L"20030216:152024", L"1, 4632, S Vodafone" },
	{ L"20030216:152406", L"1, 20622, S Vodafone" },
	{ L"20030216:152442", L"1, 4632, S Vodafone" },
	{ L"20030216:152634", L"1, 20531, S Vodafone" },
	{ L"20030216:152649", L"1, 20713, S Vodafone" },
	{ L"20030216:152832", L"1, 20542, S Vodafone" },
	{ L"20030216:152844", L"1, 20622, S Vodafone" },
	{ L"20030216:152901", L"1, 4632, S Vodafone" },
	{ L"20030216:153025", L"1, 20622, S Vodafone" },
	{ L"20030216:153212", L"1, 4632, S Vodafone" },
	{ L"20030216:154232", L"1, 20622, S Vodafone" },
	{ L"20030216:154323", L"1, 4632, S Vodafone" },
	{ L"20030216:154339", L"1, 20622, S Vodafone" },
	{ L"20030216:154353", L"1, 4632, S Vodafone" },
	{ L"20030216:155018", L"1, 20622, S Vodafone" },
	{ L"20030216:155034", L"1, 4632, S Vodafone" },
	{ L"20030216:155051", L"1, 20622, S Vodafone" },
	{ L"20030216:155132", L"1, 4632, S Vodafone" },
	{ L"20030216:155225", L"1, 20622, S Vodafone" },
	{ L"20030216:155258", L"1, 4632, S Vodafone" },
	{ L"20030216:155457", L"1, 20622, S Vodafone" },
	{ L"20030216:155512", L"1, 4632, S Vodafone" },
	{ L"20030216:155531", L"1, 20622, S Vodafone" },
	{ L"20030216:155622", L"1, 4632, S Vodafone" },
	{ L"20030216:155645", L"1, 20622, S Vodafone" },
	{ L"20030216:155655", L"1, 4632, S Vodafone" },
	{ L"20030216:155831", L"1, 20622, S Vodafone" },
	{ L"20030216:155854", L"1, 4632, S Vodafone" },
	{ L"20030216:155911", L"1, 20622, S Vodafone" },
	{ L"20030216:155943", L"1, 4632, S Vodafone" },
	{ L"20030216:161356", L"1, 20622, S Vodafone" },
	{ L"20030216:161415", L"1, 4632, S Vodafone" },
	{ L"20030216:161832", L"1, 20622, S Vodafone" },
	{ L"20030216:161846", L"1, 4632, S Vodafone" },
	{ L"20030216:162013", L"1, 20622, S Vodafone" },
	{ L"20030216:162028", L"1, 4632, S Vodafone" },
	{ L"20030216:162327", L"1, 20622, S Vodafone" },
	{ L"20030216:162343", L"1, 4632, S Vodafone" },
	{ L"20030216:162505", L"1, 20622, S Vodafone" },
	{ L"20030216:162521", L"1, 4632, S Vodafone" },
	{ L"20030216:164202", L"1, 7392, S Vodafone" },
	{ L"20030216:164213", L"1, 22252, S Vodafone" },
	{ L"20030216:164236", L"1, 21711, S Vodafone" },
	{ L"20030216:164329", L"1, 10192, S Vodafone" },
	{ L"20030216:164345", L"1, 21711, S Vodafone" },
	{ L"20030216:164409", L"1, 10192, S Vodafone" },
	{ L"20030216:164433", L"1, 21711, S Vodafone" },
	{ L"20030216:164447", L"1, 20502, S Vodafone" },
	{ L"20030216:164503", L"1, 8771, S Vodafone" },
	{ L"20030216:164514", L"1, 20502, S Vodafone" },
	{ L"20030216:164555", L"1, 4633, S Vodafone" },
	{ L"20030216:164611", L"1, 20502, S Vodafone" },
	{ L"20030216:164630", L"1, 10192, S Vodafone" },
	{ L"20030216:164652", L"1, 8771, S Vodafone" },
	{ L"20030216:164709", L"1, 20502, S Vodafone" },
	{ L"20030216:164717", L"1, 8771, S Vodafone" },
	{ L"20030216:164811", L"1, 20502, S Vodafone" },
	{ L"20030216:164902", L"1, 21711, S Vodafone" },
	{ L"20030216:164941", L"1, 20502, S Vodafone" },
	{ L"20030216:164950", L"1, 20623, S Vodafone" },
	{ L"20030216:165008", L"1, 21711, S Vodafone" },
	{ L"20030216:165017", L"1, 8771, S Vodafone" },
	{ L"20030216:165029", L"1, 20502, S Vodafone" },
	{ L"20030216:165104", L"1, 10192, S Vodafone" },
	{ L"20030216:165116", L"1, 20502, S Vodafone" },
	{ L"20030216:165231", L"1, 10192, S Vodafone" },
	{ L"20030216:165254", L"1, 20502, S Vodafone" },
	{ L"20030216:165310", L"1, 10192, S Vodafone" },
	{ L"20030216:165327", L"1, 20502, S Vodafone" },
	{ L"20030216:165343", L"1, 8771, S Vodafone" },
	{ L"20030216:165403", L"1, 21711, S Vodafone" },
	{ L"20030216:165419", L"1, 20502, S Vodafone" },
	{ L"20030216:165435", L"1, 21711, S Vodafone" },
	{ L"20030216:165448", L"1, 20502, S Vodafone" },
	{ L"20030216:165552", L"1, 10192, S Vodafone" },
	{ L"20030216:165608", L"1, 5212, S Vodafone" },
	{ L"20030216:165622", L"1, 20502, S Vodafone" },
	{ L"20030216:170044", L"1, 21711, S Vodafone" },
	{ L"20030216:170114", L"1, 20502, S Vodafone" },
	{ L"20030216:170240", L"1, 21711, S Vodafone" },
	{ L"20030216:170304", L"1, 20502, S Vodafone" },
	{ L"20030216:170323", L"1, 21711, S Vodafone" },
	{ L"20030216:170339", L"1, 20502, S Vodafone" },
	{ L"20030216:170452", L"1, 10192, S Vodafone" },
	{ L"20030216:170508", L"1, 20502, S Vodafone" },
	{ L"20030216:170538", L"1, 8771, S Vodafone" },
	{ L"20030216:170555", L"1, 21711, S Vodafone" },
	{ L"20030216:170614", L"1, 20502, S Vodafone" },
	{ L"20030216:170634", L"1, 21711, S Vodafone" },
	{ L"20030216:170745", L"1, 20502, S Vodafone" },
	{ L"20030216:170824", L"1, 10192, S Vodafone" },
	{ L"20030216:170842", L"1, 20502, S Vodafone" },
	{ L"20030216:170924", L"1, 4633, S Vodafone" },
	{ L"20030216:170934", L"1, 20623, S Vodafone" },
	{ L"20030216:170950", L"1, 21711, S Vodafone" },
	{ L"20030216:171007", L"1, 20502, S Vodafone" },
	{ L"20030216:171032", L"1, 20503, S Vodafone" },
	{ L"20030216:171048", L"1, 20502, S Vodafone" },
	{ L"20030216:171147", L"1, 20503, S Vodafone" },
	{ L"20030216:171417", L"1, 12022, S Vodafone" },
	{ L"20030216:171508", L"1, 21301, S Vodafone" },
	{ L"20030216:171548", L"1, 12941, S Vodafone" },
	{ L"20030216:172102", L"1, 12391, S Vodafone" },
	{ L"20030216:172312", L"1, 12931, S Vodafone" },
	{ L"20030216:172424", L"1, 21481, S Vodafone" },
	{ L"20030216:172441", L"1, 21572, S Vodafone" },
	{ L"20030216:172451", L"1, 7421, S Vodafone" },
	{ L"20030216:172506", L"1, 12971, S Vodafone" },
	{ L"20030216:172600", L"1, 7421, S Vodafone" },
	{ L"20030216:172711", L"1, 8741, S Vodafone" },
	{ L"20030216:172725", L"1, 20462, S Vodafone" },
	{ L"20030216:172752", L"1, 21571, S Vodafone" },
	{ L"20030216:172808", L"1, 7421, S Vodafone" },
	{ L"20030216:172900", L"1, 8742, S Vodafone" },
	{ L"20030216:172917", L"1, 20462, S Vodafone" },
	{ L"20030216:172927", L"1, 8742, S Vodafone" },
	{ L"20030216:173016", L"1, 20462, S Vodafone" },
	{ L"20030216:173031", L"1, 8742, S Vodafone" },
	{ L"20030216:173204", L"1, 20462, S Vodafone" },
	{ L"20030216:173904", L"1, 8742, S Vodafone" },
	{ L"20030216:174001", L"1, 20462, S Vodafone" },
	{ L"20030216:174126", L"1, 8742, S Vodafone" },
	{ L"20030216:174210", L"1, 20462, S Vodafone" },
	{ L"20030216:174656", L"1, 8742, S Vodafone" },
	{ L"20030216:174715", L"1, 20462, S Vodafone" },
	{ L"20030216:174956", L"1, 8742, S Vodafone" },
	{ L"20030216:175032", L"1, 20462, S Vodafone" },
	{ L"20030216:180319", L"1, 20461, S Vodafone" },
	{ L"20030216:180335", L"1, 20462, S Vodafone" },
	{ L"20030216:180843", L"1, 8742, S Vodafone" },
	{ L"20030216:180853", L"1, 20462, S Vodafone" },
	{ L"20030216:181218", L"1, 20461, S Vodafone" },
	{ L"20030216:181235", L"1, 20462, S Vodafone" },
	{ L"20030216:183751", L"1, 8742, S Vodafone" },
	{ L"20030216:183832", L"1, 20462, S Vodafone" },
	{ L"20030216:184250", L"1, 8742, S Vodafone" },
	{ L"20030216:184301", L"1, 20462, S Vodafone" },
	{ L"20030216:184332", L"1, 8742, S Vodafone" },
	{ L"20030216:184349", L"1, 20462, S Vodafone" },
	{ L"20030216:185718", L"1, 8742, S Vodafone" },
	{ L"20030216:185741", L"1, 20462, S Vodafone" },
	{ L"20030216:190332", L"1, 8742, S Vodafone" },
	{ L"20030216:190442", L"1, 20462, S Vodafone" },
	{ L"20030216:190502", L"1, 8742, S Vodafone" },
	{ L"20030216:190518", L"1, 20462, S Vodafone" },
	{ L"20030216:190539", L"1, 8742, S Vodafone" },
	{ L"20030216:190613", L"1, 20462, S Vodafone" },
	{ L"20030216:190629", L"1, 8742, S Vodafone" },
	{ L"20030216:190646", L"1, 20462, S Vodafone" },
	{ L"20030216:190702", L"1, 8742, S Vodafone" },
	{ L"20030216:190718", L"1, 20462, S Vodafone" },
	{ L"20030216:191038", L"1, 8742, S Vodafone" },
	{ L"20030216:191116", L"1, 20462, S Vodafone" },
	{ L"20030216:194349", L"1, 8742, S Vodafone" },
	{ L"20030216:194359", L"1, 20462, S Vodafone" },
	{ L"20030216:194516", L"1, 8742, S Vodafone" },
	{ L"20030216:194657", L"1, 20462, S Vodafone" },
	{ L"20030216:194940", L"1, 8742, S Vodafone" },
	{ L"20030216:194956", L"1, 20462, S Vodafone" },
	{ L"20030216:195019", L"1, 20462, S Vodafone" },
	{ L"20030216:195037", L"1, 20462, S Vodafone" },
	{ L"20030216:195450", L"1, 8742, S Vodafone" },
	{ L"20030216:195520", L"1, 20462, S Vodafone" },
	{ L"20030216:195539", L"1, 8742, S Vodafone" },
	{ L"20030216:195549", L"1, 20462, S Vodafone" },
	{ L"20030216:200330", L"1, 8742, S Vodafone" },
	{ L"20030216:200348", L"1, 20462, S Vodafone" },
	{ L"20030216:200510", L"1, 8742, S Vodafone" },
	{ L"20030216:200533", L"1, 20462, S Vodafone" },
	{ L"20030216:200612", L"1, 21571, S Vodafone" },
	{ L"20030216:200625", L"1, 20461, S Vodafone" },
	{ L"20030216:200637", L"1, 20462, S Vodafone" },
	{ L"20030216:200647", L"1, 20461, S Vodafone" },
	{ L"20030216:200806", L"1, 8741, S Vodafone" },
	{ L"20030216:200822", L"1, 20461, S Vodafone" },
	{ L"20030216:201042", L"1, 21631, S Vodafone" },
	{ L"20030216:201052", L"1, 8401, S Vodafone" },
	{ L"20030216:201259", L"1, 21631, S Vodafone" },
	{ L"20030216:201316", L"1, 8401, S Vodafone" },
	{ L"20030216:201716", L"1, 21631, S Vodafone" },
	{ L"20030216:201727", L"1, 8661, S Vodafone" },
	{ L"20030216:201753", L"1, 8402, S Vodafone" },
	{ L"20030216:201802", L"1, 22502, S Vodafone" },
	{ L"20030216:201928", L"1, 18012, S Vodafone" },
	{ L"20030216:201952", L"1, 22502, S Vodafone" },
	{ L"20030216:202025", L"1, 22501, S Vodafone" },
	{ L"20030216:202034", L"1, 18011, S Vodafone" },
	{ L"20030216:202056", L"1, 22501, S Vodafone" },
	{ L"20030216:202442", L"1, 18011, S Vodafone" },
	{ L"20030216:202451", L"1, 22502, S Vodafone" },
	{ L"20030216:202502", L"1, 22501, S Vodafone" },
	{ L"20030216:202518", L"1, 18011, S Vodafone" },
	{ L"20030216:202534", L"1, 8402, S Vodafone" },
	{ L"20030216:202550", L"1, 22501, S Vodafone" },
	{ L"20030216:202630", L"1, 20561, S Vodafone" },
	{ L"20030216:202646", L"1, 3333, S Vodafone" },
	{ L"20030216:202721", L"1, 472, S Vodafone" },
	{ L"20030216:202740", L"1, 3333, S Vodafone" },
	{ L"20030216:202757", L"1, 8661, S Vodafone" },
	{ L"20030216:202812", L"1, 20561, S Vodafone" },
	{ L"20030216:202841", L"1, 3333, S Vodafone" },
	{ L"20030216:202902", L"1, 8661, S Vodafone" },
	{ L"20030216:202911", L"1, 20561, S Vodafone" },
	{ L"20030216:202940", L"1, 3333, S Vodafone" },
	{ L"20030216:203046", L"1, 12031, S Vodafone" },
	{ L"20030216:203118", L"1, 21701, S Vodafone" },
	{ L"20030216:203201", L"1, 3333, S Vodafone" },
	{ L"20030216:203219", L"1, 472, S Vodafone" },
	{ L"20030216:203332", L"1, 3333, S Vodafone" },
	{ L"20030216:203443", L"1, 8661, S Vodafone" },
	{ L"20030216:203617", L"1, 12031, S Vodafone" },
	{ L"20030216:203803", L"1, 3333, S Vodafone" },
	{ L"20030216:203925", L"1, 12031, S Vodafone" },
	{ L"20030216:203943", L"1, 3333, S Vodafone" },
	{ L"20030216:204142", L"1, 8661, S Vodafone" },
	{ L"20030216:204156", L"1, 8661, S Vodafone" },
	{ L"20030216:204207", L"1512, 10111, TELIA" },
	{ L"20030216:204533", L"1512, 4639, TELIA" },
	{ L"20030216:204646", L"1512, 10111, TELIA" },
	{ L"20030216:204721", L"1512, 4639, TELIA" },
	{ L"20030216:204743", L"1512, 10111, TELIA" },
	{ L"20030216:204757", L"1512, 4639, TELIA" },
	{ L"20030216:204908", L"1512, 10111, TELIA" },
	{ L"20030216:204930", L"1512, 4639, TELIA" },
	{ L"20030216:204947", L"1512, 10111, TELIA" },
	{ L"20030216:205257", L"1512, 4639, TELIA" },
	{ L"20030216:205307", L"1512, 10111, TELIA" },
	{ L"20030216:205414", L"1512, 4639, TELIA" },
	{ L"20030216:205423", L"1512, 10111, TELIA" },
	{ L"20030216:211759", L"1512, 4639, TELIA" },
	{ L"20030216:211808", L"1512, 10111, TELIA" },
	{ L"20030216:211941", L"1512, 4639, TELIA" },
	{ L"20030216:211950", L"1512, 10111, TELIA" },
	{ L"20030216:212215", L"1512, 4639, TELIA" },
	{ L"20030216:212232", L"1512, 10111, TELIA" },
	{ L"20030216:212325", L"1512, 4639, TELIA" },
	{ L"20030216:212345", L"1512, 10111, TELIA" },
	{ L"20030216:212547", L"1512, 4639, TELIA" },
	{ L"20030216:212604", L"1512, 10111, TELIA" },
	{ L"20030216:212620", L"1512, 4639, TELIA" },
	{ L"20030216:212712", L"1512, 10111, TELIA" },
	{ L"20030216:212739", L"1512, 4639, TELIA" },
	{ L"20030216:212749", L"1512, 10111, TELIA" },
	{ L"20030216:213129", L"1512, 4639, TELIA" },
	{ L"20030216:213241", L"1512, 10111, TELIA" },
	{ L"20030216:214034", L"1512, 4639, TELIA" },
	{ L"20030216:214056", L"1512, 10111, TELIA" },
	{ L"20030216:214513", L"1512, 4639, TELIA" },
	{ L"20030216:214643", L"1512, 10111, TELIA" },
	{ L"20030216:214851", L"1512, 4639, TELIA" },
	{ L"20030216:214909", L"1512, 10111, TELIA" },
	{ L"20030216:215757", L"1512, 4639, TELIA" },
	{ L"20030216:215814", L"1512, 10111, TELIA" },
	{ L"20030216:220510", L"1512, 4639, TELIA" },
	{ L"20030216:220532", L"1512, 10111, TELIA" },
	{ L"20030216:220618", L"1512, 4639, TELIA" },
	{ L"20030216:220634", L"1512, 10111, TELIA" },
	{ L"20030216:220719", L"1512, 4639, TELIA" },
	{ L"20030216:220729", L"1512, 10111, TELIA" },
	{ L"20030216:221258", L"1512, 4639, TELIA" },
	{ L"20030216:221315", L"1512, 10111, TELIA" },
	{ L"20030216:221530", L"1512, 4639, TELIA" },
	{ L"20030216:221601", L"1512, 10111, TELIA" },
	{ L"20030216:222546", L"1512, 4639, TELIA" },
	{ L"20030216:222555", L"1512, 10111, TELIA" },
	{ L"20030216:222814", L"1512, 4639, TELIA" },
	{ L"20030216:222830", L"1512, 10111, TELIA" },
	{ L"20030216:223252", L"1512, 4639, TELIA" },
	{ L"20030216:223324", L"1512, 10111, TELIA" },
	{ L"20030216:223444", L"1512, 4639, TELIA" },
	{ L"20030216:223501", L"1512, 10080, TELIA" },
	{ L"20030216:223512", L"1512, 10302, TELIA" },
	{ L"20030216:223633", L"1512, 10081, TELIA" },
	{ L"20030216:223644", L"1512, 4605, TELIA" },
	{ L"20030216:223739", L"1512, 10081, TELIA" },
	{ L"20030216:223755", L"1512, 10302, TELIA" },
	{ L"20030216:223806", L"1512, 10081, TELIA" },
	{ L"20030216:223830", L"1512, 10302, TELIA" },
	{ L"20030216:223858", L"1512, 10300, TELIA" },
	{ L"20030216:223941", L"1512, 10302, TELIA" },
	{ L"20030216:223952", L"1512, 10300, TELIA" },
	{ L"20030216:224226", L"1512, 10302, TELIA" },
	{ L"20030216:224307", L"1512, 10301, TELIA" },
	{ L"20030216:224351", L"1512, 10130, TELIA" },
	{ L"20030216:224550", L"1512, 10070, TELIA" },
	{ L"20030216:224620", L"1512, 10130, TELIA" },
	{ L"20030216:224630", L"1512, 10070, TELIA" },
	{ L"20030216:224748", L"1512, 50410, TELIA" },
	{ L"20030216:225308", L"1512, 50190, TELIA" },
	{ L"20030216:225324", L"1512, 50410, TELIA" },
	{ L"20030216:225338", L"1512, 50190, TELIA" },
	{ L"20030216:225407", L"1512, 49770, TELIA" },
	{ L"20030216:225417", L"1512, 10170, TELIA" },
	{ L"20030216:225504", L"1512, 10482, TELIA" },
	{ L"20030216:225515", L"1512, 51050, TELIA" },
	{ L"20030216:225551", L"1512, 50000, TELIA" },
	{ L"20030216:225635", L"1512, 50001, TELIA" },
	{ L"20030216:225721", L"2512, 11760, TELIA" },
	{ L"20030216:225922", L"2512, 43700, TELIA" },
	{ L"20030216:230000", L"2512, 11760, TELIA" },
	{ L"20030216:230136", L"2512, 45670, TELIA" },
	{ L"20030216:230154", L"2512, 11760, TELIA" },
	{ L"20030216:230222", L"2512, 43700, TELIA" },
	{ L"20030216:230248", L"2512, 43701, TELIA" },
	{ L"20030216:230455", L"2512, 11760, TELIA" },
	{ L"20030216:230517", L"2512, 43700, TELIA" },
	{ L"20030216:230527", L"2512, 11760, TELIA" },
	{ L"20030216:230604", L"2512, 43700, TELIA" },
	{ L"20030216:230621", L"2512, 11760, TELIA" },
	{ L"20030216:230719", L"2512, 43700, TELIA" },
	{ L"20030216:230744", L"2512, 11760, TELIA" },
	{ L"20030216:230902", L"2512, 43700, TELIA" },
	{ L"20030216:230922", L"2512, 11760, TELIA" },
	{ L"20030216:231005", L"2512, 43700, TELIA" },
	{ L"20030216:231319", L"2512, 11760, TELIA" },
	{ L"20030216:231335", L"2512, 43700, TELIA" },
	{ L"20030216:231352", L"2512, 11760, TELIA" },
	{ L"20030216:231407", L"2512, 43700, TELIA" },
	{ L"20030216:231416", L"2512, 11760, TELIA" },
	{ L"20030216:231504", L"2512, 43700, TELIA" },
	{ L"20030216:231521", L"2512, 11760, TELIA" },
	{ L"20030216:231741", L"2512, 43700, TELIA" },
	{ L"20030216:231756", L"2512, 11760, TELIA" },
	{ L"20030216:231806", L"2512, 43700, TELIA" },
	{ L"20030216:231841", L"2512, 11760, TELIA" },
	{ L"20030216:231858", L"2512, 45670, TELIA" },
	{ L"20030216:231916", L"2512, 43700, TELIA" },
	{ L"20030216:231948", L"2512, 45670, TELIA" },
	{ L"20030216:232049", L"2512, 43700, TELIA" },
	{ L"20030216:232113", L"2512, 45670, TELIA" },
	{ L"20030216:232130", L"2512, 11760, TELIA" },
	{ L"20030216:232159", L"2512, 43700, TELIA" },
	{ L"20030216:232208", L"2512, 43701, TELIA" },
	{ L"20030216:232328", L"2512, 11681, TELIA" },
	{ L"20030216:232400", L"2512, 45221, TELIA" },
	{ L"20030216:232455", L"2512, 11536, TELIA" },
	{ L"20030216:232506", L"2512, 45221, TELIA" },
	{ L"20030216:233911", L"2512, 11512, TELIA" },
	{ L"20030216:233957", L"2512, 10830, TELIA" },
	{ L"20030216:234015", L"2512, 11682, TELIA" },
	{ L"20030216:234027", L"2512, 10500, TELIA" },
	{ L"20030216:234047", L"2512, 11081, TELIA" },
	{ L"20030216:234058", L"2512, 11191, TELIA" },
	{ L"20030216:234108", L"2512, 11071, TELIA" },
	{ L"20030216:234117", L"2512, 4801, TELIA" },
	{ L"20030216:234129", L"2512, 11092, TELIA" },
	{ L"20030216:234143", L"1512, 10690, TELIA" },
	{ L"20030216:234158", L"9012, 50753, TELIA" },
	{ L"20030216:234215", L"9012, 13081, TELIA" },
	{ L"20030216:234233", L"9012, 13080, TELIA" },
	{ L"20030216:234254", L"9012, 13011, TELIA" },
	{ L"20030216:234305", L"9012, 13080, TELIA" },
	{ L"20030216:234330", L"9012, 47982, TELIA" },
	{ L"20030216:234341", L"9012, 47981, TELIA" },
	{ L"20030216:234352", L"9012, 13192, TELIA" },
	{ L"20030216:234406", L"9012, 13190, TELIA" },
	{ L"20030216:234436", L"9012, 13313, TELIA" },
	{ L"20030216:234445", L"3512, 16530, TELIA" },
	{ L"20030216:234524", L"3512, 50931, TELIA" },
	{ L"20030216:234533", L"3512, 50933, TELIA" },
	{ L"20030216:234550", L"3512, 16703, TELIA" },
	{ L"20030216:234600", L"3512, 50680, TELIA" },
	{ L"20030216:234608", L"3512, 15300, TELIA" },
	{ L"20030216:234623", L"3512, 15311, TELIA" },
	{ L"20030216:234652", L"3512, 15312, TELIA" },
	{ L"20030216:234703", L"3512, 15271, TELIA" },
	{ L"20030216:234714", L"3512, 49900, TELIA" },
	{ L"20030216:234732", L"3512, 15360, TELIA" },
	{ L"20030216:234748", L"3512, 49900, TELIA" },
	{ L"20030216:234800", L"3512, 15251, TELIA" },
	{ L"20030216:234824", L"3512, 48730, TELIA" },
	{ L"20030216:234837", L"8012, 49702, TELIA" },
	{ L"20030216:234855", L"8012, 49700, TELIA" },
	{ L"20030216:234925", L"8012, 4251, TELIA" },
	{ L"20030216:234942", L"8012, 49700, TELIA" },
	{ L"20030216:234953", L"8012, 4251, TELIA" },
	{ L"20030216:235009", L"8012, 50590, TELIA" },
	{ L"20030216:235038", L"8012, 49721, TELIA" },
	{ L"20030216:235051", L"8012, 49722, TELIA" },
	{ L"20030216:235115", L"8012, 49720, TELIA" },
	{ L"20030216:235125", L"8012, 14961, TELIA" },
	{ L"20030216:235206", L"8012, 4488, TELIA" },
	{ L"20030216:235231", L"8012, 14960, TELIA" },
	{ L"20030216:235250", L"8012, 14950, TELIA" },
	{ L"20030216:235316", L"8012, 4488, TELIA" },
	{ L"20030216:235333", L"8012, 50072, TELIA" },
	{ L"20030216:235400", L"8012, 50073, TELIA" },
	{ L"20030216:235437", L"8012, 4240, TELIA" },
	{ L"20030216:235537", L"8012, 4239, TELIA" },
	{ L"20030216:235554", L"8012, 51260, TELIA" },
	{ L"20030216:235612", L"8012, 4239, TELIA" },
	{ L"20030216:235623", L"8012, 49751, TELIA" },
	{ L"20030216:235705", L"8012, 4239, TELIA" },
	{ L"20030216:235819", L"8012, 49751, TELIA" },
	{ L"20030217:000016", L"8012, 49750, TELIA" },
	{ L"20030217:000035", L"8012, 51792, TELIA" },
	{ L"20030217:000124", L"8012, 51793, TELIA" },
	{ L"20030217:000319", L"2027, 17111, TELIA" },
	{ L"20030217:000335", L"2027, 57250, TELIA" },
	{ L"20030217:000351", L"2027, 17111, TELIA" },
	{ L"20030217:000400", L"2027, 57250, TELIA" },
	{ L"20030217:000742", L"2027, 47510, TELIA" },
	{ L"20030217:000820", L"2027, 17112, TELIA" },
	{ L"20030217:000920", L"2027, 47510, TELIA" },
	{ L"20030217:000936", L"2027, 17112, TELIA" },
	{ L"20030217:001020", L"2027, 17112, TELIA" },
	{ L"20030217:001025", L"61448, 30522, COMVIQ" },
	{ L"20030217:001059", L"61448, 30523, COMVIQ" },
	{ L"20030217:001131", L"61448, 34026, COMVIQ" },
	{ L"20030217:001218", L"61448, 63882, COMVIQ" },
	{ L"20030217:001227", L"61448, 63883, COMVIQ" },
	{ L"20030217:001328", L"61448, 37098, COMVIQ" },
	{ L"20030217:001337", L"61448, 37099, COMVIQ" },
	{ L"20030217:001349", L"61448, 37100, COMVIQ" },
	{ L"20030217:001415", L"61448, 54058, COMVIQ" },
	{ L"20030217:001431", L"61448, 54059, COMVIQ" },
	{ L"20030217:001510", L"61448, 54060, COMVIQ" },
	{ L"20030217:001658", L"61448, 63866, COMVIQ" },
	{ L"20030217:001814", L"61448, 54060, COMVIQ" },
	{ L"20030217:001822", L"61448, 63866, COMVIQ" },
	{ L"20030217:001840", L"61448, 54060, COMVIQ" },
	{ L"20030217:001915", L"61448, 63868, COMVIQ" },
	{ L"20030217:002122", L"61448, 24730, COMVIQ" },
	{ L"20030217:002916", L"61448, 24732, COMVIQ" },
	{ L"20030217:002954", L"61448, 63802, COMVIQ" },
	{ L"20030217:003054", L"61448, 24732, COMVIQ" },
	{ L"20030217:003102", L"61448, 63802, COMVIQ" },
	{ L"20030217:003135", L"61448, 24732, COMVIQ" },
	{ L"20030217:003334", L"61448, 63756, COMVIQ" },
	{ L"20030217:003821", L"61448, 24732, COMVIQ" },
	{ L"20030217:003948", L"61448, 63756, COMVIQ" },
	{ L"20030217:100448", L"61448, 24732, COMVIQ" },
	{ L"20030217:100456", L"61448, 63756, COMVIQ" },
	{ L"20030217:100826", L"61448, 24732, COMVIQ" },
	{ L"20030217:100834", L"61448, 63756, COMVIQ" },
	{ L"20030217:100904", L"61448, 41564, COMVIQ" },
	{ L"20030217:100918", L"61448, 63756, COMVIQ" },
	{ L"20030217:101129", L"61448, 24732, COMVIQ" },
	{ L"20030217:101139", L"61448, 63756, COMVIQ" },
	{ L"20030217:101751", L"61448, 24732, COMVIQ" },
	{ L"20030217:101759", L"61448, 63756, COMVIQ" },
	{ L"20030217:102503", L"61448, 63627, COMVIQ" },
	{ L"20030217:102528", L"61448, 63756, COMVIQ" },
	{ L"20030217:102544", L"61448, 63627, COMVIQ" },
	{ L"20030217:102557", L"61448, 63756, COMVIQ" },
	{ L"20030217:102711", L"61448, 24732, COMVIQ" },
	{ L"20030217:102719", L"61448, 63756, COMVIQ" },
	{ L"20030217:102753", L"61448, 63627, COMVIQ" },
	{ L"20030217:102851", L"61448, 63756, COMVIQ" },
	{ L"20030217:102908", L"61448, 63627, COMVIQ" },
	{ L"20030217:102938", L"61448, 63756, COMVIQ" },
	{ L"20030217:103108", L"61448, 24732, COMVIQ" },
	{ L"20030217:103418", L"61448, 63802, COMVIQ" },
	{ L"20030217:103454", L"61448, 24732, COMVIQ" },
	{ L"20030217:103515", L"61448, 24730, COMVIQ" },
	{ L"20030217:103817", L"61448, 54060, COMVIQ" },
	{ L"20030217:103827", L"61448, 24730, COMVIQ" },
	{ L"20030217:103906", L"61448, 54060, COMVIQ" },
	{ L"20030217:104715", L"61448, 63866, COMVIQ" },
	{ L"20030217:104836", L"61448, 54060, COMVIQ" },
	{ L"20030217:104915", L"61448, 63868, COMVIQ" },
	{ L"20030217:110153", L"61448, 24730, COMVIQ" },
	{ L"20030217:110215", L"61448, 63868, COMVIQ" },
	{ L"20030217:110232", L"61448, 24730, COMVIQ" },
	{ L"20030217:110323", L"61448, 63868, COMVIQ" },
	{ L"20030217:110357", L"61448, 24730, COMVIQ" },
	{ L"20030217:110414", L"61448, 63868, COMVIQ" },
	{ L"20030217:110604", L"61448, 24730, COMVIQ" },
	{ L"20030217:110622", L"61448, 63868, COMVIQ" },
	{ L"20030217:110638", L"61448, 24730, COMVIQ" },
	{ L"20030217:110647", L"61448, 63868, COMVIQ" },
	{ L"20030217:110823", L"61448, 24730, COMVIQ" },
	{ L"20030217:110832", L"61448, 63868, COMVIQ" },
	{ L"20030217:113425", L"61448, 54060, COMVIQ" },
	{ L"20030217:113452", L"61448, 63868, COMVIQ" },
	{ L"20030217:113501", L"61448, 24730, COMVIQ" },
	{ L"20030217:113533", L"61448, 54060, COMVIQ" },
	{ L"20030217:113645", L"61448, 63866, COMVIQ" },
	{ L"20030217:113747", L"61448, 54060, COMVIQ" },
	{ L"20030217:114029", L"61448, 54059, COMVIQ" },
	{ L"20030217:114029", L"61448, 54059, COMVIQ" },
	{ L"20030217:114052", L"61448, 54058, COMVIQ" },
	{ L"20030217:114104", L"61448, 37100, COMVIQ" },
	{ L"20030217:114130", L"61448, 37099, COMVIQ" },
	{ L"20030217:114145", L"61448, 37098, COMVIQ" },
	{ L"20030217:114154", L"61448, 63883, COMVIQ" },
	{ L"20030217:114257", L"61448, 34026, COMVIQ" },
	{ L"20030217:114355", L"61448, 30523, COMVIQ" },
	{ L"20030217:114427", L"61448, 30522, COMVIQ" },
	{ L"20030217:114537", L"61460, 33996, COMVIQ" },
	{ L"20030217:114705", L"61460, 20864, COMVIQ" },
	{ L"20030217:115138", L"61460, 30528, COMVIQ" },
	{ L"20030217:115421", L"61460, 64506, COMVIQ" },
	{ L"20030217:115744", L"61460, 20507, COMVIQ" },
	{ L"20030217:115851", L"61460, 17451, COMVIQ" },
	{ L"20030217:120003", L"61460, 20653, COMVIQ" },
	{ L"20030217:120823", L"61460, 20508, COMVIQ" },
	{ L"20030217:120904", L"61460, 20653, COMVIQ" },
	{ L"20030217:121233", L"61460, 17451, COMVIQ" },
	{ L"20030217:122355", L"61460, 20506, COMVIQ" },
	{ L"20030217:122415", L"61460, 20507, COMVIQ" },
	{ L"20030217:122424", L"61460, 17451, COMVIQ" },
	{ L"20030217:122459", L"61460, 20506, COMVIQ" },
	{ L"20030217:122540", L"61460, 17451, COMVIQ" },
	{ L"20030217:125819", L"61460, 20653, COMVIQ" },
	{ L"20030217:130303", L"61460, 20508, COMVIQ" },
	{ L"20030217:130303", L"SWITCH" },
	{ L"20030217:144414", L"9113, 148, RADIOLINJA" },
	{ L"20030217:144820", L"9113, 62094, RADIOLINJA" },
	{ L"20030217:145336", L"9113, 14, RADIOLINJA" },
	{ L"20030217:145402", L"9113, 62094, RADIOLINJA" },
	{ L"20030217:145427", L"9113, 15332, RADIOLINJA" },
	{ L"20030217:145503", L"9113, 444, RADIOLINJA" },
	{ L"20030217:145642", L"9113, 15332, RADIOLINJA" },
	{ L"20030217:145750", L"9113, 444, RADIOLINJA" },
	{ L"20030217:145830", L"9113, 15332, RADIOLINJA" },
	{ L"20030217:145907", L"9113, 444, RADIOLINJA" },
	{ L"20030217:145916", L"9113, 347, RADIOLINJA" },
	{ L"20030217:150210", L"9113, 3802, RADIOLINJA" },
	{ L"20030217:150237", L"9113, 40122, RADIOLINJA" },
	{ L"20030217:150252", L"9113, 3802, RADIOLINJA" },
	{ L"20030217:150303", L"9113, 3533, RADIOLINJA" },
	{ L"20030217:150513", L"9113, 208, RADIOLINJA" },
	{ L"20030217:150545", L"9113, 3533, RADIOLINJA" },
	{ L"20030217:150602", L"9113, 40625, RADIOLINJA" },
	{ L"20030217:150611", L"9113, 208, RADIOLINJA" },
	{ L"20030217:150627", L"9113, 62524, RADIOLINJA" },
	{ L"20030217:150643", L"9113, 208, RADIOLINJA" },
	{ L"20030217:150653", L"9113, 41712, RADIOLINJA" },
	{ L"20030217:150707", L"9113, 208, RADIOLINJA" },
	{ L"20030217:150717", L"9113, 127, RADIOLINJA" },
	{ L"20030217:150728", L"9113, 134, RADIOLINJA" },
	{ L"20030217:150824", L"9113, 40743, RADIOLINJA" },
	{ L"20030217:150841", L"9113, 62523, RADIOLINJA" },
	{ L"20030217:150852", L"9005, 36027, RADIOLINJA" },
	{ L"20030217:150908", L"9005, 36028, RADIOLINJA" },
	{ L"20030217:150947", L"9005, 36031, RADIOLINJA" },
	{ L"20030217:151032", L"9005, 62080, RADIOLINJA" },
	{ L"20030217:151108", L"9005, 33, RADIOLINJA" },
	{ L"20030217:151118", L"9005, 78, RADIOLINJA" },
	{ L"20030217:151232", L"9005, 37228, RADIOLINJA" },
	{ L"20030217:151241", L"9005, 4517, RADIOLINJA" },
	{ L"20030217:151302", L"9005, 4518, RADIOLINJA" },
	{ L"20030217:151333", L"9006, 15330, RADIOLINJA" },
	{ L"20030217:151413", L"9006, 42111, RADIOLINJA" },
	{ L"20030217:151449", L"9006, 393, RADIOLINJA" },
	{ L"20030217:151516", L"9006, 15175, RADIOLINJA" },
	{ L"20030217:151537", L"9006, 600, RADIOLINJA" },
	{ L"20030217:151656", L"9006, 601, RADIOLINJA" },
	{ L"20030217:151756", L"9006, 1493, RADIOLINJA" },
	{ L"20030217:151816", L"9006, 550, RADIOLINJA" },
	{ L"20030217:152023", L"9006, 38583, RADIOLINJA" },
	{ L"20030217:172156", L"9006, 232, RADIOLINJA" },
	{ L"20030217:172156", L"9006, 15300, RADIOLINJA" },
	{ L"20030217:172156", L"9006, 35265, RADIOLINJA" },
	{ L"20030217:172156", L"9006, 15300, RADIOLINJA" },
	{ L"20030217:172156", L"9006, 35265, RADIOLINJA" },
	{ L"20030217:172156", L"9006, 15300, RADIOLINJA" },
	{ L"20030217:172227", L"9006, 62067, RADIOLINJA" },
	{ L"20030217:172237", L"9006, 15300, RADIOLINJA" },
	{ L"20030217:172253", L"9006, 62067, RADIOLINJA" },
	{ L"20030217:172309", L"9006, 15300, RADIOLINJA" },
	{ L"20030217:172339", L"9006, 62067, RADIOLINJA" },
	{ L"20030217:172348", L"9006, 15300, RADIOLINJA" },
	{ L"20030217:172541", L"9006, 508, RADIOLINJA" },
	{ L"20030217:172552", L"9006, 38583, RADIOLINJA" },
	{ L"20030217:172635", L"9006, 376, RADIOLINJA" },
	{ L"20030217:172933", L"9006, 18, RADIOLINJA" },
	{ L"20030217:173147", L"9006, 399, RADIOLINJA" },
	{ L"20030217:173223", L"9006, 376, RADIOLINJA" },
	{ L"20030217:173321", L"9006, 399, RADIOLINJA" },
	{ L"20030217:173336", L"9006, 376, RADIOLINJA" },
	{ L"20030217:173350", L"9006, 399, RADIOLINJA" },
	{ L"20030217:173359", L"9006, 376, RADIOLINJA" },
	{ L"20030217:173408", L"9006, 399, RADIOLINJA" },
	{ L"20030217:173836", L"9006, 1493, RADIOLINJA" },
	{ L"20030217:174054", L"9006, 601, RADIOLINJA" },
	{ L"20030217:174131", L"9006, 1493, RADIOLINJA" },
	{ L"20030217:174153", L"9006, 601, RADIOLINJA" },
	{ L"20030217:174239", L"9006, 1493, RADIOLINJA" },
	{ L"20030217:174305", L"9006, 601, RADIOLINJA" },
	{ L"20030217:174315", L"9006, 550, RADIOLINJA" },
	{ L"20030217:174601", L"9006, 38583, RADIOLINJA" },
	{ L"20030217:174625", L"9006, 232, RADIOLINJA" },
	{ L"20030217:174816", L"9006, 233, RADIOLINJA" },
	{ L"20030217:174914", L"9006, 232, RADIOLINJA" },
	{ L"20030217:174950", L"9006, 233, RADIOLINJA" },
	{ L"20030217:175009", L"9006, 232, RADIOLINJA" },
	{ L"20030217:175039", L"9006, 233, RADIOLINJA" },
	{ L"20030217:175107", L"9006, 62143, RADIOLINJA" },
	{ L"20030217:175124", L"9006, 233, RADIOLINJA" },
	{ L"20030217:175140", L"9006, 15300, RADIOLINJA" },
	{ L"20030217:175331", L"9006, 37204, RADIOLINJA" },
	{ L"20030217:175331", L"SWITCH" },
	{ L"20030217:185451", L"9006, 37204, RADIOLINJA" },
	{ L"20030217:185511", L"9006, 41723, RADIOLINJA" },
	{ L"20030217:185620", L"9006, 377, RADIOLINJA" },
	{ L"20030217:185752", L"9006, 62054, RADIOLINJA" },
	{ L"20030217:185804", L"9006, 354, RADIOLINJA" },
	{ L"20030217:185908", L"9006, 196, RADIOLINJA" },
	{ L"20030217:185926", L"9006, 41823, RADIOLINJA" },
	{ L"20030217:190044", L"9006, 176, RADIOLINJA" },
	{ L"20030217:190228", L"9006, 177, RADIOLINJA" },
	{ L"20030217:190338", L"9000, 62124, RADIOLINJA" },
	{ L"20030217:190345", L"9006, 62075, RADIOLINJA" },
	{ L"20030217:190402", L"9000, 41097, RADIOLINJA" },
	{ L"20030217:190429", L"9006, 390, RADIOLINJA" },
	{ L"20030217:190447", L"9000, 62124, RADIOLINJA" },
	{ L"20030217:193643", L"9000, 15227, RADIOLINJA" },
	{ L"20030217:193643", L"9000, 62125, RADIOLINJA" },
	{ L"20030217:193643", L"9000, 62124, RADIOLINJA" },
	{ L"20030217:193643", L"9000, 62125, RADIOLINJA" },
	{ L"20030217:193643", L"9000, 62124, RADIOLINJA" },
	{ L"20030217:193643", L"9000, 62125, RADIOLINJA" },
	{ L"20030217:193646", L"9000, 62124, RADIOLINJA" },
	{ L"20030217:193729", L"9000, 62125, RADIOLINJA" },
	{ L"20030217:193839", L"9000, 62124, RADIOLINJA" },
	{ L"20030217:193916", L"9000, 62125, RADIOLINJA" },
	{ L"20030217:193932", L"9000, 62124, RADIOLINJA" },
	{ L"20030217:194459", L"9000, 62125, RADIOLINJA" },
	{ L"20030217:194817", L"9000, 62124, RADIOLINJA" },
	{ L"20030217:194952", L"9000, 62125, RADIOLINJA" },
	{ L"20030217:195142", L"9000, 62124, RADIOLINJA" },
	{ L"20030217:195229", L"9000, 62125, RADIOLINJA" },
	{ L"20030217:195508", L"9000, 62124, RADIOLINJA" },
	{ L"20030217:195519", L"9000, 62125, RADIOLINJA" },
	{ L"20030217:195727", L"9000, 15227, RADIOLINJA" },
	{ L"20030217:195727", L"9000, 62125, RADIOLINJA" },
	{ L"20030217:195743", L"9000, 62124, RADIOLINJA" },
	{ L"20030217:200134", L"9000, 62125, RADIOLINJA" },
	{ L"20030217:200208", L"9000, 62101, RADIOLINJA" },
	{ L"20030217:200236", L"9000, 27, RADIOLINJA" },
	{ L"20030217:200359", L"9000, 26, RADIOLINJA" },
	{ L"20030217:200435", L"9000, 27, RADIOLINJA" },
	{ L"20030217:200728", L"9000, 622, RADIOLINJA" },
	{ L"20030217:200738", L"9000, 1969, RADIOLINJA" },
	{ L"20030217:200755", L"9000, 622, RADIOLINJA" },
	{ L"20030217:200955", L"9000, 62035, RADIOLINJA" },
	{ L"20030217:201004", L"9000, 62034, RADIOLINJA" },
	{ L"20030217:201019", L"9000, 622, RADIOLINJA" },
	{ L"20030217:201055", L"9000, 62035, RADIOLINJA" },
	{ L"20030217:201104", L"9000, 37227, RADIOLINJA" },
	{ L"20030217:201651", L"9000, 37227, RADIOLINJA" },
	{ L"20030217:201758", L"9000, 622, RADIOLINJA" },
	{ L"20030217:201808", L"9000, 62035, RADIOLINJA" },
	{ L"20030217:201930", L"9000, 396, RADIOLINJA" },
	{ L"20030217:201940", L"9000, 62034, RADIOLINJA" },
	{ L"20030217:201953", L"9000, 396, RADIOLINJA" },
	{ L"20030217:202710", L"9000, 15276, RADIOLINJA" },
	{ L"20030217:202838", L"9000, 215, RADIOLINJA" },
	{ L"20030217:202935", L"9000, 62993, RADIOLINJA" },
	{ L"20030217:203043", L"9000, 35302, RADIOLINJA" },
	{ L"20030217:203107", L"9000, 167, RADIOLINJA" },
	{ L"20030217:203117", L"9000, 495, RADIOLINJA" },
	{ L"20030217:203128", L"9000, 39713, RADIOLINJA" },
	{ L"20030217:203204", L"9000, 495, RADIOLINJA" },
	{ L"20030217:203427", L"9000, 503, RADIOLINJA" },
	{ L"20030217:203455", L"9000, 62110, RADIOLINJA" },
	{ L"20030217:203507", L"9000, 147, RADIOLINJA" },
	{ L"20030217:203527", L"9000, 62110, RADIOLINJA" },
	{ L"20030217:203626", L"9000, 62112, RADIOLINJA" },
	{ L"20030217:203641", L"9000, 62116, RADIOLINJA" },
	{ L"20030217:203656", L"9000, 62112, RADIOLINJA" },
	{ L"20030217:203732", L"9000, 9814, RADIOLINJA" },
	{ L"20030217:203757", L"9000, 179, RADIOLINJA" },
	{ L"20030217:210644", L"9000, 179, RADIOLINJA" },
	{ L"20030217:210905", L"9000, 179, RADIOLINJA" },
	{ L"20030218:071152", L"9000, 62111, RADIOLINJA" },
	{ L"20030218:071215", L"9000, 179, RADIOLINJA" },
	{ L"20030218:080256", L"9000, 178, RADIOLINJA" },
	{ L"20030218:080256", L"9000, 179, RADIOLINJA" },
	{ L"20030218:080300", L"9000, 179, RADIOLINJA" },
	{ L"20030218:080300", L"9000, 179, RADIOLINJA" },
	{ L"20030218:081258", L"9000, 178, RADIOLINJA" },
	{ L"20030218:081258", L"9000, 179, RADIOLINJA" },
	{ L"20030218:081258", L"9000, 62111, RADIOLINJA" },
	{ L"20030218:081258", L"9000, 179, RADIOLINJA" },
	{ L"20030218:082028", L"9000, 9814, RADIOLINJA" },
	{ L"20030218:082056", L"9000, 62112, RADIOLINJA" },
	{ L"20030218:082129", L"9000, 62110, RADIOLINJA" },
	{ L"20030218:082145", L"9000, 62112, RADIOLINJA" },
	{ L"20030218:082221", L"9000, 62116, RADIOLINJA" },
	{ L"20030218:082534", L"9000, 62112, RADIOLINJA" },
	{ L"20030218:082547", L"9000, 62110, RADIOLINJA" },
	{ L"20030218:082622", L"9000, 37211, RADIOLINJA" },
	{ L"20030218:082632", L"9000, 62110, RADIOLINJA" },
	{ L"20030218:082649", L"9000, 503, RADIOLINJA" },
	{ L"20030218:082722", L"9000, 495, RADIOLINJA" },
	{ L"20030218:083013", L"9000, 39713, RADIOLINJA" },
	{ L"20030218:083119", L"9000, 199, RADIOLINJA" },
	{ L"20030218:083144", L"9000, 62462, RADIOLINJA" },
	{ L"20030218:083154", L"9000, 35302, RADIOLINJA" },
	{ L"20030218:083237", L"9000, 62993, RADIOLINJA" },
	{ L"20030218:083330", L"9000, 199, RADIOLINJA" },
	{ L"20030218:083355", L"9000, 357, RADIOLINJA" },
	{ L"20030218:083608", L"9000, 440, RADIOLINJA" },
	{ L"20030218:083835", L"9000, 442, RADIOLINJA" },
	{ L"20030218:084129", L"9000, 437, RADIOLINJA" },
	{ L"20030218:084524", L"9000, 203, RADIOLINJA" },
	{ L"20030218:084826", L"9000, 62107, RADIOLINJA" },
	{ L"20030218:084946", L"9000, 754, RADIOLINJA" },
	{ L"20030218:085009", L"9000, 62107, RADIOLINJA" },
	{ L"20030218:085035", L"9000, 754, RADIOLINJA" },
	{ L"20030218:085340", L"9000, 62107, RADIOLINJA" },
	{ L"20030218:085359", L"9000, 2308, RADIOLINJA" },
	{ L"20030218:093711", L"9000, 754, RADIOLINJA" },
	{ L"20030218:093735", L"9000, 2308, RADIOLINJA" },
	{ L"20030218:094837", L"9000, 62107, RADIOLINJA" },
	{ L"20030218:094940", L"9000, 2308, RADIOLINJA" },
	{ L"20030218:094957", L"9000, 62107, RADIOLINJA" },
	{ L"20030218:095021", L"9000, 2308, RADIOLINJA" },
	{ L"20030218:103640", L"9000, 754, RADIOLINJA" },
	{ L"20030218:103654", L"9000, 2308, RADIOLINJA" },
	{ L"20030218:103654", L"SWITCH" },
	{ L"20030218:104046", L"9000, 2308, RADIOLINJA" },
	{ L"20030218:110615", L"9000, 62107, RADIOLINJA" },
	{ L"20030218:110627", L"9000, 754, RADIOLINJA" },
	{ L"20030218:110837", L"9000, 62107, RADIOLINJA" },
	{ L"20030218:110852", L"9000, 754, RADIOLINJA" },
	{ L"20030218:110913", L"9000, 15236, RADIOLINJA" },
	{ L"20030218:110923", L"9000, 62107, RADIOLINJA" },
	{ L"20030218:110938", L"9000, 203, RADIOLINJA" },
	{ L"20030218:111010", L"9000, 62107, RADIOLINJA" },
	{ L"20030218:111142", L"9000, 203, RADIOLINJA" },
	{ L"20030218:111324", L"9000, 437, RADIOLINJA" },
	{ L"20030218:111910", L"9000, 442, RADIOLINJA" },
	{ L"20030218:112128", L"9000, 35783, RADIOLINJA" },
	{ L"20030218:112234", L"9006, 441, RADIOLINJA" },
	{ L"20030218:112432", L"9006, 233, RADIOLINJA" },
	{ L"20030218:112615", L"9006, 232, RADIOLINJA" },
	{ L"20030218:112947", L"9006, 38583, RADIOLINJA" },
	{ L"20030218:113016", L"9006, 550, RADIOLINJA" },
	{ L"20030218:113122", L"9006, 1493, RADIOLINJA" },
	{ L"20030218:113156", L"9006, 601, RADIOLINJA" },
	{ L"20030218:113255", L"9006, 1493, RADIOLINJA" },
	{ L"20030218:113357", L"9006, 399, RADIOLINJA" },
	{ L"20030218:114221", L"9006, 376, RADIOLINJA" },
	{ L"20030218:114231", L"9006, 399, RADIOLINJA" },
	{ L"20030218:114747", L"9006, 376, RADIOLINJA" },
	{ L"20030218:114801", L"9006, 15306, RADIOLINJA" },
	{ L"20030218:114816", L"9006, 376, RADIOLINJA" },
	{ L"20030218:114924", L"9006, 18, RADIOLINJA" },
	{ L"20030218:114940", L"9006, 376, RADIOLINJA" },
	{ L"20030218:114956", L"9006, 15306, RADIOLINJA" },
	{ L"20030218:115029", L"9006, 376, RADIOLINJA" },
	{ L"20030218:115147", L"9006, 399, RADIOLINJA" },
	{ L"20030218:115203", L"9006, 376, RADIOLINJA" },
	{ L"20030218:115322", L"9006, 15306, RADIOLINJA" },
	{ L"20030218:115435", L"9006, 18, RADIOLINJA" },
	{ L"20030218:115512", L"9006, 399, RADIOLINJA" },
	{ L"20030218:115537", L"9006, 18, RADIOLINJA" },
	{ L"20030218:115614", L"9006, 399, RADIOLINJA" },
	{ L"20030218:115728", L"9006, 18, RADIOLINJA" },
	{ L"20030218:115752", L"9006, 399, RADIOLINJA" },
	{ L"20030218:115824", L"9006, 18, RADIOLINJA" },
	{ L"20030218:115859", L"9006, 376, RADIOLINJA" },
	{ L"20030218:115915", L"9006, 399, RADIOLINJA" },
	{ L"20030218:115933", L"9006, 376, RADIOLINJA" },
	{ L"20030218:115949", L"9006, 399, RADIOLINJA" },
	{ L"20030218:120004", L"9006, 376, RADIOLINJA" },
	{ L"20030218:120021", L"9006, 18, RADIOLINJA" },
	{ L"20030218:120036", L"9006, 15306, RADIOLINJA" },
	{ L"20030218:120052", L"9006, 376, RADIOLINJA" },
	{ L"20030218:120113", L"9006, 399, RADIOLINJA" },
	{ L"20030218:121325", L"9006, 376, RADIOLINJA" },
	{ L"20030218:121336", L"9006, 399, RADIOLINJA" },
	{ L"20030218:121433", L"9006, 376, RADIOLINJA" },
	{ L"20030218:121512", L"9006, 399, RADIOLINJA" },
	{ L"20030218:121904", L"9006, 376, RADIOLINJA" },
	{ L"20030218:121913", L"9006, 399, RADIOLINJA" },
	{ L"20030218:122250", L"9006, 18, RADIOLINJA" },
	{ L"20030218:122325", L"9006, 399, RADIOLINJA" },
	{ L"20030218:122446", L"9006, 376, RADIOLINJA" },
	{ L"20030218:122502", L"9006, 399, RADIOLINJA" },
	{ L"20030218:122738", L"9006, 376, RADIOLINJA" },
	{ L"20030218:122806", L"9006, 399, RADIOLINJA" },
	{ L"20030218:122840", L"9006, 376, RADIOLINJA" },
	{ L"20030218:122900", L"9006, 399, RADIOLINJA" },
	{ L"20030218:123034", L"9006, 376, RADIOLINJA" },
	{ L"20030218:123121", L"9006, 399, RADIOLINJA" },
	{ L"20030218:123137", L"9006, 376, RADIOLINJA" },
	{ L"20030218:123154", L"9006, 399, RADIOLINJA" },
	{ L"20030218:123207", L"9006, 376, RADIOLINJA" },
	{ L"20030218:123246", L"9006, 399, RADIOLINJA" },
	{ L"20030218:123507", L"9006, 376, RADIOLINJA" },
	{ L"20030218:123517", L"9006, 399, RADIOLINJA" },
	{ L"20030218:123535", L"9006, 376, RADIOLINJA" },
	{ L"20030218:123630", L"9006, 399, RADIOLINJA" },
	{ L"20030218:123647", L"9006, 376, RADIOLINJA" },
	{ L"20030218:123719", L"9006, 399, RADIOLINJA" },
	{ L"20030218:123959", L"9006, 376, RADIOLINJA" },
	{ L"20030218:124345", L"9006, 399, RADIOLINJA" },
	{ L"20030218:124402", L"9006, 62032, RADIOLINJA" },
	{ L"20030218:124427", L"9006, 399, RADIOLINJA" },
	{ L"20030218:124447", L"9006, 62032, RADIOLINJA" },
	{ L"20030218:124551", L"9006, 399, RADIOLINJA" },
	{ L"20030218:124606", L"9006, 376, RADIOLINJA" },
	{ L"20030218:124808", L"9006, 399, RADIOLINJA" },
	{ L"20030218:124838", L"9006, 376, RADIOLINJA" },
	{ L"20030218:124938", L"9006, 399, RADIOLINJA" },
	{ L"20030218:124954", L"9006, 376, RADIOLINJA" },
	{ L"20030218:125114", L"9006, 399, RADIOLINJA" },
	{ L"20030218:125149", L"9006, 18, RADIOLINJA" },
	{ L"20030218:125206", L"9006, 62032, RADIOLINJA" },
	{ L"20030218:125254", L"9006, 399, RADIOLINJA" },
	{ L"20030218:125330", L"9006, 376, RADIOLINJA" },
	{ L"20030218:125409", L"9006, 399, RADIOLINJA" },
	{ L"20030218:125433", L"9006, 62032, RADIOLINJA" },
	{ L"20030218:125449", L"9006, 399, RADIOLINJA" },
	{ L"20030218:125605", L"9006, 62032, RADIOLINJA" },
	{ L"20030218:125646", L"9006, 399, RADIOLINJA" },
	{ L"20030218:125802", L"9006, 376, RADIOLINJA" },
	{ L"20030218:125843", L"9006, 399, RADIOLINJA" },
	{ L"20030218:130023", L"9006, 376, RADIOLINJA" },
	{ L"20030218:130051", L"9006, 399, RADIOLINJA" },
	{ L"20030218:130138", L"9006, 376, RADIOLINJA" },
	{ L"20030218:130206", L"9006, 399, RADIOLINJA" },
	{ L"20030218:130546", L"9006, 376, RADIOLINJA" },
	{ L"20030218:130650", L"9006, 399, RADIOLINJA" },
	{ L"20030218:130732", L"9006, 376, RADIOLINJA" },
	{ L"20030218:131031", L"9006, 399, RADIOLINJA" },
	{ L"20030218:131530", L"9006, 376, RADIOLINJA" },
	{ L"20030218:131639", L"9006, 399, RADIOLINJA" },
	{ L"20030218:131757", L"9006, 376, RADIOLINJA" },
	{ L"20030218:131819", L"9006, 399, RADIOLINJA" },
	{ L"20030218:132102", L"9006, 62032, RADIOLINJA" },
	{ L"20030218:132306", L"9006, 399, RADIOLINJA" },
	{ L"20030218:132353", L"9006, 62032, RADIOLINJA" },
	{ L"20030218:132410", L"9006, 399, RADIOLINJA" },
	{ L"20030218:133039", L"9006, 376, RADIOLINJA" },
	{ L"20030218:133249", L"9006, 399, RADIOLINJA" },
	{ L"20030218:133304", L"9006, 376, RADIOLINJA" },
	{ L"20030218:133328", L"9006, 399, RADIOLINJA" },
	{ L"20030218:133638", L"9006, 376, RADIOLINJA" },
	{ L"20030218:134221", L"9006, 399, RADIOLINJA" },
	{ L"20030218:135142", L"9006, 376, RADIOLINJA" },
	{ L"20030218:135159", L"9006, 399, RADIOLINJA" },
	{ L"20030218:140717", L"9006, 376, RADIOLINJA" },
	{ L"20030218:140732", L"9006, 399, RADIOLINJA" },
	{ L"20030218:140756", L"9006, 18, RADIOLINJA" },
	{ L"20030218:140939", L"9006, 18, RADIOLINJA" },
	{ L"20030218:140945", L"9006, 18, RADIOLINJA" },
	{ L"20030218:141605", L"9006, 18, RADIOLINJA" },
	{ L"20030218:141619", L"9006, 18, RADIOLINJA" },
	{ L"20030218:141619", L"9006, 18, RADIOLINJA" },
	{ L"20030218:141638", L"9006, 18, RADIOLINJA" },
	{ L"20030218:141648", L"9006, 18, RADIOLINJA" },
	{ L"20030218:141649", L"9006, 18, RADIOLINJA" },
	{ L"20030218:141649", L"9006, 18, RADIOLINJA" },
	{ L"20030218:141714", L"9006, 18, RADIOLINJA" },
	{ L"20030218:141758", L"9006, 18, RADIOLINJA" },
	{ L"20030218:141758", L"9006, 18, RADIOLINJA" },
	{ L"20030218:141822", L"9006, 18, RADIOLINJA" },
	{ L"20030218:141843", L"9006, 18, RADIOLINJA" },
	{ L"20030218:141911", L"9006, 18, RADIOLINJA" },
	{ L"20030218:142010", L"9006, 18, RADIOLINJA" },
	{ L"20030218:142134", L"9006, 18, RADIOLINJA" },
	{ L"20030218:142142", L"9006, 18, RADIOLINJA" },
	{ L"20030218:142219", L"9006, 18, RADIOLINJA" },
	{ L"20030218:142224", L"9006, 18, RADIOLINJA" },
	{ L"20030218:142315", L"9006, 18, RADIOLINJA" },
	{ L"20030218:142315", L"9006, 18, RADIOLINJA" },
	{ L"20030218:142348", L"9006, 18, RADIOLINJA" },
	{ L"20030218:142348", L"9006, 18, RADIOLINJA" },
	{ L"20030218:142428", L"9006, 18, RADIOLINJA" },
	{ L"20030218:142428", L"9006, 18, RADIOLINJA" },
	{ L"20030218:142514", L"9006, 18, RADIOLINJA" },
	{ L"20030218:142917", L"9006, 18, RADIOLINJA" },
	{ L"20030218:142938", L"9006, 18, RADIOLINJA" },
	{ L"20030218:143401", L"9006, 62032, RADIOLINJA" },
	{ L"20030218:143828", L"9006, 18, RADIOLINJA" },
	{ L"20030218:143905", L"9006, 376, RADIOLINJA" },
	{ L"20030218:143915", L"9006, 18, RADIOLINJA" },
	{ L"20030218:143939", L"9006, 376, RADIOLINJA" },
	{ L"20030218:143956", L"9006, 399, RADIOLINJA" },
	{ L"20030218:144024", L"9006, 376, RADIOLINJA" },
	{ L"20030218:144034", L"9006, 399, RADIOLINJA" },
	{ L"20030218:161939", L"9006, 376, RADIOLINJA" },
	{ L"20030218:161956", L"9006, 399, RADIOLINJA" },
	{ L"20030218:165210", L"9006, 1493, RADIOLINJA" },
	{ L"20030218:165220", L"9006, 399, RADIOLINJA" },
	{ L"20030218:165310", L"9006, 1493, RADIOLINJA" },
	{ L"20030218:165358", L"9006, 399, RADIOLINJA" },
	{ L"20030218:165408", L"9006, 1493, RADIOLINJA" },
	{ L"20030218:165521", L"9006, 601, RADIOLINJA" },
	{ L"20030218:165613", L"9006, 1493, RADIOLINJA" },
	{ L"20030218:165657", L"9006, 601, RADIOLINJA" },
	{ L"20030218:165827", L"9006, 1493, RADIOLINJA" },
	{ L"20030218:165842", L"9006, 550, RADIOLINJA" },
	{ L"20030218:170046", L"9006, 38583, RADIOLINJA" },
	{ L"20030218:170110", L"9006, 232, RADIOLINJA" },
	{ L"20030218:170303", L"9006, 233, RADIOLINJA" },
	{ L"20030218:170325", L"9006, 62143, RADIOLINJA" },
	{ L"20030218:170357", L"9006, 233, RADIOLINJA" },
	{ L"20030218:170409", L"9006, 3900, RADIOLINJA" },
	{ L"20030218:170444", L"9006, 511, RADIOLINJA" },
	{ L"20030218:170506", L"9006, 67, RADIOLINJA" },
	{ L"20030218:170733", L"9000, 62017, RADIOLINJA" },
	{ L"20030218:170748", L"9000, 35781, RADIOLINJA" },
	{ L"20030218:170803", L"9000, 168, RADIOLINJA" },
	{ L"20030218:170834", L"9000, 62019, RADIOLINJA" },
	{ L"20030218:170902", L"9000, 440, RADIOLINJA" },
	{ L"20030218:170927", L"9000, 188, RADIOLINJA" },
	{ L"20030218:171358", L"9000, 215, RADIOLINJA" },
	{ L"20030218:171621", L"9000, 62098, RADIOLINJA" },
	{ L"20030218:171642", L"9000, 4402, RADIOLINJA" },
	{ L"20030218:171838", L"9000, 62014, RADIOLINJA" },
	{ L"20030218:171943", L"9000, 36004, RADIOLINJA" },
	{ L"20030218:172004", L"9000, 62014, RADIOLINJA" },
	{ L"20030218:172017", L"9000, 36004, RADIOLINJA" },
	{ L"20030218:172035", L"9000, 41715, RADIOLINJA" },
	{ L"20030218:172051", L"9000, 36004, RADIOLINJA" },
	{ L"20030218:172125", L"9000, 41715, RADIOLINJA" },
	{ L"20030218:172425", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:172633", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:172706", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:172720", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:172740", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:172807", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:172823", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:173119", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:173413", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:173442", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:173458", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:173631", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:173757", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:173900", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:174306", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:174435", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:174451", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:174520", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:174529", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:174624", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:174650", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:174911", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:174921", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:175333", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:175449", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:175507", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:175526", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:175548", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:175649", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:175845", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:175901", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:180049", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:180135", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:180253", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:180332", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:180355", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:180441", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:180716", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:181016", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:181032", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:181156", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:182135", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:182149", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:182206", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:182219", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:183558", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:183637", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:183732", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:183750", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:183925", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:183942", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:184009", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:184017", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:184122", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:184139", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:184215", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:184849", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:185202", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:185211", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:185622", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:185635", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:190238", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:190255", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:191021", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:191040", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:191222", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:191320", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:191400", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:191418", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:191445", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:191501", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:191545", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:191631", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:191658", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:191953", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:192517", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:192652", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:192929", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:192949", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:193018", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:193212", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:193229", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:193402", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:193523", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:193602", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:193727", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:193859", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:194005", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:194037", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:194228", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:194400", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:195851", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:195921", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:201130", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:201241", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:201710", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:201916", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:202302", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:202538", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:203004", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:203039", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:203140", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:203211", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:203327", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:203347", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:203527", L"9000, 15160, RADIOLINJA" },
	{ L"20030218:203551", L"9000, 62123, RADIOLINJA" },
	{ L"20030218:203603", L"9000, 41715, RADIOLINJA" },
	{ L"20030218:203816", L"9000, 36004, RADIOLINJA" },
	{ L"20030218:203853", L"9000, 41715, RADIOLINJA" },
	{ L"20030218:203939", L"9000, 62100, RADIOLINJA" },
	{ L"20030218:204053", L"9000, 62104, RADIOLINJA" },
	{ L"20030218:204103", L"9000, 15118, RADIOLINJA" },
	{ L"20030218:204124", L"9000, 62104, RADIOLINJA" },
	{ L"20030218:204231", L"9000, 15088, RADIOLINJA" },
	{ L"20030218:204249", L"9000, 62116, RADIOLINJA" },
	{ L"20030218:204357", L"9000, 35600, RADIOLINJA" },
	{ L"20030218:204427", L"9000, 62116, RADIOLINJA" },
	{ L"20030218:204444", L"9000, 62112, RADIOLINJA" },
	{ L"20030218:204453", L"9000, 62116, RADIOLINJA" },
	{ L"20030218:204544", L"9000, 62112, RADIOLINJA" },
	{ L"20030218:204600", L"9000, 62110, RADIOLINJA" },
	{ L"20030218:204636", L"9000, 62111, RADIOLINJA" },
	{ L"20030218:204658", L"9000, 179, RADIOLINJA" },
	{ L"20030218:211702", L"9000, 62111, RADIOLINJA" },
	{ L"20030218:211719", L"9000, 179, RADIOLINJA" },
	{ L"20030218:212233", L"9000, 9814, RADIOLINJA" },
	{ L"20030218:212243", L"9000, 179, RADIOLINJA" },
	{ L"20030218:212314", L"9000, 62111, RADIOLINJA" },
	{ L"20030218:212329", L"9000, 179, RADIOLINJA" },
	{ L"20030218:212428", L"9000, 178, RADIOLINJA" },
	{ L"20030218:212449", L"9000, 179, RADIOLINJA" },
	{ L"20030218:212502", L"9000, 178, RADIOLINJA" },
	{ L"20030218:212530", L"9000, 179, RADIOLINJA" },
	{ L"20030218:213638", L"9000, 178, RADIOLINJA" },
	{ L"20030218:213748", L"9000, 179, RADIOLINJA" },
	{ L"20030218:215753", L"9000, 178, RADIOLINJA" },
	{ L"20030218:215844", L"9000, 179, RADIOLINJA" },
	{ L"20030218:215904", L"9000, 178, RADIOLINJA" },
	{ L"20030218:215920", L"9000, 179, RADIOLINJA" },
	{ L"20030218:220029", L"9000, 178, RADIOLINJA" },
	{ L"20030218:220109", L"9000, 179, RADIOLINJA" },
	{ L"20030218:220125", L"9000, 178, RADIOLINJA" },
	{ L"20030218:220142", L"9000, 179, RADIOLINJA" },
	{ L"20030218:220246", L"9000, 178, RADIOLINJA" },
	{ L"20030218:220326", L"9000, 179, RADIOLINJA" },
	{ L"20030218:222327", L"9000, 178, RADIOLINJA" },
	{ L"20030218:223249", L"9000, 179, RADIOLINJA" },
	{ L"20030218:232639", L"9000, 178, RADIOLINJA" },
	{ L"20030218:232652", L"9000, 179, RADIOLINJA" },
	{ L"20030219:090423", L"9000, 62112, RADIOLINJA" },
	{ L"20030219:090440", L"9000, 62110, RADIOLINJA" },
	{ L"20030219:090512", L"9000, 62112, RADIOLINJA" },
	{ L"20030219:090559", L"9000, 62110, RADIOLINJA" },
	{ L"20030219:090616", L"9000, 62112, RADIOLINJA" },
	{ L"20030219:090642", L"9000, 62110, RADIOLINJA" },
	{ L"20030219:090759", L"9000, 62112, RADIOLINJA" },
	{ L"20030219:090824", L"9000, 62110, RADIOLINJA" },
	{ L"20030219:090840", L"9000, 62112, RADIOLINJA" },
	{ L"20030219:090856", L"9000, 62116, RADIOLINJA" },
	{ L"20030219:091019", L"9000, 62112, RADIOLINJA" },
	{ L"20030219:091033", L"9000, 62110, RADIOLINJA" },
	{ L"20030219:091109", L"9000, 37211, RADIOLINJA" },
	{ L"20030219:091124", L"9000, 62110, RADIOLINJA" },
	{ L"20030219:091134", L"9000, 503, RADIOLINJA" },
	{ L"20030219:091152", L"9000, 495, RADIOLINJA" },
	{ L"20030219:091329", L"9000, 243, RADIOLINJA" },
	{ L"20030219:091338", L"9000, 495, RADIOLINJA" },
	{ L"20030219:091356", L"9000, 39713, RADIOLINJA" },
	{ L"20030219:091420", L"9000, 495, RADIOLINJA" },
	{ L"20030219:091511", L"9000, 35302, RADIOLINJA" },
	{ L"20030219:091529", L"9000, 62462, RADIOLINJA" },
	{ L"20030219:091548", L"9000, 495, RADIOLINJA" },
	{ L"20030219:091601", L"9000, 41251, RADIOLINJA" },
	{ L"20030219:091618", L"9000, 168, RADIOLINJA" },
	{ L"20030219:091845", L"9000, 35781, RADIOLINJA" },
	{ L"20030219:091857", L"9000, 62017, RADIOLINJA" },
	{ L"20030219:091947", L"9006, 67, RADIOLINJA" },
	{ L"20030219:092002", L"9000, 15128, RADIOLINJA" },
	{ L"20030219:092208", L"9000, 144, RADIOLINJA" },
	{ L"20030219:092259", L"9006, 67, RADIOLINJA" },
	{ L"20030219:092329", L"9006, 511, RADIOLINJA" },
	{ L"20030219:092402", L"9006, 217, RADIOLINJA" },
	{ L"20030219:092450", L"9006, 216, RADIOLINJA" },
	{ L"20030219:092559", L"9006, 37204, RADIOLINJA" },
	{ L"20030219:092734", L"9006, 216, RADIOLINJA" },
	{ L"20030219:092751", L"9006, 35779, RADIOLINJA" },
	{ L"20030219:092823", L"9006, 216, RADIOLINJA" },
	{ L"20030219:092837", L"9006, 4707, RADIOLINJA" },
	{ L"20030219:092847", L"9006, 376, RADIOLINJA" },
	{ L"20030219:092902", L"9006, 38583, RADIOLINJA" },
	{ L"20030219:093008", L"9006, 376, RADIOLINJA" },
	{ L"20030219:093058", L"9006, 399, RADIOLINJA" },
	{ L"20030219:094006", L"9006, 376, RADIOLINJA" },
	{ L"20030219:094055", L"9006, 399, RADIOLINJA" },
	{ L"20030219:094222", L"9006, 376, RADIOLINJA" },
	{ L"20030219:094234", L"9006, 18, RADIOLINJA" },
	{ L"20030219:094255", L"9006, 399, RADIOLINJA" },
	{ L"20030219:094306", L"9006, 18, RADIOLINJA" },
	{ L"20030219:094329", L"9006, 376, RADIOLINJA" },
	{ L"20030219:094402", L"9006, 376, RADIOLINJA" },
	{ L"20030219:094403", L"9006, 376, RADIOLINJA" },
	{ L"20030219:094403", L"9006, 376, RADIOLINJA" },
	{ L"20030219:094429", L"9006, 18, RADIOLINJA" },
	{ L"20030219:095259", L"9006, 18, RADIOLINJA" },
	{ L"20030219:095303", L"9006, 18, RADIOLINJA" },
	{ L"20030219:095313", L"9006, 18, RADIOLINJA" },
	{ L"20030219:095314", L"9006, 18, RADIOLINJA" },
	{ L"20030219:095314", L"9006, 18, RADIOLINJA" },
	{ L"20030219:095839", L"9006, 399, RADIOLINJA" },
	{ L"20030219:102413", L"9006, 62032, RADIOLINJA" },
	{ L"20030219:102430", L"9006, 399, RADIOLINJA" },
	{ L"20030219:102447", L"9006, 376, RADIOLINJA" },
	{ L"20030219:102500", L"9006, 15306, RADIOLINJA" },
	{ L"20030219:102508", L"9006, 376, RADIOLINJA" },
	{ L"20030219:102525", L"9006, 15306, RADIOLINJA" },
	{ L"20030219:102547", L"9006, 18, RADIOLINJA" },
	{ L"20030219:102603", L"9006, 15306, RADIOLINJA" },
	{ L"20030219:102633", L"9006, 376, RADIOLINJA" },
	{ L"20030219:102700", L"9006, 399, RADIOLINJA" },
	{ L"20030219:102732", L"9006, 376, RADIOLINJA" },
	{ L"20030219:102751", L"9006, 399, RADIOLINJA" },
	{ L"20030219:102840", L"9006, 376, RADIOLINJA" },
	{ L"20030219:103014", L"9006, 15306, RADIOLINJA" },
	{ L"20030219:103031", L"9006, 4707, RADIOLINJA" },
	{ L"20030219:103048", L"9006, 376, RADIOLINJA" },
	{ L"20030219:103123", L"9006, 18, RADIOLINJA" },
	{ L"20030219:103148", L"9006, 376, RADIOLINJA" },
	{ L"20030219:103214", L"9006, 399, RADIOLINJA" },
	{ L"20030219:110051", L"9006, 376, RADIOLINJA" },
	{ L"20030219:110101", L"9006, 399, RADIOLINJA" },
	{ L"20030219:110237", L"9006, 18, RADIOLINJA" },
	{ L"20030219:110328", L"9006, 62032, RADIOLINJA" },
	{ L"20030219:110344", L"9006, 18, RADIOLINJA" },
	{ L"20030219:110859", L"9006, 42004, RADIOLINJA" },
	{ L"20030219:110908", L"9006, 18, RADIOLINJA" },
	{ L"20030219:110949", L"9006, 4707, RADIOLINJA" },
	{ L"20030219:111022", L"9006, 15306, RADIOLINJA" },
	{ L"20030219:111101", L"9006, 4707, RADIOLINJA" },
	{ L"20030219:111110", L"9006, 376, RADIOLINJA" },
	{ L"20030219:111131", L"9006, 4707, RADIOLINJA" },
	{ L"20030219:111246", L"9006, 15306, RADIOLINJA" },
	{ L"20030219:113809", L"9006, 376, RADIOLINJA" },
	{ L"20030219:113833", L"9006, 15306, RADIOLINJA" },
	{ L"20030219:114355", L"9006, 4707, RADIOLINJA" },
	{ L"20030219:114414", L"9006, 15306, RADIOLINJA" },
	{ L"20030219:114512", L"9006, 4707, RADIOLINJA" },
	{ L"20030219:114540", L"9006, 15306, RADIOLINJA" },
	{ L"20030219:114558", L"9006, 376, RADIOLINJA" },
	{ L"20030219:114614", L"9006, 15306, RADIOLINJA" },
	{ L"20030219:114656", L"9006, 376, RADIOLINJA" },
	{ L"20030219:114705", L"9006, 15306, RADIOLINJA" },
	{ L"20030219:114830", L"9006, 376, RADIOLINJA" },
	{ L"20030219:114839", L"9006, 15306, RADIOLINJA" },
	{ L"20030219:115050", L"9006, 376, RADIOLINJA" },
	{ L"20030219:115244", L"9006, 15306, RADIOLINJA" },
	{ L"20030219:115253", L"9006, 4707, RADIOLINJA" },
	{ L"20030219:115307", L"9006, 15306, RADIOLINJA" },
	{ L"20030219:115325", L"9006, 18, RADIOLINJA" },
	{ L"20030219:115348", L"9006, 42004, RADIOLINJA" },
	{ L"20030219:115400", L"9006, 18, RADIOLINJA" },
	{ L"20030219:115420", L"9006, 42004, RADIOLINJA" },
	{ L"20030219:115442", L"9006, 18, RADIOLINJA" },
	{ L"20030219:115653", L"9006, 4707, RADIOLINJA" },
	{ L"20030219:115715", L"9006, 18, RADIOLINJA" },
	{ L"20030219:115829", L"9006, 376, RADIOLINJA" },
	{ L"20030219:115844", L"9006, 18, RADIOLINJA" },
	{ L"20030219:115935", L"9006, 62032, RADIOLINJA" },
	{ L"20030219:115949", L"9006, 18, RADIOLINJA" },
	{ L"20030219:120005", L"9006, 376, RADIOLINJA" },
	{ L"20030219:120033", L"9006, 399, RADIOLINJA" },
	{ L"20030219:133728", L"9006, 1493, RADIOLINJA" },
	{ L"20030219:133942", L"9006, 399, RADIOLINJA" },
	{ L"20030219:152017", L"9006, 1493, RADIOLINJA" },
	{ L"20030219:152033", L"9006, 15306, RADIOLINJA" },
	{ L"20030219:152203", L"9006, 18, RADIOLINJA" },
	{ L"20030219:152215", L"9006, 399, RADIOLINJA" },
	{ L"20030219:170147", L"9006, 376, RADIOLINJA" },
	{ L"20030219:170215", L"9006, 399, RADIOLINJA" },
	{ L"20030219:170259", L"9006, 18, RADIOLINJA" },
	{ L"20030219:170313", L"9006, 399, RADIOLINJA" },
	{ L"20030219:170341", L"9006, 376, RADIOLINJA" },
	{ L"20030219:170701", L"9006, 38583, RADIOLINJA" },
	{ L"20030219:170713", L"9006, 62065, RADIOLINJA" },
	{ L"20030219:170730", L"9006, 38583, RADIOLINJA" },
	{ L"20030219:170754", L"9006, 62065, RADIOLINJA" },
	{ L"20030219:170830", L"9006, 38583, RADIOLINJA" },
	{ L"20030219:171013", L"9006, 62067, RADIOLINJA" },
	{ L"20030219:171023", L"9006, 15300, RADIOLINJA" },
	{ L"20030219:171448", L"9006, 62067, RADIOLINJA" },
	{ L"20030219:171500", L"9006, 15300, RADIOLINJA" },
	{ L"20030219:171739", L"9006, 35265, RADIOLINJA" },
	{ L"20030219:171809", L"9006, 15300, RADIOLINJA" },
	{ L"20030219:172004", L"9006, 35265, RADIOLINJA" },
	{ L"20030219:172020", L"9006, 15300, RADIOLINJA" },
	{ L"20030219:172303", L"9006, 35265, RADIOLINJA" },
	{ L"20030219:172355", L"9006, 15300, RADIOLINJA" },
	{ L"20030219:172528", L"9006, 35265, RADIOLINJA" },
	{ L"20030219:172546", L"9006, 15300, RADIOLINJA" },
	{ L"20030219:172756", L"9006, 35265, RADIOLINJA" },
	{ L"20030219:172818", L"9006, 15300, RADIOLINJA" },
	{ L"20030219:172842", L"9006, 35265, RADIOLINJA" },
	{ L"20030219:173123", L"9006, 15300, RADIOLINJA" },
	{ L"20030219:173139", L"9006, 35265, RADIOLINJA" },
	{ L"20030219:173516", L"9006, 15300, RADIOLINJA" },
	{ L"20030219:173759", L"9006, 62067, RADIOLINJA" },
	{ L"20030219:173921", L"9006, 233, RADIOLINJA" },
	{ L"20030219:173945", L"9006, 62067, RADIOLINJA" },
	{ L"20030219:173955", L"9006, 233, RADIOLINJA" },
	{ L"20030219:174257", L"9006, 62143, RADIOLINJA" },
	{ L"20030219:174314", L"9006, 233, RADIOLINJA" },
	{ L"20030219:174401", L"9006, 62143, RADIOLINJA" },
	{ L"20030219:174411", L"9006, 232, RADIOLINJA" },
	{ L"20030219:174640", L"9006, 233, RADIOLINJA" },
	{ L"20030219:174746", L"9006, 232, RADIOLINJA" },
	{ L"20030219:175114", L"9006, 233, RADIOLINJA" },
	{ L"20030219:175458", L"9006, 232, RADIOLINJA" },
	{ L"20030219:180146", L"9006, 233, RADIOLINJA" },
	{ L"20030219:180235", L"9006, 232, RADIOLINJA" },
	{ L"20030219:180611", L"9006, 233, RADIOLINJA" },
	{ L"20030219:180706", L"9006, 232, RADIOLINJA" },
	{ L"20030219:180811", L"9006, 233, RADIOLINJA" },
	{ L"20030219:180934", L"9006, 232, RADIOLINJA" },
	{ L"20030219:180946", L"9006, 233, RADIOLINJA" },
	{ L"20030219:180957", L"9006, 232, RADIOLINJA" },
	{ L"20030219:181025", L"9006, 233, RADIOLINJA" },
	{ L"20030219:181037", L"9006, 233, RADIOLINJA" },
	{ L"20030219:181301", L"9006, 233, RADIOLINJA" },
	{ L"20030219:181409", L"9006, 232, RADIOLINJA" },
	{ L"20030219:181834", L"9006, 233, RADIOLINJA" },
	{ L"20030219:181851", L"9006, 232, RADIOLINJA" },
	{ L"20030219:182027", L"9006, 233, RADIOLINJA" },
	{ L"20030219:182615", L"9006, 232, RADIOLINJA" },
	{ L"20030219:182732", L"9006, 233, RADIOLINJA" },
	{ L"20030219:182812", L"9006, 232, RADIOLINJA" },
	{ L"20030219:182851", L"9006, 233, RADIOLINJA" },
	{ L"20030219:182925", L"9006, 232, RADIOLINJA" },
	{ L"20030219:182948", L"9006, 233, RADIOLINJA" },
	{ L"20030219:183014", L"9006, 232, RADIOLINJA" },
	{ L"20030219:183116", L"9006, 233, RADIOLINJA" },
	{ L"20030219:183141", L"9006, 232, RADIOLINJA" },
	{ L"20030219:183220", L"9006, 233, RADIOLINJA" },
	{ L"20030219:183237", L"9006, 232, RADIOLINJA" },
	{ L"20030219:183617", L"9006, 233, RADIOLINJA" },
	{ L"20030219:184105", L"9006, 232, RADIOLINJA" },
	{ L"20030219:184220", L"9006, 233, RADIOLINJA" },
	{ L"20030219:184258", L"9006, 232, RADIOLINJA" },
	{ L"20030219:184358", L"9006, 233, RADIOLINJA" },
	{ L"20030219:184423", L"9006, 232, RADIOLINJA" },
	{ L"20030219:184447", L"9006, 233, RADIOLINJA" },
	{ L"20030219:184623", L"9006, 232, RADIOLINJA" },
	{ L"20030219:184714", L"9006, 233, RADIOLINJA" },
	{ L"20030219:184809", L"9006, 232, RADIOLINJA" },
	{ L"20030219:184837", L"9006, 233, RADIOLINJA" },
	{ L"20030219:184916", L"9006, 232, RADIOLINJA" },
	{ L"20030219:184933", L"9006, 233, RADIOLINJA" },
	{ L"20030219:184958", L"9006, 232, RADIOLINJA" },
	{ L"20030219:185014", L"9006, 233, RADIOLINJA" },
	{ L"20030219:185030", L"9006, 232, RADIOLINJA" },
	{ L"20030219:185813", L"9006, 233, RADIOLINJA" },
	{ L"20030219:185855", L"9006, 232, RADIOLINJA" },
	{ L"20030219:190031", L"9006, 233, RADIOLINJA" },
	{ L"20030219:190936", L"9006, 233, RADIOLINJA" },
	{ L"20030219:190946", L"9006, 233, RADIOLINJA" },
	{ L"20030219:190946", L"9006, 233, RADIOLINJA" },
	{ L"20030219:191009", L"9006, 233, RADIOLINJA" },
	{ L"20030219:191009", L"9006, 233, RADIOLINJA" },
	{ L"20030219:191041", L"9006, 233, RADIOLINJA" },
	{ L"20030219:191041", L"9006, 233, RADIOLINJA" },
	{ L"20030219:191121", L"9006, 233, RADIOLINJA" },
	{ L"20030219:191423", L"9006, 232, RADIOLINJA" },
	{ L"20030219:191453", L"9006, 233, RADIOLINJA" },
	{ L"20030219:191515", L"9006, 232, RADIOLINJA" },
	{ L"20030219:191531", L"9006, 233, RADIOLINJA" },
	{ L"20030219:191549", L"9006, 232, RADIOLINJA" },
	{ L"20030219:191736", L"9006, 233, RADIOLINJA" },
	{ L"20030219:191814", L"9006, 232, RADIOLINJA" },
	{ L"20030219:191829", L"9006, 233, RADIOLINJA" },
	{ L"20030219:191857", L"9006, 232, RADIOLINJA" },
	{ L"20030219:192145", L"9006, 233, RADIOLINJA" },
	{ L"20030219:192221", L"9006, 232, RADIOLINJA" },
	{ L"20030219:192801", L"9006, 233, RADIOLINJA" },
	{ L"20030219:192848", L"9006, 232, RADIOLINJA" },
	{ L"20030219:192905", L"9006, 233, RADIOLINJA" },
	{ L"20030219:192926", L"9006, 232, RADIOLINJA" },
	{ L"20030219:192943", L"9006, 233, RADIOLINJA" },
	{ L"20030219:193004", L"9006, 232, RADIOLINJA" },
	{ L"20030219:193036", L"9006, 233, RADIOLINJA" },
	{ L"20030219:193123", L"9006, 232, RADIOLINJA" },
	{ L"20030219:193140", L"9006, 233, RADIOLINJA" },
	{ L"20030219:193157", L"9006, 232, RADIOLINJA" },
	{ L"20030219:193206", L"9006, 233, RADIOLINJA" },
	{ L"20030219:193507", L"9006, 441, RADIOLINJA" },
	{ L"20030219:194033", L"9000, 35783, RADIOLINJA" },
	{ L"20030219:194139", L"9000, 442, RADIOLINJA" },
	{ L"20030219:194244", L"9000, 440, RADIOLINJA" },
	{ L"20030219:194517", L"9000, 357, RADIOLINJA" },
	{ L"20030219:194723", L"9000, 62993, RADIOLINJA" },
	{ L"20030219:194741", L"9000, 357, RADIOLINJA" },
	{ L"20030219:213313", L"9000, 62993, RADIOLINJA" },
	{ L"20030219:213453", L"9000, 39713, RADIOLINJA" },
	{ L"20030219:213613", L"9000, 42338, RADIOLINJA" },
	{ L"20030219:213859", L"9000, 7, RADIOLINJA" },
	{ L"20030219:213953", L"9000, 42338, RADIOLINJA" },
	{ L"20030219:214003", L"9000, 7, RADIOLINJA" },
	{ L"20030219:214023", L"9000, 8, RADIOLINJA" },
	{ L"20030219:214040", L"9000, 7, RADIOLINJA" },
	{ L"20030219:214702", L"9000, 42338, RADIOLINJA" },
	{ L"20030219:214736", L"9000, 7, RADIOLINJA" },
	{ L"20030219:214903", L"9000, 42338, RADIOLINJA" },
	{ L"20030219:214938", L"9000, 7, RADIOLINJA" },
	{ L"20030219:215001", L"9000, 42338, RADIOLINJA" },
	{ L"20030219:215105", L"9000, 7, RADIOLINJA" },
	{ L"20030219:215145", L"9000, 42338, RADIOLINJA" },
	{ L"20030219:215222", L"9000, 7, RADIOLINJA" },
	{ L"20030219:215258", L"9000, 42338, RADIOLINJA" },
	{ L"20030219:215324", L"9000, 7, RADIOLINJA" },
	{ L"20030219:215334", L"9000, 42338, RADIOLINJA" },
	{ L"20030219:215400", L"9000, 7, RADIOLINJA" },
	{ L"20030219:215506", L"9000, 42338, RADIOLINJA" },
	{ L"20030219:215542", L"9000, 7, RADIOLINJA" },
	{ L"20030219:215750", L"9000, 42338, RADIOLINJA" },
	{ L"20030219:215759", L"9000, 7, RADIOLINJA" },
	{ L"20030219:220612", L"9000, 42338, RADIOLINJA" },
	{ L"20030219:220627", L"9000, 7, RADIOLINJA" },
	{ L"20030219:221303", L"9000, 42338, RADIOLINJA" },
	{ L"20030219:221319", L"9000, 7, RADIOLINJA" },
	{ L"20030219:221745", L"9000, 42338, RADIOLINJA" },
	{ L"20030219:221851", L"9000, 7, RADIOLINJA" },
	{ L"20030219:222031", L"9000, 42338, RADIOLINJA" },
	{ L"20030219:222055", L"9000, 7, RADIOLINJA" },
	{ L"20030219:222814", L"9000, 42338, RADIOLINJA" },
	{ L"20030219:222827", L"9000, 7, RADIOLINJA" },
	{ L"20030219:223814", L"9000, 42338, RADIOLINJA" },
	{ L"20030219:223829", L"9000, 7, RADIOLINJA" },
	{ L"20030219:224803", L"9000, 42338, RADIOLINJA" },
	{ L"20030219:224816", L"9000, 7, RADIOLINJA" },
	{ L"20030219:225125", L"9000, 7, RADIOLINJA" },
	{ L"20030219:225127", L"9000, 7, RADIOLINJA" },
	{ L"20030219:225709", L"9000, 42338, RADIOLINJA" },
	{ L"20030219:225830", L"9000, 39713, RADIOLINJA" },
	{ L"20030219:225946", L"9000, 62993, RADIOLINJA" },
	{ L"20030219:230141", L"9000, 490, RADIOLINJA" },
	{ L"20030219:230155", L"9000, 490, RADIOLINJA" },
	{ L"20030219:230156", L"9000, 490, RADIOLINJA" },
	{ L"20030219:230158", L"9000, 62993, RADIOLINJA" },
	{ L"20030219:230216", L"9000, 62993, RADIOLINJA" },
	{ L"20030219:230218", L"9000, 62993, RADIOLINJA" },
	{ L"20030219:230239", L"9000, 490, RADIOLINJA" },
	{ L"20030219:230255", L"9000, 62993, RADIOLINJA" },
	{ L"20030219:230324", L"9000, 490, RADIOLINJA" },
	{ L"20030219:230404", L"9000, 62993, RADIOLINJA" },
	{ L"20030219:230433", L"9000, 35302, RADIOLINJA" },
	{ L"20030219:230442", L"9000, 62993, RADIOLINJA" },
	{ L"20030219:230452", L"9000, 199, RADIOLINJA" },
	{ L"20030219:230534", L"9000, 39713, RADIOLINJA" },
	{ L"20030219:230552", L"9000, 495, RADIOLINJA" },
	{ L"20030219:230738", L"9000, 495, RADIOLINJA" },
	{ L"20030219:230740", L"9000, 495, RADIOLINJA" },
	{ L"20030219:230813", L"9000, 503, RADIOLINJA" },
	{ L"20030219:230837", L"9000, 62110, RADIOLINJA" },
	{ L"20030219:231028", L"9000, 62110, RADIOLINJA" },
	{ L"20030219:231058", L"9000, 62110, RADIOLINJA" },
	{ L"20030219:231122", L"9000, 62110, RADIOLINJA" },
	{ L"20030219:231123", L"9000, 62110, RADIOLINJA" },
	{ L"20030219:231131", L"9000, 62111, RADIOLINJA" },
	{ L"20030219:231210", L"9000, 179, RADIOLINJA" },
	{ L"20030219:231506", L"9000, 178, RADIOLINJA" },
	{ L"20030219:231522", L"9000, 179, RADIOLINJA" },
	{ L"20030219:231522", L"SWITCH" },
	{ L"20030220:092935", L"9000, 179, RADIOLINJA" },
	{ L"20030220:092957", L"9000, 178, RADIOLINJA" },
	{ L"20030220:093010", L"9000, 179, RADIOLINJA" },
	{ L"20030220:095228", L"9000, 62112, RADIOLINJA" },
	{ L"20030220:095307", L"9000, 9814, RADIOLINJA" },
	{ L"20030220:095606", L"9000, 35600, RADIOLINJA" },
	{ L"20030220:095653", L"9000, 42335, RADIOLINJA" },
	{ L"20030220:095839", L"9000, 62105, RADIOLINJA" },
	{ L"20030220:095930", L"9000, 15164, RADIOLINJA" },
	{ L"20030220:095941", L"9000, 42336, RADIOLINJA" },
	{ L"20030220:095952", L"9000, 4402, RADIOLINJA" },
	{ L"20030220:100236", L"9000, 15276, RADIOLINJA" },
	{ L"20030220:100412", L"9000, 260, RADIOLINJA" },
	{ L"20030220:100503", L"9000, 15276, RADIOLINJA" },
	{ L"20030220:100520", L"9000, 396, RADIOLINJA" },
	{ L"20030220:100532", L"9000, 188, RADIOLINJA" },
	{ L"20030220:100704", L"9000, 440, RADIOLINJA" },
	{ L"20030220:100716", L"9000, 62019, RADIOLINJA" },
	{ L"20030220:100757", L"9000, 62018, RADIOLINJA" },
	{ L"20030220:100807", L"9000, 62017, RADIOLINJA" },
	{ L"20030220:100838", L"9000, 15128, RADIOLINJA" },
	{ L"20030220:101102", L"9000, 144, RADIOLINJA" },
	{ L"20030220:101143", L"9006, 67, RADIOLINJA" },
	{ L"20030220:101209", L"9006, 217, RADIOLINJA" },
	{ L"20030220:101225", L"9006, 511, RADIOLINJA" },
	{ L"20030220:101239", L"9006, 217, RADIOLINJA" },
	{ L"20030220:101304", L"9006, 15300, RADIOLINJA" },
	{ L"20030220:101422", L"9006, 4280, RADIOLINJA" },
	{ L"20030220:101438", L"9006, 15300, RADIOLINJA" },
	{ L"20030220:101618", L"9006, 62067, RADIOLINJA" },
	{ L"20030220:101635", L"9006, 38583, RADIOLINJA" },
	{ L"20030220:101705", L"9006, 376, RADIOLINJA" },
	{ L"20030220:101922", L"9006, 18, RADIOLINJA" },
	{ L"20030220:101941", L"9006, 376, RADIOLINJA" },
	{ L"20030220:102009", L"9006, 18, RADIOLINJA" },
	{ L"20030220:102034", L"9006, 399, RADIOLINJA" },
	{ L"20030220:102053", L"9006, 62032, RADIOLINJA" },
	{ L"20030220:102113", L"9006, 399, RADIOLINJA" },
	{ L"20030220:102153", L"9006, 376, RADIOLINJA" },
	{ L"20030220:102223", L"9006, 399, RADIOLINJA" },
	{ L"20030220:110337", L"9006, 18, RADIOLINJA" },
	{ L"20030220:110403", L"9006, 399, RADIOLINJA" },
	{ L"20030220:110459", L"9006, 376, RADIOLINJA" },
	{ L"20030220:110515", L"9006, 399, RADIOLINJA" },
	{ L"20030220:110805", L"9006, 376, RADIOLINJA" },
	{ L"20030220:110834", L"9006, 399, RADIOLINJA" },
	{ L"20030220:111030", L"9006, 376, RADIOLINJA" },
	{ L"20030220:111206", L"9006, 399, RADIOLINJA" },
	{ L"20030220:111225", L"9006, 376, RADIOLINJA" },
	{ L"20030220:111238", L"9006, 18, RADIOLINJA" },
	{ L"20030220:111304", L"9006, 399, RADIOLINJA" },
	{ L"20030220:111321", L"9006, 18, RADIOLINJA" },
	{ L"20030220:111344", L"9006, 399, RADIOLINJA" },
	{ L"20030220:111554", L"9006, 376, RADIOLINJA" },
	{ L"20030220:111618", L"9006, 399, RADIOLINJA" },
	{ L"20030220:111643", L"9006, 18, RADIOLINJA" },
	{ L"20030220:111700", L"9006, 376, RADIOLINJA" },
	{ L"20030220:111716", L"9006, 18, RADIOLINJA" },
	{ L"20030220:111957", L"9006, 399, RADIOLINJA" },
	{ L"20030220:112025", L"9006, 18, RADIOLINJA" },
	{ L"20030220:112057", L"9006, 376, RADIOLINJA" },
	{ L"20030220:112113", L"9006, 399, RADIOLINJA" },
	{ L"20030220:112413", L"9006, 18, RADIOLINJA" },
	{ L"20030220:112450", L"9006, 399, RADIOLINJA" },
	{ L"20030220:113339", L"9006, 376, RADIOLINJA" },
	{ L"20030220:113403", L"9006, 399, RADIOLINJA" },
	{ L"20030220:114058", L"9006, 1493, RADIOLINJA" },
	{ L"20030220:114216", L"9006, 399, RADIOLINJA" },
	{ L"20030220:114245", L"9006, 1493, RADIOLINJA" },
	{ L"20030220:114302", L"9006, 399, RADIOLINJA" },
	{ L"20030220:114357", L"9006, 1493, RADIOLINJA" },
	{ L"20030220:114413", L"9006, 399, RADIOLINJA" },
	{ L"20030220:121133", L"9006, 376, RADIOLINJA" },
	{ L"20030220:121142", L"9006, 399, RADIOLINJA" },
	{ L"20030220:121157", L"9006, 376, RADIOLINJA" },
	{ L"20030220:121430", L"9006, 399, RADIOLINJA" },
	{ L"20030220:121458", L"9006, 376, RADIOLINJA" },
	{ L"20030220:121517", L"9006, 399, RADIOLINJA" },
	{ L"20030220:121551", L"9006, 376, RADIOLINJA" },
	{ L"20030220:121613", L"9006, 18, RADIOLINJA" },
	{ L"20030220:121653", L"9006, 62032, RADIOLINJA" },
	{ L"20030220:121728", L"9006, 18, RADIOLINJA" },
	{ L"20030220:121825", L"9006, 399, RADIOLINJA" },
	{ L"20030220:121904", L"9006, 376, RADIOLINJA" },
	{ L"20030220:123839", L"9006, 399, RADIOLINJA" },
	{ L"20030220:125407", L"9006, 376, RADIOLINJA" },
	{ L"20030220:125741", L"9006, 399, RADIOLINJA" },
	{ L"20030220:125920", L"9006, 18, RADIOLINJA" },
	{ L"20030220:130025", L"9006, 399, RADIOLINJA" },
	{ L"20030220:130039", L"9006, 18, RADIOLINJA" },
	{ L"20030220:130508", L"9006, 62032, RADIOLINJA" },
	{ L"20030220:131018", L"9006, 18, RADIOLINJA" },
	{ L"20030220:131101", L"9006, 399, RADIOLINJA" },
	{ L"20030220:131143", L"9006, 376, RADIOLINJA" },
	{ L"20030220:131201", L"9006, 399, RADIOLINJA" },
	{ L"20030220:131516", L"9006, 18, RADIOLINJA" },
	{ L"20030220:132258", L"9006, 376, RADIOLINJA" },
	{ L"20030220:132321", L"9006, 18, RADIOLINJA" },
	{ L"20030220:132336", L"9006, 376, RADIOLINJA" },
	{ L"20030220:132801", L"9006, 18, RADIOLINJA" },
	{ L"20030220:133303", L"9006, 62032, RADIOLINJA" },
	{ L"20030220:133419", L"9006, 18, RADIOLINJA" },
	{ L"20030220:133522", L"9006, 62032, RADIOLINJA" },
	{ L"20030220:133541", L"9006, 399, RADIOLINJA" },
	{ L"20030220:133603", L"9006, 18, RADIOLINJA" },
	{ L"20030220:133614", L"9006, 399, RADIOLINJA" },
	{ L"20030220:133723", L"9006, 18, RADIOLINJA" },
	{ L"20030220:133733", L"9006, 376, RADIOLINJA" },
	{ L"20030220:133752", L"9006, 18, RADIOLINJA" },
	{ L"20030220:133816", L"9006, 376, RADIOLINJA" },
	{ L"20030220:133833", L"9006, 15306, RADIOLINJA" },
	{ L"20030220:133843", L"9006, 18, RADIOLINJA" },
	{ L"20030220:134008", L"9006, 376, RADIOLINJA" },
	{ L"20030220:134047", L"9006, 18, RADIOLINJA" },
	{ L"20030220:134105", L"9006, 62032, RADIOLINJA" },
	{ L"20030220:134121", L"9006, 18, RADIOLINJA" },
	{ L"20030220:134814", L"9006, 62032, RADIOLINJA" },
	{ L"20030220:134830", L"9006, 18, RADIOLINJA" },
	{ L"20030220:135908", L"9006, 376, RADIOLINJA" },
	{ L"20030220:135937", L"9006, 18, RADIOLINJA" },
	{ L"20030220:140009", L"9006, 376, RADIOLINJA" },
	{ L"20030220:140035", L"9006, 18, RADIOLINJA" },
	{ L"20030220:140141", L"9006, 376, RADIOLINJA" },
	{ L"20030220:140154", L"9006, 399, RADIOLINJA" },
	{ L"20030220:142651", L"9006, 18, RADIOLINJA" },
	{ L"20030220:142706", L"9006, 62032, RADIOLINJA" },
	{ L"20030220:142717", L"9006, 4707, RADIOLINJA" },
	{ L"20030220:142732", L"9006, 18, RADIOLINJA" },
	{ L"20030220:142743", L"9006, 399, RADIOLINJA" },
	{ L"20030220:163515", L"9006, 1493, RADIOLINJA" },
	{ L"20030220:163531", L"9006, 399, RADIOLINJA" },
	{ L"20030220:164147", L"9006, 376, RADIOLINJA" },
	{ L"20030220:164204", L"9006, 399, RADIOLINJA" },
	{ L"20030220:165517", L"9006, 62032, RADIOLINJA" },
	{ L"20030220:165525", L"9006, 18, RADIOLINJA" },
	{ L"20030220:165535", L"9006, 376, RADIOLINJA" },
	{ L"20030220:165559", L"9006, 38583, RADIOLINJA" },
	{ L"20030220:165757", L"9006, 62067, RADIOLINJA" },
	{ L"20030220:165810", L"9006, 15300, RADIOLINJA" },
	{ L"20030220:170222", L"9006, 62067, RADIOLINJA" },
	{ L"20030220:170306", L"9006, 15300, RADIOLINJA" },
	{ L"20030220:170430", L"9006, 35265, RADIOLINJA" },
	{ L"20030220:171428", L"9006, 15300, RADIOLINJA" },
	{ L"20030220:171459", L"9006, 35265, RADIOLINJA" },
	{ L"20030220:171613", L"9006, 15300, RADIOLINJA" },
	{ L"20030220:171735", L"9006, 35265, RADIOLINJA" },
	{ L"20030220:171815", L"9006, 15300, RADIOLINJA" },
	{ L"20030220:171837", L"9006, 35265, RADIOLINJA" },
	{ L"20030220:171853", L"9006, 15300, RADIOLINJA" },
	{ L"20030220:172247", L"9006, 35265, RADIOLINJA" },
	{ L"20030220:172551", L"9006, 15300, RADIOLINJA" },
	{ L"20030220:172551", L"SWITCH" },
	{ L"20030220:173342", L"9006, 15300, RADIOLINJA" },
	{ L"20030220:173427", L"9006, 62067, RADIOLINJA" },
	{ L"20030220:173523", L"9006, 15300, RADIOLINJA" },
	{ L"20030220:173658", L"9006, 376, RADIOLINJA" },
	{ L"20030220:173714", L"9006, 38583, RADIOLINJA" },
	{ L"20030220:173723", L"9006, 376, RADIOLINJA" },
	{ L"20030220:173949", L"9006, 18, RADIOLINJA" },
	{ L"20030220:174211", L"9006, 399, RADIOLINJA" },
	{ L"20030220:174605", L"9006, 1493, RADIOLINJA" },
	{ L"20030220:174625", L"9006, 399, RADIOLINJA" },
	{ L"20030220:174650", L"9006, 1493, RADIOLINJA" },
	{ L"20030220:174823", L"9006, 601, RADIOLINJA" },
	{ L"20030220:174858", L"9006, 1493, RADIOLINJA" },
	{ L"20030220:174934", L"9006, 550, RADIOLINJA" },
	{ L"20030220:175051", L"9006, 38583, RADIOLINJA" },
	{ L"20030220:175151", L"9006, 232, RADIOLINJA" },
	{ L"20030220:175238", L"9006, 233, RADIOLINJA" },
	{ L"20030220:175251", L"9006, 232, RADIOLINJA" },
	{ L"20030220:175307", L"9006, 233, RADIOLINJA" },
	{ L"20030220:175334", L"9006, 3900, RADIOLINJA" },
	{ L"20030220:175426", L"9006, 511, RADIOLINJA" },
	{ L"20030220:175505", L"9006, 67, RADIOLINJA" },
	{ L"20030220:175645", L"9000, 15128, RADIOLINJA" },
	{ L"20030220:175729", L"9000, 62017, RADIOLINJA" },
	{ L"20030220:175738", L"9000, 35781, RADIOLINJA" },
	{ L"20030220:175759", L"9000, 168, RADIOLINJA" },
	{ L"20030220:175810", L"9000, 62019, RADIOLINJA" },
	{ L"20030220:175832", L"9000, 168, RADIOLINJA" },
	{ L"20030220:175849", L"9000, 62019, RADIOLINJA" },
	{ L"20030220:175903", L"9000, 440, RADIOLINJA" },
	{ L"20030220:175925", L"9000, 4373, RADIOLINJA" },
	{ L"20030220:175934", L"9000, 188, RADIOLINJA" },
	{ L"20030220:180259", L"9000, 215, RADIOLINJA" },
	{ L"20030220:180818", L"9000, 316, RADIOLINJA" },
	{ L"20030220:181915", L"9000, 215, RADIOLINJA" },
	{ L"20030220:183253", L"9000, 316, RADIOLINJA" },
	{ L"20030220:183459", L"9000, 15276, RADIOLINJA" },
	{ L"20030220:183512", L"9000, 316, RADIOLINJA" },
	{ L"20030220:183522", L"9000, 15276, RADIOLINJA" },
	{ L"20030220:183539", L"9000, 316, RADIOLINJA" },
	{ L"20030220:184121", L"9000, 15276, RADIOLINJA" },
	{ L"20030220:184201", L"9000, 316, RADIOLINJA" },
	{ L"20030220:184234", L"9000, 215, RADIOLINJA" },
	{ L"20030220:184904", L"9000, 316, RADIOLINJA" },
	{ L"20030220:185112", L"9000, 15276, RADIOLINJA" },
	{ L"20030220:185252", L"9000, 316, RADIOLINJA" },
	{ L"20030220:185303", L"9000, 15276, RADIOLINJA" },
	{ L"20030220:185454", L"9000, 316, RADIOLINJA" },
	{ L"20030220:185604", L"9000, 15276, RADIOLINJA" },
	{ L"20030220:185621", L"9000, 316, RADIOLINJA" },
	{ L"20030220:185855", L"9000, 215, RADIOLINJA" },
	{ L"20030220:190003", L"9000, 62098, RADIOLINJA" },
	{ L"20030220:190017", L"9000, 316, RADIOLINJA" },
	{ L"20030220:192213", L"9000, 15266, RADIOLINJA" },
	{ L"20030220:192242", L"9000, 316, RADIOLINJA" },
	{ L"20030220:192903", L"9000, 215, RADIOLINJA" },
	{ L"20030220:192957", L"9000, 62098, RADIOLINJA" },
	{ L"20030220:193038", L"9000, 215, RADIOLINJA" },
	{ L"20030220:193129", L"9000, 62098, RADIOLINJA" },
	{ L"20030220:193203", L"9000, 215, RADIOLINJA" },
	{ L"20030220:193339", L"9000, 62098, RADIOLINJA" },
	{ L"20030220:193356", L"9000, 215, RADIOLINJA" },
	{ L"20030220:193609", L"9000, 62098, RADIOLINJA" },
	{ L"20030220:193645", L"9000, 215, RADIOLINJA" },
	{ L"20030220:193717", L"9000, 62098, RADIOLINJA" },
	{ L"20030220:193838", L"9000, 215, RADIOLINJA" },
	{ L"20030220:193929", L"9000, 188, RADIOLINJA" },
	{ L"20030220:193939", L"9000, 215, RADIOLINJA" },
	{ L"20030220:194048", L"9000, 62993, RADIOLINJA" },
	{ L"20030220:194109", L"9000, 215, RADIOLINJA" },
	{ L"20030220:194124", L"9000, 62993, RADIOLINJA" },
	{ L"20030220:194736", L"9000, 199, RADIOLINJA" },
	{ L"20030220:194746", L"9000, 62993, RADIOLINJA" },
	{ L"20030220:194810", L"9000, 62462, RADIOLINJA" },
	{ L"20030220:194825", L"9000, 199, RADIOLINJA" },
	{ L"20030220:194840", L"9000, 39713, RADIOLINJA" },
	{ L"20030220:195007", L"9000, 495, RADIOLINJA" },
	{ L"20030220:195230", L"9000, 503, RADIOLINJA" },
	{ L"20030220:195252", L"9000, 62110, RADIOLINJA" },
	{ L"20030220:195418", L"9000, 62112, RADIOLINJA" },
	{ L"20030220:195434", L"9000, 62116, RADIOLINJA" },
	{ L"20030220:195449", L"9000, 62112, RADIOLINJA" },
	{ L"20030220:195537", L"9000, 9814, RADIOLINJA" },
	{ L"20030220:195558", L"9000, 179, RADIOLINJA" },
	{ L"20030220:195607", L"9000, 62111, RADIOLINJA" },
	{ L"20030220:195627", L"9000, 179, RADIOLINJA" },
	{ L"20030220:200354", L"9000, 178, RADIOLINJA" },
	{ L"20030220:200404", L"9000, 179, RADIOLINJA" },
	{ L"20030220:200857", L"9000, 178, RADIOLINJA" },
	{ L"20030220:200944", L"9000, 179, RADIOLINJA" },
	{ L"20030220:201048", L"9000, 178, RADIOLINJA" },
	{ L"20030220:201113", L"9000, 179, RADIOLINJA" },
	{ L"20030220:201205", L"9000, 178, RADIOLINJA" },
	{ L"20030220:201215", L"9000, 179, RADIOLINJA" },
	{ L"20030220:202410", L"9000, 178, RADIOLINJA" },
	{ L"20030220:202449", L"9000, 179, RADIOLINJA" },
	{ L"20030220:202525", L"9000, 178, RADIOLINJA" },
	{ L"20030220:202704", L"9000, 179, RADIOLINJA" },
	{ L"20030220:202721", L"9000, 178, RADIOLINJA" },
	{ L"20030220:202737", L"9000, 179, RADIOLINJA" },
	{ L"20030220:204901", L"9000, 62112, RADIOLINJA" },
	{ L"20030220:204927", L"9000, 62110, RADIOLINJA" },
	{ L"20030220:204940", L"9000, 62111, RADIOLINJA" },
	{ L"20030220:204951", L"9000, 9814, RADIOLINJA" },
	{ L"20030220:205807", L"9000, 179, RADIOLINJA" },
	{ L"20030220:205816", L"9000, 62111, RADIOLINJA" },
	{ L"20030220:205833", L"9000, 179, RADIOLINJA" },
	{ L"20030220:211648", L"9000, 62111, RADIOLINJA" },
	{ L"20030220:211720", L"9000, 179, RADIOLINJA" },
	{ L"20030220:214515", L"9000, 62111, RADIOLINJA" },
	{ L"20030220:214541", L"9000, 179, RADIOLINJA" },
	{ L"20030220:214732", L"9000, 9814, RADIOLINJA" },
	{ L"20030220:214750", L"9000, 179, RADIOLINJA" },
	{ L"20030220:214807", L"9000, 9814, RADIOLINJA" },
	{ L"20030220:214823", L"9000, 179, RADIOLINJA" },
	{ L"20030220:214856", L"9000, 178, RADIOLINJA" },
	{ L"20030220:214917", L"9000, 179, RADIOLINJA" },
	{ L"20030220:215548", L"9000, 178, RADIOLINJA" },
	{ L"20030220:215639", L"9000, 179, RADIOLINJA" },
	{ L"20030220:221715", L"9000, 178, RADIOLINJA" },
	{ L"20030220:221725", L"9000, 179, RADIOLINJA" },
	{ L"20030220:221735", L"9000, 179, RADIOLINJA" },
	{ L"20030220:222223", L"9000, 179, RADIOLINJA" },
	{ L"20030220:222831", L"9000, 62111, RADIOLINJA" },
	{ L"20030220:223122", L"9000, 179, RADIOLINJA" },
	{ L"20030220:223436", L"9000, 62111, RADIOLINJA" },
	{ L"20030220:223450", L"9000, 179, RADIOLINJA" },
	{ L"20030220:230214", L"9000, 178, RADIOLINJA" },
	{ L"20030220:230258", L"9000, 179, RADIOLINJA" },
	{ L"20030220:230315", L"9000, 178, RADIOLINJA" },
	{ L"20030220:230354", L"9000, 179, RADIOLINJA" },
	{ L"20030220:230410", L"9000, 178, RADIOLINJA" },
	{ L"20030220:230458", L"9000, 179, RADIOLINJA" },
	{ L"20030220:230538", L"9000, 178, RADIOLINJA" },
	{ L"20030220:230643", L"9000, 179, RADIOLINJA" },
	{ L"20030221:001124", L"9000, 62111, RADIOLINJA" },
	{ L"20030221:001137", L"9000, 179, RADIOLINJA" },
	{ L"20030221:052056", L"9000, 179, RADIOLINJA" },
	{ L"20030221:090616", L"9000, 179, RADIOLINJA" },
	{ L"20030221:091742", L"9000, 62111, RADIOLINJA" },
	{ L"20030221:091838", L"9000, 179, RADIOLINJA" },
	{ L"20030221:091854", L"9000, 178, RADIOLINJA" },
	{ L"20030221:091958", L"9000, 179, RADIOLINJA" },
	{ L"20030221:092018", L"9000, 62111, RADIOLINJA" },
	{ L"20030221:092054", L"9000, 179, RADIOLINJA" },
	{ L"20030221:093006", L"9000, 178, RADIOLINJA" },
	{ L"20030221:093021", L"9000, 179, RADIOLINJA" },
	{ L"20030221:093159", L"9000, 62111, RADIOLINJA" },
	{ L"20030221:093216", L"9000, 179, RADIOLINJA" },
	{ L"20030221:094031", L"9000, 178, RADIOLINJA" },
	{ L"20030221:094041", L"9000, 179, RADIOLINJA" },
	{ L"20030221:094632", L"9000, 62112, RADIOLINJA" },
	{ L"20030221:094708", L"9000, 62110, RADIOLINJA" },
	{ L"20030221:094929", L"9000, 62112, RADIOLINJA" },
	{ L"20030221:094938", L"9000, 62116, RADIOLINJA" },
	{ L"20030221:094958", L"9000, 62112, RADIOLINJA" },
	{ L"20030221:095027", L"9000, 62110, RADIOLINJA" },
	{ L"20030221:095129", L"9000, 503, RADIOLINJA" },
	{ L"20030221:095244", L"9000, 62110, RADIOLINJA" },
	{ L"20030221:095300", L"9000, 503, RADIOLINJA" },
	{ L"20030221:095327", L"9000, 495, RADIOLINJA" },
	{ L"20030221:095625", L"9000, 62462, RADIOLINJA" },
	{ L"20030221:095644", L"9000, 35302, RADIOLINJA" },
	{ L"20030221:095703", L"9000, 167, RADIOLINJA" },
	{ L"20030221:095712", L"9000, 199, RADIOLINJA" },
	{ L"20030221:095724", L"9000, 62993, RADIOLINJA" },
	{ L"20030221:095826", L"9000, 215, RADIOLINJA" },
	{ L"20030221:095924", L"9000, 15276, RADIOLINJA" },
	{ L"20030221:100001", L"9000, 396, RADIOLINJA" },
	{ L"20030221:100226", L"9000, 62035, RADIOLINJA" },
	{ L"20030221:100406", L"9000, 396, RADIOLINJA" },
	{ L"20030221:100435", L"9000, 622, RADIOLINJA" },
	{ L"20030221:100510", L"9000, 363, RADIOLINJA" },
	{ L"20030221:102439", L"9000, 62035, RADIOLINJA" },
	{ L"20030221:102448", L"9000, 622, RADIOLINJA" },
	{ L"20030221:102457", L"9000, 62035, RADIOLINJA" },
	{ L"20030221:102937", L"9000, 62034, RADIOLINJA" },
	{ L"20030221:103156", L"9000, 35769, RADIOLINJA" },
	{ L"20030221:103253", L"9006, 62054, RADIOLINJA" },
	{ L"20030221:103315", L"9006, 354, RADIOLINJA" },
	{ L"20030221:103418", L"9006, 40943, RADIOLINJA" },
	{ L"20030221:103453", L"9006, 15158, RADIOLINJA" },
	{ L"20030221:103536", L"9006, 86, RADIOLINJA" },
	{ L"20030221:103719", L"9007, 35764, RADIOLINJA" },
	{ L"20030221:103751", L"9007, 35765, RADIOLINJA" },
	{ L"20030221:103800", L"9007, 9813, RADIOLINJA" },
	{ L"20030221:103817", L"9007, 35765, RADIOLINJA" },
	{ L"20030221:103838", L"9007, 35596, RADIOLINJA" },
	{ L"20030221:103859", L"9007, 57, RADIOLINJA" },
	{ L"20030221:103956", L"9007, 510, RADIOLINJA" },
	{ L"20030221:104043", L"9007, 62047, RADIOLINJA" },
	{ L"20030221:104131", L"9007, 39495, RADIOLINJA" },
	{ L"20030221:104156", L"9007, 62046, RADIOLINJA" },
	{ L"20030221:104225", L"9007, 40322, RADIOLINJA" },
	{ L"20030221:104236", L"9007, 56, RADIOLINJA" },
	{ L"20030221:104257", L"9007, 62049, RADIOLINJA" },
	{ L"20030221:104431", L"9007, 38247, RADIOLINJA" },
	{ L"20030221:104456", L"9007, 62048, RADIOLINJA" },
	{ L"20030221:104516", L"9007, 38247, RADIOLINJA" },
	{ L"20030221:104532", L"9007, 15374, RADIOLINJA" },
	{ L"20030221:104600", L"9121, 4471, RADIOLINJA" },
	{ L"20030221:104634", L"9121, 62024, RADIOLINJA" },
	{ L"20030221:104650", L"9121, 279, RADIOLINJA" },
	{ L"20030221:104705", L"9121, 15228, RADIOLINJA" },
	{ L"20030221:104721", L"9121, 35273, RADIOLINJA" },
	{ L"20030221:104804", L"9121, 15403, RADIOLINJA" },
	{ L"20030221:104815", L"9121, 9900, RADIOLINJA" },
	{ L"20030221:104836", L"9121, 312, RADIOLINJA" },
	{ L"20030221:104910", L"9121, 39353, RADIOLINJA" },
	{ L"20030221:104945", L"9121, 39354, RADIOLINJA" },
	{ L"20030221:105017", L"9121, 45, RADIOLINJA" },
	{ L"20030221:105245", L"9121, 46, RADIOLINJA" },
	{ L"20030221:105319", L"9121, 44, RADIOLINJA" },
	{ L"20030221:105328", L"9121, 35277, RADIOLINJA" },
	{ L"20030221:105407", L"9121, 42010, RADIOLINJA" },
	{ L"20030221:105418", L"9121, 41457, RADIOLINJA" },
	{ L"20030221:105509", L"9140, 530, RADIOLINJA" },
	{ L"20030221:105621", L"9140, 51, RADIOLINJA" },
	{ L"20030221:105800", L"9140, 41142, RADIOLINJA" },
	{ L"20030221:105815", L"9140, 3634, RADIOLINJA" },
	{ L"20030221:105942", L"9140, 457, RADIOLINJA" },
	{ L"20030221:105957", L"9140, 41458, RADIOLINJA" },
	{ L"20030221:110017", L"9140, 457, RADIOLINJA" },
	{ L"20030221:110049", L"9140, 52, RADIOLINJA" },
	{ L"20030221:110150", L"9140, 15106, RADIOLINJA" },
	{ L"20030221:110326", L"9140, 513, RADIOLINJA" },
	{ L"20030221:110358", L"9140, 15106, RADIOLINJA" },
	{ L"20030221:110407", L"9140, 513, RADIOLINJA" },
	{ L"20030221:110459", L"9140, 15250, RADIOLINJA" },
	{ L"20030221:110507", L"9140, 513, RADIOLINJA" },
	{ L"20030221:110526", L"9140, 15250, RADIOLINJA" },
	{ L"20030221:110546", L"9140, 4696, RADIOLINJA" },
	{ L"20030221:110618", L"9140, 15250, RADIOLINJA" },
	{ L"20030221:110638", L"9140, 115, RADIOLINJA" },
	{ L"20030221:110648", L"9140, 15250, RADIOLINJA" },
	{ L"20030221:110727", L"9140, 4696, RADIOLINJA" },
	{ L"20030221:110752", L"9140, 15250, RADIOLINJA" },
	{ L"20030221:110857", L"9140, 15172, RADIOLINJA" },
	{ L"20030221:110922", L"9140, 4696, RADIOLINJA" },
	{ L"20030221:111003", L"9140, 762, RADIOLINJA" },
	{ L"20030221:111053", L"9140, 9822, RADIOLINJA" },
	{ L"20030221:111207", L"9140, 9823, RADIOLINJA" },
	{ L"20030221:111316", L"9140, 92, RADIOLINJA" },
	{ L"20030221:111332", L"9140, 9823, RADIOLINJA" },
	{ L"20030221:111403", L"9140, 92, RADIOLINJA" },
	{ L"20030221:111443", L"9140, 9823, RADIOLINJA" },
	{ L"20030221:111503", L"9140, 92, RADIOLINJA" },
	{ L"20030221:111606", L"9140, 36602, RADIOLINJA" },
	{ L"20030221:111628", L"9140, 173, RADIOLINJA" },
	{ L"20030221:111750", L"9140, 173, RADIOLINJA" },
	{ L"20030221:111753", L"9140, 91, RADIOLINJA" },
	{ L"20030221:111755", L"9140, 91, RADIOLINJA" },
	{ L"20030221:111842", L"9140, 91, RADIOLINJA" },
	{ L"20030221:111857", L"9140, 91, RADIOLINJA" },
	{ L"20030221:111857", L"9140, 91, RADIOLINJA" },
	{ L"20030221:111924", L"9140, 461, RADIOLINJA" },
	{ L"20030221:112251", L"9140, 36033, RADIOLINJA" },
	{ L"20030221:112335", L"9140, 40532, RADIOLINJA" },
	{ L"20030221:112356", L"9140, 36033, RADIOLINJA" },
	{ L"20030221:112411", L"9140, 36032, RADIOLINJA" },
	{ L"20030221:112443", L"9140, 15183, RADIOLINJA" },
	{ L"20030221:112502", L"9140, 36032, RADIOLINJA" },
	{ L"20030221:112535", L"9140, 15183, RADIOLINJA" },
	{ L"20030221:112655", L"9140, 15159, RADIOLINJA" },
	{ L"20030221:113031", L"9140, 111, RADIOLINJA" },
	{ L"20030221:113203", L"9140, 37753, RADIOLINJA" },
	{ L"20030221:113220", L"9140, 36032, RADIOLINJA" },
	{ L"20030221:113257", L"9140, 37753, RADIOLINJA" },
	{ L"20030221:113306", L"9140, 795, RADIOLINJA" },
	{ L"20030221:113348", L"9140, 84, RADIOLINJA" },
	{ L"20030221:113542", L"9140, 37753, RADIOLINJA" },
	{ L"20030221:113602", L"9140, 264, RADIOLINJA" },
	{ L"20030221:113815", L"9140, 540, RADIOLINJA" },
	{ L"20030221:114243", L"9140, 88, RADIOLINJA" },
	{ L"20030221:114402", L"9140, 37216, RADIOLINJA" },
	{ L"20030221:114443", L"3700, 30186, RADIOLINJA" },
	{ L"20030221:114604", L"3700, 3434, RADIOLINJA" },
	{ L"20030221:114637", L"3700, 30186, RADIOLINJA" },
	{ L"20030221:114809", L"3700, 2274, RADIOLINJA" },
	{ L"20030221:114825", L"3700, 30186, RADIOLINJA" },
	{ L"20030221:114834", L"3700, 2274, RADIOLINJA" },
	{ L"20030221:115044", L"3700, 1227, RADIOLINJA" },
	{ L"20030221:115213", L"3700, 30180, RADIOLINJA" },
	{ L"20030221:115230", L"3700, 30180, RADIOLINJA" },
	{ L"20030221:115239", L"3700, 30180, RADIOLINJA" },
	{ L"20030221:115520", L"3700, 40775, RADIOLINJA" },
	{ L"20030221:115644", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:115818", L"3700, 37534, RADIOLINJA" },
	{ L"20030221:115853", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:115901", L"3700, 37533, RADIOLINJA" },
	{ L"20030221:115915", L"3700, 36317, RADIOLINJA" },
	{ L"20030221:115925", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:115941", L"3700, 36317, RADIOLINJA" },
	{ L"20030221:120034", L"3700, 38636, RADIOLINJA" },
	{ L"20030221:120047", L"3700, 36317, RADIOLINJA" },
	{ L"20030221:120229", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:120251", L"3700, 30181, RADIOLINJA" },
	{ L"20030221:120817", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:120853", L"3700, 30181, RADIOLINJA" },
	{ L"20030221:120917", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:121019", L"3700, 37527, RADIOLINJA" },
	{ L"20030221:121029", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:121416", L"3700, 37527, RADIOLINJA" },
	{ L"20030221:121435", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:121515", L"3700, 37527, RADIOLINJA" },
	{ L"20030221:121604", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:121706", L"3700, 37527, RADIOLINJA" },
	{ L"20030221:121721", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:121736", L"3700, 37527, RADIOLINJA" },
	{ L"20030221:121851", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:121923", L"3700, 37527, RADIOLINJA" },
	{ L"20030221:121959", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:122008", L"3700, 37527, RADIOLINJA" },
	{ L"20030221:122029", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:122044", L"3700, 37527, RADIOLINJA" },
	{ L"20030221:122101", L"3700, 4547, RADIOLINJA" },
	{ L"20030221:122146", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:122210", L"3700, 4547, RADIOLINJA" },
	{ L"20030221:122304", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:122513", L"3700, 37527, RADIOLINJA" },
	{ L"20030221:122530", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:122545", L"3700, 37527, RADIOLINJA" },
	{ L"20030221:122554", L"3700, 4547, RADIOLINJA" },
	{ L"20030221:122610", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:122639", L"3700, 37527, RADIOLINJA" },
	{ L"20030221:122708", L"3700, 38635, RADIOLINJA" },
	{ L"20030221:122746", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:122801", L"3700, 38635, RADIOLINJA" },
	{ L"20030221:122912", L"3700, 37527, RADIOLINJA" },
	{ L"20030221:122926", L"3700, 38635, RADIOLINJA" },
	{ L"20030221:123043", L"3700, 37527, RADIOLINJA" },
	{ L"20030221:123151", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:123207", L"3700, 37527, RADIOLINJA" },
	{ L"20030221:123319", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:123334", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:123407", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:123436", L"3700, 37527, RADIOLINJA" },
	{ L"20030221:123445", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:123545", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:123559", L"3700, 37527, RADIOLINJA" },
	{ L"20030221:123624", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:123644", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:123709", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:123816", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:123842", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:123927", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:130024", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:130110", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:130110", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:130110", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:130125", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:130135", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:130152", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:130256", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:130305", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:130423", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:130442", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:130443", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:130525", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:130535", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:130535", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:130720", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:130721", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:130721", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:130925", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:130931", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:131200", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:131214", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:131855", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:131905", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:131905", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:132310", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:132434", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:132639", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:132655", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:133655", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:133718", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:133921", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:133933", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:140458", L"3700, 3296, RADIOLINJA" },
	{ L"20030221:140507", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:141658", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:141706", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:141908", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:141958", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:142050", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:142103", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:150843", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:150844", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:151007", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:151008", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:151047", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:151048", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:152717", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:152724", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:153712", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:153714", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:154207", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:154214", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:154214", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:154229", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:154231", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:154305", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:154307", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:155304", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:155309", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:155330", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:155339", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:155716", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:155717", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:155951", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:160001", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:160001", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:162916", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:162921", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:162921", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:175452", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:175516", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:175601", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:175618", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:175634", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:175754", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:175804", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:175852", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:175917", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:175956", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:180440", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:180444", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:180454", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:180533", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:180604", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:180618", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:180618", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:180643", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:180722", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:180748", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:180755", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:180837", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:180915", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:180915", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:180931", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:180940", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:181003", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:181004", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:181246", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:181259", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:181259", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:185826", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:185846", L"3700, 1214, RADIOLINJA" },
	{ L"20030221:190411", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:190619", L"3700, 30182, RADIOLINJA" },
	{ L"20030221:190659", L"3700, 30181, RADIOLINJA" },
	{ L"20030221:190756", L"3700, 2146, RADIOLINJA" },
	{ L"20030221:190835", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:191128", L"3700, 30006, RADIOLINJA" },
	{ L"20030221:191140", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:191219", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:191247", L"3700, 3406, RADIOLINJA" },
	{ L"20030221:191332", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:191505", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:191520", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:191552", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:191554", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:191931", L"3700, 1227, RADIOLINJA" },
	{ L"20030221:191943", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:191953", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:192001", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:192001", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:192050", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:192051", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:192052", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:192146", L"3700, 1227, RADIOLINJA" },
	{ L"20030221:192204", L"3700, 1227, RADIOLINJA" },
	{ L"20030221:192215", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:192215", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:192217", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:192349", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:192401", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:192401", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:192437", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:192452", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:192825", L"3700, 3406, RADIOLINJA" },
	{ L"20030221:192846", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:193052", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:193054", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:193121", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:193123", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:193442", L"3700, 1227, RADIOLINJA" },
	{ L"20030221:193451", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:193546", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:193547", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:193840", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:193850", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:194003", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:194024", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:194635", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:195153", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:195201", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:195444", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:195456", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:195949", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:200000", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:200954", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:200956", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:200956", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:201302", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:201303", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:201351", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:201355", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:201355", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:201535", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:201601", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:201619", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:201629", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:201629", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:201638", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:201656", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:201712", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:201951", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:201955", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:201956", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:202103", L"3700, 3406, RADIOLINJA" },
	{ L"20030221:202141", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:202301", L"3700, 3406, RADIOLINJA" },
	{ L"20030221:202421", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:202437", L"3700, 3406, RADIOLINJA" },
	{ L"20030221:202503", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:202503", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:202525", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:202617", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:202617", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:202718", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:202902", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:202918", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:202935", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:202935", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:203015", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:203015", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:203101", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:203101", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:203309", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:203309", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:203421", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:203421", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:203501", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:203501", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:203520", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:203520", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:203601", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:203601", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:203645", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:203645", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:203708", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:203737", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:203737", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:203809", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:203809", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:203830", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:203935", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:203959", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:204021", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:204031", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:204031", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:204139", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:204202", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:205310", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:205311", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:205311", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:205321", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:205321", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:205508", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:205510", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:205520", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:205525", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:205525", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:205820", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:205826", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:210524", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:210541", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:210559", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:210630", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:210730", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:210730", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:210748", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:210748", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:210803", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:210941", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:210951", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:210951", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:211007", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:211008", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:211116", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:211129", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:211129", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:211456", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:211515", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:211554", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:211559", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:212203", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:212207", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:212245", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:212248", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:213025", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:213036", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:213213", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:213213", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:213249", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:213250", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:213314", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:213721", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:213723", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:213732", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:213809", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:213823", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:213908", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:213958", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:213958", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:214030", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:214102", L"3700, 3406, RADIOLINJA" },
	{ L"20030221:214102", L"3700, 3406, RADIOLINJA" },
	{ L"20030221:214123", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:214823", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:214832", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:214934", L"3700, 3406, RADIOLINJA" },
	{ L"20030221:214951", L"3700, 3406, RADIOLINJA" },
	{ L"20030221:214957", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:215025", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:215130", L"3700, 3406, RADIOLINJA" },
	{ L"20030221:215148", L"3700, 3406, RADIOLINJA" },
	{ L"20030221:215154", L"3700, 3406, RADIOLINJA" },
	{ L"20030221:215154", L"3700, 3406, RADIOLINJA" },
	{ L"20030221:215208", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:215349", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:215359", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:220039", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:220055", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:221559", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:221601", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:221939", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:221950", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:223704", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:223714", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:223947", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:223947", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:224133", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:224134", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:224207", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:224207", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:224318", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:224318", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:224333", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:224333", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:224348", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:224429", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:224430", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:224556", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:224611", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:224752", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:224752", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:224834", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:224835", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:225102", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:225117", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:225308", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:225318", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:225802", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:225817", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:225951", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:230014", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:233519", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:233530", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:233632", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:233634", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:233634", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:233635", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:233827", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:233839", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:234124", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:234145", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:234157", L"3700, 2272, RADIOLINJA" },
	{ L"20030221:234227", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:234242", L"3700, 2272, RADIOLINJA" },
	{ L"20030221:234318", L"3700, 2272, RADIOLINJA" },
	{ L"20030221:234328", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:234328", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:234428", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:234446", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:234501", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:234518", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:234518", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:234559", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:234619", L"3700, 2272, RADIOLINJA" },
	{ L"20030221:234637", L"3700, 40773, RADIOLINJA" },
	{ L"20030221:234648", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:234703", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:234720", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:234818", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:234944", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:234959", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:235045", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:235113", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:235150", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:235205", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:235224", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:235300", L"3700, 30328, RADIOLINJA" },
	{ L"20030221:235358", L"3700, 3302, RADIOLINJA" },
	{ L"20030221:235417", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:000213", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:000223", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:000347", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:000416", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:000436", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:000538", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:000555", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:000635", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:000650", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:000713", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:000737", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:000815", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:000815", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:000955", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:000955", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:001029", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:001030", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:001139", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:001147", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:001148", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:001303", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:001446", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:001456", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:001613", L"3700, 1227, RADIOLINJA" },
	{ L"20030222:001629", L"3700, 3406, RADIOLINJA" },
	{ L"20030222:001646", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:002147", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:002217", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:002219", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:002238", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:002336", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:002336", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:002351", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:002417", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:002451", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:002617", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:002642", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:002735", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:002737", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:002756", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:002842", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:002843", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:002902", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:002904", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:002924", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:002932", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:002932", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:002934", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:002954", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:003006", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:003008", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:003021", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:003527", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:003527", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:003545", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:004055", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:004057", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:004108", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:004126", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:004143", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:004242", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:004257", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:004544", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:004616", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:004642", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:004657", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:004720", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:004735", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:004837", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:004852", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:005031", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:005031", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:005045", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:005046", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:005131", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:005429", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:005430", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:005508", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:005523", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:005539", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:005634", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:005636", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:005644", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:010020", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:010020", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:010022", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:010042", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:010134", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:010144", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:010247", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:010255", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:011455", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:011527", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:011537", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:011629", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:011711", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:011722", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:011722", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:011804", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:011822", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:011844", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:011918", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:012355", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:013000", L"3700, 1227, RADIOLINJA" },
	{ L"20030222:013055", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:013241", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:013242", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:013243", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:013305", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:013307", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:014403", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:014414", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:014520", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:014535", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:014723", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:014738", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:014753", L"3700, 1227, RADIOLINJA" },
	{ L"20030222:014833", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:014833", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:102323", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:102338", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:103108", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:103123", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:103719", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:103721", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:103722", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:104040", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:104057", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:104700", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:104710", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:104959", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:105037", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:105428", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:105500", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:105515", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:105532", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:105619", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:105740", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:105816", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:105924", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:110018", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:110033", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:110058", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:110113", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:110211", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:110317", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:110332", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:110412", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:110428", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:110516", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:110547", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:110809", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:110907", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:110931", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:110946", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:111020", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:111134", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:111310", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:111325", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:111351", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:111408", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:111508", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:111525", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:111608", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:111828", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:111934", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:112011", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:112914", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:112914", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:112914", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:112946", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:113010", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:113010", L"SWITCH" },
	{ L"20030222:125330", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:125333", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:125359", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:125535", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:125614", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:125702", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:125752", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:125824", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:125849", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:125928", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:125943", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:130004", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:130019", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:130051", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:130112", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:130259", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:130310", L"3700, 35377, RADIOLINJA" },
	{ L"20030222:130613", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:130622", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:130712", L"3700, 37533, RADIOLINJA" },
	{ L"20030222:130737", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:131207", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:131229", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:131250", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:131305", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:131649", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:131658", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:131815", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:131834", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:131851", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:131904", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:131940", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:132027", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:132305", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:132320", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:132335", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:132356", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:132428", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:132502", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:132517", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:132552", L"3700, 35377, RADIOLINJA" },
	{ L"20030222:132619", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:132736", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:132751", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:132802", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:133313", L"3700, 3406, RADIOLINJA" },
	{ L"20030222:133400", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:133450", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:133529", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:133559", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:134109", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:134119", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:134206", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:134206", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:134214", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:134215", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:134323", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:134339", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:134454", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:134455", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:134612", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:134613", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:134614", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:140122", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:140123", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:140142", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:140159", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:140214", L"3700, 3406, RADIOLINJA" },
	{ L"20030222:140346", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:140401", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:140435", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:140435", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:140435", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:140436", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:140500", L"3700, 30006, RADIOLINJA" },
	{ L"20030222:140507", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:140507", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:140508", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:140609", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:140619", L"3700, 40773, RADIOLINJA" },
	{ L"20030222:140702", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:140723", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:140843", L"3700, 3406, RADIOLINJA" },
	{ L"20030222:140909", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:140925", L"3700, 30328, RADIOLINJA" },
	{ L"20030222:141033", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:141306", L"3700, 37533, RADIOLINJA" },
	{ L"20030222:141320", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:141345", L"3700, 2146, RADIOLINJA" },
	{ L"20030222:141416", L"3700, 30181, RADIOLINJA" },
	{ L"20030222:141505", L"3700, 30182, RADIOLINJA" },
	{ L"20030222:141554", L"3700, 2146, RADIOLINJA" },
	{ L"20030222:141623", L"3700, 38636, RADIOLINJA" },
	{ L"20030222:141639", L"3700, 41020, RADIOLINJA" },
	{ L"20030222:141654", L"3700, 1214, RADIOLINJA" },
	{ L"20030222:141710", L"3700, 2146, RADIOLINJA" },
	{ L"20030222:141726", L"3700, 1214, RADIOLINJA" },
	{ L"20030222:143952", L"3700, 2146, RADIOLINJA" },
	{ L"20030222:144008", L"3700, 1214, RADIOLINJA" },
	{ L"20030222:144903", L"3700, 2146, RADIOLINJA" },
	{ L"20030222:145203", L"3700, 1214, RADIOLINJA" },
	{ L"20030222:155110", L"3700, 1214, RADIOLINJA" },
	{ L"20030222:155110", L"3700, 1214, RADIOLINJA" },
	{ L"20030222:155110", L"3700, 1214, RADIOLINJA" },
	{ L"20030222:161057", L"3700, 2146, RADIOLINJA" },
	{ L"20030222:161119", L"3700, 1214, RADIOLINJA" },
	{ L"20030222:161132", L"3700, 41020, RADIOLINJA" },
	{ L"20030222:161153", L"3700, 38636, RADIOLINJA" },
	{ L"20030222:161215", L"3700, 41020, RADIOLINJA" },
	{ L"20030222:161309", L"3700, 37923, RADIOLINJA" },
	{ L"20030222:161320", L"3700, 2146, RADIOLINJA" },
	{ L"20030222:161329", L"3700, 36644, RADIOLINJA" },
	{ L"20030222:161409", L"3700, 36643, RADIOLINJA" },
	{ L"20030222:165557", L"3700, 36644, RADIOLINJA" },
	{ L"20030222:165648", L"3700, 30181, RADIOLINJA" },
	{ L"20030222:170034", L"3700, 2146, RADIOLINJA" },
	{ L"20030222:170106", L"3700, 30181, RADIOLINJA" },
	{ L"20030222:170123", L"3700, 2146, RADIOLINJA" },
	{ L"20030222:170136", L"3700, 30181, RADIOLINJA" },
	{ L"20030222:170312", L"3700, 2146, RADIOLINJA" },
	{ L"20030222:170528", L"3700, 36643, RADIOLINJA" },
	{ L"20030222:170641", L"3700, 2146, RADIOLINJA" },
	{ L"20030222:170858", L"3700, 37923, RADIOLINJA" },
	{ L"20030222:171221", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:171237", L"3700, 2146, RADIOLINJA" },
	{ L"20030222:171255", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:171322", L"3700, 2146, RADIOLINJA" },
	{ L"20030222:171615", L"3700, 36643, RADIOLINJA" },
	{ L"20030222:171630", L"3700, 2146, RADIOLINJA" },
	{ L"20030222:171646", L"3700, 37923, RADIOLINJA" },
	{ L"20030222:171743", L"3700, 2146, RADIOLINJA" },
	{ L"20030222:171755", L"3700, 36643, RADIOLINJA" },
	{ L"20030222:171823", L"3700, 2146, RADIOLINJA" },
	{ L"20030222:171838", L"3700, 36643, RADIOLINJA" },
	{ L"20030222:172345", L"3700, 2146, RADIOLINJA" },
	{ L"20030222:172756", L"3700, 30181, RADIOLINJA" },
	{ L"20030222:172919", L"3700, 36644, RADIOLINJA" },
	{ L"20030222:172938", L"3700, 30181, RADIOLINJA" },
	{ L"20030222:172955", L"3700, 36644, RADIOLINJA" },
	{ L"20030222:173207", L"3700, 2146, RADIOLINJA" },
	{ L"20030222:173237", L"3700, 30181, RADIOLINJA" },
	{ L"20030222:173425", L"3700, 2146, RADIOLINJA" },
	{ L"20030222:173434", L"3700, 36644, RADIOLINJA" },
	{ L"20030222:173502", L"3700, 30181, RADIOLINJA" },
	{ L"20030222:173843", L"3700, 2146, RADIOLINJA" },
	{ L"20030222:173852", L"3700, 30181, RADIOLINJA" },
	{ L"20030222:174902", L"3700, 2146, RADIOLINJA" },
	{ L"20030222:174917", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:174926", L"3700, 2146, RADIOLINJA" },
	{ L"20030222:175017", L"3700, 36317, RADIOLINJA" },
	{ L"20030222:175041", L"3700, 38636, RADIOLINJA" },
	{ L"20030222:175051", L"3700, 2146, RADIOLINJA" },
	{ L"20030222:175100", L"3700, 36317, RADIOLINJA" },
	{ L"20030222:175115", L"3700, 2146, RADIOLINJA" },
	{ L"20030222:175133", L"3700, 37923, RADIOLINJA" },
	{ L"20030222:175154", L"3700, 37533, RADIOLINJA" },
	{ L"20030222:175208", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:175222", L"3700, 37534, RADIOLINJA" },
	{ L"20030222:175255", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:175304", L"3700, 37534, RADIOLINJA" },
	{ L"20030222:175357", L"3700, 3302, RADIOLINJA" },
	{ L"20030222:175537", L"3700, 40775, RADIOLINJA" },
	{ L"20030222:175720", L"3700, 30180, RADIOLINJA" },
	{ L"20030222:180105", L"3700, 1227, RADIOLINJA" },
	{ L"20030222:180322", L"3700, 2274, RADIOLINJA" },
	{ L"20030222:180536", L"3700, 30186, RADIOLINJA" },
	{ L"20030222:180831", L"3700, 3434, RADIOLINJA" },
	{ L"20030222:180859", L"3700, 30186, RADIOLINJA" },
	{ L"20030222:181124", L"9140, 88, RADIOLINJA" },
	{ L"20030222:181329", L"9140, 540, RADIOLINJA" },
	{ L"20030222:181845", L"9140, 264, RADIOLINJA" },
	{ L"20030222:181900", L"9140, 39409, RADIOLINJA" },
	{ L"20030222:181912", L"9140, 264, RADIOLINJA" },
	{ L"20030222:182116", L"9140, 84, RADIOLINJA" },
	{ L"20030222:182328", L"9140, 795, RADIOLINJA" },
	{ L"20030222:182427", L"9140, 37753, RADIOLINJA" },
	{ L"20030222:182437", L"9140, 36032, RADIOLINJA" },
	{ L"20030222:182508", L"9140, 461, RADIOLINJA" },
	{ L"20030222:182526", L"9140, 36032, RADIOLINJA" },
	{ L"20030222:182607", L"9140, 795, RADIOLINJA" },
	{ L"20030222:182622", L"9140, 4618, RADIOLINJA" },
	{ L"20030222:182722", L"9140, 461, RADIOLINJA" },
	{ L"20030222:182731", L"9140, 4618, RADIOLINJA" },
	{ L"20030222:182818", L"9140, 461, RADIOLINJA" },
	{ L"20030222:182836", L"9140, 4618, RADIOLINJA" },
	{ L"20030222:182943", L"9140, 461, RADIOLINJA" },
	{ L"20030222:182954", L"9140, 4618, RADIOLINJA" },
	{ L"20030222:183029", L"9140, 461, RADIOLINJA" },
	{ L"20030222:183048", L"9140, 36032, RADIOLINJA" },
	{ L"20030222:183104", L"9140, 461, RADIOLINJA" },
	{ L"20030222:183122", L"9140, 36032, RADIOLINJA" },
	{ L"20030222:183440", L"9140, 36033, RADIOLINJA" },
	{ L"20030222:183454", L"9140, 40532, RADIOLINJA" },
	{ L"20030222:183520", L"9140, 461, RADIOLINJA" },
	{ L"20030222:183529", L"9140, 36033, RADIOLINJA" },
	{ L"20030222:183554", L"9140, 461, RADIOLINJA" },
	{ L"20030222:183616", L"9140, 36033, RADIOLINJA" },
	{ L"20030222:183632", L"9140, 461, RADIOLINJA" },
	{ L"20030222:184101", L"9140, 91, RADIOLINJA" },
	{ L"20030222:184134", L"9140, 91, RADIOLINJA" },
	{ L"20030222:184143", L"9140, 91, RADIOLINJA" },
	{ L"20030222:184143", L"9140, 91, RADIOLINJA" },
	{ L"20030222:184337", L"9140, 173, RADIOLINJA" },
	{ L"20030222:184438", L"9140, 36602, RADIOLINJA" },
	{ L"20030222:184504", L"9140, 92, RADIOLINJA" },
	{ L"20030222:184523", L"9140, 9821, RADIOLINJA" },
	{ L"20030222:184532", L"9140, 92, RADIOLINJA" },
	{ L"20030222:184552", L"9140, 9823, RADIOLINJA" },
	{ L"20030222:184608", L"9140, 9821, RADIOLINJA" },
	{ L"20030222:184623", L"9140, 9823, RADIOLINJA" },
	{ L"20030222:184814", L"9140, 9822, RADIOLINJA" },
	{ L"20030222:185005", L"9140, 762, RADIOLINJA" },
	{ L"20030222:185046", L"9140, 4696, RADIOLINJA" },
	{ L"20030222:185112", L"9140, 15172, RADIOLINJA" },
	{ L"20030222:185146", L"9140, 15250, RADIOLINJA" },
	{ L"20030222:190313", L"9140, 41142, RADIOLINJA" },
	{ L"20030222:190324", L"9140, 51, RADIOLINJA" },
	{ L"20030222:190410", L"9140, 530, RADIOLINJA" },
	{ L"20030222:190424", L"9140, 51, RADIOLINJA" },
	{ L"20030222:190450", L"9140, 530, RADIOLINJA" },
	{ L"20030222:190613", L"9121, 41457, RADIOLINJA" },
	{ L"20030222:190659", L"9121, 42010, RADIOLINJA" },
	{ L"20030222:190716", L"9121, 35277, RADIOLINJA" },
	{ L"20030222:190749", L"9121, 46, RADIOLINJA" },
	{ L"20030222:190829", L"9121, 45, RADIOLINJA" },
	{ L"20030222:190907", L"9121, 39354, RADIOLINJA" },
	{ L"20030222:190930", L"9121, 45, RADIOLINJA" },
	{ L"20030222:191020", L"9121, 39354, RADIOLINJA" },
	{ L"20030222:191118", L"9121, 39353, RADIOLINJA" },
	{ L"20030222:191150", L"9121, 312, RADIOLINJA" },
	{ L"20030222:191226", L"9121, 9900, RADIOLINJA" },
	{ L"20030222:191330", L"9121, 9900, RADIOLINJA" },
	{ L"20030222:191334", L"9121, 15228, RADIOLINJA" },
	{ L"20030222:191353", L"9121, 62024, RADIOLINJA" },
	{ L"20030222:191417", L"9121, 279, RADIOLINJA" },
	{ L"20030222:191426", L"9121, 4471, RADIOLINJA" },
	{ L"20030222:191509", L"9007, 15374, RADIOLINJA" },
	{ L"20030222:191526", L"9007, 62558, RADIOLINJA" },
	{ L"20030222:191538", L"9007, 62048, RADIOLINJA" },
	{ L"20030222:191656", L"9007, 62049, RADIOLINJA" },
	{ L"20030222:191747", L"9007, 15259, RADIOLINJA" },
	{ L"20030222:191811", L"9007, 56, RADIOLINJA" },
	{ L"20030222:191851", L"9007, 62046, RADIOLINJA" },
	{ L"20030222:191901", L"9007, 40322, RADIOLINJA" },
	{ L"20030222:191910", L"9007, 39495, RADIOLINJA" },
	{ L"20030222:192021", L"9007, 42047, RADIOLINJA" },
	{ L"20030222:192037", L"9007, 510, RADIOLINJA" },
	{ L"20030222:192233", L"9007, 62047, RADIOLINJA" },
	{ L"20030222:192249", L"9007, 9813, RADIOLINJA" },
	{ L"20030222:192306", L"9007, 35765, RADIOLINJA" },
	{ L"20030222:192327", L"9007, 35764, RADIOLINJA" },
	{ L"20030222:192355", L"9006, 86, RADIOLINJA" },
	{ L"20030222:192821", L"9006, 15158, RADIOLINJA" },
	{ L"20030222:192931", L"9006, 40943, RADIOLINJA" },
	{ L"20030222:192957", L"9006, 62054, RADIOLINJA" },
	{ L"20030222:193007", L"9006, 63010, RADIOLINJA" },
	{ L"20030222:193026", L"9006, 15192, RADIOLINJA" },
	{ L"20030222:193036", L"9006, 63010, RADIOLINJA" },
	{ L"20030222:193053", L"9006, 354, RADIOLINJA" },
	{ L"20030222:193206", L"9006, 197, RADIOLINJA" },
	{ L"20030222:193222", L"9000, 35769, RADIOLINJA" },
	{ L"20030222:193310", L"9000, 62034, RADIOLINJA" },
	{ L"20030222:193422", L"9000, 396, RADIOLINJA" },
	{ L"20030222:193944", L"9000, 15276, RADIOLINJA" },
	{ L"20030222:194045", L"9000, 62098, RADIOLINJA" },
	{ L"20030222:194110", L"9000, 15276, RADIOLINJA" },
	{ L"20030222:194146", L"9000, 62098, RADIOLINJA" },
	{ L"20030222:194155", L"9000, 4402, RADIOLINJA" },
	{ L"20030222:194409", L"9000, 4402, RADIOLINJA" },
	{ L"20030222:194425", L"9000, 62105, RADIOLINJA" },
	{ L"20030222:194456", L"9000, 42335, RADIOLINJA" },
	{ L"20030222:194539", L"9000, 62112, RADIOLINJA" },
	{ L"20030222:194558", L"9000, 62110, RADIOLINJA" },
	{ L"20030222:194628", L"9000, 62112, RADIOLINJA" },
	{ L"20030222:194832", L"9000, 62110, RADIOLINJA" },
	{ L"20030222:194853", L"9000, 62112, RADIOLINJA" },
	{ L"20030222:194933", L"9000, 9814, RADIOLINJA" },
	{ L"20030222:194944", L"9000, 179, RADIOLINJA" },
	{ L"20030222:200610", L"9000, 62112, RADIOLINJA" },
	{ L"20030222:200634", L"9000, 9814, RADIOLINJA" },
	{ L"20030222:200652", L"9000, 62112, RADIOLINJA" },
	{ L"20030222:200818", L"9000, 62112, RADIOLINJA" },
	{ L"20030222:200818", L"9000, 62112, RADIOLINJA" },
	{ L"20030222:200831", L"9000, 62110, RADIOLINJA" },
	{ L"20030222:200929", L"9000, 62112, RADIOLINJA" },
	{ L"20030222:201135", L"9000, 8, RADIOLINJA" },
	{ L"20030222:201330", L"9000, 15308, RADIOLINJA" },
	{ L"20030222:201344", L"9000, 8, RADIOLINJA" },
	{ L"20030222:201650", L"9000, 42338, RADIOLINJA" },
	{ L"20030222:201848", L"9000, 39713, RADIOLINJA" },
	{ L"20030222:201957", L"9000, 62993, RADIOLINJA" },
	{ L"20030222:202214", L"9000, 357, RADIOLINJA" },
	{ L"20030222:202316", L"9000, 440, RADIOLINJA" },
	{ L"20030222:202556", L"9000, 442, RADIOLINJA" },
	{ L"20030222:203103", L"9000, 35783, RADIOLINJA" },
	{ L"20030222:203212", L"9006, 441, RADIOLINJA" },
	{ L"20030222:203348", L"9006, 35313, RADIOLINJA" },
	{ L"20030222:203416", L"9006, 174, RADIOLINJA" },
	{ L"20030222:203444", L"9006, 35245, RADIOLINJA" },
	{ L"20030222:203558", L"9112, 35775, RADIOLINJA" },
	{ L"20030222:203639", L"9112, 35582, RADIOLINJA" },
	{ L"20030222:203715", L"9112, 62077, RADIOLINJA" },
	{ L"20030222:203750", L"9112, 9892, RADIOLINJA" },
	{ L"20030222:203807", L"9112, 39883, RADIOLINJA" },
	{ L"20030222:203858", L"9112, 182, RADIOLINJA" },
	{ L"20030222:203917", L"9112, 42340, RADIOLINJA" },
	{ L"20030222:203933", L"9112, 101, RADIOLINJA" },
	{ L"20030222:203943", L"9112, 39882, RADIOLINJA" },
	{ L"20030222:204041", L"9112, 1423, RADIOLINJA" },
	{ L"20030222:204102", L"9112, 1383, RADIOLINJA" },
	{ L"20030222:204119", L"9112, 431, RADIOLINJA" },
	{ L"20030222:204128", L"9112, 62084, RADIOLINJA" },
	{ L"20030222:204600", L"9112, 436, RADIOLINJA" },
	{ L"20030222:204617", L"9112, 62084, RADIOLINJA" },
	{ L"20030222:204836", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:204845", L"9112, 62084, RADIOLINJA" },
	{ L"20030222:204901", L"9112, 62083, RADIOLINJA" },
	{ L"20030222:204924", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:204945", L"9112, 62083, RADIOLINJA" },
	{ L"20030222:204955", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:205038", L"9112, 431, RADIOLINJA" },
	{ L"20030222:205124", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:205225", L"9112, 62083, RADIOLINJA" },
	{ L"20030222:205242", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:211358", L"9112, 62083, RADIOLINJA" },
	{ L"20030222:211414", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:211459", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:211510", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:211510", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:211522", L"9112, 431, RADIOLINJA" },
	{ L"20030222:211650", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:211758", L"9112, 431, RADIOLINJA" },
	{ L"20030222:211849", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:212300", L"9112, 431, RADIOLINJA" },
	{ L"20030222:212352", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:212430", L"9112, 431, RADIOLINJA" },
	{ L"20030222:212606", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:212630", L"9112, 431, RADIOLINJA" },
	{ L"20030222:212723", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:212748", L"9112, 431, RADIOLINJA" },
	{ L"20030222:212812", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:212837", L"9112, 431, RADIOLINJA" },
	{ L"20030222:212927", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:212956", L"9112, 431, RADIOLINJA" },
	{ L"20030222:213007", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:213125", L"9112, 431, RADIOLINJA" },
	{ L"20030222:213145", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:213221", L"9112, 431, RADIOLINJA" },
	{ L"20030222:213308", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:213329", L"9112, 431, RADIOLINJA" },
	{ L"20030222:213540", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:213558", L"9112, 431, RADIOLINJA" },
	{ L"20030222:213615", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:213645", L"9112, 431, RADIOLINJA" },
	{ L"20030222:213739", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:213756", L"9112, 431, RADIOLINJA" },
	{ L"20030222:213813", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:213915", L"9112, 431, RADIOLINJA" },
	{ L"20030222:214113", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:214134", L"9112, 431, RADIOLINJA" },
	{ L"20030222:214143", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:214200", L"9112, 431, RADIOLINJA" },
	{ L"20030222:214217", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:214234", L"9112, 431, RADIOLINJA" },
	{ L"20030222:215104", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:215457", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:215502", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:215502", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:215557", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:220252", L"9112, 62083, RADIOLINJA" },
	{ L"20030222:220417", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:220432", L"9112, 62083, RADIOLINJA" },
	{ L"20030222:220545", L"9112, 436, RADIOLINJA" },
	{ L"20030222:220601", L"9112, 62083, RADIOLINJA" },
	{ L"20030222:220633", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:220724", L"9112, 62083, RADIOLINJA" },
	{ L"20030222:220739", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:220835", L"9112, 62083, RADIOLINJA" },
	{ L"20030222:220851", L"9112, 40627, RADIOLINJA" },
	{ L"20030222:221037", L"9112, 62084, RADIOLINJA" },
	{ L"20030222:221051", L"9112, 62083, RADIOLINJA" },
	{ L"20030222:221101", L"9112, 62084, RADIOLINJA" },
	{ L"20030222:221218", L"9112, 436, RADIOLINJA" },
	{ L"20030222:221253", L"9112, 62084, RADIOLINJA" },
	{ L"20030222:221639", L"9112, 62083, RADIOLINJA" },
	{ L"20030222:221649", L"9112, 15022, RADIOLINJA" },
	{ L"20030222:222615", L"9112, 62084, RADIOLINJA" },
	{ L"20030222:222645", L"9112, 39396, RADIOLINJA" },
	{ L"20030222:222659", L"9112, 3508, RADIOLINJA" },
	{ L"20030222:222709", L"9112, 1383, RADIOLINJA" },
	{ L"20030222:222727", L"9112, 1423, RADIOLINJA" },
	{ L"20030222:222752", L"9112, 39882, RADIOLINJA" },
	{ L"20030222:222853", L"9112, 101, RADIOLINJA" },
	{ L"20030222:222902", L"9112, 42340, RADIOLINJA" },
	{ L"20030222:222917", L"9112, 182, RADIOLINJA" },
	{ L"20030222:222938", L"9112, 39883, RADIOLINJA" },
	{ L"20030222:223021", L"9112, 9892, RADIOLINJA" },
	{ L"20030222:223034", L"9112, 62076, RADIOLINJA" },
	{ L"20030222:223044", L"9112, 62077, RADIOLINJA" },
	{ L"20030222:223123", L"9112, 35582, RADIOLINJA" },
	{ L"20030222:223158", L"9112, 35775, RADIOLINJA" },
	{ L"20030222:223236", L"9006, 62089, RADIOLINJA" },
	{ L"20030222:223250", L"9006, 15397, RADIOLINJA" },
	{ L"20030222:223318", L"9006, 62089, RADIOLINJA" },
	{ L"20030222:223328", L"9006, 35245, RADIOLINJA" },
	{ L"20030222:223355", L"9000, 62121, RADIOLINJA" },
	{ L"20030222:223409", L"9006, 174, RADIOLINJA" },
	{ L"20030222:223447", L"9006, 35313, RADIOLINJA" },
	{ L"20030222:223502", L"9006, 174, RADIOLINJA" },
	{ L"20030222:223511", L"9006, 441, RADIOLINJA" },
	{ L"20030222:223725", L"9006, 233, RADIOLINJA" },
	{ L"20030222:224054", L"9006, 62067, RADIOLINJA" },
	{ L"20030222:224229", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:063559", L"9006, 35265, RADIOLINJA" },
	{ L"20030223:063619", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:092924", L"9006, 62067, RADIOLINJA" },
	{ L"20030223:092940", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:093204", L"9006, 62067, RADIOLINJA" },
	{ L"20030223:093242", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:093414", L"9006, 62067, RADIOLINJA" },
	{ L"20030223:093437", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:093449", L"9006, 376, RADIOLINJA" },
	{ L"20030223:093458", L"9006, 38583, RADIOLINJA" },
	{ L"20030223:094404", L"9006, 62067, RADIOLINJA" },
	{ L"20030223:094421", L"9006, 38583, RADIOLINJA" },
	{ L"20030223:094718", L"9006, 62065, RADIOLINJA" },
	{ L"20030223:094735", L"9006, 15057, RADIOLINJA" },
	{ L"20030223:094744", L"9006, 38583, RADIOLINJA" },
	{ L"20030223:095113", L"9006, 62065, RADIOLINJA" },
	{ L"20030223:095130", L"9006, 38583, RADIOLINJA" },
	{ L"20030223:100240", L"9006, 376, RADIOLINJA" },
	{ L"20030223:100317", L"9006, 38583, RADIOLINJA" },
	{ L"20030223:100550", L"9006, 18, RADIOLINJA" },
	{ L"20030223:100610", L"9006, 376, RADIOLINJA" },
	{ L"20030223:100642", L"9006, 18, RADIOLINJA" },
	{ L"20030223:100718", L"9006, 376, RADIOLINJA" },
	{ L"20030223:100734", L"9006, 18, RADIOLINJA" },
	{ L"20030223:100756", L"9006, 376, RADIOLINJA" },
	{ L"20030223:100943", L"9006, 18, RADIOLINJA" },
	{ L"20030223:101119", L"9006, 399, RADIOLINJA" },
	{ L"20030223:113559", L"9006, 376, RADIOLINJA" },
	{ L"20030223:113611", L"9006, 399, RADIOLINJA" },
	{ L"20030223:113713", L"9006, 18, RADIOLINJA" },
	{ L"20030223:113728", L"9006, 399, RADIOLINJA" },
	{ L"20030223:114209", L"9006, 18, RADIOLINJA" },
	{ L"20030223:114236", L"9006, 399, RADIOLINJA" },
	{ L"20030223:114421", L"9006, 18, RADIOLINJA" },
	{ L"20030223:114429", L"9006, 376, RADIOLINJA" },
	{ L"20030223:114539", L"9006, 4707, RADIOLINJA" },
	{ L"20030223:114618", L"9006, 376, RADIOLINJA" },
	{ L"20030223:114804", L"9006, 15306, RADIOLINJA" },
	{ L"20030223:114836", L"9006, 376, RADIOLINJA" },
	{ L"20030223:114926", L"9006, 399, RADIOLINJA" },
	{ L"20030223:115047", L"9006, 376, RADIOLINJA" },
	{ L"20030223:115216", L"9006, 399, RADIOLINJA" },
	{ L"20030223:115428", L"9006, 1493, RADIOLINJA" },
	{ L"20030223:115529", L"9006, 399, RADIOLINJA" },
	{ L"20030223:121051", L"9006, 1493, RADIOLINJA" },
	{ L"20030223:121107", L"9006, 399, RADIOLINJA" },
	{ L"20030223:121136", L"9006, 1493, RADIOLINJA" },
	{ L"20030223:121147", L"9006, 15306, RADIOLINJA" },
	{ L"20030223:121339", L"9006, 1493, RADIOLINJA" },
	{ L"20030223:121430", L"9006, 399, RADIOLINJA" },
	{ L"20030223:121731", L"9006, 1493, RADIOLINJA" },
	{ L"20030223:121757", L"9006, 399, RADIOLINJA" },
	{ L"20030223:122217", L"9006, 1493, RADIOLINJA" },
	{ L"20030223:122336", L"9006, 399, RADIOLINJA" },
	{ L"20030223:122641", L"9006, 1493, RADIOLINJA" },
	{ L"20030223:122659", L"9006, 399, RADIOLINJA" },
	{ L"20030223:122659", L"SWITCH" },
	{ L"20030223:144148", L"9006, 399, RADIOLINJA" },
	{ L"20030223:144223", L"9006, 1493, RADIOLINJA" },
	{ L"20030223:144616", L"9006, 399, RADIOLINJA" },
	{ L"20030223:144634", L"9006, 1493, RADIOLINJA" },
	{ L"20030223:144701", L"9006, 399, RADIOLINJA" },
	{ L"20030223:144724", L"9006, 1493, RADIOLINJA" },
	{ L"20030223:144805", L"9006, 399, RADIOLINJA" },
	{ L"20030223:150038", L"9006, 376, RADIOLINJA" },
	{ L"20030223:150229", L"9006, 399, RADIOLINJA" },
	{ L"20030223:152443", L"9006, 376, RADIOLINJA" },
	{ L"20030223:152453", L"9006, 399, RADIOLINJA" },
	{ L"20030223:152523", L"9006, 1493, RADIOLINJA" },
	{ L"20030223:152600", L"9006, 399, RADIOLINJA" },
	{ L"20030223:152617", L"9006, 1493, RADIOLINJA" },
	{ L"20030223:152647", L"9006, 399, RADIOLINJA" },
	{ L"20030223:152919", L"9006, 1493, RADIOLINJA" },
	{ L"20030223:152956", L"9006, 399, RADIOLINJA" },
	{ L"20030223:153205", L"9006, 1493, RADIOLINJA" },
	{ L"20030223:153221", L"9006, 399, RADIOLINJA" },
	{ L"20030223:153248", L"9006, 1493, RADIOLINJA" },
	{ L"20030223:153340", L"9006, 399, RADIOLINJA" },
	{ L"20030223:153502", L"9006, 1493, RADIOLINJA" },
	{ L"20030223:153521", L"9006, 399, RADIOLINJA" },
	{ L"20030223:153812", L"9006, 1493, RADIOLINJA" },
	{ L"20030223:153854", L"9006, 399, RADIOLINJA" },
	{ L"20030223:153917", L"9006, 376, RADIOLINJA" },
	{ L"20030223:153941", L"9006, 399, RADIOLINJA" },
	{ L"20030223:154041", L"9006, 376, RADIOLINJA" },
	{ L"20030223:154117", L"9006, 399, RADIOLINJA" },
	{ L"20030223:154346", L"9006, 376, RADIOLINJA" },
	{ L"20030223:154425", L"9006, 399, RADIOLINJA" },
	{ L"20030223:154507", L"9006, 376, RADIOLINJA" },
	{ L"20030223:154524", L"9006, 399, RADIOLINJA" },
	{ L"20030223:154648", L"9006, 376, RADIOLINJA" },
	{ L"20030223:154658", L"9006, 399, RADIOLINJA" },
	{ L"20030223:160204", L"9006, 1493, RADIOLINJA" },
	{ L"20030223:160237", L"9006, 399, RADIOLINJA" },
	{ L"20030223:160258", L"9006, 1493, RADIOLINJA" },
	{ L"20030223:160309", L"9006, 399, RADIOLINJA" },
	{ L"20030223:160921", L"9006, 376, RADIOLINJA" },
	{ L"20030223:160935", L"9006, 399, RADIOLINJA" },
	{ L"20030223:161603", L"9006, 1493, RADIOLINJA" },
	{ L"20030223:161613", L"9006, 399, RADIOLINJA" },
	{ L"20030223:162522", L"9006, 1493, RADIOLINJA" },
	{ L"20030223:162538", L"9006, 399, RADIOLINJA" },
	{ L"20030223:163341", L"9006, 1493, RADIOLINJA" },
	{ L"20030223:163448", L"9006, 399, RADIOLINJA" },
	{ L"20030223:163508", L"9006, 1493, RADIOLINJA" },
	{ L"20030223:163527", L"9006, 399, RADIOLINJA" },
	{ L"20030223:164001", L"9006, 376, RADIOLINJA" },
	{ L"20030223:164023", L"9006, 399, RADIOLINJA" },
	{ L"20030223:174122", L"9006, 376, RADIOLINJA" },
	{ L"20030223:174211", L"9006, 399, RADIOLINJA" },
	{ L"20030223:183612", L"9006, 376, RADIOLINJA" },
	{ L"20030223:183631", L"9006, 399, RADIOLINJA" },
	{ L"20030223:183649", L"9006, 376, RADIOLINJA" },
	{ L"20030223:183659", L"9006, 18, RADIOLINJA" },
	{ L"20030223:183708", L"9006, 399, RADIOLINJA" },
	{ L"20030223:183740", L"9006, 376, RADIOLINJA" },
	{ L"20030223:184101", L"9006, 38583, RADIOLINJA" },
	{ L"20030223:184113", L"9006, 376, RADIOLINJA" },
	{ L"20030223:184128", L"9006, 38583, RADIOLINJA" },
	{ L"20030223:184334", L"9006, 508, RADIOLINJA" },
	{ L"20030223:184352", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:184824", L"9006, 62067, RADIOLINJA" },
	{ L"20030223:184842", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:190852", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:190857", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:190857", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:190921", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:191214", L"9006, 4280, RADIOLINJA" },
	{ L"20030223:191235", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:191311", L"9006, 62067, RADIOLINJA" },
	{ L"20030223:191327", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:191358", L"9006, 4280, RADIOLINJA" },
	{ L"20030223:191407", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:192707", L"9006, 62067, RADIOLINJA" },
	{ L"20030223:192748", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:193308", L"9006, 35265, RADIOLINJA" },
	{ L"20030223:193325", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:193422", L"9006, 35265, RADIOLINJA" },
	{ L"20030223:193459", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:193520", L"9006, 35265, RADIOLINJA" },
	{ L"20030223:193619", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:193637", L"9006, 35265, RADIOLINJA" },
	{ L"20030223:193759", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:193816", L"9006, 35265, RADIOLINJA" },
	{ L"20030223:193831", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:193921", L"9006, 35265, RADIOLINJA" },
	{ L"20030223:193939", L"9006, 35265, RADIOLINJA" },
	{ L"20030223:193942", L"9006, 35265, RADIOLINJA" },
	{ L"20030223:194047", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:194123", L"9006, 35265, RADIOLINJA" },
	{ L"20030223:194251", L"9006, 35265, RADIOLINJA" },
	{ L"20030223:194254", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:194519", L"9006, 62067, RADIOLINJA" },
	{ L"20030223:194558", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:194755", L"9006, 62067, RADIOLINJA" },
	{ L"20030223:194905", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:195005", L"9006, 4280, RADIOLINJA" },
	{ L"20030223:195042", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:195248", L"9006, 35265, RADIOLINJA" },
	{ L"20030223:195336", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:195419", L"9006, 35265, RADIOLINJA" },
	{ L"20030223:195607", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:195642", L"9006, 35265, RADIOLINJA" },
	{ L"20030223:195715", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:195738", L"9006, 35265, RADIOLINJA" },
	{ L"20030223:195830", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:200317", L"9006, 35265, RADIOLINJA" },
	{ L"20030223:200346", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:201344", L"9006, 62067, RADIOLINJA" },
	{ L"20030223:201405", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:203031", L"9006, 35265, RADIOLINJA" },
	{ L"20030223:203138", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:204016", L"9006, 4280, RADIOLINJA" },
	{ L"20030223:204031", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:204126", L"9006, 4280, RADIOLINJA" },
	{ L"20030223:204134", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:204239", L"9006, 35265, RADIOLINJA" },
	{ L"20030223:204255", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:212153", L"9006, 35265, RADIOLINJA" },
	{ L"20030223:213015", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:213122", L"9006, 35265, RADIOLINJA" },
	{ L"20030223:213138", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:213306", L"9006, 35265, RADIOLINJA" },
	{ L"20030223:213316", L"9006, 15300, RADIOLINJA" },
	{ L"20030223:221458", L"9006, 233, RADIOLINJA" },
	{ L"20030223:221525", L"9006, 15300, RADIOLINJA" },
	{ L"20030224:054901", L"9006, 35265, RADIOLINJA" },
	{ L"20030224:054914", L"9006, 15300, RADIOLINJA" },
	{ L"20030224:091029", L"9006, 62067, RADIOLINJA" },
	{ L"20030224:091103", L"9006, 15300, RADIOLINJA" },
	{ L"20030224:091240", L"9006, 62067, RADIOLINJA" },
	{ L"20030224:091255", L"9006, 38583, RADIOLINJA" },
	{ L"20030224:091531", L"9006, 15057, RADIOLINJA" },
	{ L"20030224:091547", L"9006, 38583, RADIOLINJA" },
	{ L"20030224:091647", L"9006, 18, RADIOLINJA" },
	{ L"20030224:091709", L"9006, 62032, RADIOLINJA" },
	{ L"20030224:091854", L"9006, 18, RADIOLINJA" },
	{ L"20030224:091909", L"9006, 376, RADIOLINJA" },
	{ L"20030224:092011", L"9006, 18, RADIOLINJA" },
	{ L"20030224:092106", L"9006, 399, RADIOLINJA" },
	{ L"20030224:092705", L"9006, 376, RADIOLINJA" },
	{ L"20030224:092728", L"9006, 18, RADIOLINJA" },
	{ L"20030224:092924", L"9006, 399, RADIOLINJA" },
	{ L"20030224:092943", L"9006, 18, RADIOLINJA" },
	{ L"20030224:094749", L"9006, 376, RADIOLINJA" },
	{ L"20030224:094805", L"9006, 18, RADIOLINJA" },
	{ L"20030224:095117", L"9006, 62032, RADIOLINJA" },
	{ L"20030224:095201", L"9006, 18, RADIOLINJA" },
	{ L"20030224:095629", L"9006, 376, RADIOLINJA" },
	{ L"20030224:095644", L"9006, 399, RADIOLINJA" },
	{ L"20030224:095653", L"9006, 376, RADIOLINJA" },
	{ L"20030224:095702", L"9006, 399, RADIOLINJA" },
	{ L"20030224:112744", L"9006, 1493, RADIOLINJA" },
	{ L"20030224:112810", L"9006, 399, RADIOLINJA" },
	{ L"20030224:114400", L"9006, 376, RADIOLINJA" },
	{ L"20030224:114416", L"9006, 399, RADIOLINJA" },
	{ L"20030224:114952", L"9006, 376, RADIOLINJA" },
	{ L"20030224:115008", L"9006, 18, RADIOLINJA" },
	{ L"20030224:115024", L"9006, 15306, RADIOLINJA" },
	{ L"20030224:115141", L"9006, 18, RADIOLINJA" },
	{ L"20030224:115229", L"9006, 15306, RADIOLINJA" },
	{ L"20030224:115338", L"9006, 18, RADIOLINJA" },
	{ L"20030224:115503", L"9006, 15306, RADIOLINJA" },
	{ L"20030224:115902", L"9006, 18, RADIOLINJA" },
	{ L"20030224:115918", L"9006, 15306, RADIOLINJA" },
	{ L"20030224:120113", L"9006, 18, RADIOLINJA" },
	{ L"20030224:120130", L"9006, 399, RADIOLINJA" },
	{ L"20030224:120146", L"9006, 376, RADIOLINJA" },
	{ L"20030224:120201", L"9006, 399, RADIOLINJA" },
	{ L"20030224:131316", L"9006, 62032, RADIOLINJA" },
	{ L"20030224:131325", L"9006, 399, RADIOLINJA" },
	{ L"20030224:140535", L"9006, 1493, RADIOLINJA" },
	{ L"20030224:140600", L"9006, 399, RADIOLINJA" },
	{ L"20030224:140721", L"9006, 376, RADIOLINJA" },
	{ L"20030224:140757", L"9006, 399, RADIOLINJA" },
	{ L"20030224:140848", L"9006, 376, RADIOLINJA" },
	{ L"20030224:140920", L"9006, 399, RADIOLINJA" },
	{ L"20030224:141528", L"9006, 1493, RADIOLINJA" },
	{ L"20030224:141634", L"9006, 399, RADIOLINJA" },
	{ L"20030224:144907", L"9006, 1493, RADIOLINJA" },
	{ L"20030224:144937", L"9006, 399, RADIOLINJA" },
	{ L"20030224:180635", L"9006, 376, RADIOLINJA" },
	{ L"20030224:180756", L"9006, 399, RADIOLINJA" },
	{ L"20030224:180811", L"9006, 376, RADIOLINJA" },
	{ L"20030224:180828", L"9006, 18, RADIOLINJA" },
	{ L"20030224:180838", L"9006, 62032, RADIOLINJA" },
	{ L"20030224:180852", L"9006, 18, RADIOLINJA" },
	{ L"20030224:181021", L"9006, 62032, RADIOLINJA" },
	{ L"20030224:181043", L"9006, 62032, RADIOLINJA" },
	{ L"20030224:181045", L"9006, 62032, RADIOLINJA" },
	{ L"20030224:181045", L"9006, 62032, RADIOLINJA" },
	{ L"20030224:181133", L"9006, 18, RADIOLINJA" },
	{ L"20030224:182019", L"9006, 376, RADIOLINJA" },
	{ L"20030224:182055", L"9006, 18, RADIOLINJA" },
	{ L"20030224:182254", L"9006, 62032, RADIOLINJA" },
	{ L"20030224:182546", L"9006, 62032, RADIOLINJA" },
	{ L"20030224:182549", L"9006, 18, RADIOLINJA" },
	{ L"20030224:182549", L"9006, 18, RADIOLINJA" },
	{ L"20030224:182803", L"9006, 62032, RADIOLINJA" },
	{ L"20030224:182906", L"9006, 18, RADIOLINJA" },
	{ L"20030224:183018", L"9006, 62032, RADIOLINJA" },
	{ L"20030224:183058", L"9006, 18, RADIOLINJA" },
	{ L"20030224:183128", L"9006, 62032, RADIOLINJA" },
	{ L"20030224:183436", L"9006, 15306, RADIOLINJA" },
	{ L"20030224:183453", L"9006, 62032, RADIOLINJA" },
	{ L"20030224:183523", L"9006, 15306, RADIOLINJA" },
	{ L"20030224:183540", L"9006, 62032, RADIOLINJA" },
	{ L"20030224:183656", L"9006, 18, RADIOLINJA" },
	{ L"20030224:183709", L"9006, 399, RADIOLINJA" },
	{ L"20030224:192948", L"9006, 62032, RADIOLINJA" },
	{ L"20030224:193008", L"9006, 18, RADIOLINJA" },
	{ L"20030224:193018", L"9006, 399, RADIOLINJA" },
	{ L"20030224:193033", L"9006, 376, RADIOLINJA" },
	{ L"20030224:193044", L"9006, 399, RADIOLINJA" },
	{ L"20030224:193111", L"9006, 18, RADIOLINJA" },
	{ L"20030224:193143", L"9006, 18, RADIOLINJA" },
	{ L"20030224:193144", L"9006, 399, RADIOLINJA" },
	{ L"20030224:193144", L"9006, 399, RADIOLINJA" },
	{ L"20030224:193204", L"9006, 18, RADIOLINJA" },
	{ L"20030224:193243", L"9006, 376, RADIOLINJA" },
	{ L"20030224:193417", L"9006, 18, RADIOLINJA" },
	{ L"20030224:193428", L"9006, 376, RADIOLINJA" },
	{ L"20030224:193624", L"9006, 62032, RADIOLINJA" },
	{ L"20030224:193639", L"9006, 18, RADIOLINJA" },
	{ L"20030224:193657", L"9006, 376, RADIOLINJA" },
	{ L"20030224:193908", L"9006, 38583, RADIOLINJA" },
	{ L"20030224:194123", L"9006, 62067, RADIOLINJA" },
	{ L"20030224:194134", L"9006, 15300, RADIOLINJA" },
	{ L"20030224:194232", L"9006, 62067, RADIOLINJA" },
	{ L"20030224:194251", L"9006, 15300, RADIOLINJA" },
	{ L"20030224:194303", L"9006, 508, RADIOLINJA" },
	{ L"20030224:195055", L"9006, 15300, RADIOLINJA" },
	{ L"20030224:195117", L"9006, 4280, RADIOLINJA" },
	{ L"20030224:195126", L"9006, 508, RADIOLINJA" },
	{ L"20030224:195219", L"9006, 15300, RADIOLINJA" },
	{ L"20030224:195235", L"9006, 4280, RADIOLINJA" },
	{ L"20030224:195251", L"9006, 508, RADIOLINJA" },
	{ L"20030224:195310", L"9006, 15300, RADIOLINJA" },
	{ L"20030224:195350", L"9006, 62067, RADIOLINJA" },
	{ L"20030224:195406", L"9006, 15300, RADIOLINJA" },
	{ L"20030224:195507", L"9006, 62067, RADIOLINJA" },
	{ L"20030224:195601", L"9006, 4280, RADIOLINJA" },
	{ L"20030224:195614", L"9006, 15300, RADIOLINJA" },
	{ L"20030224:195834", L"9006, 62067, RADIOLINJA" },
	{ L"20030224:195915", L"9006, 15300, RADIOLINJA" },
	{ L"20030224:200552", L"9006, 4280, RADIOLINJA" },
	{ L"20030224:200612", L"9006, 15300, RADIOLINJA" },
	{ L"20030224:200753", L"9006, 4280, RADIOLINJA" },
	{ L"20030224:200809", L"9006, 15300, RADIOLINJA" },
	{ L"20030224:202042", L"9006, 35265, RADIOLINJA" },
	{ L"20030224:202102", L"9006, 15300, RADIOLINJA" },
	{ L"20030224:202435", L"9006, 35265, RADIOLINJA" },
	{ L"20030224:202503", L"9006, 35265, RADIOLINJA" },
	{ L"20030224:202504", L"9006, 15300, RADIOLINJA" },
	{ L"20030224:202504", L"9006, 15300, RADIOLINJA" },
	{ L"20030224:205744", L"9006, 4280, RADIOLINJA" },
	{ L"20030224:205753", L"9006, 15300, RADIOLINJA" },
	{ L"20030224:212800", L"9006, 35265, RADIOLINJA" },
	{ L"20030224:212907", L"9006, 15300, RADIOLINJA" },
	{ L"20030224:212936", L"9006, 35265, RADIOLINJA" },
	{ L"20030224:212958", L"9006, 15300, RADIOLINJA" },
	{ L"20030225:084747", L"9006, 4280, RADIOLINJA" },
	{ L"20030225:084801", L"9006, 15300, RADIOLINJA" },
	{ L"20030225:084930", L"9006, 62067, RADIOLINJA" },
	{ L"20030225:085155", L"9006, 15300, RADIOLINJA" },
	{ L"20030225:085517", L"9006, 62067, RADIOLINJA" },
	{ L"20030225:085545", L"9006, 15300, RADIOLINJA" },
	{ L"20030225:085751", L"9006, 62067, RADIOLINJA" },
	{ L"20030225:085812", L"9006, 38583, RADIOLINJA" },
	{ L"20030225:090216", L"9006, 18, RADIOLINJA" },
	{ L"20030225:090227", L"9006, 62032, RADIOLINJA" },
	{ L"20030225:090227", L"SWITCH" },
	{ L"20030225:100343", L"9006, 399, RADIOLINJA" },
	{ L"20030225:104159", L"9006, 376, RADIOLINJA" },
	{ L"20030225:104231", L"9006, 399, RADIOLINJA" },
	{ L"20030225:104305", L"9006, 376, RADIOLINJA" },
	{ L"20030225:104321", L"9006, 399, RADIOLINJA" },
	{ L"20030225:104410", L"9006, 376, RADIOLINJA" },
	{ L"20030225:104424", L"9006, 399, RADIOLINJA" },
	{ L"20030225:105739", L"9006, 18, RADIOLINJA" },
	{ L"20030225:110326", L"9006, 15306, RADIOLINJA" },
	{ L"20030225:110401", L"9006, 18, RADIOLINJA" },
	{ L"20030225:110710", L"9006, 376, RADIOLINJA" },
	{ L"20030225:110726", L"9006, 18, RADIOLINJA" },
	{ L"20030225:110959", L"9006, 376, RADIOLINJA" },
	{ L"20030225:111020", L"9006, 18, RADIOLINJA" },
	{ L"20030225:112050", L"9006, 399, RADIOLINJA" },
	{ L"20030225:112108", L"9006, 18, RADIOLINJA" },
	{ L"20030225:112125", L"9006, 399, RADIOLINJA" },
	{ L"20030225:112140", L"9006, 18, RADIOLINJA" },
	{ L"20030225:112254", L"9006, 4707, RADIOLINJA" },
	{ L"20030225:112319", L"9006, 18, RADIOLINJA" },
	{ L"20030225:112637", L"9006, 376, RADIOLINJA" },
	{ L"20030225:112654", L"9006, 399, RADIOLINJA" },
	{ L"20030225:113107", L"9006, 1493, RADIOLINJA" },
	{ L"20030225:113123", L"9006, 399, RADIOLINJA" },
	{ L"20030225:113140", L"9006, 1493, RADIOLINJA" },
	{ L"20030225:113204", L"9006, 399, RADIOLINJA" },
	{ L"20030225:113221", L"9006, 1493, RADIOLINJA" },
	{ L"20030225:113231", L"9006, 399, RADIOLINJA" },
	{ L"20030225:113315", L"9006, 1493, RADIOLINJA" },
	{ L"20030225:113448", L"9006, 399, RADIOLINJA" },
	{ L"20030225:121518", L"9006, 376, RADIOLINJA" },
	{ L"20030225:121534", L"9006, 18, RADIOLINJA" },
	{ L"20030225:121550", L"9006, 376, RADIOLINJA" },
	{ L"20030225:121624", L"9006, 399, RADIOLINJA" },
	{ L"20030225:121700", L"9006, 376, RADIOLINJA" },
	{ L"20030225:122002", L"9006, 399, RADIOLINJA" },
	{ L"20030225:122018", L"9006, 376, RADIOLINJA" },
	{ L"20030225:122114", L"9006, 399, RADIOLINJA" },
	{ L"20030225:122416", L"9006, 376, RADIOLINJA" },
	{ L"20030225:122435", L"9006, 399, RADIOLINJA" },
	{ L"20030225:122450", L"9006, 376, RADIOLINJA" },
	{ L"20030225:122511", L"9006, 399, RADIOLINJA" },
	{ L"20030225:122543", L"9006, 376, RADIOLINJA" },
	{ L"20030225:122601", L"9006, 399, RADIOLINJA" },
	{ L"20030225:122615", L"9006, 376, RADIOLINJA" },
	{ L"20030225:122650", L"9006, 399, RADIOLINJA" },
	{ L"20030225:122706", L"9006, 376, RADIOLINJA" },
	{ L"20030225:123010", L"9006, 399, RADIOLINJA" },
	{ L"20030225:123027", L"9006, 376, RADIOLINJA" },
	{ L"20030225:123235", L"9006, 399, RADIOLINJA" },
	{ L"20030225:123251", L"9006, 376, RADIOLINJA" },
	{ L"20030225:123345", L"9006, 399, RADIOLINJA" },
	{ L"20030225:123407", L"9006, 376, RADIOLINJA" },
	{ L"20030225:123443", L"9006, 399, RADIOLINJA" },
	{ L"20030225:123751", L"9006, 376, RADIOLINJA" },
	{ L"20030225:123816", L"9006, 399, RADIOLINJA" },
	{ L"20030225:123852", L"9006, 376, RADIOLINJA" },
	{ L"20030225:123935", L"9006, 399, RADIOLINJA" },
	{ L"20030225:123952", L"9006, 18, RADIOLINJA" },
	{ L"20030225:124032", L"9006, 62032, RADIOLINJA" },
	{ L"20030225:124048", L"9006, 399, RADIOLINJA" },
	{ L"20030225:124105", L"9006, 376, RADIOLINJA" },
	{ L"20030225:124143", L"9006, 399, RADIOLINJA" },
	{ L"20030225:124254", L"9006, 376, RADIOLINJA" },
	{ L"20030225:124334", L"9006, 399, RADIOLINJA" },
	{ L"20030225:130023", L"9006, 18, RADIOLINJA" },
	{ L"20030225:130055", L"9006, 399, RADIOLINJA" },
	{ L"20030225:130516", L"9006, 376, RADIOLINJA" },
	{ L"20030225:130532", L"9006, 399, RADIOLINJA" },
	{ L"20030225:130635", L"9006, 376, RADIOLINJA" },
	{ L"20030225:130919", L"9006, 399, RADIOLINJA" },
	{ L"20030225:130939", L"9006, 376, RADIOLINJA" },
	{ L"20030225:130958", L"9006, 399, RADIOLINJA" },
	{ L"20030225:131204", L"9006, 376, RADIOLINJA" },
	{ L"20030225:131410", L"9006, 399, RADIOLINJA" },
	{ L"20030225:131507", L"9006, 376, RADIOLINJA" },
	{ L"20030225:132014", L"9006, 399, RADIOLINJA" },
	{ L"20030225:132708", L"9006, 376, RADIOLINJA" },
	{ L"20030225:132847", L"9006, 399, RADIOLINJA" },
	{ L"20030225:133204", L"9006, 376, RADIOLINJA" },
	{ L"20030225:133236", L"9006, 399, RADIOLINJA" },
	{ L"20030225:133315", L"9006, 376, RADIOLINJA" },
	{ L"20030225:133330", L"9006, 399, RADIOLINJA" },
	{ L"20030225:133544", L"9006, 376, RADIOLINJA" },
	{ L"20030225:133553", L"9006, 399, RADIOLINJA" },
	{ L"20030225:134455", L"9006, 376, RADIOLINJA" },
	{ L"20030225:134512", L"9006, 399, RADIOLINJA" },
	{ L"20030225:134537", L"9006, 376, RADIOLINJA" },
	{ L"20030225:134646", L"9006, 399, RADIOLINJA" },
	{ L"20030225:140240", L"9006, 62032, RADIOLINJA" },
	{ L"20030225:140349", L"9006, 399, RADIOLINJA" },
	{ L"20030225:141252", L"9006, 376, RADIOLINJA" },
	{ L"20030225:141308", L"9006, 399, RADIOLINJA" },
	{ L"20030225:141337", L"9006, 376, RADIOLINJA" },
	{ L"20030225:141353", L"9006, 18, RADIOLINJA" },
	{ L"20030225:141512", L"9006, 62032, RADIOLINJA" },
	{ L"20030225:141528", L"9006, 18, RADIOLINJA" },
	{ L"20030225:141946", L"9006, 376, RADIOLINJA" },
	{ L"20030225:141955", L"9006, 399, RADIOLINJA" },
	{ L"20030225:142017", L"9006, 18, RADIOLINJA" },
	{ L"20030225:142426", L"9006, 15306, RADIOLINJA" },
	{ L"20030225:142435", L"9006, 62032, RADIOLINJA" },
	{ L"20030225:142450", L"9006, 18, RADIOLINJA" },
	{ L"20030225:142510", L"9006, 18, RADIOLINJA" },
	{ L"20030225:142529", L"9006, 62032, RADIOLINJA" },
	{ L"20030225:142529", L"9006, 62032, RADIOLINJA" },
	{ L"20030225:142615", L"9006, 18, RADIOLINJA" },
	{ L"20030225:142735", L"9006, 18, RADIOLINJA" },
	{ L"20030225:142736", L"9006, 18, RADIOLINJA" },
	{ L"20030225:142736", L"9006, 18, RADIOLINJA" },
	{ L"20030225:142841", L"9006, 62032, RADIOLINJA" },
	{ L"20030225:142942", L"9006, 18, RADIOLINJA" },
	{ L"20030225:143112", L"9006, 62032, RADIOLINJA" },
	{ L"20030225:143147", L"9006, 18, RADIOLINJA" },
	{ L"20030225:143454", L"9006, 18, RADIOLINJA" },
	{ L"20030225:143521", L"9006, 62032, RADIOLINJA" },
	{ L"20030225:143601", L"9006, 18, RADIOLINJA" },
	{ L"20030225:143732", L"9006, 62032, RADIOLINJA" },
	{ L"20030225:143807", L"9006, 18, RADIOLINJA" },
	{ L"20030225:143907", L"9006, 18, RADIOLINJA" },
	{ L"20030225:143909", L"9006, 18, RADIOLINJA" },
	{ L"20030225:143919", L"9006, 18, RADIOLINJA" },
	{ L"20030225:144002", L"9006, 18, RADIOLINJA" },
	{ L"20030225:144002", L"9006, 18, RADIOLINJA" },
	{ L"20030225:144023", L"9006, 376, RADIOLINJA" },
	{ L"20030225:144054", L"9006, 18, RADIOLINJA" },
	{ L"20030225:144110", L"9006, 62032, RADIOLINJA" },
	{ L"20030225:144121", L"9006, 399, RADIOLINJA" },
	{ L"20030225:144152", L"9006, 18, RADIOLINJA" },
	{ L"20030225:144535", L"9006, 18, RADIOLINJA" },
	{ L"20030225:144542", L"9006, 18, RADIOLINJA" },
	{ L"20030225:145112", L"9006, 376, RADIOLINJA" },
	{ L"20030225:145127", L"9006, 18, RADIOLINJA" },
	{ L"20030225:145138", L"9006, 376, RADIOLINJA" },
	{ L"20030225:145154", L"9006, 18, RADIOLINJA" },
	{ L"20030225:145314", L"9006, 376, RADIOLINJA" },
	{ L"20030225:145330", L"9006, 399, RADIOLINJA" },
	{ L"20030225:145339", L"9006, 376, RADIOLINJA" },
	{ L"20030225:145348", L"9006, 399, RADIOLINJA" },
	{ L"20030225:145914", L"9006, 376, RADIOLINJA" },
	{ L"20030225:145930", L"9006, 399, RADIOLINJA" },
	{ L"20030225:145930", L"SWITCH" },
	{ L"20030301:163030", L"9006, 399, RADIOLINJA" },
	{ L"20030301:163030", L"SWITCH" },
	{ L"20030301:165104", L"9006, 399, RADIOLINJA" },
	{ L"20030301:165104", L"SWITCH" },
	{ L"20030301:172709", L"9006, 399, RADIOLINJA" },
	{ L"20030301:172709", L"SWITCH" },
	{ L"20030301:172743", L"9006, 399, RADIOLINJA" },
	{ L"20030301:172743", L"SWITCH" },
	{ L"20030301:173007", L"9006, 399, RADIOLINJA" },
	{ L"20030301:174341", L"9006, 1493, RADIOLINJA" },
	{ L"20030301:174531", L"9006, 399, RADIOLINJA" },
	{ L"20030301:174547", L"9006, 1493, RADIOLINJA" },
	{ L"20030301:174607", L"9006, 601, RADIOLINJA" },
	{ L"20030301:174646", L"9006, 1493, RADIOLINJA" },
	{ L"20030301:174731", L"9006, 550, RADIOLINJA" },
	{ L"20030301:174950", L"9006, 38583, RADIOLINJA" },
	{ L"20030301:175039", L"9006, 232, RADIOLINJA" },
	{ L"20030301:175152", L"9006, 233, RADIOLINJA" },
	{ L"20030301:175250", L"9006, 3900, RADIOLINJA" },
	{ L"20030301:175323", L"9006, 511, RADIOLINJA" },
	{ L"20030301:175501", L"9006, 67, RADIOLINJA" },
	{ L"20030301:175603", L"9000, 15128, RADIOLINJA" },
	{ L"20030301:175626", L"9000, 62017, RADIOLINJA" },
	{ L"20030301:175650", L"9000, 35781, RADIOLINJA" },
	{ L"20030301:175706", L"9000, 168, RADIOLINJA" },
	{ L"20030301:175717", L"9000, 62019, RADIOLINJA" },
	{ L"20030301:175817", L"9000, 440, RADIOLINJA" },
	{ L"20030301:175835", L"9000, 4373, RADIOLINJA" },
	{ L"20030301:175844", L"9000, 188, RADIOLINJA" },
	{ L"20030301:180243", L"9000, 215, RADIOLINJA" },
	{ L"20030301:180349", L"9000, 62098, RADIOLINJA" },
	{ L"20030301:180417", L"9000, 62596, RADIOLINJA" },
	{ L"20030301:180611", L"9000, 316, RADIOLINJA" },
	{ L"20030301:180620", L"9000, 62596, RADIOLINJA" },
	{ L"20030301:180904", L"9000, 316, RADIOLINJA" },
	{ L"20030301:180943", L"9000, 62596, RADIOLINJA" },
	{ L"20030301:181026", L"9000, 316, RADIOLINJA" },
	{ L"20030301:181042", L"9000, 62596, RADIOLINJA" },
	{ L"20030301:181145", L"9000, 316, RADIOLINJA" },
	{ L"20030301:181155", L"9000, 62596, RADIOLINJA" },
	{ L"20030301:181609", L"9000, 316, RADIOLINJA" },
	{ L"20030301:181626", L"9000, 15266, RADIOLINJA" },
	{ L"20030301:181705", L"9000, 316, RADIOLINJA" },
	{ L"20030301:181722", L"9000, 62596, RADIOLINJA" },
	{ L"20030301:181800", L"9000, 316, RADIOLINJA" },
	{ L"20030301:181828", L"9000, 15266, RADIOLINJA" },
	{ L"20030301:181902", L"9000, 316, RADIOLINJA" },
	{ L"20030301:181918", L"9000, 15266, RADIOLINJA" },
	{ L"20030301:181934", L"9000, 316, RADIOLINJA" },
	{ L"20030301:182002", L"9000, 15266, RADIOLINJA" },
	{ L"20030301:182558", L"9000, 316, RADIOLINJA" },
	{ L"20030301:182609", L"9000, 62596, RADIOLINJA" },
	{ L"20030301:182832", L"9000, 316, RADIOLINJA" },
	{ L"20030301:182841", L"9000, 62596, RADIOLINJA" },
	{ L"20030301:183028", L"9000, 316, RADIOLINJA" },
	{ L"20030301:183045", L"9000, 62596, RADIOLINJA" },
	{ L"20030301:183308", L"9000, 316, RADIOLINJA" },
	{ L"20030301:183323", L"9000, 62596, RADIOLINJA" },
	{ L"20030301:183929", L"9000, 62098, RADIOLINJA" },
	{ L"20030301:183945", L"9000, 215, RADIOLINJA" },
	{ L"20030301:185659", L"9000, 215, RADIOLINJA" },
	{ L"20030301:185721", L"9000, 62993, RADIOLINJA" },
	{ L"20030301:185731", L"9000, 215, RADIOLINJA" },
	{ L"20030301:185941", L"9000, 62993, RADIOLINJA" },
	{ L"20030301:190013", L"9000, 215, RADIOLINJA" },
	{ L"20030301:190045", L"9000, 62993, RADIOLINJA" },
	{ L"20030301:190149", L"9000, 215, RADIOLINJA" },
	{ L"20030301:190226", L"9000, 62098, RADIOLINJA" },
	{ L"20030301:190242", L"9000, 396, RADIOLINJA" },
	{ L"20030301:190256", L"9000, 15276, RADIOLINJA" },
	{ L"20030301:190437", L"9000, 396, RADIOLINJA" },
	{ L"20030301:190620", L"9000, 62034, RADIOLINJA" },
	{ L"20030301:190826", L"9000, 1969, RADIOLINJA" },
	{ L"20030301:190903", L"9000, 350, RADIOLINJA" },
	{ L"20030301:191013", L"9000, 62124, RADIOLINJA" },
	{ L"20030301:191034", L"9000, 62125, RADIOLINJA" },
	{ L"20030301:191134", L"9000, 62124, RADIOLINJA" },
	{ L"20030301:191146", L"9000, 62125, RADIOLINJA" },
	{ L"20030301:191323", L"9000, 62124, RADIOLINJA" },
	{ L"20030301:191352", L"9000, 62125, RADIOLINJA" },
	{ L"20030301:192910", L"9000, 62124, RADIOLINJA" },
	{ L"20030301:192930", L"9000, 62125, RADIOLINJA" },
	{ L"20030301:193012", L"9000, 62124, RADIOLINJA" },
	{ L"20030301:193029", L"9000, 62125, RADIOLINJA" },
	{ L"20030301:193550", L"9000, 62124, RADIOLINJA" },
	{ L"20030301:193604", L"9000, 62125, RADIOLINJA" },
	{ L"20030301:194616", L"9000, 62125, RADIOLINJA" },
	{ L"20030301:194948", L"9000, 15227, RADIOLINJA" },
	{ L"20030301:194948", L"SWITCH" },
	{ L"20030301:205650", L"9000, 62125, RADIOLINJA" },
	{ L"20030301:205802", L"9000, 15227, RADIOLINJA" },
	{ L"20030301:205802", L"SWITCH" },
	{ L"20030302:130632", L"9006, 399, RADIOLINJA" },
	{ L"20030302:131245", L"9006, 376, RADIOLINJA" },
	{ L"20030302:131347", L"9006, 399, RADIOLINJA" },
	{ L"20030302:132424", L"9006, 376, RADIOLINJA" },
	{ L"20030302:132615", L"9006, 399, RADIOLINJA" },
	{ L"20030302:132630", L"9006, 376, RADIOLINJA" },
	{ L"20030302:132702", L"9006, 399, RADIOLINJA" },
	{ L"20030302:132721", L"9006, 376, RADIOLINJA" },
	{ L"20030302:132827", L"9006, 399, RADIOLINJA" },
	{ L"20030302:133025", L"9006, 376, RADIOLINJA" },
	{ L"20030302:133107", L"9006, 399, RADIOLINJA" },
	{ L"20030302:133131", L"9006, 376, RADIOLINJA" },
	{ L"20030302:133256", L"9006, 399, RADIOLINJA" },
	{ L"20030302:133447", L"9006, 376, RADIOLINJA" },
	{ L"20030302:133846", L"9006, 399, RADIOLINJA" },
	{ L"20030302:134003", L"9006, 376, RADIOLINJA" },
	{ L"20030302:134726", L"9006, 399, RADIOLINJA" },
	{ L"20030302:134900", L"9006, 376, RADIOLINJA" },
	{ L"20030302:135014", L"9006, 399, RADIOLINJA" },
	{ L"20030302:135101", L"9006, 376, RADIOLINJA" },
	{ L"20030302:135152", L"9006, 399, RADIOLINJA" },
	{ L"20030302:135210", L"9006, 376, RADIOLINJA" },
	{ L"20030302:135428", L"9006, 399, RADIOLINJA" },
	{ L"20030302:135526", L"9006, 376, RADIOLINJA" },
	{ L"20030302:135606", L"9006, 399, RADIOLINJA" },
	{ L"20030302:135653", L"9006, 376, RADIOLINJA" },
	{ L"20030302:135855", L"9006, 399, RADIOLINJA" },
	{ L"20030302:140206", L"9006, 18, RADIOLINJA" },
	{ L"20030302:140232", L"9006, 376, RADIOLINJA" },
	{ L"20030302:140708", L"9006, 18, RADIOLINJA" },
	{ L"20030302:140814", L"9006, 376, RADIOLINJA" },
	{ L"20030302:141435", L"9006, 15306, RADIOLINJA" },
	{ L"20030302:141456", L"9006, 376, RADIOLINJA" },
	{ L"20030302:142028", L"9006, 18, RADIOLINJA" },
	{ L"20030302:142044", L"9006, 376, RADIOLINJA" },
	{ L"20030302:142550", L"9006, 15306, RADIOLINJA" },
	{ L"20030302:142558", L"9006, 376, RADIOLINJA" },
	{ L"20030302:142732", L"9006, 4707, RADIOLINJA" },
	{ L"20030302:142747", L"9006, 376, RADIOLINJA" },
	{ L"20030302:150110", L"9006, 18, RADIOLINJA" },
	{ L"20030302:150120", L"9006, 399, RADIOLINJA" },
	{ L"20030302:150239", L"9006, 376, RADIOLINJA" },
	{ L"20030302:150255", L"9006, 399, RADIOLINJA" },
	{ L"20030302:154144", L"9006, 376, RADIOLINJA" },
	{ L"20030302:154537", L"9006, 399, RADIOLINJA" },
	{ L"20030302:161620", L"9006, 376, RADIOLINJA" },
	{ L"20030302:161636", L"9006, 399, RADIOLINJA" },
	{ L"20030302:163145", L"9006, 376, RADIOLINJA" },
	{ L"20030302:163159", L"9006, 399, RADIOLINJA" },
	{ L"20030302:163911", L"9006, 376, RADIOLINJA" },
	{ L"20030302:164015", L"9006, 399, RADIOLINJA" },
	{ L"20030302:164616", L"9006, 399, RADIOLINJA" },
	{ L"20030302:164619", L"9006, 399, RADIOLINJA" },
	{ L"20030302:165442", L"9006, 399, RADIOLINJA" },
	{ L"20030302:165443", L"9006, 399, RADIOLINJA" },
	{ L"20030302:165518", L"9006, 399, RADIOLINJA" },
	{ L"20030302:165519", L"9006, 399, RADIOLINJA" },
	{ L"20030302:165617", L"9006, 376, RADIOLINJA" },
	{ L"20030302:165850", L"9006, 399, RADIOLINJA" },
	{ L"20030302:165945", L"9006, 1493, RADIOLINJA" },
	{ L"20030302:170014", L"9006, 399, RADIOLINJA" },
	{ L"20030302:170014", L"SWITCH" },
	{ L"20030303:115431", L"9006, 399, RADIOLINJA" },
	{ L"20030303:115431", L"SWITCH" },
	{ L"20030303:115602", L"9006, 376, RADIOLINJA" },
	{ L"20030303:115619", L"9006, 399, RADIOLINJA" },
	{ L"20030303:115924", L"9006, 376, RADIOLINJA" },
	{ L"20030303:115937", L"9006, 399, RADIOLINJA" },
	{ L"20030303:120340", L"9006, 1493, RADIOLINJA" },
	{ L"20030303:120705", L"9006, 550, RADIOLINJA" },
	{ L"20030303:120854", L"9006, 38583, RADIOLINJA" },
	{ L"20030303:121003", L"9006, 232, RADIOLINJA" },
	{ L"20030303:121012", L"9006, 62142, RADIOLINJA" },
	{ L"20030303:121022", L"9006, 232, RADIOLINJA" },
	{ L"20030303:121052", L"9006, 233, RADIOLINJA" },
	{ L"20030303:121150", L"9006, 3900, RADIOLINJA" },
	{ L"20030303:121233", L"9006, 511, RADIOLINJA" },
	{ L"20030303:121408", L"9006, 67, RADIOLINJA" },
	{ L"20030303:121655", L"9000, 15128, RADIOLINJA" },
	{ L"20030303:121710", L"9000, 62017, RADIOLINJA" },
	{ L"20030303:121719", L"9000, 35781, RADIOLINJA" },
	{ L"20030303:121730", L"9000, 168, RADIOLINJA" },
	{ L"20030303:121747", L"9000, 62019, RADIOLINJA" },
	{ L"20030303:121853", L"9000, 440, RADIOLINJA" },
	{ L"20030303:121919", L"9000, 4373, RADIOLINJA" },
	{ L"20030303:121930", L"9000, 188, RADIOLINJA" },
	{ L"20030303:122312", L"9000, 15206, RADIOLINJA" },
	{ L"20030303:122603", L"9000, 645, RADIOLINJA" },
	{ L"20030303:122631", L"9000, 37887, RADIOLINJA" },
	{ L"20030303:122840", L"9000, 15135, RADIOLINJA" },
	{ L"20030303:122852", L"9000, 62034, RADIOLINJA" },
	{ L"20030303:123147", L"9000, 35769, RADIOLINJA" },
	{ L"20030303:123221", L"9000, 320, RADIOLINJA" },
	{ L"20030303:123855", L"9000, 35769, RADIOLINJA" },
	{ L"20030303:123912", L"9000, 320, RADIOLINJA" },
	{ L"20030303:124508", L"9000, 35769, RADIOLINJA" },
	{ L"20030303:124522", L"9000, 320, RADIOLINJA" },
	{ L"20030303:124522", L"SWITCH" },
	{ L"20030303:125009", L"9000, 320, RADIOLINJA" },
	{ L"20030303:130937", L"9000, 35769, RADIOLINJA" },
	{ L"20030303:130947", L"9000, 320, RADIOLINJA" },
	{ L"20030303:131208", L"9000, 62034, RADIOLINJA" },
	{ L"20030303:131223", L"9000, 320, RADIOLINJA" },
	{ L"20030303:131556", L"9000, 62034, RADIOLINJA" },
	{ L"20030303:131622", L"9000, 320, RADIOLINJA" },
	{ L"20030303:131641", L"9000, 62034, RADIOLINJA" },
	{ L"20030303:131914", L"9000, 15135, RADIOLINJA" },
	{ L"20030303:132037", L"9000, 26, RADIOLINJA" },
	{ L"20030303:132112", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:132201", L"9000, 1969, RADIOLINJA" },
	{ L"20030303:132230", L"9000, 26, RADIOLINJA" },
	{ L"20030303:132247", L"9000, 1969, RADIOLINJA" },
	{ L"20030303:132352", L"9000, 26, RADIOLINJA" },
	{ L"20030303:132401", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:132417", L"9000, 1969, RADIOLINJA" },
	{ L"20030303:132433", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:132540", L"9000, 26, RADIOLINJA" },
	{ L"20030303:132630", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:132630", L"SWITCH" },
	{ L"20030303:134153", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:134245", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:134313", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:134355", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:134625", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:134657", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:135941", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:140036", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:140115", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:140216", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:140355", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:140420", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:140503", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:140503", L"SWITCH" },
	{ L"20030303:140503", L"SWITCH" },
	{ L"20030303:140503", L"SWITCH" },
	{ L"20030303:140503", L"SWITCH" },
	{ L"20030303:141140", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:141218", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:141307", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:141513", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:141549", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:141625", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:141950", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:143605", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:143621", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:143707", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:143801", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:145422", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:145422", L"SWITCH" },
	{ L"20030303:145739", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:145809", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:150208", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:150340", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:151314", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:151331", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:151427", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:151427", L"SWITCH" },
	{ L"20030303:151834", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:151858", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:151941", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:152000", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:152108", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:152156", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:152206", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:152222", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:152238", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:153416", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:153425", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:153632", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:153647", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:154504", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:154535", L"9000, 15227, RADIOLINJA" },
	{ L"20030303:154535", L"SWITCH" },
	{ L"20030303:155701", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:155734", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:155855", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:155912", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:160443", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:160727", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:161222", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:161252", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:161308", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:161308", L"SWITCH" },
	{ L"20030303:161416", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:161443", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:161459", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:161509", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:161533", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:161741", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:162403", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:162509", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:162600", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:162616", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:162829", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:162845", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:163156", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:163213", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:163753", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:164521", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:164555", L"9000, 62125, RADIOLINJA" },
	{ L"20030303:165321", L"9000, 62124, RADIOLINJA" },
	{ L"20030303:165753", L"9000, 15227, RADIOLINJA" },
	{ L"20030303:165753", L"SWITCH" },
	{ L"20030315:120251", L"9006, 399, RADIOLINJA" },
	{ L"20030315:121429", L"9006, 376, RADIOLINJA" },
	{ L"20030315:121457", L"9006, 399, RADIOLINJA" },
	{ L"20030315:121540", L"9006, 376, RADIOLINJA" },
	{ L"20030315:121556", L"9006, 399, RADIOLINJA" },
	{ L"20030315:121639", L"9006, 18, RADIOLINJA" },
	{ L"20030315:121655", L"9006, 399, RADIOLINJA" },
	{ L"20030315:121712", L"9006, 18, RADIOLINJA" },
	{ L"20030315:121737", L"9006, 399, RADIOLINJA" },
	{ L"20030315:121753", L"9006, 18, RADIOLINJA" },
	{ L"20030315:121907", L"9006, 399, RADIOLINJA" },
	{ L"20030315:121917", L"9006, 18, RADIOLINJA" },
	{ L"20030315:121935", L"9006, 376, RADIOLINJA" },
	{ L"20030315:121951", L"9006, 18, RADIOLINJA" },
	{ L"20030315:122008", L"9006, 376, RADIOLINJA" },
	{ L"20030315:122017", L"9006, 399, RADIOLINJA" },
	{ L"20030315:122032", L"9006, 376, RADIOLINJA" },
	{ L"20030315:122043", L"9006, 18, RADIOLINJA" },
	{ L"20030315:122147", L"9006, 399, RADIOLINJA" },
	{ L"20030315:122229", L"9006, 18, RADIOLINJA" },
	{ L"20030315:122257", L"9006, 399, RADIOLINJA" },
	{ L"20030315:122310", L"9006, 62032, RADIOLINJA" },
	{ L"20030315:122324", L"9006, 18, RADIOLINJA" },
	{ L"20030315:122346", L"9006, 399, RADIOLINJA" },
	{ L"20030315:122430", L"9006, 18, RADIOLINJA" },
	{ L"20030315:122635", L"9006, 399, RADIOLINJA" },
	{ L"20030315:122651", L"9006, 18, RADIOLINJA" },
	{ L"20030315:123127", L"9006, 399, RADIOLINJA" },
	{ L"20030315:123149", L"9006, 18, RADIOLINJA" },
	{ L"20030315:123352", L"9006, 399, RADIOLINJA" },
	{ L"20030315:123644", L"9006, 18, RADIOLINJA" },
	{ L"20030315:123734", L"9006, 376, RADIOLINJA" },
	{ L"20030315:123750", L"9006, 18, RADIOLINJA" },
	{ L"20030315:124146", L"9006, 376, RADIOLINJA" },
	{ L"20030315:124203", L"9006, 399, RADIOLINJA" },
	{ L"20030315:124241", L"9006, 376, RADIOLINJA" },
	{ L"20030315:124257", L"9006, 399, RADIOLINJA" },
	{ L"20030315:124314", L"9006, 18, RADIOLINJA" },
	{ L"20030315:124430", L"9006, 399, RADIOLINJA" },
	{ L"20030315:124501", L"9006, 18, RADIOLINJA" },
	{ L"20030315:124517", L"9006, 376, RADIOLINJA" },
	{ L"20030315:124649", L"9006, 18, RADIOLINJA" },
	{ L"20030315:124810", L"9006, 376, RADIOLINJA" },
	{ L"20030315:124931", L"9006, 18, RADIOLINJA" },
	{ L"20030315:124947", L"9006, 62032, RADIOLINJA" },
	{ L"20030315:125118", L"9006, 399, RADIOLINJA" },
	{ L"20030315:125156", L"9006, 376, RADIOLINJA" },
	{ L"20030315:125211", L"9006, 18, RADIOLINJA" },
	{ L"20030315:125316", L"9006, 62032, RADIOLINJA" },
	{ L"20030315:125332", L"9006, 399, RADIOLINJA" },
	{ L"20030315:125429", L"9006, 62032, RADIOLINJA" },
	{ L"20030315:125446", L"9006, 399, RADIOLINJA" },
	{ L"20030315:125502", L"9006, 62032, RADIOLINJA" },
	{ L"20030315:125517", L"9006, 399, RADIOLINJA" },
	{ L"20030315:125534", L"9006, 18, RADIOLINJA" },
	{ L"20030315:125607", L"9006, 62032, RADIOLINJA" },
	{ L"20030315:125617", L"9006, 18, RADIOLINJA" },
	{ L"20030315:125827", L"9006, 399, RADIOLINJA" },
	{ L"20030315:130019", L"9006, 18, RADIOLINJA" },
	{ L"20030315:130117", L"9006, 62032, RADIOLINJA" },
	{ L"20030315:130130", L"9006, 399, RADIOLINJA" },
	{ L"20030315:130146", L"9006, 18, RADIOLINJA" },
	{ L"20030315:130633", L"9006, 376, RADIOLINJA" },
	{ L"20030315:130712", L"9006, 18, RADIOLINJA" },
	{ L"20030315:131017", L"9006, 376, RADIOLINJA" },
	{ L"20030315:131034", L"9006, 15306, RADIOLINJA" },
	{ L"20030315:131051", L"9006, 18, RADIOLINJA" },
	{ L"20030315:131107", L"9006, 399, RADIOLINJA" },
	{ L"20030315:131124", L"9006, 18, RADIOLINJA" },
	{ L"20030315:131141", L"9006, 62032, RADIOLINJA" },
	{ L"20030315:131156", L"9006, 18, RADIOLINJA" },
	{ L"20030315:131236", L"9006, 399, RADIOLINJA" },
	{ L"20030315:131252", L"9006, 376, RADIOLINJA" },
	{ L"20030315:131323", L"9006, 18, RADIOLINJA" },
	{ L"20030315:131339", L"9006, 399, RADIOLINJA" },
	{ L"20030315:131403", L"9006, 18, RADIOLINJA" },
	{ L"20030315:131423", L"9006, 399, RADIOLINJA" },
	{ L"20030315:131528", L"9006, 18, RADIOLINJA" },
	{ L"20030315:133711", L"9006, 62032, RADIOLINJA" },
	{ L"20030315:133939", L"9006, 18, RADIOLINJA" },
	{ L"20030315:134251", L"9006, 399, RADIOLINJA" },
	{ L"20030315:134310", L"9006, 18, RADIOLINJA" },
	{ L"20030315:134835", L"9006, 399, RADIOLINJA" },
	{ L"20030315:134851", L"9006, 376, RADIOLINJA" },
	{ L"20030315:134900", L"9006, 18, RADIOLINJA" },
	{ L"20030315:135128", L"9006, 399, RADIOLINJA" },
	{ L"20030315:135628", L"9006, 376, RADIOLINJA" },
	{ L"20030315:135637", L"9006, 399, RADIOLINJA" },
	{ L"20030315:140006", L"9006, 376, RADIOLINJA" },
	{ L"20030315:140017", L"9006, 15306, RADIOLINJA" },
	{ L"20030315:140713", L"9006, 18, RADIOLINJA" },
	{ L"20030315:140728", L"9006, 399, RADIOLINJA" },
	{ L"20030315:140746", L"9006, 18, RADIOLINJA" },
	{ L"20030315:140800", L"9006, 399, RADIOLINJA" },
	{ L"20030315:140907", L"9006, 18, RADIOLINJA" },
	{ L"20030315:140938", L"9006, 15306, RADIOLINJA" },
	{ L"20030315:141042", L"9006, 18, RADIOLINJA" },
	{ L"20030315:141415", L"9006, 15306, RADIOLINJA" },
	{ L"20030315:141509", L"9006, 18, RADIOLINJA" },
	{ L"20030315:141520", L"9006, 399, RADIOLINJA" },
	{ L"20030315:141752", L"9006, 18, RADIOLINJA" },
	{ L"20030315:141809", L"9006, 15306, RADIOLINJA" },
	{ L"20030315:141840", L"9006, 18, RADIOLINJA" },
	{ L"20030315:141856", L"9006, 399, RADIOLINJA" },
	{ L"20030315:144327", L"9006, 376, RADIOLINJA" },
	{ L"20030315:144416", L"9006, 399, RADIOLINJA" },
	{ L"20030315:144959", L"9006, 376, RADIOLINJA" },
	{ L"20030315:145019", L"9006, 399, RADIOLINJA" },
	{ L"20030315:145046", L"9006, 376, RADIOLINJA" },
	{ L"20030315:145110", L"9006, 399, RADIOLINJA" },
	{ L"20030315:145126", L"9006, 376, RADIOLINJA" },
	{ L"20030315:145157", L"9006, 399, RADIOLINJA" },
	{ L"20030315:145218", L"9006, 376, RADIOLINJA" },
	{ L"20030315:145244", L"9006, 399, RADIOLINJA" },
	{ L"20030315:145301", L"9006, 376, RADIOLINJA" },
	{ L"20030315:145441", L"9006, 399, RADIOLINJA" },
	{ L"20030315:145541", L"9006, 376, RADIOLINJA" },
	{ L"20030315:145636", L"9006, 399, RADIOLINJA" },
	{ L"20030315:150842", L"9006, 376, RADIOLINJA" },
	{ L"20030315:150907", L"9006, 399, RADIOLINJA" },
	{ L"20030315:150925", L"9006, 376, RADIOLINJA" },
	{ L"20030315:151101", L"9006, 399, RADIOLINJA" },
	{ L"20030315:151508", L"9006, 376, RADIOLINJA" },
	{ L"20030315:151540", L"9006, 399, RADIOLINJA" },
	{ L"20030315:151559", L"9006, 376, RADIOLINJA" },
	{ L"20030315:151615", L"9006, 399, RADIOLINJA" },
	{ L"20030315:151615", L"SWITCH" },
	{ L"20030317:091738", L"9112, 36026, RADIOLINJA" },
	{ L"20030317:091755", L"9112, 15142, RADIOLINJA" },
	{ L"20030317:091812", L"9112, 1984, RADIOLINJA" },
	{ L"20030317:091901", L"9111, 287, RADIOLINJA" },
	{ L"20030317:091941", L"9111, 36021, RADIOLINJA" },
	{ L"20030317:092025", L"9111, 37688, RADIOLINJA" },
	{ L"20030317:092054", L"9111, 36960, RADIOLINJA" },
	{ L"20030317:092132", L"9111, 5, RADIOLINJA" },
	{ L"20030317:092141", L"9111, 40321, RADIOLINJA" },
	{ L"20030317:092157", L"9111, 40800, RADIOLINJA" },
	{ L"20030317:092216", L"9111, 5, RADIOLINJA" },
	{ L"20030317:092226", L"9111, 3513, RADIOLINJA" },
	{ L"20030317:092238", L"9111, 40258, RADIOLINJA" },
	{ L"20030317:092304", L"9111, 39443, RADIOLINJA" },
	{ L"20030317:092330", L"9111, 39443, RADIOLINJA" },
	{ L"20030317:092347", L"9111, 39443, RADIOLINJA" },
	{ L"20030317:092347", L"9111, 39443, RADIOLINJA" },
	{ L"20030317:092412", L"9113, 35598, RADIOLINJA" },
	{ L"20030317:092412", L"9113, 35598, RADIOLINJA" },
	{ L"20030317:092441", L"9113, 41753, RADIOLINJA" },
	{ L"20030317:092518", L"9113, 41754, RADIOLINJA" },
	{ L"20030317:092530", L"9113, 42278, RADIOLINJA" },
	{ L"20030317:092611", L"9113, 42278, RADIOLINJA" },
	{ L"20030317:092617", L"9113, 35576, RADIOLINJA" },
	{ L"20030317:092650", L"9113, 35576, RADIOLINJA" },
	{ L"20030317:092652", L"9170, 42000, RADIOLINJA" },
	{ L"20030317:092654", L"9170, 42000, RADIOLINJA" },
	{ L"20030317:092655", L"9170, 42000, RADIOLINJA" },
	{ L"20030317:092725", L"9113, 35574, RADIOLINJA" },
	{ L"20030317:092731", L"9170, 15284, RADIOLINJA" },
	{ L"20030317:092806", L"9170, 15281, RADIOLINJA" },
	{ L"20030317:092830", L"9170, 41729, RADIOLINJA" },
	{ L"20030317:092903", L"9170, 2280, RADIOLINJA" },
	{ L"20030317:092954", L"9170, 15028, RADIOLINJA" },
	{ L"20030317:093005", L"9170, 41738, RADIOLINJA" },
	{ L"20030317:093028", L"9170, 41738, RADIOLINJA" },
	{ L"20030317:093036", L"9170, 41737, RADIOLINJA" },
	{ L"20030317:093036", L"9170, 41737, RADIOLINJA" },
	{ L"20030317:093046", L"9170, 42314, RADIOLINJA" },
	{ L"20030317:093138", L"9170, 15080, RADIOLINJA" },
	{ L"20030317:093218", L"9170, 313, RADIOLINJA" },
	{ L"20030317:093228", L"9170, 41636, RADIOLINJA" },
	{ L"20030317:093244", L"9170, 313, RADIOLINJA" },
	{ L"20030317:093322", L"9170, 4271, RADIOLINJA" },
	{ L"20030317:093331", L"9170, 37758, RADIOLINJA" },
	{ L"20030317:093348", L"9170, 15136, RADIOLINJA" },
	{ L"20030317:093412", L"9170, 37758, RADIOLINJA" },
	{ L"20030317:093557", L"9170, 37758, RADIOLINJA" },
	{ L"20030317:093557", L"9170, 37758, RADIOLINJA" },
	{ L"20030317:093558", L"9170, 37758, RADIOLINJA" },
	{ L"20030317:093608", L"9170, 36586, RADIOLINJA" },
	{ L"20030317:093809", L"9170, 4732, RADIOLINJA" },
	{ L"20030317:093827", L"9170, 36585, RADIOLINJA" },
	{ L"20030317:093926", L"9170, 48, RADIOLINJA" },
	{ L"20030317:094035", L"9170, 384, RADIOLINJA" },
	{ L"20030317:094104", L"9170, 47, RADIOLINJA" },
	{ L"20030317:094206", L"9170, 1514, RADIOLINJA" },
	{ L"20030317:094302", L"9170, 244, RADIOLINJA" },
	{ L"20030317:094348", L"9170, 15366, RADIOLINJA" },
	{ L"20030317:094357", L"9170, 244, RADIOLINJA" },
	{ L"20030317:094413", L"9170, 387, RADIOLINJA" },
	{ L"20030317:094721", L"9170, 15037, RADIOLINJA" },
	{ L"20030317:094949", L"9170, 1476, RADIOLINJA" },
	{ L"20030317:094957", L"9170, 15037, RADIOLINJA" },
	{ L"20030317:095113", L"3900, 2261, RADIOLINJA" },
	{ L"20030317:095328", L"3900, 1210, RADIOLINJA" },
	{ L"20030317:095625", L"3900, 39313, RADIOLINJA" },
	{ L"20030317:095729", L"3900, 38979, RADIOLINJA" },
	{ L"20030317:095853", L"3900, 30143, RADIOLINJA" },
	{ L"20030317:095921", L"3900, 38979, RADIOLINJA" },
	{ L"20030317:095934", L"3900, 30143, RADIOLINJA" },
	{ L"20030317:100040", L"3910, 41671, RADIOLINJA" },
	{ L"20030317:100054", L"3910, 35217, RADIOLINJA" },
	{ L"20030317:100109", L"3910, 1413, RADIOLINJA" },
	{ L"20030317:100118", L"3910, 41671, RADIOLINJA" },
	{ L"20030317:100222", L"3910, 42018, RADIOLINJA" },
	{ L"20030317:100237", L"3910, 41638, RADIOLINJA" },
	{ L"20030317:100248", L"3910, 1411, RADIOLINJA" },
	{ L"20030317:100330", L"3910, 3215, RADIOLINJA" },
	{ L"20030317:100346", L"3910, 1693, RADIOLINJA" },
	{ L"20030317:100410", L"3910, 41637, RADIOLINJA" },
	{ L"20030317:100418", L"3910, 37426, RADIOLINJA" },
	{ L"20030317:100518", L"3910, 37202, RADIOLINJA" },
	{ L"20030317:100646", L"3911, 39570, RADIOLINJA" },
	{ L"20030317:100701", L"3911, 2223, RADIOLINJA" },
	{ L"20030317:100727", L"3911, 39570, RADIOLINJA" },
	{ L"20030317:100835", L"3911, 38969, RADIOLINJA" },
	{ L"20030317:101026", L"3911, 30137, RADIOLINJA" },
	{ L"20030317:101250", L"3900, 41055, RADIOLINJA" },
	{ L"20030317:101319", L"3900, 1761, RADIOLINJA" },
	{ L"20030317:101401", L"3900, 684, RADIOLINJA" },
	{ L"20030317:101425", L"3900, 41055, RADIOLINJA" },
	{ L"20030317:101449", L"3900, 2793, RADIOLINJA" },
	{ L"20030317:101457", L"3900, 41055, RADIOLINJA" },
	{ L"20030317:101554", L"3900, 1212, RADIOLINJA" },
	{ L"20030317:101651", L"3900, 2793, RADIOLINJA" },
	{ L"20030317:101853", L"3901, 39408, RADIOLINJA" },
	{ L"20030317:102130", L"3901, 3342, RADIOLINJA" },
	{ L"20030317:102412", L"3901, 40620, RADIOLINJA" },
	{ L"20030317:102421", L"3901, 3342, RADIOLINJA" },
	{ L"20030317:102437", L"3901, 40620, RADIOLINJA" },
	{ L"20030317:102538", L"3901, 1736, RADIOLINJA" },
	{ L"20030317:102547", L"3901, 40621, RADIOLINJA" },
	{ L"20030317:102721", L"3900, 1740, RADIOLINJA" },
	{ L"20030317:102800", L"3900, 1280, RADIOLINJA" },
	{ L"20030317:103120", L"3900, 1740, RADIOLINJA" },
	{ L"20030317:103128", L"3900, 1280, RADIOLINJA" },
	{ L"20030317:103326", L"3900, 1740, RADIOLINJA" },
	{ L"20030317:103335", L"3900, 642, RADIOLINJA" },
	{ L"20030317:103356", L"3900, 1740, RADIOLINJA" },
	{ L"20030317:103416", L"3900, 1280, RADIOLINJA" },
	{ L"20030317:103517", L"3900, 1740, RADIOLINJA" },
	{ L"20030317:103525", L"3900, 1280, RADIOLINJA" },
	{ L"20030317:105452", L"3900, 1740, RADIOLINJA" },
	{ L"20030317:105521", L"3900, 1280, RADIOLINJA" },
	{ L"20030317:105700", L"3900, 1740, RADIOLINJA" },
	{ L"20030317:105716", L"3900, 1280, RADIOLINJA" },
	{ L"20030317:105745", L"3900, 1740, RADIOLINJA" },
	{ L"20030317:105805", L"3900, 1280, RADIOLINJA" },
	{ L"20030317:105834", L"3900, 642, RADIOLINJA" },
	{ L"20030317:105842", L"3900, 1280, RADIOLINJA" },
	{ L"20030317:110134", L"3900, 642, RADIOLINJA" },
	{ L"20030317:110158", L"3900, 1280, RADIOLINJA" },
	{ L"20030317:110459", L"3900, 1740, RADIOLINJA" },
	{ L"20030317:110508", L"3900, 1280, RADIOLINJA" },
	{ L"20030317:110817", L"3900, 642, RADIOLINJA" },
	{ L"20030317:110826", L"3900, 2254, RADIOLINJA" },
	{ L"20030317:110845", L"3900, 1280, RADIOLINJA" },
	{ L"20030317:110858", L"3900, 643, RADIOLINJA" },
	{ L"20030317:110907", L"3900, 2254, RADIOLINJA" },
	{ L"20030317:111041", L"3900, 1216, RADIOLINJA" },
	{ L"20030317:111131", L"3900, 30148, RADIOLINJA" },
	{ L"20030317:111140", L"3900, 1216, RADIOLINJA" },
	{ L"20030317:111420", L"3900, 30148, RADIOLINJA" },
	{ L"20030317:111806", L"3900, 30131, RADIOLINJA" },
	{ L"20030317:111821", L"3900, 1774, RADIOLINJA" },
	{ L"20030317:112003", L"3900, 41666, RADIOLINJA" },
	{ L"20030317:112201", L"3900, 41665, RADIOLINJA" },
	{ L"20030317:112332", L"3900, 39888, RADIOLINJA" },
	{ L"20030317:112517", L"3900, 2216, RADIOLINJA" },
	{ L"20030317:112526", L"3900, 41684, RADIOLINJA" },
	{ L"20030317:112549", L"3900, 2216, RADIOLINJA" },
	{ L"20030317:112652", L"3900, 1765, RADIOLINJA" },
	{ L"20030317:112727", L"3900, 37467, RADIOLINJA" },
	{ L"20030317:112755", L"3900, 2216, RADIOLINJA" },
	{ L"20030317:112827", L"3900, 1765, RADIOLINJA" },
	{ L"20030317:112845", L"3900, 37467, RADIOLINJA" },
	{ L"20030317:112859", L"3900, 1765, RADIOLINJA" },
	{ L"20030317:113112", L"3900, 1766, RADIOLINJA" },
	{ L"20030317:113259", L"3900, 41059, RADIOLINJA" },
	{ L"20030317:113313", L"3900, 41060, RADIOLINJA" },
	{ L"20030317:113411", L"3900, 1746, RADIOLINJA" },
	{ L"20030317:113423", L"3900, 1249, RADIOLINJA" },
	{ L"20030317:113507", L"3900, 1746, RADIOLINJA" },
	{ L"20030317:113731", L"3900, 30144, RADIOLINJA" },
	{ L"20030317:113837", L"3900, 37442, RADIOLINJA" },
	{ L"20030317:113846", L"3900, 30144, RADIOLINJA" },
	{ L"20030317:114001", L"3900, 1773, RADIOLINJA" },
	{ L"20030317:114355", L"3900, 1773, RADIOLINJA" },
	{ L"20030317:114404", L"1800, 41970, RADIOLINJA" },
	{ L"20030317:114422", L"1800, 41970, RADIOLINJA" },
	{ L"20030317:114425", L"3900, 38972, RADIOLINJA" },
	{ L"20030317:114427", L"3900, 38972, RADIOLINJA" },
	{ L"20030317:114429", L"3900, 38972, RADIOLINJA" },
	{ L"20030317:114519", L"1800, 1064, RADIOLINJA" },
	{ L"20030317:114534", L"1800, 4570, RADIOLINJA" },
	{ L"20030317:114600", L"1800, 4571, RADIOLINJA" },
	{ L"20030317:114620", L"1800, 41970, RADIOLINJA" },
	{ L"20030317:114705", L"1800, 1064, RADIOLINJA" },
	{ L"20030317:114733", L"1800, 5033, RADIOLINJA" },
	{ L"20030317:114807", L"1800, 38338, RADIOLINJA" },
	{ L"20030317:114943", L"3900, 38972, RADIOLINJA" },
	{ L"20030317:115339", L"3900, 35624, RADIOLINJA" },
	{ L"20030317:115355", L"3900, 38972, RADIOLINJA" },
	{ L"20030317:115418", L"3900, 35624, RADIOLINJA" },
	{ L"20030317:115456", L"3900, 38972, RADIOLINJA" },
	{ L"20030317:115512", L"3900, 6460, RADIOLINJA" },
	{ L"20030317:115521", L"3900, 35624, RADIOLINJA" },
	{ L"20030317:115543", L"3900, 38972, RADIOLINJA" },
	{ L"20030317:115556", L"3900, 35624, RADIOLINJA" },
	{ L"20030317:115636", L"3900, 6460, RADIOLINJA" },
	{ L"20030317:115850", L"3900, 3453, RADIOLINJA" },
	{ L"20030317:115905", L"14300, 1465, RADIOLINJA" },
	{ L"20030317:115915", L"14300, 1465, RADIOLINJA" },
	{ L"20030317:115915", L"14300, 1465, RADIOLINJA" },
	{ L"20030317:115926", L"3900, 3453, RADIOLINJA" },
	{ L"20030317:120003", L"14300, 1465, RADIOLINJA" },
	{ L"20030317:120022", L"3900, 3453, RADIOLINJA" },
	{ L"20030317:120026", L"3900, 3453, RADIOLINJA" },
	{ L"20030317:120026", L"3900, 3453, RADIOLINJA" },
	{ L"20030317:120029", L"14300, 39277, RADIOLINJA" },
	{ L"20030317:120404", L"14300, 1465, RADIOLINJA" },
	{ L"20030317:120424", L"14300, 39277, RADIOLINJA" },
	{ L"20030317:120638", L"14300, 40407, RADIOLINJA" },
	{ L"20030317:121344", L"14300, 40362, RADIOLINJA" },
	{ L"20030317:121523", L"14300, 40363, RADIOLINJA" },
	{ L"20030317:121757", L"14300, 40431, RADIOLINJA" },
	{ L"20030317:121826", L"14300, 20246, RADIOLINJA" },
	{ L"20030317:121835", L"14300, 40431, RADIOLINJA" },
	{ L"20030317:121936", L"14300, 20246, RADIOLINJA" },
	{ L"20030317:122006", L"14300, 40363, RADIOLINJA" },
	{ L"20030317:122022", L"14300, 20246, RADIOLINJA" },
	{ L"20030317:122104", L"14300, 40363, RADIOLINJA" },
	{ L"20030317:122131", L"14300, 20246, RADIOLINJA" },
	{ L"20030317:122516", L"14300, 6455, RADIOLINJA" },
	{ L"20030317:122713", L"14300, 9703, RADIOLINJA" },
	{ L"20030317:122732", L"14300, 6455, RADIOLINJA" },
	{ L"20030317:122811", L"1800, 41938, RADIOLINJA" },
	{ L"20030317:122943", L"1800, 3058, RADIOLINJA" },
	{ L"20030317:123243", L"1800, 6205, RADIOLINJA" },
	{ L"20030317:123411", L"1800, 41298, RADIOLINJA" },
	{ L"20030317:123420", L"1800, 4094, RADIOLINJA" },
	{ L"20030317:123447", L"1800, 41951, RADIOLINJA" },
	{ L"20030317:123539", L"1800, 2075, RADIOLINJA" },
	{ L"20030317:123608", L"1800, 4793, RADIOLINJA" },
	{ L"20030317:123625", L"1800, 2075, RADIOLINJA" },
	{ L"20030317:123658", L"1800, 4791, RADIOLINJA" },
	{ L"20030317:123717", L"1800, 2075, RADIOLINJA" },
	{ L"20030317:123752", L"1800, 4094, RADIOLINJA" },
	{ L"20030317:123942", L"1800, 5049, RADIOLINJA" },
	{ L"20030317:124012", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:124454", L"1800, 610, RADIOLINJA" },
	{ L"20030317:124525", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:124645", L"1800, 610, RADIOLINJA" },
	{ L"20030317:124702", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:124817", L"1800, 610, RADIOLINJA" },
	{ L"20030317:124855", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:124917", L"1800, 610, RADIOLINJA" },
	{ L"20030317:124931", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:125236", L"1800, 610, RADIOLINJA" },
	{ L"20030317:125256", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:125409", L"1800, 610, RADIOLINJA" },
	{ L"20030317:125431", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:125504", L"1800, 610, RADIOLINJA" },
	{ L"20030317:125528", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:131013", L"1800, 610, RADIOLINJA" },
	{ L"20030317:131027", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:131522", L"1800, 610, RADIOLINJA" },
	{ L"20030317:131843", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:131859", L"1800, 610, RADIOLINJA" },
	{ L"20030317:131937", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:132038", L"1800, 610, RADIOLINJA" },
	{ L"20030317:132302", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:132623", L"1800, 610, RADIOLINJA" },
	{ L"20030317:132659", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:132723", L"1800, 610, RADIOLINJA" },
	{ L"20030317:132803", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:133133", L"1800, 610, RADIOLINJA" },
	{ L"20030317:133153", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:133926", L"1800, 610, RADIOLINJA" },
	{ L"20030317:134033", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:134048", L"1800, 610, RADIOLINJA" },
	{ L"20030317:134123", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:134217", L"1800, 610, RADIOLINJA" },
	{ L"20030317:134239", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:134410", L"1800, 610, RADIOLINJA" },
	{ L"20030317:134536", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:134739", L"1800, 610, RADIOLINJA" },
	{ L"20030317:134747", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:134805", L"1800, 610, RADIOLINJA" },
	{ L"20030317:134834", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:134900", L"1800, 610, RADIOLINJA" },
	{ L"20030317:134915", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:135049", L"1800, 610, RADIOLINJA" },
	{ L"20030317:135201", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:135446", L"1800, 610, RADIOLINJA" },
	{ L"20030317:135651", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:135743", L"1800, 610, RADIOLINJA" },
	{ L"20030317:135812", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:135919", L"1800, 610, RADIOLINJA" },
	{ L"20030317:140026", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:140129", L"1800, 610, RADIOLINJA" },
	{ L"20030317:140219", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:140339", L"1800, 610, RADIOLINJA" },
	{ L"20030317:140408", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:140429", L"1800, 610, RADIOLINJA" },
	{ L"20030317:140514", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:140643", L"1800, 610, RADIOLINJA" },
	{ L"20030317:140727", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:140815", L"1800, 610, RADIOLINJA" },
	{ L"20030317:140831", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:140927", L"1800, 610, RADIOLINJA" },
	{ L"20030317:141102", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:141133", L"1800, 610, RADIOLINJA" },
	{ L"20030317:141147", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:141307", L"1800, 610, RADIOLINJA" },
	{ L"20030317:141338", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:141547", L"1800, 610, RADIOLINJA" },
	{ L"20030317:141607", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:141623", L"1800, 610, RADIOLINJA" },
	{ L"20030317:153112", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:153128", L"1800, 610, RADIOLINJA" },
	{ L"20030317:153315", L"1800, 20017, RADIOLINJA" },
	{ L"20030317:153358", L"1800, 610, RADIOLINJA" },
	{ L"20030317:153528", L"1800, 20017, RADIOLINJA" },
	{ L"20030317:153537", L"1800, 610, RADIOLINJA" },
	{ L"20030317:153715", L"1800, 20017, RADIOLINJA" },
	{ L"20030317:153726", L"1800, 610, RADIOLINJA" },
	{ L"20030317:155048", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:155131", L"1800, 610, RADIOLINJA" },
	{ L"20030317:155147", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:155208", L"1800, 610, RADIOLINJA" },
	{ L"20030317:155743", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:155759", L"1800, 610, RADIOLINJA" },
	{ L"20030317:155913", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:160001", L"1800, 610, RADIOLINJA" },
	{ L"20030317:160017", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:160118", L"1800, 610, RADIOLINJA" },
	{ L"20030317:160144", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:160254", L"1800, 610, RADIOLINJA" },
	{ L"20030317:160312", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:160417", L"1800, 610, RADIOLINJA" },
	{ L"20030317:160433", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:160515", L"1800, 610, RADIOLINJA" },
	{ L"20030317:160533", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:160602", L"1800, 610, RADIOLINJA" },
	{ L"20030317:160652", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:160729", L"1800, 610, RADIOLINJA" },
	{ L"20030317:160745", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:160924", L"1800, 610, RADIOLINJA" },
	{ L"20030317:160949", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:161009", L"1800, 610, RADIOLINJA" },
	{ L"20030317:161042", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:161134", L"1800, 610, RADIOLINJA" },
	{ L"20030317:161153", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:161329", L"1800, 610, RADIOLINJA" },
	{ L"20030317:161712", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:161739", L"1800, 610, RADIOLINJA" },
	{ L"20030317:161838", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:161856", L"1800, 610, RADIOLINJA" },
	{ L"20030317:162642", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:162802", L"1800, 610, RADIOLINJA" },
	{ L"20030317:163007", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:163049", L"1800, 610, RADIOLINJA" },
	{ L"20030317:163134", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:163205", L"1800, 610, RADIOLINJA" },
	{ L"20030317:163228", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:163314", L"1800, 610, RADIOLINJA" },
	{ L"20030317:163421", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:163429", L"1800, 610, RADIOLINJA" },
	{ L"20030317:163445", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:163755", L"1800, 610, RADIOLINJA" },
	{ L"20030317:163900", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:163917", L"1800, 610, RADIOLINJA" },
	{ L"20030317:164026", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:164042", L"1800, 610, RADIOLINJA" },
	{ L"20030317:164100", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:164241", L"1800, 610, RADIOLINJA" },
	{ L"20030317:164316", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:164341", L"1800, 610, RADIOLINJA" },
	{ L"20030317:164533", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:164604", L"1800, 610, RADIOLINJA" },
	{ L"20030317:164830", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:164903", L"1800, 610, RADIOLINJA" },
	{ L"20030317:164945", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:165022", L"1800, 610, RADIOLINJA" },
	{ L"20030317:165038", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:165105", L"1800, 610, RADIOLINJA" },
	{ L"20030317:165140", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:165211", L"1800, 610, RADIOLINJA" },
	{ L"20030317:165236", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:165254", L"1800, 610, RADIOLINJA" },
	{ L"20030317:165303", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:165430", L"1800, 610, RADIOLINJA" },
	{ L"20030317:165450", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:165529", L"1800, 610, RADIOLINJA" },
	{ L"20030317:165628", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:165648", L"1800, 610, RADIOLINJA" },
	{ L"20030317:165656", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:165841", L"1800, 610, RADIOLINJA" },
	{ L"20030317:165858", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:170015", L"1800, 610, RADIOLINJA" },
	{ L"20030317:170118", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:170137", L"1800, 610, RADIOLINJA" },
	{ L"20030317:170216", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:170225", L"1800, 610, RADIOLINJA" },
	{ L"20030317:170402", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:170425", L"1800, 610, RADIOLINJA" },
	{ L"20030317:170448", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:170555", L"1800, 610, RADIOLINJA" },
	{ L"20030317:170626", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:170803", L"1800, 610, RADIOLINJA" },
	{ L"20030317:170812", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:170915", L"1800, 610, RADIOLINJA" },
	{ L"20030317:171027", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:171318", L"1800, 610, RADIOLINJA" },
	{ L"20030317:171504", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:171648", L"1800, 610, RADIOLINJA" },
	{ L"20030317:171729", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:172015", L"1800, 610, RADIOLINJA" },
	{ L"20030317:172024", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:172102", L"1800, 610, RADIOLINJA" },
	{ L"20030317:172132", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:172210", L"1800, 610, RADIOLINJA" },
	{ L"20030317:172226", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:172246", L"1800, 610, RADIOLINJA" },
	{ L"20030317:172324", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:172359", L"1800, 610, RADIOLINJA" },
	{ L"20030317:172438", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:172524", L"1800, 610, RADIOLINJA" },
	{ L"20030317:172627", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:172643", L"1800, 610, RADIOLINJA" },
	{ L"20030317:172712", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:172745", L"1800, 610, RADIOLINJA" },
	{ L"20030317:172835", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:172906", L"1800, 610, RADIOLINJA" },
	{ L"20030317:173035", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:173107", L"1800, 610, RADIOLINJA" },
	{ L"20030317:173225", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:173553", L"1800, 610, RADIOLINJA" },
	{ L"20030317:174049", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:174204", L"1800, 610, RADIOLINJA" },
	{ L"20030317:174312", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:174408", L"1800, 610, RADIOLINJA" },
	{ L"20030317:174443", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:174534", L"1800, 610, RADIOLINJA" },
	{ L"20030317:175333", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:175406", L"1800, 610, RADIOLINJA" },
	{ L"20030317:175430", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:175446", L"1800, 610, RADIOLINJA" },
	{ L"20030317:175708", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:175731", L"1800, 610, RADIOLINJA" },
	{ L"20030317:175801", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:175839", L"1800, 610, RADIOLINJA" },
	{ L"20030317:175857", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:175953", L"1800, 610, RADIOLINJA" },
	{ L"20030317:180010", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:180019", L"1800, 610, RADIOLINJA" },
	{ L"20030317:180128", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:180246", L"1800, 610, RADIOLINJA" },
	{ L"20030317:180254", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:180641", L"1800, 610, RADIOLINJA" },
	{ L"20030317:180708", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:182059", L"1800, 610, RADIOLINJA" },
	{ L"20030317:182121", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:183124", L"1800, 610, RADIOLINJA" },
	{ L"20030317:183140", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:183215", L"1800, 610, RADIOLINJA" },
	{ L"20030317:183231", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:183621", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:183715", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:183715", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:183750", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:183750", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:184420", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:184421", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:184500", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:200610", L"1800, 610, RADIOLINJA" },
	{ L"20030317:200622", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:203719", L"1800, 610, RADIOLINJA" },
	{ L"20030317:203735", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:203908", L"1800, 610, RADIOLINJA" },
	{ L"20030317:203924", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:203959", L"1800, 610, RADIOLINJA" },
	{ L"20030317:204015", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:204044", L"1800, 610, RADIOLINJA" },
	{ L"20030317:204439", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:204610", L"1800, 610, RADIOLINJA" },
	{ L"20030317:204641", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:204827", L"1800, 610, RADIOLINJA" },
	{ L"20030317:204851", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:204946", L"1800, 610, RADIOLINJA" },
	{ L"20030317:205030", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:205655", L"1800, 610, RADIOLINJA" },
	{ L"20030317:205730", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:210041", L"1800, 610, RADIOLINJA" },
	{ L"20030317:210316", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:210508", L"1800, 610, RADIOLINJA" },
	{ L"20030317:210526", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:210544", L"1800, 610, RADIOLINJA" },
	{ L"20030317:210552", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:210835", L"1800, 610, RADIOLINJA" },
	{ L"20030317:210903", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:211145", L"1800, 610, RADIOLINJA" },
	{ L"20030317:211220", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:212645", L"1800, 610, RADIOLINJA" },
	{ L"20030317:212701", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:212800", L"1800, 610, RADIOLINJA" },
	{ L"20030317:212905", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:213127", L"1800, 610, RADIOLINJA" },
	{ L"20030317:213149", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:213205", L"1800, 610, RADIOLINJA" },
	{ L"20030317:213221", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:213655", L"1800, 610, RADIOLINJA" },
	{ L"20030317:213737", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:213827", L"1800, 610, RADIOLINJA" },
	{ L"20030317:213955", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:214024", L"1800, 610, RADIOLINJA" },
	{ L"20030317:214549", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:215656", L"1800, 610, RADIOLINJA" },
	{ L"20030317:215725", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:220439", L"1800, 610, RADIOLINJA" },
	{ L"20030317:220500", L"1800, 610, RADIOLINJA" },
	{ L"20030317:220502", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:220502", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:220722", L"1800, 610, RADIOLINJA" },
	{ L"20030317:220801", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:221401", L"1800, 610, RADIOLINJA" },
	{ L"20030317:221440", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:221456", L"1800, 610, RADIOLINJA" },
	{ L"20030317:221504", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:221649", L"1800, 610, RADIOLINJA" },
	{ L"20030317:221720", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:222145", L"1800, 610, RADIOLINJA" },
	{ L"20030317:222157", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:222300", L"1800, 610, RADIOLINJA" },
	{ L"20030317:222321", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:222436", L"1800, 610, RADIOLINJA" },
	{ L"20030317:222444", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:222926", L"1800, 610, RADIOLINJA" },
	{ L"20030317:222957", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:223400", L"1800, 610, RADIOLINJA" },
	{ L"20030317:223418", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:223641", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:223642", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:224507", L"1800, 610, RADIOLINJA" },
	{ L"20030317:224523", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:224635", L"1800, 610, RADIOLINJA" },
	{ L"20030317:224746", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:224817", L"1800, 610, RADIOLINJA" },
	{ L"20030317:224837", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:224959", L"1800, 610, RADIOLINJA" },
	{ L"20030317:225030", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:225118", L"1800, 610, RADIOLINJA" },
	{ L"20030317:225241", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:225719", L"1800, 610, RADIOLINJA" },
	{ L"20030317:225735", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:225915", L"1800, 610, RADIOLINJA" },
	{ L"20030317:225931", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:225947", L"1800, 610, RADIOLINJA" },
	{ L"20030317:230018", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:230240", L"1800, 610, RADIOLINJA" },
	{ L"20030317:230334", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:230435", L"1800, 610, RADIOLINJA" },
	{ L"20030317:230451", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:230507", L"1800, 610, RADIOLINJA" },
	{ L"20030317:230557", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:230859", L"1800, 610, RADIOLINJA" },
	{ L"20030317:230943", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:231044", L"1800, 610, RADIOLINJA" },
	{ L"20030317:231111", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:231142", L"1800, 610, RADIOLINJA" },
	{ L"20030317:231244", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:231300", L"1800, 610, RADIOLINJA" },
	{ L"20030317:231359", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:231434", L"1800, 610, RADIOLINJA" },
	{ L"20030317:231455", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:231530", L"1800, 610, RADIOLINJA" },
	{ L"20030317:231554", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:231644", L"1800, 610, RADIOLINJA" },
	{ L"20030317:231715", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:231816", L"1800, 610, RADIOLINJA" },
	{ L"20030317:231836", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:232052", L"1800, 610, RADIOLINJA" },
	{ L"20030317:232108", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:232846", L"1800, 610, RADIOLINJA" },
	{ L"20030317:232902", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:233230", L"1800, 610, RADIOLINJA" },
	{ L"20030317:233246", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:234251", L"1800, 610, RADIOLINJA" },
	{ L"20030317:234307", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:234800", L"1800, 610, RADIOLINJA" },
	{ L"20030317:234822", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:234908", L"1800, 610, RADIOLINJA" },
	{ L"20030317:234924", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:235040", L"1800, 610, RADIOLINJA" },
	{ L"20030317:235100", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:235235", L"1800, 610, RADIOLINJA" },
	{ L"20030317:235251", L"1800, 41719, RADIOLINJA" },
	{ L"20030317:235806", L"1800, 610, RADIOLINJA" },
	{ L"20030317:235835", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:000023", L"1800, 610, RADIOLINJA" },
	{ L"20030318:000039", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:001043", L"1800, 610, RADIOLINJA" },
	{ L"20030318:001104", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:001213", L"1800, 610, RADIOLINJA" },
	{ L"20030318:001229", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:001841", L"1800, 610, RADIOLINJA" },
	{ L"20030318:002004", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:002049", L"1800, 610, RADIOLINJA" },
	{ L"20030318:002106", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:002141", L"1800, 610, RADIOLINJA" },
	{ L"20030318:002211", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:002257", L"1800, 610, RADIOLINJA" },
	{ L"20030318:002320", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:002455", L"1800, 610, RADIOLINJA" },
	{ L"20030318:002530", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:002802", L"1800, 610, RADIOLINJA" },
	{ L"20030318:002817", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:002851", L"1800, 610, RADIOLINJA" },
	{ L"20030318:002906", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:003323", L"1800, 610, RADIOLINJA" },
	{ L"20030318:003351", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:003515", L"1800, 610, RADIOLINJA" },
	{ L"20030318:003542", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:003611", L"1800, 610, RADIOLINJA" },
	{ L"20030318:003627", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:003643", L"1800, 610, RADIOLINJA" },
	{ L"20030318:003729", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:004133", L"1800, 610, RADIOLINJA" },
	{ L"20030318:004149", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:004242", L"1800, 610, RADIOLINJA" },
	{ L"20030318:004302", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:004324", L"1800, 610, RADIOLINJA" },
	{ L"20030318:004340", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:004502", L"1800, 610, RADIOLINJA" },
	{ L"20030318:004540", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:004747", L"1800, 610, RADIOLINJA" },
	{ L"20030318:004805", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:005335", L"1800, 610, RADIOLINJA" },
	{ L"20030318:005351", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:005625", L"1800, 610, RADIOLINJA" },
	{ L"20030318:010008", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:010035", L"1800, 610, RADIOLINJA" },
	{ L"20030318:010051", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:010122", L"1800, 610, RADIOLINJA" },
	{ L"20030318:010140", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:010232", L"1800, 610, RADIOLINJA" },
	{ L"20030318:010259", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:010330", L"1800, 610, RADIOLINJA" },
	{ L"20030318:010409", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:010516", L"1800, 610, RADIOLINJA" },
	{ L"20030318:010547", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:010625", L"1800, 610, RADIOLINJA" },
	{ L"20030318:010652", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:010725", L"1800, 610, RADIOLINJA" },
	{ L"20030318:010942", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:010958", L"1800, 610, RADIOLINJA" },
	{ L"20030318:011114", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:011134", L"1800, 610, RADIOLINJA" },
	{ L"20030318:011243", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:011302", L"1800, 610, RADIOLINJA" },
	{ L"20030318:011326", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:011414", L"1800, 610, RADIOLINJA" },
	{ L"20030318:011608", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:011641", L"1800, 610, RADIOLINJA" },
	{ L"20030318:011657", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:011820", L"1800, 610, RADIOLINJA" },
	{ L"20030318:012130", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:012147", L"1800, 610, RADIOLINJA" },
	{ L"20030318:012235", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:012303", L"1800, 610, RADIOLINJA" },
	{ L"20030318:012408", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:012426", L"1800, 610, RADIOLINJA" },
	{ L"20030318:012623", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:012649", L"1800, 610, RADIOLINJA" },
	{ L"20030318:012720", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:012834", L"1800, 610, RADIOLINJA" },
	{ L"20030318:013206", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:013301", L"1800, 610, RADIOLINJA" },
	{ L"20030318:013726", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:013759", L"1800, 610, RADIOLINJA" },
	{ L"20030318:013900", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:013923", L"1800, 610, RADIOLINJA" },
	{ L"20030318:014039", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:014133", L"1800, 610, RADIOLINJA" },
	{ L"20030318:014149", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:014205", L"1800, 610, RADIOLINJA" },
	{ L"20030318:014221", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:014241", L"1800, 610, RADIOLINJA" },
	{ L"20030318:014416", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:014458", L"1800, 610, RADIOLINJA" },
	{ L"20030318:014614", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:014645", L"1800, 610, RADIOLINJA" },
	{ L"20030318:014724", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:014810", L"1800, 610, RADIOLINJA" },
	{ L"20030318:014830", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:015035", L"1800, 610, RADIOLINJA" },
	{ L"20030318:015051", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:015148", L"1800, 610, RADIOLINJA" },
	{ L"20030318:015208", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:015455", L"1800, 610, RADIOLINJA" },
	{ L"20030318:015512", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:015553", L"1800, 610, RADIOLINJA" },
	{ L"20030318:015609", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:015636", L"1800, 610, RADIOLINJA" },
	{ L"20030318:015654", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:015801", L"1800, 610, RADIOLINJA" },
	{ L"20030318:015817", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:015916", L"1800, 610, RADIOLINJA" },
	{ L"20030318:015932", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:020051", L"1800, 610, RADIOLINJA" },
	{ L"20030318:020122", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:020153", L"1800, 610, RADIOLINJA" },
	{ L"20030318:020231", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:020251", L"1800, 610, RADIOLINJA" },
	{ L"20030318:020307", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:020414", L"1800, 610, RADIOLINJA" },
	{ L"20030318:020430", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:020555", L"1800, 610, RADIOLINJA" },
	{ L"20030318:020649", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:020915", L"1800, 610, RADIOLINJA" },
	{ L"20030318:020942", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:021011", L"1800, 610, RADIOLINJA" },
	{ L"20030318:021059", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:021145", L"1800, 610, RADIOLINJA" },
	{ L"20030318:021201", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:021223", L"1800, 610, RADIOLINJA" },
	{ L"20030318:021239", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:021304", L"1800, 610, RADIOLINJA" },
	{ L"20030318:021421", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:021726", L"1800, 610, RADIOLINJA" },
	{ L"20030318:021805", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:021821", L"1800, 610, RADIOLINJA" },
	{ L"20030318:021922", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:022237", L"1800, 610, RADIOLINJA" },
	{ L"20030318:022252", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:022344", L"1800, 610, RADIOLINJA" },
	{ L"20030318:022400", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:022632", L"1800, 610, RADIOLINJA" },
	{ L"20030318:022706", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:022838", L"1800, 610, RADIOLINJA" },
	{ L"20030318:022911", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:023012", L"1800, 610, RADIOLINJA" },
	{ L"20030318:023050", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:023301", L"1800, 610, RADIOLINJA" },
	{ L"20030318:023330", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:023504", L"1800, 610, RADIOLINJA" },
	{ L"20030318:023529", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:023623", L"1800, 610, RADIOLINJA" },
	{ L"20030318:023650", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:023715", L"1800, 610, RADIOLINJA" },
	{ L"20030318:023739", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:023946", L"1800, 610, RADIOLINJA" },
	{ L"20030318:024007", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:024048", L"1800, 610, RADIOLINJA" },
	{ L"20030318:024104", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:024534", L"1800, 610, RADIOLINJA" },
	{ L"20030318:024613", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:024628", L"1800, 610, RADIOLINJA" },
	{ L"20030318:024644", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:024859", L"1800, 610, RADIOLINJA" },
	{ L"20030318:024915", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:025058", L"1800, 610, RADIOLINJA" },
	{ L"20030318:025129", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:025200", L"1800, 610, RADIOLINJA" },
	{ L"20030318:025244", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:025300", L"1800, 610, RADIOLINJA" },
	{ L"20030318:025316", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:025332", L"1800, 610, RADIOLINJA" },
	{ L"20030318:025348", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:025434", L"1800, 610, RADIOLINJA" },
	{ L"20030318:025452", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:025826", L"1800, 610, RADIOLINJA" },
	{ L"20030318:025905", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:030012", L"1800, 610, RADIOLINJA" },
	{ L"20030318:030029", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:030101", L"1800, 610, RADIOLINJA" },
	{ L"20030318:030109", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:030831", L"1800, 610, RADIOLINJA" },
	{ L"20030318:030850", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:031322", L"1800, 610, RADIOLINJA" },
	{ L"20030318:031338", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:031517", L"1800, 610, RADIOLINJA" },
	{ L"20030318:031533", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:031939", L"1800, 610, RADIOLINJA" },
	{ L"20030318:031958", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:032603", L"1800, 610, RADIOLINJA" },
	{ L"20030318:032611", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:032731", L"1800, 610, RADIOLINJA" },
	{ L"20030318:032747", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:033058", L"1800, 610, RADIOLINJA" },
	{ L"20030318:033116", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:033405", L"1800, 610, RADIOLINJA" },
	{ L"20030318:033420", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:033503", L"1800, 610, RADIOLINJA" },
	{ L"20030318:033519", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:033851", L"1800, 610, RADIOLINJA" },
	{ L"20030318:033905", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:034129", L"1800, 610, RADIOLINJA" },
	{ L"20030318:034141", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:034409", L"1800, 610, RADIOLINJA" },
	{ L"20030318:034426", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:034458", L"1800, 610, RADIOLINJA" },
	{ L"20030318:034506", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:034713", L"1800, 610, RADIOLINJA" },
	{ L"20030318:034729", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:034827", L"1800, 610, RADIOLINJA" },
	{ L"20030318:034842", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:035048", L"1800, 610, RADIOLINJA" },
	{ L"20030318:035122", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:035301", L"1800, 610, RADIOLINJA" },
	{ L"20030318:035332", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:035721", L"1800, 610, RADIOLINJA" },
	{ L"20030318:035818", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:041029", L"1800, 610, RADIOLINJA" },
	{ L"20030318:041045", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:041328", L"1800, 610, RADIOLINJA" },
	{ L"20030318:041337", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:041727", L"1800, 610, RADIOLINJA" },
	{ L"20030318:041751", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:041848", L"1800, 610, RADIOLINJA" },
	{ L"20030318:041914", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:042005", L"1800, 610, RADIOLINJA" },
	{ L"20030318:042033", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:042051", L"1800, 610, RADIOLINJA" },
	{ L"20030318:042118", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:042213", L"1800, 610, RADIOLINJA" },
	{ L"20030318:042241", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:042310", L"1800, 610, RADIOLINJA" },
	{ L"20030318:042326", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:042459", L"1800, 610, RADIOLINJA" },
	{ L"20030318:042528", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:042626", L"1800, 610, RADIOLINJA" },
	{ L"20030318:042708", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:042841", L"1800, 610, RADIOLINJA" },
	{ L"20030318:042953", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:043019", L"1800, 610, RADIOLINJA" },
	{ L"20030318:043317", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:043338", L"1800, 610, RADIOLINJA" },
	{ L"20030318:043430", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:043448", L"1800, 610, RADIOLINJA" },
	{ L"20030318:043600", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:043713", L"1800, 610, RADIOLINJA" },
	{ L"20030318:043837", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:043932", L"1800, 610, RADIOLINJA" },
	{ L"20030318:044026", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:044053", L"1800, 610, RADIOLINJA" },
	{ L"20030318:044147", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:044210", L"1800, 610, RADIOLINJA" },
	{ L"20030318:044349", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:044433", L"1800, 610, RADIOLINJA" },
	{ L"20030318:044512", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:044549", L"1800, 610, RADIOLINJA" },
	{ L"20030318:044627", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:044645", L"1800, 610, RADIOLINJA" },
	{ L"20030318:044801", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:044828", L"1800, 610, RADIOLINJA" },
	{ L"20030318:044939", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:045006", L"1800, 610, RADIOLINJA" },
	{ L"20030318:045104", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:045121", L"1800, 610, RADIOLINJA" },
	{ L"20030318:045149", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:045207", L"1800, 610, RADIOLINJA" },
	{ L"20030318:045452", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:045610", L"1800, 610, RADIOLINJA" },
	{ L"20030318:045644", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:045727", L"1800, 610, RADIOLINJA" },
	{ L"20030318:050115", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:050205", L"1800, 610, RADIOLINJA" },
	{ L"20030318:050307", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:050338", L"1800, 610, RADIOLINJA" },
	{ L"20030318:050416", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:050438", L"1800, 610, RADIOLINJA" },
	{ L"20030318:050456", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:050625", L"1800, 610, RADIOLINJA" },
	{ L"20030318:050641", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:050657", L"1800, 610, RADIOLINJA" },
	{ L"20030318:050713", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:050759", L"1800, 610, RADIOLINJA" },
	{ L"20030318:050900", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:050920", L"1800, 610, RADIOLINJA" },
	{ L"20030318:051040", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:051107", L"1800, 610, RADIOLINJA" },
	{ L"20030318:051135", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:051213", L"1800, 610, RADIOLINJA" },
	{ L"20030318:051229", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:051249", L"1800, 610, RADIOLINJA" },
	{ L"20030318:051335", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:051410", L"1800, 610, RADIOLINJA" },
	{ L"20030318:051441", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:051516", L"1800, 610, RADIOLINJA" },
	{ L"20030318:051552", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:051642", L"1800, 610, RADIOLINJA" },
	{ L"20030318:051656", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:051731", L"1800, 610, RADIOLINJA" },
	{ L"20030318:051806", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:051845", L"1800, 610, RADIOLINJA" },
	{ L"20030318:051916", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:052002", L"1800, 610, RADIOLINJA" },
	{ L"20030318:052033", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:052140", L"1800, 610, RADIOLINJA" },
	{ L"20030318:052205", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:052240", L"1800, 610, RADIOLINJA" },
	{ L"20030318:052256", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:052357", L"1800, 610, RADIOLINJA" },
	{ L"20030318:052413", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:052448", L"1800, 610, RADIOLINJA" },
	{ L"20030318:052504", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:052520", L"1800, 610, RADIOLINJA" },
	{ L"20030318:052536", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:052639", L"1800, 610, RADIOLINJA" },
	{ L"20030318:052655", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:052733", L"1800, 610, RADIOLINJA" },
	{ L"20030318:052852", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:052909", L"1800, 610, RADIOLINJA" },
	{ L"20030318:052925", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:053051", L"1800, 610, RADIOLINJA" },
	{ L"20030318:053122", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:053149", L"1800, 610, RADIOLINJA" },
	{ L"20030318:053222", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:053314", L"1800, 610, RADIOLINJA" },
	{ L"20030318:053330", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:053348", L"1800, 610, RADIOLINJA" },
	{ L"20030318:053428", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:053452", L"1800, 610, RADIOLINJA" },
	{ L"20030318:053519", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:053539", L"1800, 610, RADIOLINJA" },
	{ L"20030318:053621", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:053707", L"1800, 610, RADIOLINJA" },
	{ L"20030318:053748", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:053942", L"1800, 610, RADIOLINJA" },
	{ L"20030318:054105", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:054303", L"1800, 610, RADIOLINJA" },
	{ L"20030318:054321", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:054433", L"1800, 610, RADIOLINJA" },
	{ L"20030318:054447", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:054859", L"1800, 610, RADIOLINJA" },
	{ L"20030318:054915", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:055005", L"1800, 610, RADIOLINJA" },
	{ L"20030318:055020", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:055127", L"1800, 610, RADIOLINJA" },
	{ L"20030318:055136", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:055218", L"1800, 610, RADIOLINJA" },
	{ L"20030318:055249", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:055501", L"1800, 610, RADIOLINJA" },
	{ L"20030318:055516", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:055642", L"1800, 610, RADIOLINJA" },
	{ L"20030318:055658", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:055725", L"1800, 610, RADIOLINJA" },
	{ L"20030318:055804", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:055943", L"1800, 610, RADIOLINJA" },
	{ L"20030318:060021", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:060342", L"1800, 610, RADIOLINJA" },
	{ L"20030318:060358", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:060459", L"1800, 610, RADIOLINJA" },
	{ L"20030318:060507", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:060603", L"1800, 610, RADIOLINJA" },
	{ L"20030318:060626", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:060659", L"1800, 610, RADIOLINJA" },
	{ L"20030318:060719", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:060815", L"1800, 610, RADIOLINJA" },
	{ L"20030318:060838", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:060958", L"1800, 610, RADIOLINJA" },
	{ L"20030318:061025", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:061134", L"1800, 610, RADIOLINJA" },
	{ L"20030318:061150", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:061251", L"1800, 610, RADIOLINJA" },
	{ L"20030318:061309", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:061409", L"1800, 610, RADIOLINJA" },
	{ L"20030318:061417", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:061507", L"1800, 610, RADIOLINJA" },
	{ L"20030318:061522", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:061631", L"1800, 610, RADIOLINJA" },
	{ L"20030318:061649", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:061726", L"1800, 610, RADIOLINJA" },
	{ L"20030318:061805", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:062144", L"1800, 610, RADIOLINJA" },
	{ L"20030318:062300", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:062431", L"1800, 610, RADIOLINJA" },
	{ L"20030318:062517", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:062755", L"1800, 610, RADIOLINJA" },
	{ L"20030318:062809", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:062838", L"1800, 610, RADIOLINJA" },
	{ L"20030318:062924", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:062948", L"1800, 610, RADIOLINJA" },
	{ L"20030318:063007", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:063050", L"1800, 610, RADIOLINJA" },
	{ L"20030318:063105", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:063243", L"1800, 610, RADIOLINJA" },
	{ L"20030318:063257", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:063350", L"1800, 610, RADIOLINJA" },
	{ L"20030318:063406", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:063835", L"1800, 610, RADIOLINJA" },
	{ L"20030318:063852", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:064105", L"1800, 610, RADIOLINJA" },
	{ L"20030318:064125", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:064154", L"1800, 610, RADIOLINJA" },
	{ L"20030318:064227", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:064343", L"1800, 610, RADIOLINJA" },
	{ L"20030318:064407", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:064735", L"1800, 610, RADIOLINJA" },
	{ L"20030318:064813", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:065113", L"1800, 610, RADIOLINJA" },
	{ L"20030318:065135", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:065255", L"1800, 610, RADIOLINJA" },
	{ L"20030318:065309", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:065347", L"1800, 610, RADIOLINJA" },
	{ L"20030318:065405", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:065533", L"1800, 610, RADIOLINJA" },
	{ L"20030318:065619", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:065747", L"1800, 610, RADIOLINJA" },
	{ L"20030318:065802", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:065837", L"1800, 610, RADIOLINJA" },
	{ L"20030318:065853", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:065915", L"1800, 610, RADIOLINJA" },
	{ L"20030318:065944", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:070023", L"1800, 610, RADIOLINJA" },
	{ L"20030318:070124", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:070202", L"1800, 610, RADIOLINJA" },
	{ L"20030318:070218", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:070312", L"1800, 610, RADIOLINJA" },
	{ L"20030318:070328", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:070344", L"1800, 610, RADIOLINJA" },
	{ L"20030318:070408", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:070446", L"1800, 610, RADIOLINJA" },
	{ L"20030318:070502", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:070607", L"1800, 610, RADIOLINJA" },
	{ L"20030318:070723", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:070841", L"1800, 610, RADIOLINJA" },
	{ L"20030318:070857", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:070913", L"1800, 610, RADIOLINJA" },
	{ L"20030318:070943", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:071034", L"1800, 610, RADIOLINJA" },
	{ L"20030318:071113", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:071210", L"1800, 610, RADIOLINJA" },
	{ L"20030318:071226", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:071819", L"1800, 610, RADIOLINJA" },
	{ L"20030318:071905", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:072105", L"1800, 610, RADIOLINJA" },
	{ L"20030318:072121", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:072307", L"1800, 610, RADIOLINJA" },
	{ L"20030318:072323", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:072358", L"1800, 610, RADIOLINJA" },
	{ L"20030318:072414", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:073039", L"1800, 610, RADIOLINJA" },
	{ L"20030318:073426", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:073445", L"1800, 610, RADIOLINJA" },
	{ L"20030318:073535", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:073544", L"1800, 610, RADIOLINJA" },
	{ L"20030318:073611", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:073627", L"1800, 610, RADIOLINJA" },
	{ L"20030318:073724", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:073740", L"1800, 610, RADIOLINJA" },
	{ L"20030318:073756", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:073833", L"1800, 610, RADIOLINJA" },
	{ L"20030318:073936", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:073954", L"1800, 610, RADIOLINJA" },
	{ L"20030318:074118", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:074149", L"1800, 610, RADIOLINJA" },
	{ L"20030318:074346", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:074447", L"1800, 610, RADIOLINJA" },
	{ L"20030318:074503", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:074533", L"1800, 610, RADIOLINJA" },
	{ L"20030318:074617", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:074648", L"1800, 610, RADIOLINJA" },
	{ L"20030318:074705", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:074803", L"1800, 610, RADIOLINJA" },
	{ L"20030318:075031", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:075251", L"1800, 610, RADIOLINJA" },
	{ L"20030318:075305", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:075528", L"1800, 610, RADIOLINJA" },
	{ L"20030318:075629", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:075758", L"1800, 610, RADIOLINJA" },
	{ L"20030318:075842", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:075851", L"1800, 610, RADIOLINJA" },
	{ L"20030318:075903", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:075919", L"1800, 610, RADIOLINJA" },
	{ L"20030318:080024", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:080129", L"1800, 610, RADIOLINJA" },
	{ L"20030318:080147", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:081453", L"1800, 610, RADIOLINJA" },
	{ L"20030318:081531", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:081636", L"1800, 610, RADIOLINJA" },
	{ L"20030318:081705", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:081740", L"1800, 610, RADIOLINJA" },
	{ L"20030318:081807", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:082135", L"1800, 610, RADIOLINJA" },
	{ L"20030318:082151", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:082224", L"1800, 610, RADIOLINJA" },
	{ L"20030318:082318", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:082501", L"1800, 610, RADIOLINJA" },
	{ L"20030318:082516", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:082833", L"1800, 610, RADIOLINJA" },
	{ L"20030318:082902", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:083930", L"1800, 610, RADIOLINJA" },
	{ L"20030318:083953", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:084352", L"1800, 610, RADIOLINJA" },
	{ L"20030318:084430", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:084838", L"1800, 610, RADIOLINJA" },
	{ L"20030318:084916", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:085010", L"1800, 610, RADIOLINJA" },
	{ L"20030318:085033", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:085129", L"1800, 610, RADIOLINJA" },
	{ L"20030318:085144", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:085206", L"1800, 610, RADIOLINJA" },
	{ L"20030318:085219", L"1800, 41719, RADIOLINJA" },
	{ L"20030318:085526", L"1800, 610, RADIOLINJA" },
	{ L"20030318:085548", L"1800, 41719, RADIOLINJA" },
	 
};
#endif