#include "csd_battery.h"


EXPORT_C const TTypeName& TBBBattery::Type() const
{
	return KBatteryType;
}

EXPORT_C TBool TBBBattery::Equals(const MBBData* aRhs) const
{
	const TBBBattery* rhs=bb_cast<TBBBattery>(aRhs);
	return (rhs && *this==*rhs);
}

EXPORT_C const TTypeName& TBBBattery::StaticType()
{
	return KBatteryType;
}

EXPORT_C const MBBData* TBBBattery::Part(TUint aPartNo) const
{
	if (aPartNo==0) return &iState;
	if (aPartNo==1) return &iLevel;
	return 0;
}

_LIT(KState, "status");
_LIT(KLevel, "level");

EXPORT_C TBBBattery::TBBBattery(const TDesC& aName) : TBBCompoundData(aName),
	iState(KState), iLevel(KLevel)
{
}

EXPORT_C bool TBBBattery::operator==(const TBBBattery& aRhs) const
{
	return (
		iLevel == aRhs.iLevel &&
		iState == aRhs.iState
		);
}

_LIT(KSpace, " ");

const TDesC& TBBBattery::StringSep(TUint aBeforePart) const
{
	if (aBeforePart==0 || aBeforePart>1) return KNullDesC;
	return KSpace;
}

EXPORT_C TBBBattery& TBBBattery::operator=(const TBBBattery& aBattery)
{
	iState()=aBattery.iState();
	iLevel()=aBattery.iLevel();
	return *this;
}

EXPORT_C MBBData* TBBBattery::CloneL(const TDesC& Name) const
{
	TBBBattery* ret=new (ELeave) TBBBattery(Name);
	*ret=*this;
	return ret;
}
