#include "csd_calendar.h"

EXPORT_C const TTypeName& TBBCalendarEvent::Type() const
{
	return KCalendarEventType;
}

EXPORT_C TBool TBBCalendarEvent::Equals(const MBBData* aRhs) const
{
	const TBBCalendarEvent* rhs=bb_cast<TBBCalendarEvent>(aRhs);
	return (rhs && *this==*rhs);
}

EXPORT_C const TTypeName& TBBCalendarEvent::StaticType()
{
	return KCalendarEventType;
}

EXPORT_C const MBBData* TBBCalendarEvent::Part(TUint aPartNo) const
{
	switch(aPartNo) {
	case 0:
		return &iStartTime;
	case 1:
		return &iDescription;
	case 2:
		return &iEndTime;
	default:
		return 0;
	}
}

_LIT(KDescription, "description");
_LIT(KStartTime, "start_time");
_LIT(KEndTime, "end_time");

EXPORT_C TBBCalendarEvent::TBBCalendarEvent(const TDesC& aName) : 
	TBBCompoundData(aName),
	iDescription(KDescription), iStartTime(KStartTime), iEndTime(KEndTime) { }

EXPORT_C bool TBBCalendarEvent::operator==(const TBBCalendarEvent& aRhs) const
{
	return (
		iDescription==aRhs.iDescription &&
		iStartTime()==aRhs.iStartTime() &&
		iEndTime()==aRhs.iEndTime()
		);
}

_LIT(KSemicolon, ";");

const TDesC& TBBCalendarEvent::StringSep(TUint aBeforePart) const
{
	if (aBeforePart>0 && aBeforePart<=2)
		return KSemicolon;
	else
		return KNullDesC;
}

EXPORT_C TBBCalendarEvent& TBBCalendarEvent::operator=(const TBBCalendarEvent& aRhs)
{
	iDescription()=aRhs.iDescription();
	iStartTime()=aRhs.iStartTime();
	iEndTime()=aRhs.iEndTime();

	return *this;
}

EXPORT_C MBBData* TBBCalendarEvent::CloneL(const TDesC& Name) const
{
	TBBCalendarEvent* ret=new (ELeave) TBBCalendarEvent(Name);
	*ret=*this;
	return ret;
}

EXPORT_C const TTypeName& TBBCalendar::Type() const
{
	return KCalendarType;
}

EXPORT_C TBool TBBCalendar::Equals(const MBBData* aRhs) const
{
	const TBBCalendar* rhs=bb_cast<TBBCalendar>(aRhs);
	return (rhs && *this==*rhs);
}

EXPORT_C const TTypeName& TBBCalendar::StaticType()
{
	return KCalendarType;
}

EXPORT_C const MBBData* TBBCalendar::Part(TUint aPartNo) const
{
	switch (aPartNo) {
	case 0:
		return &iPreviousOrCurrent;
	case 1:
		return &iCurrentOrNext;
	default:
		return 0;
	}
}

_LIT(KPreviousOrCurrent, "previous_or_current");
_LIT(KCurrentOrNext, "current_or_next");

EXPORT_C TBBCalendar::TBBCalendar() : TBBCompoundData(KCalendar), 
	iPreviousOrCurrent(KPreviousOrCurrent), iCurrentOrNext(KCurrentOrNext) { }

EXPORT_C bool TBBCalendar::operator==(const TBBCalendar& aRhs) const
{
	return (
		iPreviousOrCurrent==aRhs.iPreviousOrCurrent &&
		iCurrentOrNext==aRhs.iCurrentOrNext
		);
}

_LIT(KHash, "#");

const TDesC& TBBCalendar::StringSep(TUint aBeforePart) const
{
	if (aBeforePart>0 && aBeforePart<=1)
		return KHash;
	else
		return KNullDesC;
}

EXPORT_C TBBCalendar& TBBCalendar::operator=(const TBBCalendar& aRhs)
{
	iPreviousOrCurrent=aRhs.iPreviousOrCurrent;
	iCurrentOrNext=aRhs.iCurrentOrNext;

	return *this;
}

EXPORT_C MBBData* TBBCalendar::CloneL(const TDesC& ) const
{
	TBBCalendar* ret=new (ELeave) TBBCalendar;
	*ret=*this;
	return ret;
}