#include "csd_cell.h"

EXPORT_C const TTypeName& TBBShortNetworkName::Type() const
{
	return KShortNetworkNameType;
}

EXPORT_C const TTypeName& TBBShortNetworkName::StaticType()
{
	return KShortNetworkNameType;
}

EXPORT_C TBool TBBShortNetworkName::Equals(const MBBData* aRhs) const
{
	const TBBShortNetworkName* rhs=bb_cast<TBBShortNetworkName>(aRhs);
	return (rhs && iValue.Compare(rhs->iValue)==0);
}

_LIT(KMCC, "location.mcc");
_LIT(KMNC, "location.mnc");
_LIT(KShortName, "location.network");
_LIT(KLAC, "location.lac");
_LIT(KCellId, "location.cellid");
_LIT(KMappedCellId, "location.id");

EXPORT_C TBBCellId::TBBCellId(const TDesC& aName) : TBBCompoundData(aName),
	iMCC(KMCC), iMNC(KMNC), iShortName(KShortName), iLocationAreaCode(KLAC),
	iCellId(KCellId), iMappedId(KMappedCellId)
{
}

EXPORT_C bool TBBCellId::operator==(const TBBCellId& aRhs) const
{
	return (iMCC == aRhs.iMCC &&
		iMNC == aRhs.iMNC &&
		iShortName == aRhs.iShortName &&
		iLocationAreaCode == aRhs.iLocationAreaCode &&
		iCellId == aRhs.iCellId &&
		iMappedId == aRhs.iMappedId);
}

const MBBData* TBBCellId::Part(TUint aPartNo) const
{
	switch(aPartNo) {
	case 0:
		return &iMCC;
	case 1:
		return &iMNC;
	case 2:
		return &iShortName;
	case 3:
		return &iLocationAreaCode;
	case 4:
		return &iCellId;
	case 5:
		return &iMappedId;
	default:
		return 0;
	}
}

EXPORT_C const TTypeName& TBBCellId::Type() const
{
	return KCellIdType;
}

EXPORT_C const TTypeName& TBBCellId::StaticType()
{
	return KCellIdType;
}

EXPORT_C TBool TBBCellId::Equals(const MBBData* aRhs) const
{
	const TBBCellId* rhs=bb_cast<TBBCellId>(aRhs);
	return (rhs && *this==*rhs);
}

_LIT(KComma, ", ");

const TDesC& TBBCellId::StringSep(TUint aBeforePart) const
{
	if (aBeforePart>0 && aBeforePart<=4) return KComma;
	return KNullDesC;
}

EXPORT_C void TBBCellId::IntoStringL(TDes& aString) const
{
	TUint i=0;
	for (const MBBData *p=Part(i); i<5; p=Part(++i)) {
		const TDesC& sep=StringSep(i);
		CheckStringSpaceL(aString, sep.Length());
		aString.Append(sep);
		p->IntoStringL(aString);
	}
	const TDesC& sep=StringSep(i);
	CheckStringSpaceL(aString, sep.Length());
	aString.Append(sep);
}


EXPORT_C TBBCellId& TBBCellId::operator=(const TBBCellId& aRhs)
{
	iMCC()=aRhs.iMCC();
	iMNC()=aRhs.iMNC();
	iShortName()=aRhs.iShortName();
	iLocationAreaCode()=aRhs.iLocationAreaCode();
	iCellId=aRhs.iCellId();
	iMappedId()=aRhs.iMappedId();
	return *this;
}

EXPORT_C TBBCellId::TBBCellId(const TBBCellId& aRhs) : TBBCompoundData(aRhs.Name()),
	iMCC(KMCC), iMNC(KMNC), iShortName(KShortName), iLocationAreaCode(KLAC),
	iCellId(KCellId), iMappedId(KMappedCellId)
{
	iMCC()=aRhs.iMCC();
	iMNC()=aRhs.iMNC();
	iShortName()=aRhs.iShortName();
	iLocationAreaCode()=aRhs.iLocationAreaCode();
	iCellId=aRhs.iCellId();
	iMappedId()=aRhs.iMappedId();
}

EXPORT_C MBBData* TBBShortNetworkName::CloneL(const TDesC& Name) const
{
	TBBShortNetworkName* ret=new (ELeave) TBBShortNetworkName(Name);
	*ret=iValue;
	return ret;
}


EXPORT_C MBBData* TBBCellId::CloneL(const TDesC& Name) const
{
	TBBCellId* ret=new (ELeave) TBBCellId(Name);
	*ret=*this;
	return ret;
}

void SkipComma(TLex& l)
{
	TChar c;
	while ( (c=l.Get()) && c!=',');
	l.Get();
}

EXPORT_C void TBBCellId::FromStringL(const TDesC& aString)
{
	TLex l(aString);
	User::LeaveIfError(l.Val(iMCC()));
	SkipComma(l);
	User::LeaveIfError(l.Val(iMNC()));
	SkipComma(l);
	l.Mark(); SkipComma(l); 

	// network name may be empty
	if (l.MarkedToken().Length()>2) {
		iShortName()=l.MarkedToken().Left(l.MarkedToken().Length()-2);
	} else {
		iShortName().Zero();
	}
	User::LeaveIfError(l.Val(iLocationAreaCode()));
	SkipComma(l);
	User::LeaveIfError(l.Val(iCellId()));
}
