#include "csd_current_app.h"

EXPORT_C const TTypeName& TBBCurrentApp::Type() const
{
	return KCurrentAppType;
}

EXPORT_C TBool TBBCurrentApp::Equals(const MBBData* aRhs) const
{
	const TBBCurrentApp* rhs=bb_cast<TBBCurrentApp>(aRhs);
	return (rhs && *this==*rhs);
}

EXPORT_C const TTypeName& TBBCurrentApp::StaticType()
{
	return KCurrentAppType;
}

EXPORT_C const MBBData* TBBCurrentApp::Part(TUint aPartNo) const
{
	if (aPartNo==0) return &iUid;
	if (aPartNo==1) return &iCaption;
	return 0;
}

EXPORT_C TBBCurrentApp::TBBCurrentApp() : TBBCompoundData(KCurrentApp), iUid(KUid), iCaption(KCaption)
{
}

_LIT(KOpenBracket, "[");
_LIT(KCloseBracket, "] ");

const TDesC& TBBCurrentApp::StringSep(TUint aBeforePart) const
{
	if (aBeforePart==0) return KOpenBracket;
	if (aBeforePart==1) return KCloseBracket;
	return KNullDesC;
}

EXPORT_C bool TBBCurrentApp::operator==(const TBBCurrentApp& aRhs) const
{
	return (
		iUid == aRhs.iUid &&
		iCaption == aRhs.iCaption
		);
}

EXPORT_C TBBCurrentApp& TBBCurrentApp::operator=(const TBBCurrentApp& aCurrentApp)
{
	iUid()=aCurrentApp.iUid();
	iCaption()=aCurrentApp.iCaption();
	return *this;
}

EXPORT_C MBBData* TBBCurrentApp::CloneL(const TDesC&) const
{
	TBBCurrentApp* ret=new (ELeave) TBBCurrentApp;
	*ret=*this;
	return ret;
}
