#include "csd_event.h"

EXPORT_C const TTypeName& CBBSensorEvent::Type() const
{
	return KEventType;
}

EXPORT_C TBool CBBSensorEvent::Equals(const MBBData* aRhs) const
{
	const CBBSensorEvent* rhs=bb_cast<CBBSensorEvent>(aRhs);
	return (rhs && *rhs==*this);
}

EXPORT_C const TTypeName& CBBSensorEvent::StaticType()
{
	return KEventType;
}

EXPORT_C const MBBData* CBBSensorEvent::Part(TUint aPartNo) const
{
	if (aPartNo==0) return &iStamp;
	if (aPartNo==1) return &iPriority;
	if (aPartNo==2) return &iName;
	if (aPartNo==3) return &iData;
	return 0;
}

_LIT(KEventName, "eventname");

EXPORT_C CBBSensorEvent::CBBSensorEvent(const TDesC& aName, const TTupleName& aTupleName,
					MBBDataFactory* aFactory, TTime aTime, MBBData* iData, TPriority aPriority) : 
	TBBCompoundData(aName), iStamp(aTime, KStamp), iPriority(aPriority, KPriority), iName(aName, KEventName),
		iData(aFactory, iData), iFactory(aFactory), iTupleName(aTupleName)
{
}

EXPORT_C const TDesC& CBBSensorEvent::Name() const
{
	return iName();
}

EXPORT_C MBBData* CBBSensorEvent::GetPart(const TDesC& aName, const TTypeName& aType, TUint& aPartNoInto)
{
	MBBData* p=TBBCompoundData::GetPart(aName, aType, aPartNoInto);
	if (!p) {
		iData()=iFactory->CreateBBDataL(aType, aName, iFactory);
		aPartNoInto=3;
		p=&iData;
	}
	return p;
}

EXPORT_C bool CBBSensorEvent::operator==(const CBBSensorEvent& aRhs) const
{
	return (
		iStamp == aRhs.iStamp &&
		iPriority == aRhs.iPriority &&
		iData.Equals(aRhs.iData.iValue) &&
		iName == aRhs.iName );
}

EXPORT_C const TTypeName& TBBTupleSubName::Type() const
{
	return KSubNameType;
}

EXPORT_C const TTypeName& TBBTupleSubName::StaticType()
{
	return KSubNameType;
}

EXPORT_C TBool TBBTupleSubName::Equals(const MBBData* aRhs) const
{
	const TBBTupleSubName* rhs=bb_cast<TBBTupleSubName>(aRhs);
	return (rhs && *this==*rhs);
}

EXPORT_C const TTypeName& TBBTupleMeta::Type() const
{
	return KTupleMetaType;
}

EXPORT_C TBool TBBTupleMeta::Equals(const MBBData* aRhs) const
{
	const TBBTupleMeta* rhs=bb_cast<TBBTupleMeta>(aRhs);
	return (rhs && *this==*rhs);
}

EXPORT_C const TTypeName& TBBTupleMeta::StaticType()
{
	return KTupleMetaType;
}

EXPORT_C const MBBData* TBBTupleMeta::Part(TUint aPartNo) const
{
	switch(aPartNo) {
	case 0:
		return &iModuleUid;
	case 1:
		return &iModuleId;
	case 2:
		return &iSubName;
	default:
		return 0;
	}
}

EXPORT_C TBBTupleMeta::TBBTupleMeta() : TBBCompoundData(KMeta),
	iModuleUid(0, KModuleUid), iModuleId(0, KModuleId), iSubName(KNullDesC, KSubName)
{
}

EXPORT_C TBBTupleMeta::TBBTupleMeta(TInt aModuleUid, TInt aModuleId, const TDesC& aSubName) : TBBCompoundData(KMeta),
	iModuleUid(aModuleUid, KModuleUid), iModuleId(aModuleId, KModuleId), iSubName(aSubName, KSubName)
{
}

EXPORT_C bool TBBTupleMeta::operator==(const TBBTupleMeta& aRhs) const
{
	return (
		iModuleUid==aRhs.iModuleUid &&
		iModuleId==aRhs.iModuleId &&
		iSubName==aRhs.iSubName 
		);
}

_LIT(KSpace, " ");

const TDesC& TBBTupleMeta::StringSep(TUint aBeforePart) const
{
	if (aBeforePart==0 || aBeforePart > 2) return KNullDesC;
	return KSpace;
}


EXPORT_C const TTypeName& CBBTuple::Type() const
{
	return KTupleType;
}

EXPORT_C TBool CBBTuple::Equals(const MBBData* aRhs) const
{
	const CBBTuple* rhs=bb_cast<CBBTuple>(aRhs);
	return (rhs && *this==*rhs);
}

EXPORT_C const TTypeName& CBBTuple::StaticType()
{
	return KTupleType;
}

EXPORT_C const MBBData* CBBTuple::Part(TUint aPartNo) const
{
	switch(aPartNo) {
	case 0:
		return &iTupleId;
	case 1:
		return &iTupleMeta;
	case 2:
		return &iData;
	default:
		return 0;
	}
}

_LIT(KTuple, "tuple");

EXPORT_C CBBTuple::CBBTuple(MBBDataFactory* aFactory, TUint aTupleId, TInt aModuleUid, TInt aModuleId,
			    const TDesC& aSubName, MBBData* aData) : TBBCompoundData(KTuple),
			    iTupleId(aTupleId, KId),
			    iTupleMeta(aModuleUid, aModuleId, aSubName), iData(aFactory, aData), iFactory(aFactory)
{
}

EXPORT_C bool CBBTuple::operator==(const CBBTuple& aRhs) const
{
	return (
		iTupleId==aRhs.iTupleId &&
		iTupleMeta==aRhs.iTupleMeta &&
		iData.Equals(aRhs.iData.iValue)
		);
}

const TDesC& CBBTuple::StringSep(TUint aBeforePart) const
{
	if (aBeforePart==0 || aBeforePart > 2) return KNullDesC;
	return KSpace;
}

EXPORT_C const TDesC& CBBSensorEvent::StringSep(TUint aBeforePart) const
{
	if (aBeforePart==0 || aBeforePart > 2) return KNullDesC;
	return KSpace;
}


MBBData* CBBTuple::GetPart(const TDesC& aName, const TTypeName& aType, TUint& aPartNoInto)
{
	MBBData* p=TBBCompoundData::GetPart(aName, aType, aPartNoInto);
	if (!p) {
		iData()=iFactory->CreateBBDataL(aType, aName, iFactory);
		aPartNoInto=2;
		p=&iData;
	}
	return p;
}

EXPORT_C const TTupleName& CBBSensorEvent::TupleName() const
{
	return iTupleName;
}

EXPORT_C CBBSensorEvent& CBBSensorEvent::operator=(const CBBSensorEvent& aSensorEvent)
{
	MBBData* val=0;
	if (aSensorEvent.iData.iValue) val=aSensorEvent.iData.iValue->CloneL(aSensorEvent.iData.iValue->Name());

	iStamp()=aSensorEvent.iStamp();
	iPriority()=aSensorEvent.iPriority();
	if (iData.iValue && iData.OwnsValue()) delete iData.iValue;
	iData.iValue=val;
	iData.SetOwnsValue(ETrue);
	iName()=aSensorEvent.iName();
	return *this;
}

EXPORT_C MBBData* CBBSensorEvent::CloneL(const TDesC& Name) const
{
	auto_ptr<CBBSensorEvent> ret(new (ELeave) CBBSensorEvent(Name, iTupleName, iFactory));
	*ret=*this;
	return ret.release();
}

EXPORT_C MBBData* TBBTupleSubName::CloneL(const TDesC& Name) const
{
	return new (ELeave) TBBTupleSubName(iValue, Name);
}

EXPORT_C TBBTupleMeta& TBBTupleMeta::operator=(const TBBTupleMeta& aMetaData)
{
	iModuleUid()=aMetaData.iModuleUid();
	iModuleId()=aMetaData.iModuleId();
	iSubName()=aMetaData.iSubName();
	return *this;
}

EXPORT_C MBBData* TBBTupleMeta::CloneL(const TDesC&) const
{
	return new (ELeave) TBBTupleMeta(iModuleUid(), iModuleId(), iSubName());
}

EXPORT_C CBBTuple& CBBTuple::operator=(const CBBTuple& aTuple)
{
	MBBData* val=0;
	if (aTuple.iData.iValue) {
		val=aTuple.iData.iValue->CloneL(aTuple.iData.iValue->Name());
	}
	if (iData.iValue && iData.OwnsValue()) delete iData.iValue;
	iData.iValue=val;
	iData.SetOwnsValue(ETrue);
	iTupleId()=aTuple.iTupleId();
	iTupleMeta=aTuple.iTupleMeta;
	return *this;
}
	
EXPORT_C MBBData* CBBTuple::CloneL(const TDesC& ) const
{
	auto_ptr<CBBTuple> ret(new (ELeave) CBBTuple(iFactory));
	*ret=*this;
	return ret.release();
}


