#include "csd_idle.h"

EXPORT_C const TTypeName& TBBUserActive::Type() const
{
	return KIdleType;
}

EXPORT_C TBool TBBUserActive::Equals(const MBBData* aRhs) const
{
	const TBBUserActive* rhs=bb_cast<TBBUserActive>(aRhs);
	return (rhs && *this==*rhs);
}

EXPORT_C const TTypeName& TBBUserActive::StaticType()
{
	return KIdleType;
}

EXPORT_C const MBBData* TBBUserActive::Part(TUint aPartNo) const
{
	if (aPartNo==0) return &iActive;
	if (aPartNo==1) return &iSince;
	return 0;
}

EXPORT_C MBBData* TBBUserActive::CloneL(const TDesC&) const
{
	TBBUserActive* ret=new (ELeave) TBBUserActive;
	*ret=*this;
	return ret;
}

EXPORT_C void TBBUserActive::IntoStringL(TDes& aString) const
{
	CheckStringSpaceL(aString, 6);
	if (iActive()) aString.Append(_L("active"));
	else aString.Append(_L("idle"));
}

_LIT(KActive, "active");
_LIT(KSince, "since");

EXPORT_C TBBUserActive::TBBUserActive() :  TBBCompoundData(KIdle), iActive(KActive), iSince(KSince) { }

const TDesC& TBBUserActive::StringSep(TUint) const
{
	return KNullDesC;
}

EXPORT_C bool TBBUserActive::operator==(const TBBUserActive& rhs) const
{
	return (iActive==rhs.iActive && iSince==rhs.iSince);
}

EXPORT_C TBBUserActive& TBBUserActive::operator=(const TBBUserActive& aRhs)
{
	iActive()=aRhs.iActive();
	iSince()=aRhs.iSince();
	return *this;
}

