#include "csd_loca.h"

EXPORT_C const TTypeName& TBBLocaMsgStatus::Type() const
{
	return KLocaMessageStatusType;
}

EXPORT_C TBool TBBLocaMsgStatus::Equals(const MBBData* aRhs) const
{
	const TBBLocaMsgStatus* rhs=bb_cast<TBBLocaMsgStatus>(aRhs);
	return (rhs && *rhs==*this);
}

EXPORT_C const TTypeName& TBBLocaMsgStatus::StaticType()
{
	return KLocaMessageStatusType;
}

EXPORT_C const MBBData* TBBLocaMsgStatus::Part(TUint aPartNo) const
{
	switch(aPartNo) {
	case 0:
		return &iMessageId;
	case 1:
		return &iRecipientAddress;
	case 2:
		return &iSucceeded;
	case 3:
		return &iAtTime;
	default:
		return 0;
	};
}


EXPORT_C MBBData* TBBLocaMsgStatus::CloneL(const TDesC&) const
{
	return new (ELeave) TBBLocaMsgStatus(*this);
}

_LIT(KMessageId, "messageid");
_LIT(KRecipientAddress, "recipient_address");
_LIT(KSucceeded, "succeeded");
_LIT(KAtTime, "at_time");

EXPORT_C TBBLocaMsgStatus::TBBLocaMsgStatus() : TBBCompoundData(KLocaMsgStatus),
	iMessageId(KMessageId), iRecipientAddress(KRecipientAddress),
	iSucceeded(KSucceeded), iAtTime(KAtTime) { }

EXPORT_C TBBLocaMsgStatus::TBBLocaMsgStatus(const TBBLocaMsgStatus& aFrom)  : TBBCompoundData(KLocaMsgStatus),
	iMessageId(aFrom.iMessageId(), KMessageId), 
	iRecipientAddress(aFrom.iRecipientAddress(), KRecipientAddress),
	iSucceeded(aFrom.iSucceeded(), KSucceeded),
	iAtTime(aFrom.iAtTime(), KAtTime) { }

_LIT(KSpace, " ");

const TDesC& TBBLocaMsgStatus::StringSep(TUint ) const
{
	return KSpace;
}

EXPORT_C bool TBBLocaMsgStatus::operator==(const TBBLocaMsgStatus& aRhs) const
{
	return (
		iMessageId==aRhs.iMessageId &&
		iRecipientAddress==aRhs.iRecipientAddress &&
		iSucceeded==aRhs.iSucceeded &&
		iAtTime==aRhs.iAtTime
		);
}

EXPORT_C TBBLocaMsgStatus& TBBLocaMsgStatus::operator=(const TBBLocaMsgStatus& aRhs)
{
	iMessageId()=aRhs.iMessageId();
	iRecipientAddress()=aRhs.iRecipientAddress();
	iSucceeded()=aRhs.iSucceeded();
	iAtTime()=aRhs.iAtTime();
	return *this;
}
