#include "csd_presence.h"
#include "icons.h"
#include <contextcommon.mbg>
#include <avkon.mbg>
#include <e32math.h>
#include "symbian_auto_ptr.h"

EXPORT_C CBBPresence* CBBPresence::NewL()
{
	auto_ptr<CBBPresence> ret(new (ELeave) CBBPresence);
	ret->ConstructL();
	return ret.release();
}
EXPORT_C CBBPresence* CBBPresence::NewL(TUint aVersion)
{
	auto_ptr<CBBPresence> ret(new (ELeave) CBBPresence(aVersion));
	ret->ConstructL();
	return ret.release();
}
EXPORT_C void CBBPresence::AddRef()
{
	++iRefCount;
}

EXPORT_C void CBBPresence::Release()
{
	--iRefCount;
	if (iRefCount==0) delete this;
}

EXPORT_C const TTypeName& CBBPresence::Type() const
{
	return KPresenceType;
}

EXPORT_C TBool CBBPresence::Equals(const MBBData* aRhs) const
{
	const CBBPresence* rhs=bb_cast<CBBPresence>(aRhs);
	return (rhs && *this==*rhs);
}

EXPORT_C const TTypeName& CBBPresence::StaticType()
{
	return KPresenceType;
}

EXPORT_C void CBBPresence::ConstructL()
{
	iDevices=CBBBtDeviceList::NewL();
}

EXPORT_C const MBBData* CBBPresence::Part(TUint aPartNo) const
{
	switch(aPartNo) {
	case 0:
		return &iCellId;
	case 1:
		return &iBaseInfo;
	case 2:
		return &iUserActive;
	case 3:
		return &iProfile;
	case 4:
		return &iUserGiven;
	case 5:
		return &iGps;
	case 6:
		return &iNeighbourhoodInfo;
	case 7:
		return iDevices;
	default:
		if (iUseVersion==2) {
			switch(aPartNo) {
			case 8:
				return &iCalendar;
			case 9:
				return &iUnread;
			case 10:
				return &iAlarm;
			}
		}
		return 0;
	}
}

_LIT(KUserGiven, "usergiven");
_LIT(KSent, "sent");

EXPORT_C CBBPresence::CBBPresence(TUint aVersion) : TBBCompoundData(KPresence), iUserGiven(KUserGiven), iCellId(KCell),
	iSentTimeStamp(KSent), iAlarm(KAlarm), iCreatedVersion(aVersion), iUseVersion(2) { }
EXPORT_C CBBPresence::CBBPresence() : TBBCompoundData(KPresence), iUserGiven(KUserGiven), iCellId(KCell),
	iSentTimeStamp(KSent), iAlarm(KAlarm), iCreatedVersion(2), iUseVersion(2) { }

EXPORT_C void CBBPresence::InternalizeL(RReadStream& aStream)
{
	iUseVersion=iCreatedVersion;
	TBBCompoundData::InternalizeL(aStream);
	iUseVersion=2;
}


_LIT(KSpace, " ");

EXPORT_C const TDesC& CBBPresence::StringSep(TUint aBeforePart) const
{
	return KSpace;
}

EXPORT_C bool CBBPresence::operator==(const CBBPresence& aRhs) const
{
	return (iCellId==aRhs.iCellId &&
		iBaseInfo==aRhs.iBaseInfo &&
		iUserActive==aRhs.iUserActive &&
		iProfile==aRhs.iProfile &&
		iDevices->Equals(aRhs.iDevices) &&
		iGps==aRhs.iGps &&
		iNeighbourhoodInfo==aRhs.iNeighbourhoodInfo &&
		iUserGiven==aRhs.iUserGiven &&
		iSentTimeStamp()==aRhs.iSentTimeStamp() &&
		iSent==aRhs.iSent &&
		iCalendar==aRhs.iCalendar &&
		iUnread==aRhs.iUnread &&
		iAlarm==aRhs.iAlarm
		);
}

EXPORT_C MBBData* CBBPresence::CloneL(const TDesC& Name) const
{
	auto_ptr<CBBPresence> ret(new (ELeave) CBBPresence);
	*ret=*this;
	return ret.release();
}

EXPORT_C void CBBPresence::SetDevices(const CBBBtDeviceList* aList)
{
	MBBData* d=aList->CloneL(aList->Name());
	CBBBtDeviceList* l=bb_cast<CBBBtDeviceList>(d);
	if (!l) {
		delete d;
		User::Leave(KErrNotSupported);
	}
	delete iDevices;
	iDevices=l;
}

EXPORT_C CBBPresence& CBBPresence::operator=(const CBBPresence& aRhs)
{
	MBBData* d=aRhs.iDevices->CloneL(aRhs.iDevices->Name());
	CBBBtDeviceList* l=bb_cast<CBBBtDeviceList>(d);
	if (!l) {
		delete d;
		User::Leave(KErrNotSupported);
	}
	delete iDevices;
	iDevices=l;

	iCellId=aRhs.iCellId;
	iBaseInfo=aRhs.iBaseInfo;
	iUserActive=aRhs.iUserActive;
	iProfile=aRhs.iProfile;

	iGps=aRhs.iGps;
	iNeighbourhoodInfo=aRhs.iNeighbourhoodInfo;
	iUserGiven=aRhs.iUserGiven;
	iSentTimeStamp()=aRhs.iSentTimeStamp();
	iSent=aRhs.iSent;

	iCalendar=aRhs.iCalendar;
	iUnread=aRhs.iUnread;
	iAlarm()=aRhs.iAlarm();

	return *this;
}


EXPORT_C CBBPresence::~CBBPresence()
{
	delete iDevices;
}

//_----------------------------------

EXPORT_C const TTypeName& TBBUserGiven::Type() const
{
	return KUserGivenType;
}

EXPORT_C TBool TBBUserGiven::Equals(const MBBData* aRhs) const
{
	const TBBUserGiven* rhs=bb_cast<TBBUserGiven>(aRhs);
	return (rhs && *this==*rhs);
}

EXPORT_C const TTypeName& TBBUserGiven::StaticType()
{
	return KUserGivenType;
}

EXPORT_C const MBBData* TBBUserGiven::Part(TUint aPartNo) const
{
	if (aPartNo==0) return &iDescription;
	if (aPartNo==1) return &iSince;
	return 0;
}

_LIT(KDescription, "description");
_LIT(KSince, "since");

EXPORT_C TBBUserGiven::TBBUserGiven(const TDesC& aName) : TBBCompoundData(aName),
	iDescription(KDescription), iSince(KSince)
{
}

EXPORT_C bool TBBUserGiven::operator==(const TBBUserGiven& aRhs) const
{
	return (
		iDescription == aRhs.iDescription &&
		iSince == aRhs.iSince
		);
}


const TDesC& TBBUserGiven::StringSep(TUint aBeforePart) const
{
	if (aBeforePart==0 || aBeforePart>1) return KNullDesC;
	return KSpace;
}

EXPORT_C TBBUserGiven& TBBUserGiven::operator=(const TBBUserGiven& aUserGiven)
{
	iDescription()=aUserGiven.iDescription();
	iSince()=aUserGiven.iSince();
	return *this;
}

EXPORT_C MBBData* TBBUserGiven::CloneL(const TDesC& Name) const
{
	TBBUserGiven* ret=new (ELeave) TBBUserGiven(Name);
	*ret=*this;
	return ret;
}