#include "csd_profile.h"

EXPORT_C const TTypeName& TBBProfile::Type() const
{
	return KProfileType;
}

EXPORT_C TBool TBBProfile::Equals(const MBBData* aRhs) const
{
	const TBBProfile* rhs=bb_cast<TBBProfile>(aRhs);
	return (rhs && *this==*rhs);
}

EXPORT_C const TTypeName& TBBProfile::StaticType()
{
	return KProfileType;
}

EXPORT_C const MBBData* TBBProfile::Part(TUint aPartNo) const
{
	switch(aPartNo) {
	case 0:
		return &iProfileId;
	case 1:
		return &iProfileName;
	case 2:
		return &iRingingType;
	case 3:
		return &iRingingVolume;
	case 4:
		return &iVibra;
	default:
		return 0;
	}
}

EXPORT_C TBBProfile::TBBProfile() : TBBCompoundData(KProfile),
	iProfileId(KProfileId), iProfileName(KProfileName),
	iRingingType(KProfileRingType), iRingingVolume(KProfileRingVolume),
	iVibra(KProfileVibra)
{
}

_LIT(KSpace, " ");
_LIT(KOpenParen, " (");
_LIT(KCloseParen, ")");

const TDesC& TBBProfile::StringSep(TUint aBeforePart) const
{
	if (aBeforePart==0) return KNullDesC;
	if (aBeforePart==1 || aBeforePart==3 || aBeforePart==4) return KSpace;
	if (aBeforePart==2) return KOpenParen;
	if (aBeforePart==5) return KCloseParen;
	return KNullDesC;
}

EXPORT_C bool TBBProfile::operator==(const TBBProfile& aRhs) const
{
	return (
		iProfileId == aRhs.iProfileId &&
		iProfileName == aRhs.iProfileName &&
		iRingingType == aRhs.iRingingType &&
		iRingingVolume == aRhs.iRingingVolume &&
		iVibra == aRhs.iVibra
		);
}

EXPORT_C TBBProfile& TBBProfile::operator=(const TBBProfile& aProfile)
{
	iProfileId()=aProfile.iProfileId();
	iProfileName()=aProfile.iProfileName();
	iRingingType()=aProfile.iRingingType();
	iRingingVolume()=aProfile.iRingingVolume();
	iVibra()=aProfile.iVibra();
	return *this;
}

EXPORT_C MBBData* TBBProfile::CloneL(const TDesC& ) const
{
	TBBProfile* ret=new (ELeave) TBBProfile();
	*ret=*this;
	return ret;
}