#include "csd_system.h"

_LIT(KUid, "uid");

EXPORT_C const TTypeName& TBBSysEvent::Type() const
{
	return KSysEventType;
}

EXPORT_C TBool TBBSysEvent::Equals(const MBBData* aRhs) const
{
	const TBBSysEvent* rhs=bb_cast<TBBSysEvent>(aRhs);
	return (rhs && *this==*rhs);
}

EXPORT_C const TTypeName& TBBSysEvent::StaticType()
{
	return KSysEventType;
}

EXPORT_C const MBBData* TBBSysEvent::Part(TUint aPartNo) const
{
	if (aPartNo==0) return &iUid;
	if (aPartNo==1) return &iState;
	return 0;
}

EXPORT_C TBBSysEvent::TBBSysEvent(const TDesC& aName) : TBBCompoundData(aName),
	iUid(KUid), iState(KState)
{
}

EXPORT_C bool TBBSysEvent::operator==(const TBBSysEvent& aRhs) const
{
	return (
		iUid == aRhs.iUid &&
		iState == aRhs.iState
		);
}

_LIT(KSpace, " ");

const TDesC& TBBSysEvent::StringSep(TUint aBeforePart) const
{
	if (aBeforePart==0 || aBeforePart>1) return KNullDesC;
	return KSpace;
}

EXPORT_C TBBSysEvent& TBBSysEvent::operator=(const TBBSysEvent& aSysEvent)
{
	iUid()=aSysEvent.iUid();
	iState()=aSysEvent.iState();
	return *this;
}

EXPORT_C MBBData* TBBSysEvent::CloneL(const TDesC& Name) const
{
	TBBSysEvent* ret=new (ELeave) TBBSysEvent(Name);
	*ret=*this;
	return ret;
}