#include "csd_unread.h"

EXPORT_C const TTypeName& TBBUnread::Type() const
{
	return KUnreadType;
}

EXPORT_C TBool TBBUnread::Equals(const MBBData* aRhs) const
{
	const TBBUnread* rhs=bb_cast<TBBUnread>(aRhs);
	return (rhs && *this==*rhs);
}

EXPORT_C const TTypeName& TBBUnread::StaticType()
{
	return KUnreadType;
}

EXPORT_C const MBBData* TBBUnread::Part(TUint aPartNo) const
{
	switch(aPartNo) {
	case 0:
		return &iUnreadMessages;
	case 1:
		return &iUnreadSince;
	case 2:
		return &iUnansweredCalls;
	case 3:
		return &iUnansweredSince;
	default:
		return 0;
	}
}

_LIT(KUnansweredSince, "unanswered_since");
_LIT(KUnansweredCalls, "unanswered_calls");
_LIT(KUnreadMessages, "unread_messages");
_LIT(KUnreadSince, "unread_since");

EXPORT_C TBBUnread::TBBUnread() : TBBCompoundData(KUnread),
	iUnreadMessages(KUnreadMessages), iUnreadSince(KUnreadSince),
	iUnansweredCalls(KUnansweredCalls), iUnansweredSince(KUnansweredSince) { }

EXPORT_C bool TBBUnread::operator==(const TBBUnread& aRhs) const
{
	return (
		iUnreadMessages()==aRhs.iUnreadMessages() &&
		iUnreadSince()==aRhs.iUnreadSince() &&
		iUnansweredCalls()==aRhs.iUnansweredCalls() &&
		iUnansweredSince()==aRhs.iUnansweredSince()
		);
}

_LIT(KSpace, " ");
_LIT(KMsgs, "msgs ");
_LIT(KCalls, " calls ");

const TDesC& TBBUnread::StringSep(TUint aBeforePart) const
{
	if (aBeforePart==0) return KMsgs;
	if (aBeforePart==2) return KCalls;
	return KSpace;
}

EXPORT_C TBBUnread& TBBUnread::operator=(const TBBUnread& aRhs)
{
	iUnreadMessages()=aRhs.iUnreadMessages();
	iUnreadSince()=aRhs.iUnreadSince();
	iUnansweredCalls()=aRhs.iUnansweredCalls();
	iUnansweredSince()=aRhs.iUnansweredSince();

	return *this;
}

EXPORT_C MBBData* TBBUnread::CloneL(const TDesC&) const
{
	TBBUnread* ret=new (ELeave) TBBUnread;
	*ret=*this;
	return ret;
}