#include "bbtypes.h"
#include "csd_bluetooth.h"
#include "csd_cell.h"
#include "csd_current_app.h"
#include "csd_event.h"
#include "csd_gps.h"
#include "csd_profile.h"
#include "csd_system.h"
#include "csd_battery.h"
#include "csd_idle.h"
#include "csd_presence.h"
#include "csd_loca.h"

_LIT(KDefaultStringSep, " ");

class TConcreteDataFactory : public MBBDataFactory {
	virtual MBBData* CreateBBDataL(const TTypeName& aType, const TDesC& aName, MBBDataFactory* aTopLevelFactory) {

		if (aType==KBluetoothInfoType) {
			return new (ELeave) TBBBtDeviceInfo();
		} else if (aType==KBluetoothListType) {
			return CBBBtDeviceList::NewL();
		} else if (aType==KBluetoothNameType) {
			return new (ELeave) TBBBluetoothName(aName);
		} else if (aType==KBluetoothAddrType) {
			return new (ELeave) TBBBluetoothAddress(aName);
		} else if( aType==KBluetoothNeighboursType) {
			return new (ELeave) TBBNeighbourhoodInfo;
		} else if( aType==KBluetoothNeighboursType1) {
			return new (ELeave) TBBNeighbourhoodInfo(1);

		} else if (aType==KCellIdType) {
			return new (ELeave) TBBCellId(KCell);
		} else if (aType==KShortNetworkNameType) {
			return new (ELeave) TBBShortNetworkName(aName);
		
		} else if (aType==KCurrentAppType) {
			return new (ELeave) TBBCurrentApp();
		
		} else if (aType==KEventType) {
			return new (ELeave) CBBSensorEvent(aName, KNoTuple, aTopLevelFactory);
		} else if (aType==KTupleType) {
			return new (ELeave) CBBTuple(aTopLevelFactory);
		} else if( aType==KSubNameType) {
			return new (ELeave) TBBTupleSubName(aName);
		} else if( aType==KTupleMetaType) {
			return new (ELeave) TBBTupleMeta();

		} else if( aType==KGpsLineType ) {
			return new (ELeave) TGpsLine();

		} else if( aType==KProfileType ) {
			return new (ELeave) TBBProfile();

		} else if ( aType==KSysEventType) {
			return new (ELeave) TBBSysEvent(aName);

		} else if ( aType==KBatteryType) {
			return new (ELeave) TBBBattery(aName);

		} else if ( aType==KIdleType) {
			return new (ELeave) TBBUserActive;

		} else if ( aType==KPresenceType) {
			return CBBPresence::NewL();
		} else if ( aType==KPresenceType1) {
			return CBBPresence::NewL(1);

		} else if ( aType==KBaseInfoType) {
			return new (ELeave) TBBBaseInfo();
		} else if ( aType==KBaseVisitType) {
			return new (ELeave) TBBBaseVisit(aName);

		} else if ( aType==KLocationType) {
			return new (ELeave) TBBLocation();

		} else if ( aType==KLocaMessageStatusType) {
			return new (ELeave) TBBLocaMsgStatus;

		} else if ( aType==KCalendarEventType) {
			return new (ELeave) TBBCalendarEvent(aName);
		} else if ( aType==KCalendarType) {
			return new (ELeave) TBBCalendar;

		} else if ( aType==KUnreadType) {
			return new (ELeave) TBBUnread;

		} else {
			User::Leave(KErrNotSupported);
		}

		return 0;
	}
	virtual ~TConcreteDataFactory() { }
	virtual void ConstructL() { }
};

EXPORT_C MBBDataFactory* CreateDataFactory()
{
	return new TConcreteDataFactory;
}
