/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "log_appuse.h"
#include "symbian_auto_ptr.h"
#include "apgwgnam.h"
#include <e32std.h>

EXPORT_C CLog_AppUse::~CLog_AppUse()
{
	CALLSTACKITEM_N(_CL("CLog_AppUse"), _CL("~CLog_AppUse"));

	Cancel();
	iTimer.Close();
}

EXPORT_C const CBBSensorEvent& CLog_AppUse::get_value()
{
	CALLSTACKITEM_N(_CL("CLog_AppUse"), _CL("get_value"));

	TInt wgid=Ws().GetFocusWindowGroup();
	auto_ptr<CApaWindowGroupName> gn(CApaWindowGroupName::NewL(Ws(), wgid));

	iValue.iUid()=gn->AppUid().iUid;
	iValue.iCaption()=gn->Caption().Left(iValue.iCaption().MaxLength());
	iEvent.iData()=&iValue; iEvent.iStamp=GetTime();
	return iEvent;
}

void CLog_AppUse::CheckedRunL()
{
	CALLSTACKITEM_N(_CL("CLog_AppUse"), _CL("CheckedRunL"));

	TUint prev=iValue.iUid();
	get_value();
#if 1
	if (prev!=iValue.iUid()) {
		post_new_value(&iValue);
	}
#else
	post_new_value(&iValue);
#endif

	Wait();
}

EXPORT_C CLog_AppUse* CLog_AppUse::NewL(MApp_context& Context)
{
	CALLSTACKITEM2_N(_CL("CLog_AppUse"), _CL("NewL"),  &Context);

	auto_ptr<CLog_AppUse> ret(new (ELeave) CLog_AppUse(Context));
	ret->ConstructL();
	return ret.release();
}

void CLog_AppUse::DoCancel()
{
	CALLSTACKITEM_N(_CL("CLog_AppUse"), _CL("DoCancel"));

	iTimer.Cancel();
}

void CLog_AppUse::Wait()
{
	CALLSTACKITEM_N(_CL("CLog_AppUse"), _CL("Wait"));

	if (User::InactivityTime().Int()>iTimeOut) {
		iCurrentState=EIdle;
		iTimer.Inactivity(iStatus, 0);
	} else {
		iTimer.After(iStatus, TTimeIntervalMicroSeconds32(1*1000*1000));
		iCurrentState=EActive;
	}
	SetActive();
}

TInt CLog_AppUse::CheckedRunError(TInt /*aError*/)
{
	CALLSTACKITEM_N(_CL("CLog_AppUse"), _CL("CheckedRunError"));

	Wait();
	return KErrNone;
}

CLog_AppUse::CLog_AppUse(MApp_context& Context) : CCheckedActive(EPriorityHigh, _L("CLog_AppUse")), 
Mlog_base_impl(Context, KCurrentApp, KCurrentAppTuple), iTimeOut(5)
{
	CALLSTACKITEM_N(_CL("CLog_AppUse"), _CL("CLog_AppUse"));

}

void CLog_AppUse::ConstructL()
{
	CALLSTACKITEM_N(_CL("CLog_AppUse"), _CL("ConstructL"));

	Mlog_base_impl::ConstructL();
	iTimer.CreateLocal();
	CActiveScheduler::Add(this);
	Wait();

	post_new_value(get_value());
}
