/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "log_base_impl.h"

#include <e32std.h>
#include <eikenv.h>

#include "bbdata.h"

EXPORT_C void Mlog_base_impl::ConstructL()
{
	CALLSTACKITEM_N(_CL("Mlog_base_impl"), _CL("ConstructL"));

	iBBSubSession=BBSession()->CreateSubSessionL(0);
}

EXPORT_C Mlog_base_impl::Mlog_base_impl(MApp_context& Context, const TDesC& aName, const TTupleName& aTupleName) : MContextBase(Context),
	iEvent(aName, aTupleName, 0)
{
	iEvent.iData.SetOwnsValue(EFalse);

}

EXPORT_C Mlog_base_impl::~Mlog_base_impl()
{
	CALLSTACKITEM_N(_CL("Mlog_base_impl"), _CL("~Mlog_base_impl"));

	delete iBBSubSession;
}

EXPORT_C void Mlog_base_impl::add_sinkL(Mlogger* sink)
{
	CALLSTACKITEM_N(_CL("Mlog_base_impl"), _CL("add_sinkL"));

	if (!sink) return;

	sink->iBBSubSessionNotif->AddNotificationL(iEvent.TupleName());
}

EXPORT_C void Mlog_base_impl::post_new_value(const CBBSensorEvent& aEvent)
{
	CALLSTACKITEM_N(_CL("Mlog_base_impl"), _CL("post_new_value"));

	iBBSubSession->PutL(aEvent.TupleName(), KNullDesC, &aEvent);
}


EXPORT_C void Mlog_base_impl::post_new_value(CBBSensorEvent& aEvent)
{
	CALLSTACKITEM_N(_CL("Mlog_base_impl"), _CL("post_new_value"));
	if (aEvent.iStamp()==TTime(0)) aEvent.iStamp()=GetTime();

	iBBSubSession->PutL(aEvent.TupleName(), KNullDesC, &aEvent);
}

EXPORT_C void Mlog_base_impl::post_error(const TDesC& aMsg, TInt aCode, const TTime& time)
{
	// FIXME
	TBuf<10> name;
	if (aCode==KErrNone) {
		iEvent.iPriority()=CBBSensorEvent::INFO;
		name=_L("info");
	} else {
		name=_L("error");
		iEvent.iPriority()=CBBSensorEvent::ERR;
	}

	TBBLongString s(aMsg, name);
	iEvent.iData()=&s;
	iEvent.iStamp()=time;
	post_new_value(iEvent);
	iEvent.iData()=0;
	iEvent.iPriority()=CBBSensorEvent::VALUE;
}

EXPORT_C void Mlog_base_impl::post_error(const TDesC& aMsg, TInt aCode)
{
	post_error(aMsg, aCode, GetTime());
}

EXPORT_C const CBBSensorEvent& Mlog_base_impl::get_value()
{
	return iEvent;
}

EXPORT_C void Mlog_base_impl::post_new_value(MBBData* aData)
{
	post_new_value(aData, GetTime());
}

EXPORT_C void Mlog_base_impl::post_new_value(MBBData* aData, const TTime& time)
{
	iEvent.iData()=aData;
	iEvent.iStamp()=time;
	iEvent.iPriority()=CBBSensorEvent::VALUE;
	post_new_value(iEvent);
}

EXPORT_C Clog_base_impl::Clog_base_impl(MApp_context& Context, const TDesC& aName, 
			       const TTupleName& aTupleName) : 
	Mlog_base_impl(Context, aName, aTupleName) { }

EXPORT_C Clog_base_impl* Clog_base_impl::NewL(MApp_context& Context, const TDesC& aName, const TTupleName& aTupleName)
{
	CALLSTACKITEM2_N(_CL("Clog_base_impl"), _CL("NewL"),  &Context);

	auto_ptr<Clog_base_impl> ret(new (ELeave) Clog_base_impl(Context, aName, aTupleName));
	ret->ConstructL();
	return ret.release();
}