/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/

/*
 * Concepts:
 * !Cell Id!
 */

#include "log_cellid.h"
#include "csd_cell.h"
#include "cellmap.h"

Clog_cellid::Clog_cellid(MApp_context& Context, COperatorMap* aOpMap, CCellMap* aCellMap) : 
	CCheckedActive(EPriorityIdle, _L("Clog_cellid")), 
	Mlog_base_impl(Context, KCell, KCellIdTuple), iCell(KCell),
	iCellMap(aCellMap)
{
	CALLSTACKITEM_N(_CL("Clog_cellid"), _CL("Clog_cellid"));

#ifdef __WINS__
	iOpMap=aOpMap;
	test_data_i=0;
#endif
}

void Clog_cellid::ConstructL() 
{
	CALLSTACKITEM_N(_CL("Clog_cellid"), _CL("ConstructL"));

	Mlog_base_impl::ConstructL();

	CActiveScheduler::Add(this); // add to scheduler
#ifndef __WINS__

#ifndef __S60V2__
	Phone().NotifyChangeOfCurrentNetwork(iStatus, async_info);
#else
	Phone().NotifyChangeOfCurrentNetworkNS(iStatus, async_info);
#endif
	SetActive();
#else
	iOpMap->AddRef();
	timer.CreateLocal();
	TTimeIntervalMicroSeconds32 w(5*1000*1000);
	timer.After(iStatus, w);
	SetActive();
#endif
	post_new_value(get_value());
}

EXPORT_C Clog_cellid* Clog_cellid::NewL(MApp_context& Context, COperatorMap* aOpMap, CCellMap* aCellMap)
{
	CALLSTACKITEM2_N(_CL("Clog_cellid"), _CL("NewL"),  &Context);

	auto_ptr<Clog_cellid> ret(new (ELeave) Clog_cellid(Context, aOpMap, aCellMap));
	ret->ConstructL();
	return ret.release();
}

EXPORT_C Clog_cellid::~Clog_cellid()
{
	CALLSTACKITEM_N(_CL("Clog_cellid"), _CL("~Clog_cellid"));

	Cancel();

#ifdef __WINS__
	if (iOpMap) iOpMap->Release();
	timer.Close();
#endif
}

void Clog_cellid::DoCancel()
{
	CALLSTACKITEM_N(_CL("Clog_cellid"), _CL("DoCancel"));

#ifndef __WINS__
#ifndef __S60V2__
	Phone().NotifyChangeOfCurrentNetworkCancel();
#else
	// The Cancel hangs on v2 :-(
	//Phone().NotifyChangeOfCurrentNetworkCancelNS();
	TRequestStatus* s=&iStatus;
	User::RequestComplete(s, KErrCancel);
#endif
#else
	timer.Cancel();
#endif
}

TInt Clog_cellid::CheckedRunError(TInt aError)
{
	CALLSTACKITEM_N(_CL("Clog_cellid"), _CL("CheckedRunError"));
	if (iErrorCount >= 10) return aError;

	TBuf<40> msg;
	msg.Format(_L("Clog_cellid::CheckedRunError %d"), aError);

	post_error(msg, aError, GetTime());

#ifndef __WINS__
	Cancel();
#  ifndef __S60V2__
	Phone().NotifyChangeOfCurrentNetwork(iStatus, async_info);
#  else
	Phone().NotifyChangeOfCurrentNetworkNS(iStatus, async_info);
#  endif
	SetActive();
	return KErrNone;
#else // __WINS__
	return aError;
#endif
}

void Clog_cellid::CheckedRunL()
{
	CALLSTACKITEM_N(_CL("Clog_cellid"), _CL("CheckedRunL"));

	if (iStatus!=KErrNone) {
		TBuf<40> msg;
		msg.Format(_L("NotifyChangeOfCurrentNetwork %d"), iStatus.Int());
		post_error(msg, iStatus.Int(), GetTime());
		if (iErrorCount++ >= 10) {
			User::Leave(-1005);
		}
	} else {
		iErrorCount=0;
#ifndef __WINS__
		if (async_info.iNetworkInfo.iShortName.CompareF(_L("elisa"))==0) {
			async_info.iNetworkInfo.iShortName=_L("RADIOLINJA");
		}
		iCell.iMCC()=async_info.iNetworkInfo.iId.iMCC;
		iCell.iMNC()=async_info.iNetworkInfo.iId.iMNC;
		iCell.iShortName=async_info.iNetworkInfo.iShortName;
		iCell.iLocationAreaCode()=async_info.iLocationAreaCode;
		iCell.iCellId()=async_info.iCellId;
		iCell.iMappedId()=iCellMap->GetId(iCell);
		post_new_value(&iCell);
		
		prev_info=async_info;
	}
#  ifndef __S60V2__
	Phone().NotifyChangeOfCurrentNetwork(iStatus, async_info);
#  else
	Phone().NotifyChangeOfCurrentNetworkNS(iStatus, async_info);
#  endif
	SetActive();
#else
		TBuf<40> val=bases::test_data[test_data_i][1];
		while (! val.Compare(_L("SWITCH"))) {
			val=bases::test_data[++test_data_i][1];
		}
		TPtrC dtd(bases::test_data[test_data_i][0]);
		_LIT(KTime, "t");
		TBBTime t(KTime);
		t.FromStringL(dtd);
		CCellMap::Parse(val, iCell.iCellId(), iCell.iLocationAreaCode(), iCell.iShortName());
		iOpMap->NameToMccMnc(iCell.iShortName(), iCell.iMCC(), iCell.iMNC());
		++test_data_i;
		iCell.iMappedId()=iCellMap->GetId(iCell);
		post_new_value(&iCell, t());
	}
	TTimeIntervalMicroSeconds32 w(20*1000*1000);
	timer.After(iStatus, w);
	SetActive();
	//iErrorCount=10; User::Leave(1);
	//User::Panic(_L("test panic"), 10);
	//RThread me;
	//me.Open(me.Id());
	//me.RaiseException(EExcAccessViolation);
#endif

}

EXPORT_C const CBBSensorEvent& Clog_cellid::get_value()
{
	CALLSTACKITEM_N(_CL("Clog_cellid"), _CL("get_value"));

#ifndef __WINS__
	MBasicGsmPhoneNetwork::TCurrentNetworkInfo ni;
	ni.iLocationAreaCode=ni.iCellId=0;
	// get network info

	User::LeaveIfError( Phone().GetCurrentNetworkInfo( ni ) );
	if (ni.iNetworkInfo.iShortName.CompareF(_L("elisa"))==0) {
		ni.iNetworkInfo.iShortName=_L("RADIOLINJA");
	}
	prev_info=ni;

	iCell.iMCC()=ni.iNetworkInfo.iId.iMCC;
	iCell.iMNC()=ni.iNetworkInfo.iId.iMNC;
	iCell.iShortName=ni.iNetworkInfo.iShortName;
	iCell.iLocationAreaCode()=ni.iLocationAreaCode;
	iCell.iCellId()=ni.iCellId;
	iCell.iMappedId()=iCellMap->GetId(iCell);
	iEvent.iData()=&iCell;
	iEvent.iStamp()=GetTime();
#endif
	return iEvent;
}
