/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "log_local.h"
#include "symbian_auto_ptr.h"
#include "csd_idle.h"

#define IDLE_TIME	60

EXPORT_C CLog_local* CLog_local::NewL(MApp_context& Context, const TDesC& name)
{
	CALLSTACKITEMSTATIC_N(_CL("CLog_local"), _CL("NewL"));

	auto_ptr<CLog_local> ret(new (ELeave) CLog_local(Context));
	ret->ConstructL(name);
	return ret.release();
}

EXPORT_C CLog_local::~CLog_local()
{
	CALLSTACKITEM_N(_CL("CLog_local"), _CL("~CLog_local"));

	Cancel();
	delete iTimer;
}

EXPORT_C TRequestStatus* CLog_local::RequestStatus()
{
	CALLSTACKITEM_N(_CL("CLog_local"), _CL("RequestStatus"));

	return &iStatus;
}

CLog_local::CLog_local(MApp_context& Context) : CCheckedActive(EPriorityNormal, _L("CLog_local")), 
	Mlog_base_impl(Context, KIdle, KIdleTuple) { }

void CLog_local::ConstructL(const TDesC& /*name*/)
{
	CALLSTACKITEM_N(_CL("CLog_local"), _CL("ConstructL"));

	Mlog_base_impl::ConstructL();
	CActiveScheduler::Add(this); // add to scheduler
	iStatus=KRequestPending;
	SetActive();
	iTimer=CTimeOut::NewL(*this);
	iTimer->Wait(IDLE_TIME);
}

void CLog_local::DoCancel()
{
	CALLSTACKITEM_N(_CL("CLog_local"), _CL("DoCancel"));

	TRequestStatus *sp=&iStatus;
	User::RequestComplete(sp, KErrNone);
}

void CLog_local::CheckedRunL()
{
	CALLSTACKITEM_N(_CL("CLog_local"), _CL("CheckedRunL"));

	if (! iTimer->IsActive() ) {
		iValue.iSince()=GetTime();
		iValue.iActive()=ETrue;;
		post_new_value(&iValue);
	}
	//RDebug::Print(_L("user active"));
	iStatus=KRequestPending;
	iTimer->Wait(IDLE_TIME);
	SetActive();
}

TInt CLog_local::CheckedRunError(TInt /*aError*/)
{
	CALLSTACKITEM_N(_CL("CLog_local"), _CL("CheckedRunError"));

	return KErrNone;
}

void CLog_local::expired(CBase*)
{
	CALLSTACKITEM_N(_CL("CLog_local"), _CL("expired"));

	iValue.iActive()=EFalse;
	iValue.iSince()=GetTime();
	post_new_value(&iValue);
}
