/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/

/*
 * Concepts:
 * !Profile API!
 */

#include "log_profile.h"
#include "symbian_auto_ptr.h"
#include <e32std.h>
#define INTERVAL 30

#ifndef NO_PROFILEAPI_H
#include <profileapi.h>
#else
typedef TInt32 TContactItemId;
class CProfileAPI : public CBase {
public:
	enum TProErrorCode
	    {
	    EPro0=0
	   ,EPro1
	    };
	IMPORT_C static CProfileAPI* NewL(TBool);
	IMPORT_C virtual ~CProfileAPI();
	IMPORT_C TProErrorCode GetProfileActiveName(TPtr, TInt*);
	IMPORT_C TProErrorCode GetProfileMultiData( TDes&, TDes&, TInt&,
					       TInt&, TBool&, TInt&, CArrayFixFlat<TContactItemId>*,
					       TInt&, TInt);
};
#endif


Clog_profile::Clog_profile(MApp_context& Context) : CCheckedActive(CCheckedActive::EPriorityIdle, _L("Clog_profile")), 
	Mlog_base_impl(Context, KProfile, KProfileTuple)
{
	CALLSTACKITEM_N(_CL("Clog_profile"), _CL("Clog_profile"));

}

void Clog_profile::ConstructL()
{
	CALLSTACKITEM_N(_CL("Clog_profile"), _CL("ConstructL"));

	Mlog_base_impl::ConstructL();

	aConditions=new (ELeave) CArrayFixFlat<TSysAgentCondition>(sizeof(TSysAgentCondition));
	aConditions->SetReserveL(1);
	
	CActiveScheduler::Add(this);
	listen_for_notification();
	iProfile.iProfileId()=prev_profile;

	post_new_value(get_value());
}

void Clog_profile::listen_for_notification()
{
	CALLSTACKITEM_N(_CL("Clog_profile"), _CL("listen_for_notification"));

	Cancel();

	if (! iAgentIsOpen ) {
		TInt ret=iSysAgent.Connect();
		if (ret!=KErrNone) {
			iWait->Wait(5);
			return;
		} else {
			iAgentIsOpen=true;
		}
	}

	prev_profile=get_profile_via_profilapi();
	TSysAgentCondition cond(KUidProfile, prev_profile, ESysAgentNotEquals);
	if (aConditions->Count()==0) {
		aConditions->AppendL(cond);
	} else {
		aConditions->At(0)=cond;
	}

	TInt ret=iSysAgent.NotifyOnCondition(*aConditions, iStatus);
	if (ret==KErrNone) {
		SetActive();
	} else {
		iStatus=ret;
		iWait->Wait(5);
	}
}

void Clog_profile::expired(CBase* )
{
	CALLSTACKITEM_N(_CL("Clog_profile"), _CL("expired"));

	CheckedRunL();
}

EXPORT_C Clog_profile* Clog_profile::NewL(MApp_context& Context)
{
	CALLSTACKITEMSTATIC_N(_CL("Clog_profile"), _CL("NewL"));

	auto_ptr<Clog_profile> ret(new (ELeave) Clog_profile(Context));
	ret->ConstructL();
	return ret.release();
}

void Clog_profile::DoCancel()
{
	CALLSTACKITEM_N(_CL("Clog_profile"), _CL("DoCancel"));

	iSysAgent.NotifyEventCancel();
}

EXPORT_C Clog_profile::~Clog_profile()
{
	CALLSTACKITEM_N(_CL("Clog_profile"), _CL("~Clog_profile"));

	delete iWait;
	Cancel();

	if (iAgentIsOpen) iSysAgent.Close();

	delete aConditions;

}

TInt Clog_profile::CheckedRunError(TInt /*aError*/)
{
	CALLSTACKITEM_N(_CL("Clog_profile"), _CL("CheckedRunError"));

	if (iErrorCount>10) {
		return -1010;
	}

	Cancel();
	listen_for_notification();
	return KErrNone;
}

void Clog_profile::CheckedRunL()
{
	CALLSTACKITEM_N(_CL("Clog_profile"), _CL("CheckedRunL"));

	if (iStatus!=KErrNone) {
		if (iErrorCount>10) {
			User::Leave(-1010);
		}
		iErrorCount++;
		if (iAgentIsOpen) {
			iSysAgent.Close();
			iAgentIsOpen=true;
		}
	} else {
		iErrorCount=0;
	}

	iProfile.iProfileId()=get_profile_via_profilapi();

	if (prev_profile==iProfile.iProfileId()) {
		listen_for_notification();
		return;
	}

	prev_profile=iProfile.iProfileId();

	post_new_value(&iProfile);

	listen_for_notification();
}

TInt Clog_profile::get_profile_via_profilapi()
{
	CALLSTACKITEM_N(_CL("Clog_profile"), _CL("get_profile_via_profilapi"));

	TInt profileUid=0;
#ifndef __WINS__2

	auto_ptr<CProfileAPI> profile(CProfileAPI::NewL(EFalse));
	auto_ptr<HBufC> name(HBufC::NewL(30));
	//name->Des().FillZ(30); name->Des().Zero();
	TPtr16 p=name->Des();
	if (profile->GetProfileActiveName(p, &profileUid)!= 0)
		return -1; // Get active profile

	iProfile.iProfileName()=*name;

	if (profileUid<0 || profileUid>10) return -1;

	
	TFileName dummy1, dummy2;
	TInt dummy3, dummy4;
	auto_ptr<CArrayFixFlat<TContactItemId> > dummy6(new (ELeave) CArrayFixFlat<TContactItemId>(1));
	profile->GetProfileMultiData(dummy1, dummy2, iProfile.iRingingType(), iProfile.iRingingVolume(), iProfile.iVibra(), 
		dummy3, dummy6.get(),
		dummy4, -1);
#else
	iProfile.iVibra()=true;
	iProfile.iRingingType()=3;
	iProfile.iRingingVolume()=2;
	iProfile.iProfileName()=_L("Genrl");

#endif
	return profileUid;
}

EXPORT_C const CBBSensorEvent& Clog_profile::get_value()
{
	iEvent.iData()=&iProfile;
	iEvent.iStamp()=GetTime();

	return iEvent;
}

EXPORT_C int Clog_profile::get_current_profile() { return prev_profile; }