#include "log_shareddata.h"

#include "symbian_auto_ptr.h"
#include "checkedactive.h"

#include "cc_shareddata.h"

#define MAX_ERRORS	10

#include "csd_system.h"

class CLog_SharedDataImpl : public CLog_SharedData, public MSharedDataNotifyHandler, public CBase {
public:
	virtual ~CLog_SharedDataImpl();
private:
	CLog_SharedDataImpl(MApp_context& Context, const TDesC& name, const TTupleName& aTupleName);
	void ConstructL(TUid Uid, const TDesC& aKeyName);

	virtual void HandleNotifyL( const TUid aUid, const TDesC& aKey,
                                const TDesC& aValue );

	RSharedDataClient iAgent;
	TInt		iErrorCount;

	TUid		iUid;
	TBuf<50>	iKeyName;

	TBBLongString	iValue;

	friend class CLog_SharedData;
};

EXPORT_C CLog_SharedData::~CLog_SharedData() { }

EXPORT_C CLog_SharedData* CLog_SharedData::NewL(MApp_context& Context, const TDesC& name, TUid Uid, 
				       const TDesC& aKeyName, const TTupleName& aTupleName)
{
	auto_ptr<CLog_SharedDataImpl> ret(new (ELeave) CLog_SharedDataImpl(Context, name, aTupleName));
	ret->ConstructL(Uid, aKeyName);
	return ret.release();
}

CLog_SharedData::CLog_SharedData(MApp_context& Context, const TDesC& name, const TTupleName& aTupleName) : 
	Mlog_base_impl(Context, name, aTupleName)
{
}

CLog_SharedDataImpl::~CLog_SharedDataImpl()
{
	iAgent.CancelNotify(iUid, &iKeyName);
	iAgent.Close();
}

CLog_SharedDataImpl::CLog_SharedDataImpl(MApp_context& Context, const TDesC& name, const TTupleName& aTupleName) : 
	CLog_SharedData(Context, name, aTupleName), 
	iAgent(this), 
	iValue(name)
{
}

void CLog_SharedDataImpl::ConstructL(TUid Uid, const TDesC& aKeyName)
{
	Mlog_base_impl::ConstructL();
	iUid=Uid;
	iKeyName=aKeyName;
	User::LeaveIfError(iAgent.Connect());
	User::LeaveIfError(iAgent.Assign(iUid));

	iAgent.GetString(iKeyName, iValue());
	iEvent.iStamp()=GetTime();
	iEvent.iData()=&iValue; iEvent.iData.SetOwnsValue(EFalse);

	User::LeaveIfError(iAgent.NotifyChange(iUid));
	post_new_value(get_value());
}

void CLog_SharedDataImpl::HandleNotifyL( const TUid /*aUid*/, const TDesC& aKey,
                        const TDesC& aValue )
{
	iValue()=aKey;
	iValue().Append(_L(" "));
	iValue().Append(aValue);
	post_new_value(&iValue);
}
