/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "log_sms.h"
#include "symbian_auto_ptr.h"
#include <e32std.h>
#include "cntdb.h"

#include "csd_sms.h"

void ReplaceEndl(TDes& buf)
{
	CALLSTACKITEM_N(_CL(""), _CL("ReplaceEndl"));
	for (int i=0; i<buf.Length(); i++)
	{
		if ( (buf[i] == '\n') || (buf[i] == '\r') || (buf[i] == TChar(8233)) )
		{
			buf.Replace(i, 1, _L(" ") );
		}
	}
}

bool CLog_sms::handle_reception(const TMsvId& entry_id, const TMsvId& folder_id, const TDesC& sender, const TDesC& body)
{
	CALLSTACKITEM_N(_CL("CLog_sms"), _CL("handle_reception"));

	if ( !IsFromToBuddy(sender) ) return false;

	iValue->Zero();
	TBuf<30> b;
	b.Format(_L("new msg #%d in "), entry_id);
	iValue->Append(b);
	MapEntry(folder_id, iValue);
	if (folder_id == KMsvGlobalInBoxIndexEntryId)
	{
		iValue->Append(_L(" from "));
	}
	else
	{
		iValue->Append(_L(" to "));
	}
	iValue->Append(sender);
	iValue->Append(_L(":["));
	iValue->Append(body);
	iValue->Append(_L("]"));
	ReplaceEndl(iValue->iPtr);
	post_new_value(iValue);
	return false;
} 

void CLog_sms::handle_change(const TMsvId& msg_id, const TDesC& sender)
{
	CALLSTACKITEM_N(_CL("CLog_sms"), _CL("handle_change"));
	
	if (!IsFromToBuddy(sender)) return;
	// no real need to log that ... (?)
	TBuf<50> buf;
	buf.Format(_L("msg #%d modified."), msg_id);
	iValue->Zero(); iValue->Append(buf);
	post_new_value(iValue);	
}

void CLog_sms::handle_read(const TMsvId& msg_id, const TDesC& sender)
{
	CALLSTACKITEM_N(_CL("CLog_sms"), _CL("handle_read"));

	if (!IsFromToBuddy(sender)) return;

	TBuf<50> buf;
	buf.Format(_L("msg #%d read."), msg_id);
	iValue->Zero(); iValue->Append(buf);
	post_new_value(iValue);	
}

void CLog_sms::handle_sending(const TMsvId& entry_id, const TDesC &sender, const TDesC &body)
{
	CALLSTACKITEM_N(_CL("CLog_sms"), _CL("handle_sending"));

	if ( !IsFromToBuddy(sender) ) return;
	
	iValue->Zero();
	TBuf<30> b;
	b.Format(_L("sent msg #%d to "), entry_id);
	iValue->Append(b);
	iValue->Append(sender);
	iValue->Append(_L(": "));
	iValue->Append(body);
	ReplaceEndl(iValue->iPtr);
	post_new_value(iValue);
}

void CLog_sms::handle_delete(const TMsvId& msg_id, const TMsvId& parent_folder, const TDesC& sender)
{
	CALLSTACKITEM_N(_CL("CLog_sms"), _CL("handle_delete"));

	if (!IsFromToBuddy(sender)) return;

	TBuf<30> buf;
	buf.Format(_L("msg #%d deleted from "),msg_id);
	iValue->Zero(); iValue->Append(buf);
	MapEntry(parent_folder, iValue);
	post_new_value(iValue);	
}

void CLog_sms::MapEntry(const TMsvId& entry_id, CBBString* aInto)
{
	CALLSTACKITEM_N(_CL("CLog_sms"), _CL("MapEntry"));

	TBuf<15> buf;
	if ( entry_id == KMsvGlobalInBoxIndexEntryId)
	{
		buf.Append(_L("Inbox"));
	}
	else if ( entry_id == KMsvDraftEntryId)
	{
		buf.Append(_L("Drafts"));
	}
	else if ( entry_id == KMsvGlobalOutBoxIndexEntryId)
	{
		buf.Append(_L("Outbox"));
	}
	else if ( entry_id == KMsvSentEntryId)
	{
		buf.Append(_L("Sent"));
	}
	else
	{
		buf.Format(_L("dir%d"), entry_id);
	}
	aInto->Append(buf);
}

TBool CLog_sms::IsFromToBuddy(const TDesC& sender)
{
	CALLSTACKITEM_N(_CL("CLog_sms"), _CL("IsFromToBuddy"));
	
	iSpecialGroups->store_contact(sender);
	if (iSpecialGroups->is_special_contact()) {
		return ETrue;
	} else {
		return EFalse;
	}
}

void CLog_sms::handle_move(const TMsvId& msg_id, const TMsvId& from_folder, const TMsvId& to_folder, const TDesC& sender)
{
	CALLSTACKITEM_N(_CL("CLog_sms"), _CL("handle_move"));

	if (!IsFromToBuddy(sender)) return;

	TBuf<20> buf;
	buf.Format(_L("msg #%d "), msg_id);
	iValue->Zero(); iValue->Append(buf);
	iValue->Append(_L("moved from "));
	MapEntry(from_folder, iValue);
	iValue->Append(_L(" to "));
	MapEntry(to_folder, iValue);
	post_new_value(iValue);	
}

void CLog_sms::handle_error(const TDesC& descr)
{
	CALLSTACKITEM_N(_CL("CLog_sms"), _CL("handle_error"));

	post_error(descr, KErrGeneral);
}

EXPORT_C CLog_sms* CLog_sms::NewL(MApp_context& Context, const TDesC& name)
{
	CALLSTACKITEMSTATIC_N(_CL("CLog_sms"), _CL("NewL"));

	auto_ptr<CLog_sms> ret(new (ELeave) CLog_sms(Context));
	ret->ConstructL(name);
	return ret.release();	
}

void CLog_sms::ConstructL(const TDesC& /*name*/)
{
	CALLSTACKITEM_N(_CL("CLog_sms"), _CL("ConstructL"));

	iValue=CBBString::NewL(KSMS);

	Mlog_base_impl::ConstructL();
	iSpecialGroups=CSpecialGroups::NewL(AppContext());
	iSpecialGroups->AddGroupL(_L("Record"));
	iSpecialGroups->read_contact_groups();
}

EXPORT_C CLog_sms::~CLog_sms()
{
	CALLSTACKITEM_N(_CL("CLog_sms"), _CL("~CLog_sms"));
	delete iSpecialGroups;
	delete iValue;
}

CLog_sms::CLog_sms(MApp_context &Context) : Mlog_base_impl(Context, KSMS, KSmsTuple)
{
}
