#include "log_systemevent.h"
#include "symbian_auto_ptr.h"
#include "checkedactive.h"
#include <saclient.h>


#define MAX_ERRORS	10

#include "csd_system.h"

class CLog_SystemEventImpl : public CLog_SystemEvent, public CCheckedActive {
public:
	virtual ~CLog_SystemEventImpl();
private:
	CLog_SystemEventImpl(MApp_context& Context, const TDesC& name, const TTupleName& aTupleName);
	void ConstructL(TUid Uid);

	void CheckedRunL();
	void DoCancel();

	RSystemAgent	iAgent;
	TSysAgentEvent	iSysEvent;
	TInt		iErrorCount;

	TBBSysEvent	iValue;

	friend class CLog_SystemEvent;
};

EXPORT_C CLog_SystemEvent::~CLog_SystemEvent() { }

EXPORT_C CLog_SystemEvent* CLog_SystemEvent::NewL(MApp_context& Context, const TDesC& name, TUid Uid, const TTupleName& aTupleName)
{
	auto_ptr<CLog_SystemEventImpl> ret(new (ELeave) CLog_SystemEventImpl(Context, name, aTupleName));
	ret->ConstructL(Uid);
	return ret.release();
}

CLog_SystemEvent::CLog_SystemEvent(MApp_context& Context, const TDesC& name, const TTupleName& aTupleName) : 
	Mlog_base_impl(Context, name, aTupleName)
{
}

CLog_SystemEventImpl::~CLog_SystemEventImpl()
{
	Cancel();
	iAgent.Close();
}

CLog_SystemEventImpl::CLog_SystemEventImpl(MApp_context& Context, const TDesC& name, const TTupleName& aTupleName) : 
	CLog_SystemEvent(Context, name, aTupleName), 
	CCheckedActive(EPriorityNormal, _L("CLog_SystemEventImpl")), iValue(name)
{
}

void CLog_SystemEventImpl::ConstructL(TUid Uid)
{
	iValue.iUid()=Uid.iUid;
	Mlog_base_impl::ConstructL();
	CActiveScheduler::Add(this);
	User::LeaveIfError(iAgent.Connect());

	iSysEvent.SetUid(Uid);
	iSysEvent.SetRequestStatus(iStatus);

	iValue.iState=iAgent.GetState(Uid);
	iEvent.iData()=&iValue; iEvent.iData.SetOwnsValue(EFalse);
	iEvent.iStamp()=GetTime();

	iAgent.NotifyOnEvent(iSysEvent);

	SetActive();

	post_new_value(get_value());
}

void CLog_SystemEventImpl::CheckedRunL()
{
	if (iStatus!=KErrNone) {
		TBuf<20> msg=_L("err: ");
		msg.AppendNum(iStatus.Int());
		post_error(msg, iStatus.Int());
		iErrorCount++;
		if (iErrorCount>MAX_ERRORS) User::Leave(iStatus.Int());
	} else {
		iErrorCount=0;

		iValue.iState=iSysEvent.State();
		post_new_value(&iValue);
	}
	iSysEvent.SetRequestStatus(iStatus);
	iAgent.NotifyOnEvent(iSysEvent);

	SetActive();
}

void CLog_SystemEventImpl::DoCancel()
{
	iAgent.NotifyEventCancel();
}
