/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


//CContextServer.h
#ifndef __CONTEXTSERVER__
#define __CONTEXTSERVER__

#include "ver.h"

#include <e32base.h>
#include <app_context.h>

#include <ContextCommon.h>
#include "PresenceInfo.h"
#include "jabber.h"
#include "messageholder.h"

#include "contextservernotifier.h"

_LIT(KThisUser, "USER");

class CContextServer : public CServer, public MJabberObserver, public MContextBase
{
public:

	static CContextServer* NewL(MApp_context& Context);
	static CContextServer* NewLC(MApp_context& Context);
	~CContextServer();

	static TInt ThreadFunction(TAny* aNone);
	
	void IncrementSessions();
	void DecrementSessions();

	void RunL();
	TInt CheckedRunError(TInt aError);

	CContextServer(TInt aPriority, MApp_context& Context) ;

	void ConstructL() ;

	static void PanicClient(const RMessage& aMessage, TContextServPanic aReason);
	static void PanicServer(TContextServPanic aReason);
	static void ThreadFunctionL();

	//-------------------------------------------------------------
	// communications ...
	//-------------------------------------------------------------
	
	void TerminateContextServer();
	void ConnectToPresenceServer();

//	void HandleRequestPresenceInfo(const RMessage &aMessage);
	bool HandleRequestPresenceNotification();
	bool HandleRequestMessageNotification();

	void ConnectToPresenceServer(TDesC & username, TDesC & password, TDesC & server, TUint32 accessPoint);
	void ConnectToPresenceServer(const RMessage &aMessage);
	void SuspendConnection();
	void ResumeConnection();
	
	void CancelRequest(const RMessage &aMessage);

	CPresenceInfo  * GetPresenceInfo();
	CMessageHolder  * GetMessageHolder();
	CJabber * GetJabberClient();

public: 
	void NotifyJabberStatus(TInt st);
	void NotifyNewPresenceInfo(const TDesC & from, const TDesC & info, const TTime& stamp);
	void NotifyNewMessage(const TDesC & from, const TDesC& subject, const TDesC & message);
	enum TEvent { EConnected, EDisconnected, ENewPresenceInfo, ENewMessage, ETerminated };
	
private:
	void NotifySessions(TEvent aEvent);

	TInt iSessionCount;
	CSharableSession *	NewSessionL(const TVersion &aVersion) const;

	CPresenceInfo *		iPresenceInfo;
	CMessageHolder *	iMessageHolder;
	CJabber *	iJabberClient;

	TUint32		iAccessPoint;
	TBuf<200>	iUsername;
	TBuf<200>	iPassword;
	TBuf<200>	iServer;

};

#endif