/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


/* Copyright (c) 2001, Nokia. All rights reserved */


#ifndef __UINOTIFIER_H__
#define __UINOTIFIER_H__


/*! 
  @class MUINotifier
  
  @discussion This class specifies the console output functions.
  */
class MUINotifier
	{
public:
/*!
  @function PrintNotify

  @discussion Display the descriptor as text (with attributes) on the console
  @param aMessage message text
  @param aAttributes font attributes e.g. CEikGlobalTextEditor::EItalic
  */
	virtual void PrintNotify(const TDesC& aMessage, TUint aAttributes = 0) = 0;
/*!
  @function PrintNotify

  @discussion Display the descriptor as text (with attributes) on the console
  @param aMessage message text
  @param aAttributes font attributes e.g. CEikGlobalTextEditor::EItalic
  */
	virtual void PrintNotify(const TDesC8& aMessage, TUint aAttributes = 0) = 0;
/*!
  @function ErrorNotify

  @discussion Display an error message
  @param aErrMessage error message text
  @param aErrCode error code number
  */
	virtual void ErrorNotify(const TDesC& aErrMessage, TInt aErrCode) = 0;
/*!
  @function SetStatus

  @discussion Display the text in the 'status' window
  @param aStatus new status description text
  */
    virtual void SetStatus(const TDesC& aStatus) = 0;
	};

#endif