/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "PresenceInfo.h"
#include "ContextServer.h"

#include "SocketsEngine.h"

#include <flogger.h>
#include "app_context.h"

CPresenceInfo * CPresenceInfo::NewL()
{
	CALLSTACKITEM_N(_CL("CPresenceInfo"), _CL("NewL"));

	CPresenceInfo * presenceInfo = CPresenceInfo::NewLC();
    	CleanupStack::Pop(presenceInfo);
    	return presenceInfo;
}

CPresenceInfo * CPresenceInfo::NewLC()
{
	CALLSTACKITEM_N(_CL("CPresenceInfo"), _CL("NewLC"));

	CPresenceInfo* presenceInfo = new (ELeave) CPresenceInfo();
    	CleanupStack::PushL(presenceInfo);
    	presenceInfo->ConstructL();
    	return presenceInfo;
}

CPresenceInfo::~CPresenceInfo()
{
	CALLSTACKITEM_N(_CL("CPresenceInfo"), _CL("~CPresenceInfo"));

	delete iAllContactsArray;
	delete iAllContactsPresenceInfoArray;
	delete iFlagList;
	if (iSend_timestamps) iSend_timestamps->Close();
	delete iSend_timestamps;

}

void CPresenceInfo::ConstructL()
{
	CALLSTACKITEM_N(_CL("CPresenceInfo"), _CL("ConstructL"));

	iAllContactsArray             = new (ELeave) CDesCArrayFlat(KMaxContacts);
	iAllContactsPresenceInfoArray = new (ELeave) CDesCArrayFlat(KMaxContacts);
	iFlagList = CList< RArray<TInt>* >::NewL();
	iSend_timestamps = new (ELeave) RArray<TTime>;
}

void CPresenceInfo::RemoveFlag(TInt pos)
{
	CList< RArray<TInt> * >::Node *n=iFlagList->iFirst;
	while (n) {
		n->Item->Remove(pos);
		n=n->Next;
	}
}

void CPresenceInfo::AppendFlag(TInt val)
{
	CList< RArray<TInt> * >::Node *n=iFlagList->iFirst;
	while (n) {
		User::LeaveIfError(n->Item->Append(val));
		n=n->Next;
	}
}

void CPresenceInfo::CompressFlag()
{
	CList< RArray<TInt> * >::Node *n=iFlagList->iFirst;
	while (n) {
		n->Item->Compress();
		n=n->Next;
	}
}

void CPresenceInfo::Update(const TDesC & contact, const TDesC& presence, const TTime & time)
{
	CALLSTACKITEM_N(_CL("CPresenceInfo"), _CL("Update"));

	TInt pos;

	if (iAllContactsArray->Find(contact ,pos) == 0)
	// found
	{
		iAllContactsPresenceInfoArray->Delete(pos);
		iAllContactsArray->Delete(pos);

		RemoveFlag(pos);
		
		iSend_timestamps->Remove(pos);

		iAllContactsArray->Compress();
		iAllContactsPresenceInfoArray->Compress();
		CompressFlag();
		iSend_timestamps->Compress();
	}
		
	iAllContactsPresenceInfoArray->AppendL(presence);
	iAllContactsArray->AppendL(contact);
	AppendFlag(1);
	iSend_timestamps->Append(time);
}

const TPresenceInfo& CPresenceInfo::GetNewPresenceInfo(RArray<TInt>* Flags)
{
	CALLSTACKITEM_N(_CL("CPresenceInfo"), _CL("GetNewPresenceInfo"));

	TInt pos = Flags->Find(1);

	info.newInfo = 0;

	if ( pos != KErrNotFound)
	{
		(*Flags)[pos] = 0;
		info.contact.Set( (*iAllContactsArray)[pos] );
		info.info.Set( (*iAllContactsPresenceInfoArray)[pos] );
		info.send_timestamp = (*iSend_timestamps)[pos];
		info.newInfo = 1;
	}
	return info;
}

void CPresenceInfo::SetAllAsNew(RArray<TInt>* Flags)
{
	CALLSTACKITEM_N(_CL("CPresenceInfo"), _CL("SetAllAsNew"));

	for (int i=0;i<Flags->Count();i++)
	{
		(*Flags)[i] = 1;
	}
}

void CPresenceInfo::SetAsNew(const TDesC & contact, RArray<TInt>* Flags)
{
	CALLSTACKITEM_N(_CL("CPresenceInfo"), _CL("SetAsNew"));

	TInt pos;
	if (iAllContactsArray->Find(contact ,pos) == 0)
	{
		(*Flags)[pos] = 1;
	}
}


TPtrC CPresenceInfo::GetPresenceInfoAsDes()
{
	CALLSTACKITEM_N(_CL("CPresenceInfo"), _CL("GetPresenceInfoAsDes"));

	TBuf<800> info ;

	for (int i = 0;i<iAllContactsArray->Count();i++)
	{
		info.Append((*iAllContactsArray)[i]);
		info.Append(_L(":"));
		info.Append((*iAllContactsPresenceInfoArray)[i]);
		info.Append(_L(";"));
	}
	return TPtrC(info);
}

	
void CPresenceInfo::RemoveFlags( RArray<TInt>* Flags)
{
	CList< RArray<TInt>* >::Node *n=iFlagList->iFirst;
	do {
		if (n->Item == Flags) {
			iFlagList->DeleteNode(n, true);
			return;
		}
	} while ( (n=n->Next) );
}

void CPresenceInfo::AddFlagsL( RArray<TInt>* Flags)
{
	iFlagList->AppendL(Flags);
	for (int i=0; i<iAllContactsArray->Count(); i++) {
		User::LeaveIfError(Flags->Append(1));
	}
}
