/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/

#ifndef SETTINGSVIEW_H
#define SETTINGSVIEW_H

#include <aknview.h>
#include <aknsettingitemlist.h>
#include <app_context.h>
#include <cl_settings.h>
#include <settings.h>
#include <app_local_settings.h>

#ifndef NULL
#define NULL 0
#endif

class CCLSettingList: public CAknSettingItemList 
{
public:
	CCLSettingList(const TSettingItemEnabled  * EnabledSettings): CAknSettingItemList(), iEnabledSettings(EnabledSettings) {}
        CAknSettingItem* CreateSettingItemL( TInt identifier );
	void SetListData();
	void UpdateSettings();
	TAny*		iData[SETTINGS_COUNT];
	~CCLSettingList();
private:
	CAknSettingItem	*iItems[SETTINGS_COUNT];
	const TSettingItemEnabled  * iEnabledSettings;
};

class CSettingsView : public CAknView, public MContextBase
{
public: // Constructors and destructor
	IMPORT_C static CSettingsView* NewL(TUid aViewId, MApp_context& Context, const TSettingItemEnabled * EnabledSettings);
        IMPORT_C ~CSettingsView();

public: // Functions from base classes
        TUid Id() const;
        void HandleCommandL(TInt aCommand);
        void HandleClientRectChange();

private:
	CSettingsView(TUid aViewId, MApp_context& Context, const TSettingItemEnabled * EnabledSettings);
        void ConstructL();
        void DoActivateL(const TVwsViewId& aPrevViewId,TUid aCustomMessageId, const TDesC8& aCustomMessage);
        void DoDeactivate();

private: 
        CCLSettingList* iListBox;
	TUid iViewId;
	TVwsViewId iPreviousViewId;
	TInt		iResource;
	const TSettingItemEnabled  * iEnabledSettings;
};

#endif

// End of File
