/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


// INCLUDE FILES
#include  <aknviewappui.h>
#include  <avkon.hrh>
#include  <contextui.rsg>
#include  <aknsettingitemlist.h> 
#include  <cdbcols.h>
#include  <commdb.h>
#include "cl_settings.h"
#include "cl_settings_impl.h"
#include  "SettingsView.h"
#include "symbian_auto_ptr.h"
#include  "contextui.hrh"
#include  <bautils.h>
#include  <avkon.mbg>
#include <akniconarray.h> 
#include "app_local_settings.h"

CCLSettingList::~CCLSettingList()
{
	for (int i=0; i<SETTINGS_COUNT; i++) {
		if (! iData[i]) continue;
		const TSettingItem s=TClSettings::GetKClSettings(i);
		switch (s.iDatatype) {
		case EAP:
		case EInt:
		case EBool:
		case EEnum:
			delete (TInt*)iData[i];
			break;
		case EString:
			delete (TBuf<128>*)iData[i];
			break;
		}
	}
}

CAknSettingItem* CCLSettingList::CreateSettingItemL( TInt identifier )
{
	CALLSTACKITEM_N(_CL("CCLSettingList"), _CL("CreateSettingItemL"));

	CAknSettingItem * settingItem = NULL;

	const TSettingItem i = TClSettings::GetKClSettings(identifier);
	
	switch (i.iDatatype) {
	case EAP:
		{
		TInt *p=new (ELeave) TInt;
		*p=1;
		if (i.iDefaultExists) *p=i.iIntDefault;
		iData[identifier]=p;
		CAknSettingItem * item = (new (ELeave) CAknEnumeratedTextPopupSettingItem(identifier, *p ));
		settingItem =  item;
		iItems[identifier] = item;
		break;
		}
	case EString:
		{
		TBuf<128>* p=new (ELeave) TBuf<128>;
		iData[identifier]=p;
		if (i.iDefaultExists && i.iStringDefault) *p=TPtrC((TText*)i.iStringDefault);
		CAknSettingItem * item =  new (ELeave) CAknTextSettingItem(identifier, *p);
		settingItem = item;
		iItems[identifier] = item;
		break;
		}
	case EBool:
	case EEnum:
		{
		TInt *p=new (ELeave) TInt;
		*p=1;
		if (i.iDefaultExists) *p=i.iIntDefault;
		iData[identifier]=p;
		CAknSettingItem * item =new (ELeave) CAknEnumeratedTextPopupSettingItem(identifier, *p );
		settingItem =  item;
		iItems[identifier] =  item; 
		break;
		}
	case EInt:
		{
		TInt *p=new (ELeave) TInt;
		*p=0;
		if (i.iDefaultExists) *p=i.iIntDefault;
		iData[identifier]=p;
		CAknSettingItem * item = new (ELeave) CAknIntegerEdwinSettingItem(identifier, *p );
		settingItem =  item;
		iItems[identifier] =  item;
		break;
		}
	default:
		break;
	}
	if (!settingItem) {
		User::Leave(-1027);
	}
	if (!iEnabledSettings[identifier].iEnabled) settingItem->SetHidden(ETrue);
	return settingItem;
}

void CCLSettingList::SetListData()
{
	CALLSTACKITEM_N(_CL("CCLSettingList"), _CL("SetListData"));

	for (int i=0; i< SETTINGS_COUNT; i++) {
		if ( ! iItems[i] ) continue;
		TSettingItem s=TClSettings::GetKClSettings(i);
		switch(s.iDatatype) {
		case EAP:
			{
			CAknEnumeratedTextPopupSettingItem *list=(CAknEnumeratedTextPopupSettingItem *)iItems[i];
			TInt *list_id=(TInt*)iData[i];
			auto_ptr<CCommsDatabase> db(CCommsDatabase::NewL(EDatabaseTypeIAP));
			CCommsDbTableView* iViewP=db->OpenTableLC(TPtrC(IAP));
			CleanupStack::Pop();
			auto_ptr<CCommsDbTableView> iView(iViewP);

			auto_ptr<CArrayPtr< CAknEnumeratedText > > enumarr(
				new (ELeave) CArrayPtrFlat< CAknEnumeratedText >(4));
			auto_ptr<CArrayPtr< HBufC > > popuparr( 
				new (ELeave) CArrayPtrFlat< HBufC >(4));

			TInt err;
			TUint32 id=-1;
			{
				TBuf<16> KNoAp=_L("No connection");
				auto_ptr<HBufC> text(KNoAp.AllocL());
				auto_ptr<HBufC> popup(KNoAp.AllocL());
				auto_ptr<CAknEnumeratedText> item(new (ELeave) CAknEnumeratedText(-1, text.get()));
				text.release();
				enumarr->AppendL(item.get());
				item.release();
				popuparr->AppendL(popup.get());
				popup.release();
			}
			bool seen=false;
			while( (err=iView->GotoNextRecord()) == KErrNone ) {
				iView->ReadUintL(TPtrC(COMMDB_ID), id);
				if ( (TInt)id==*list_id) { seen=true; }
				auto_ptr<HBufC> text(HBufC::NewL(KCommsDbSvrMaxColumnNameLength));
				TPtr ptr(text->Des());
				iView->ReadTextL(TPtrC(COMMDB_NAME), ptr);
				auto_ptr<HBufC> popup(text->AllocL());
				auto_ptr<CAknEnumeratedText> item(new (ELeave) CAknEnumeratedText(TInt(id), text.get()));
				text.release();
				enumarr->AppendL(item.get());
				item.release();
				popuparr->AppendL(popup.get());
				popup.release();
			}
			if (!seen) *list_id=-1;
			//FIXME: what if no records?
			list->SetEnumeratedTextArrays(enumarr.release(), popuparr.release());
			list->HandleTextArrayUpdateL();
			list->UpdateListBoxTextL ();
			}
		default:
			break;
		}
	}
}

void CCLSettingList::UpdateSettings()
{
	CALLSTACKITEM_N(_CL("CCLSettingList"), _CL("UpdateSettings"));

	for (int i=0; i< SETTINGS_COUNT; i++) {
		if ( ! iItems[i] ) continue;
		CAknSettingItem* list= iItems[i];
		list->LoadL();
		list->UpdateListBoxTextL();
	}
}

// ================= MEMBER FUNCTIONS =======================

EXPORT_C CSettingsView* CSettingsView::NewL(TUid aViewId, MApp_context& Context, const TSettingItemEnabled * EnabledSettings)
{
	CALLSTACKITEMSTATIC_N(_CL("CSettingsView"), _CL("NewL"));

	auto_ptr<CSettingsView> ret(new (ELeave) CSettingsView(aViewId, Context, EnabledSettings));
	ret->ConstructL();
	return ret.release();
}

CSettingsView::CSettingsView(TUid aViewId, MApp_context& Context, const TSettingItemEnabled * EnabledSettings) : MContextBase(Context), iViewId(aViewId), iEnabledSettings(EnabledSettings)
{
	CALLSTACKITEM_N(_CL("CSettingsView"), _CL("CSettingsView"));

}

// ---------------------------------------------------------
// CSettingsView::ConstructL(const TRect& aRect)
// EPOC two-phased constructor
// ---------------------------------------------------------
//
void CSettingsView::ConstructL()
{
	CALLSTACKITEM_N(_CL("CSettingsView"), _CL("ConstructL"));
#ifndef __WINS__
	TFileName resfile=_L("c:\\System\\data\\contextui.rsc");
	if (! BaflUtils::FileExists(iEikonEnv->FsSession(), resfile) ) {
		resfile.Replace(0, 1, _L("e"));
	}
#else
	TFileName resfile=_L("z:\\System\\data\\contextui.rsc");
	BaflUtils::NearestLanguageFile(iEikonEnv->FsSession(), resfile); //for localization
#endif
	TRAPD(err, iResource=iEikonEnv->AddResourceFileL(resfile));
	User::LeaveIfError(err);

	BaseConstructL( R_SETTINGS_VIEW );
}

EXPORT_C CSettingsView::~CSettingsView()
{
	CALLSTACKITEM_N(_CL("CSettingsView"), _CL("~CSettingsView"));

	if ( iListBox ) {
		AppUi()->RemoveFromViewStack( *this, iListBox );
        }
	delete iListBox;
	if (iResource) iEikonEnv->DeleteResourceFile(iResource);
}

TUid CSettingsView::Id() const
{
	CALLSTACKITEM_N(_CL("CSettingsView"), _CL("Id"));

	return iViewId;
}

void CSettingsView::HandleCommandL(TInt aCommand)
{   
	CALLSTACKITEM_N(_CL("CSettingsView"), _CL("HandleCommandL"));

	switch ( aCommand )
        {
        case EAknSoftkeyOk:
	case EContextUICmdSettingsSave:
		{
			iListBox->StoreSettingsL();
			TBuf<128> prev_string; TInt prev_int;
			for (int i=0; i<SETTINGS_COUNT; i++) {
				if (! iListBox->iData[i]) continue;
				TSettingItem s=TClSettings::GetKClSettings(i);
				switch (s.iDatatype) {
				case EAP:
				case EInt:
				case EBool:
				case EEnum:
				{
					TInt *v=(TInt*)(iListBox->iData[i]);
					if (!Settings().GetSettingL(i, prev_int) || prev_int!=*v)
						Settings().WriteSettingL(i, *v);
				}
				break;
				case EString:
				{
					TBuf<128> *v=(TBuf<128>*)(iListBox->iData[i]);
					if (!Settings().GetSettingL(i, prev_string) || prev_string.Compare(*v))
						Settings().WriteSettingL(i, *v);
				}
				break;
				}
			}
		}
        default:
		AppUi()->ActivateViewL(iPreviousViewId);
		break;
        }
}

void CSettingsView::HandleClientRectChange()
{
	CALLSTACKITEM_N(_CL("CSettingsView"), _CL("HandleClientRectChange"));
	if ( iListBox ) {
		iListBox->SetRect( ClientRect() );
        }
}

void CSettingsView::DoActivateL(
				const TVwsViewId& aPrevViewId,TUid /*aCustomMessageId*/,
				const TDesC8& /*aCustomMessage*/)
{
	CALLSTACKITEM_N(_CL("CSettingsView"), _CL("DoActivateL"));
	iPreviousViewId = aPrevViewId;
	if (!iListBox) {
		iListBox = new (ELeave) CCLSettingList(iEnabledSettings);
		iListBox->SetMopParent(this);
		iListBox->ConstructFromResourceL(R_CL_SETTINGS_LIST);
				
		TBuf<128> prev_string; TInt prev_int;
		for (int i=0; i<SETTINGS_COUNT; i++) {
			if (! iListBox->iData[i]) continue;
			TSettingItem s=TClSettings::GetKClSettings(i);
			switch (s.iDatatype) {
			case EAP:
			case EInt:
			case EBool:
			case EEnum:
			{
				TInt *v=(TInt*)(iListBox->iData[i]);
				if (Settings().GetSettingL(i, prev_int)) *v=prev_int;
			}
			break;
			case EString:
			{
				TBuf<128> *v=(TBuf<128>*)(iListBox->iData[i]);
				if (Settings().GetSettingL(i, prev_string)) *v=prev_string;
			}
			break;
			}
		}
		iListBox->SetListData();
		iListBox->UpdateSettings();

		AppUi()->AddToStackL( *this, iListBox );
		iListBox->MakeVisible(ETrue);
		iListBox->SetRect(ClientRect());

		CEikStatusPane* sp=iEikonEnv->AppUiFactory()->StatusPane();
		CAknNavigationControlContainer *np = (CAknNavigationControlContainer *)sp->ControlL(TUid::Uid(EEikStatusPaneUidNavi)); 
		np->PushDefaultL();

		iListBox->ActivateL();
		iListBox->DrawNow();
        } 
}


void CSettingsView::DoDeactivate()
{
	CALLSTACKITEM_N(_CL("CSettingsView"), _CL("DoDeactivate"));
	CEikStatusPane* sp=iEikonEnv->AppUiFactory()->StatusPane();
	CAknNavigationControlContainer* np = (CAknNavigationControlContainer *)sp->ControlL(TUid::Uid(EEikStatusPaneUidNavi));
	np->Pop(NULL);
	
	if ( iListBox )
        {
		AppUi()->RemoveFromViewStack( *this, iListBox );
        }
	
	delete iListBox;
	iListBox = NULL;
}



