/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/

#include <flogger.h>

#include "doublelinebox.h"
#include <eikfrlbd.h> 
#include <eiklbv.h>
#include "presence_ui_helper.h"

//#define CB_TRANSLATE_LOG 1
 
/*
 * Concepts:
 * !Listbox filtering!
 */


EXPORT_C CPresenceModel* CPresenceModel::NewL(MDesCArray* aNameArray, MDesCArray* aPresenceArray)
{
	CPresenceModel* ret=new (ELeave) CPresenceModel(aNameArray, aPresenceArray);
	CleanupStack::PushL(ret);
	ret->ConstructL();
	CleanupStack::Pop();
	return ret;
}

CPresenceModel::CPresenceModel(MDesCArray* aNameArray, MDesCArray* aPresenceArray) : 
	iNameArray(aNameArray), iPresenceArray(aPresenceArray)
{
}

void CPresenceModel::ConstructL()
{
	CAknFilteredTextListBoxModel::ConstructL(iPresenceArray, ELbmDoesNotOwnItemArray);
}

EXPORT_C void CPresenceModel::SetFilter(CAknListBoxFilterItems * aFilter)
{
	iFilter=aFilter;
}

TPtrC CPresenceModel::ItemText(TInt aItemIndex) const
{
	TInt idx=aItemIndex;
	if (iFilter) idx=iFilter->FilteredItemIndex(aItemIndex);

	return iPresenceArray->MdcaPoint(idx);
}

TInt CPresenceModel::NumberOfItems() const
{
	if (iFilter) return iFilter->FilteredNumberOfItems();
	return iPresenceArray->MdcaCount();
}

const MDesCArray* CPresenceModel::MatchableTextArray() const
{
	return iNameArray;
}

EXPORT_C void doublelinebox::ConstructL(MDesCArray* aNameArray, MDesCArray* aPresenceArray, 
			       const CCoeControl* aParent,TInt aFlags)
{
	iPresenceModel=CPresenceModel::NewL(aNameArray, aPresenceArray);
	CEikFormattedCellListBox::ConstructL(aParent, aFlags);
}

void doublelinebox::LogItem(const TDesC& anItem)
{
	CALLSTACKITEM_N(_CL("doublelinebox"), _CL("LogItem"));


#ifdef CB_TRANSLATE_LOG
	TInt length = anItem.Length();
	
	if (iLog) 
		iLog->write_to_output(anItem.Mid(0,length-8 ));
	
	RArray<TInt> icons;

	TLex lex;
	TInt err, tmp;

	lex=anItem.Mid(length-2,2);
	err = lex.Val(tmp);
	if(!err)  icons.Append( tmp );
	
	lex=anItem.Mid(length-5,2);
	err = lex.Val(tmp);
	if(!err)  icons.Append( tmp );
	
	lex=anItem.Mid(length-8,2);
	err = lex.Val(tmp);
	if(!err)  icons.Append( tmp );
		
	TBool grey = EFalse;

	for (int i=0; i<icons.Count();i++)
	{
		switch (icons[i])
		{
		case 0:
			break;

		case 1:
			if (iLog) iLog->write_to_output(_L(" spkrOn"));
			break;

		case 2:
			if (iLog) iLog->write_to_output(_L(" spkrOff"));
			break;

		case 3:
			if (iLog) iLog->write_to_output(_L(" spkrOn"));
			grey= ETrue;
			break;

		case 4:
			if (iLog) iLog->write_to_output(_L(" spkrOff"));
			grey= ETrue;
			break;

		case 5:
			if (iLog) iLog->write_to_output(_L(" usrAct"));
			break;

		case 6:
			if (iLog) iLog->write_to_output(_L(" usrInact"));
			break;

		case 7:
			if (iLog) iLog->write_to_output(_L(" vibOn"));
			break;

		case 8:
			if (iLog) iLog->write_to_output(_L(" vibOff"));
			break;

		case 9:
			if (iLog) iLog->write_to_output(_L(" vibOn"));
			break;

		case 10:
			if (iLog) iLog->write_to_output(_L(" vibOff"));
			break;

		case 11:
			if (iLog) iLog->write_to_output(_L(" usrInact1"));
			break;

		case 12:
			if (iLog) iLog->write_to_output(_L(" usrInact2"));
			break;

		case 13:
			if (iLog) iLog->write_to_output(_L(" usrInact3"));
			break;
		
		default:
			break;
		}

		if (grey)
		{
			if (iLog) iLog->write_to_output(_L("(?)"));
		}
	}
	icons.Close();
#else
	if (iLog) iLog->write_to_output(anItem);
#endif
}

//-------------------------------------------------------------------------------------------

/*
 * Concepts:
 * !Customizing a Listbox!
 */

drawer::drawer(MTextListBoxModel *aTextListBoxModel, const CFont *aFont, 
	       CFormattedCellListBoxData *aFormattedCellData, phonebook_i* aBook, 
	       Cfile_output_base * aLog, doublelinebox *aListBox) :
		CFormattedCellListBoxItemDrawer(aTextListBoxModel, aFont, aFormattedCellData)
		{
			itemd=aFormattedCellData;
			iTextListBoxModel=aTextListBoxModel;
			iBook = aBook;
			iLog = aLog;
			iListBox = aListBox;
		}


void drawer::DrawItemText (TInt aItemIndex, const TRect &aItemTextRect, 
		TBool aItemIsCurrent, TBool aViewIsEmphasized, TBool aItemIsSelected) const 
{	
	CALLSTACKITEM_N(_CL("drawer"), _CL("DrawItemText"));

	// we draw the mark on top of the vibrator as necessary
	if (!aItemIsSelected) {
		itemd->SetSubCellSizeL(10, TSize(0, 19));
	} else {
		itemd->SetSubCellSizeL(10, TSize(16, 19));
	}

	//RDebug::Print(iListBox->Model()->ItemText(aItemIndex));

	TBool out_of_date = EFalse;
	contact * con = 0;
	if (iBook != 0) {
		con = iBook->GetContact(aItemIndex); 
	} else {
		CFormattedCellListBoxItemDrawer::DrawItemText(aItemIndex, aItemTextRect,
				aItemIsCurrent, aViewIsEmphasized, aItemIsSelected);
		return;
	}

	if ( (con != NULL) && (con->presence != NULL) )
	{
		TTime stamp = con->presence->iSentTimeStamp();
		out_of_date = IsOutOfDate(stamp );	
	}

	CFormattedCellListBoxData::TColors c = itemd->SubCellColors(1);
	if ( out_of_date ) {
		c.iText = TRgb(128,128,128);
		c.iHighlightedText = TRgb(128,128,128);
			
		c.iBack = TRgb(255,255,255);
		c.iHighlightedBack = TRgb(230,230,230); 
	} else {
		c.iText = TRgb(0,0,0);
		c.iHighlightedText = TRgb(0,0,0);
		c.iBack = TRgb(255,255,255);	
		c.iHighlightedBack = TRgb(170,170,255); // original blue of the list items
	}
	
	itemd->SetSubCellColorsL(1, c);
	itemd->SetSubCellColorsL(2, c);
	itemd->SetSubCellColorsL(3, c);
	itemd->SetSubCellColorsL(4, c);
	itemd->SetSubCellColorsL(5, c);
	itemd->SetSubCellColorsL(6, c);
	itemd->SetSubCellColorsL(7, c);

	CFormattedCellListBoxData::TColors c2 = itemd->SubCellColors(1);
	c2.iText = TRgb(0,0,0);
	c2.iHighlightedText = TRgb(0,0,0);
		
	c2.iBack = TRgb(255,255,255);
	c2.iHighlightedBack = TRgb(230,230,230); // original blue of the list items
	itemd->SetSubCellColorsL(0, c2); // sub cell 0 should always draw text in black

	CFormattedCellListBoxItemDrawer::DrawItemText(aItemIndex, aItemTextRect,
			aItemIsCurrent, aViewIsEmphasized, aItemIsSelected);
		
	if ( aItemIsCurrent) { iListBox->LogVisibleItems(aItemIndex); }
}	

EXPORT_C doublelinebox::doublelinebox(phonebook_i * aBook, Cfile_output_base * aLog) : CEikFormattedCellListBox(), book(aBook), iLog(aLog), iLastCurrentItemIndex(-1)
{
	CALLSTACKITEM_N(_CL("doublelinebox"), _CL("doublelinebox"));

}

void doublelinebox::AddSubCell(CFormattedCellListBoxData* itemd,
			       TMargins marg, TSize size, TPoint pos, TInt baselinepos, 
			       CGraphicsContext::TTextAlign aAlign, TBool aGraphic)
{
	itemd->SetSubCellMarginsL(iCells, marg);		
	itemd->SetSubCellSizeL(iCells,  size);
	itemd->SetSubCellPositionL(iCells,  pos);
	itemd->SetSubCellBaselinePosL(iCells, baselinepos);
	itemd->SetSubCellFontL(iCells, iEikonEnv->DenseFont() );
	itemd->SetSubCellAlignmentL(iCells, aAlign);
	if (aGraphic)
		itemd->SetGraphicsSubCellL(iCells, ETrue);

	++iCells;
}

void doublelinebox::CreateItemDrawerL(void)
{
	CALLSTACKITEM_N(_CL("doublelinebox"), _CL("CreateItemDrawerL"));

	CFormattedCellListBoxData* itemd=CFormattedCellListBoxData::NewL();

	CleanupStack::PushL(itemd);

	TMargins marg, marg2;
	marg.iBottom=marg.iTop=marg.iLeft=marg.iRight=0;
	marg2.iBottom=marg2.iTop=marg2.iRight=0;
	marg2.iLeft=2;

	//Name of contact
	AddSubCell(itemd, marg, TSize(118, 18), TPoint(16, 0), 14, CGraphicsContext::ELeft);
	
	//Textual PresenceInfo
	AddSubCell(itemd, marg2, TSize(166 - 3*16, 19), TPoint(0, 19), 32, CGraphicsContext::ELeft);

	// Contact Icon (type of number)
	AddSubCell(itemd, marg, TSize(16, 19), TPoint(0, 0), 17, CGraphicsContext::ECenter, ETrue);

	// Ringing volume
	AddSubCell(itemd, marg, TSize(16, 19), TPoint(144, 0), 17, CGraphicsContext::ECenter, ETrue);

	// Vibrator
	AddSubCell(itemd, marg, TSize(16, 19), TPoint(160, 0), 17, CGraphicsContext::ECenter, ETrue);

	// Desktop
	AddSubCell(itemd, marg, TSize(16, 19), TPoint(134-3*16, 19), 32, CGraphicsContext::ECenter, ETrue);
	// Laptop
	AddSubCell(itemd, marg, TSize(16, 19), TPoint(134-2*16, 19), 32, CGraphicsContext::ECenter, ETrue);
	// PDA
	AddSubCell(itemd, marg, TSize(16, 19), TPoint(134-1*16, 19), 32, CGraphicsContext::ECenter, ETrue);

	// BT buddies
	AddSubCell(itemd, marg, TSize(20, 19), TPoint(134, 19), 32, CGraphicsContext::ECenter, ETrue);

	// other phones
	AddSubCell(itemd, marg, TSize(20, 19), TPoint(154, 19), 32, CGraphicsContext::ECenter, ETrue);

	//Marked or not
	AddSubCell(itemd, marg, TSize(14, 19), TPoint(160, 0), 17, CGraphicsContext::ECenter, ETrue);

	iItemDrawer=new (ELeave) drawer(iPresenceModel, iEikonEnv->NormalFont(), 
		itemd, book, iLog, this);

	CleanupStack::Pop();	
}

EXPORT_C doublelinebox::~doublelinebox()
{
	CALLSTACKITEM_N(_CL("doublelinebox"), _CL("~doublelinebox"));

	delete iPresenceModel;
}

EXPORT_C void doublelinebox::LogVisibleItems(TInt currentItemIndex)
{
	CALLSTACKITEM_N(_CL("doublelinebox"), _CL("LogVisibleItems"));

	if (! iLog) return;

		TBuf<800> buf;
		if (this->View()->ItemIsVisible(currentItemIndex-2))
		{
			buf.Append(iPresenceModel->ItemTextArray()->MdcaPoint(currentItemIndex-2));
		}
		if (this->View()->ItemIsVisible(currentItemIndex-1))
		{
			buf.Append(iPresenceModel->ItemTextArray()->MdcaPoint(currentItemIndex-1));
		}
		if (this->View()->ItemIsVisible(currentItemIndex))
		{
			buf.Append(iPresenceModel->ItemTextArray()->MdcaPoint(currentItemIndex));
		}
		if (this->View()->ItemIsVisible(currentItemIndex+1))
		{
			buf.Append(iPresenceModel->ItemTextArray()->MdcaPoint(currentItemIndex+1));
		}
		if (this->View()->ItemIsVisible(currentItemIndex+2))
		{
			buf.Append(iPresenceModel->ItemTextArray()->MdcaPoint(currentItemIndex+2));
		}

		if (currentItemIndex == iLastCurrentItemIndex && buf.Compare(iBuf) == 0)
		{
			return;
		}

//-----------------------------------

		iLog->write_time();
		iLog->write_to_output(_L("Items:"));

		if (this->View()->ItemIsVisible(currentItemIndex-2))
		{
			LogItem(iPresenceModel->ItemTextArray()->MdcaPoint(currentItemIndex-2));
			//if (iLog) iLog->write_to_output(this->Model()->ItemTextArray()->MdcaPoint(currentItemIndex-2));
			if (iLog) iLog->write_to_output(_L("/"));
		}

		if (this->View()->ItemIsVisible(currentItemIndex-1))
		{
			LogItem(iPresenceModel->ItemTextArray()->MdcaPoint(currentItemIndex-1));
			//if (iLog) iLog->write_to_output(this->Model()->ItemTextArray()->MdcaPoint(currentItemIndex-1));
			if (iLog) iLog->write_to_output(_L("/"));
		}

		iLog->write_to_output(_L("["));
		LogItem(iPresenceModel->ItemTextArray()->MdcaPoint(currentItemIndex));
		iLog->write_to_output(_L("]"));

		if (this->View()->ItemIsVisible(currentItemIndex+1))
		{
			if (iLog) iLog->write_to_output(_L("/"));
			LogItem(iPresenceModel->ItemTextArray()->MdcaPoint(currentItemIndex+1));
			//if (iLog) iLog->write_to_output(this->Model()->ItemTextArray()->MdcaPoint(currentItemIndex+1));
		}

		if (this->View()->ItemIsVisible(currentItemIndex+2))
		{
			if (iLog) iLog->write_to_output(_L("/"));
			//if (iLog) iLog->write_to_output(this->Model()->ItemTextArray()->MdcaPoint(currentItemIndex+2));
			LogItem(iPresenceModel->ItemTextArray()->MdcaPoint(currentItemIndex+2));
		}
		iLog->write_nl();

		iBuf=buf;
		iLastCurrentItemIndex = currentItemIndex;
}


EXPORT_C TKeyResponse doublelinebox::OfferKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType)
{
	CALLSTACKITEM_N(_CL("doublelinebox"), _CL("OfferKeyEventL"));


	TKeyResponse resp = CEikFormattedCellListBox::OfferKeyEventL(aKeyEvent, aType);
	//LogVisibleItems(this->View()->CurrentItemIndex());
	return resp;
}
