#include "presence_ui_helper.h"
#include <contextcommon.mbg>
#include <contextcommon.rsg>
#include "icons.h"
#include <avkon.mbg>
#include <e32math.h>
#include <eikenv.h>


EXPORT_C void PresenceToListBoxL(const CBBPresence* data, HBufC*& name,
				 HBufC* last_name, HBufC* first_name, const TDesC& prev,
				 const TDesC& not_avail, bool last_name_first)
{
	/* length */
	TInt base_len=0;
	if ( data && data->iBaseInfo.iPreviousStay.IsSet() ) 
		base_len=data->iBaseInfo.iPreviousStay.iBaseName().Length();
	else if ( data && data->iBaseInfo.iCurrent.IsSet() ) 
		base_len=data->iBaseInfo.iCurrent.iBaseName().Length();

	if ( data )
		base_len += data->iUserGiven.iDescription.iValue.Length();

	TInt len=name->Length()+base_len+120;
	name->Des().Zero();
	while (len>name->Des().MaxLength()) {
		name=name->ReAllocL(name->Des().MaxLength()*2);
	}

	// - Name --------------------------------------------------------------

	if (last_name_first)
	{
		if (last_name) name->Des().Append(*last_name);
		if (last_name && last_name->Length()>0 && first_name && first_name->Length()>0) {
			name->Des().Append(_L(" "));
		}
		if (first_name) name->Des().Append(*first_name);
	}
	else
	{
		if (first_name) name->Des().Append(*first_name);
		if (first_name && first_name->Length()>0 && last_name && last_name->Length()>0) {
			name->Des().Append(_L(" "));
		}
		if (last_name) name->Des().Append(*last_name);
	}

	if (!data || ! data->iSent) {
		name->Des().Append(_L("\t"));
		name->Des().Append(not_avail);
		name->Des().AppendFormat(_L("\t0\t0\t0\t0\t0\t0\t0\t0\t%02d"), 
			GetIconIndex(EMbmAvkonQgn_indi_marked_add) );
		return;
	}

	if ( data->iUserGiven.iDescription.iValue.Length() != 0 )
	{
		if ( name->Des().Length() > 6) {
			TBuf<6> temp;
			temp.Append(name->Des().Left(6));
			name->Des().Copy(temp);
			name->Des().Append(_L("."));
		}
		name->Des().Append(_L(" '"));
		name->Des().Append(data->iUserGiven.iDescription.Value());
		name->Des().Append(_L("'"));
	}

	name->Des().Append(_L("\t"));	
	
	TBool out_of_date = IsOutOfDate(data->iSentTimeStamp());
		
	// - Location Info -----------------------------------------------------
	
	TTime stamp; stamp=GetTime();
	
	TBool prev_known=data->iBaseInfo.iPreviousStay.IsSet();
	TBool current_known=data->iBaseInfo.iCurrent.IsSet();
	if (  prev_known && !current_known ) {
		name->Des().Append(_L("? ("));
		name->Des().Append(prev);
		name->Des().Append(_L(" "));
		name->Des().Append(data->iBaseInfo.iPreviousStay.iBaseName());
		stamp = data->iBaseInfo.iPreviousStay.iLeft();
	} else if (current_known) {
		name->Des().Append(data->iBaseInfo.iCurrent.iBaseName());
		stamp = data->iBaseInfo.iCurrent.iEntered();
	} else {
		name->Des().Append(_L("?"));
	}
	
	name->Des().Append(_L(" ("));
	TPtr p=name->Des();
	TimeSinceStamp(p, stamp, 2);
	name->Des().Append(_L(")"));
	
	if (  prev_known && !current_known) {
		name->Des().Append(_L(" )"));
	}
	
	// - User activity --------------------------------------------------
	if (data->iUserActive.iActive() )
	{
		if (out_of_date) 
		{
			TBuf<5> icon_int;
			icon_int.Format(_L("\t%02d"), GetIconIndex(EMbmContextcommonUser_inactive) );
			name->Des().Append(icon_int);
		}
		else
		{
			TBuf<5> icon_int;
			icon_int.Format(_L("\t%02d"), GetIconIndex(EMbmContextcommonUser_active) );
			name->Des().Append(icon_int);
		}
	} else 	{
		TTimeIntervalMinutes minutes;
		TTime now; now=GetTime();
		
		now.MinutesFrom(data->iUserActive.iSince(), minutes);
		
		if (minutes.Int() <= 10)
		{
			TBuf<5> icon_int;
			icon_int.Format(_L("\t%02d"), GetIconIndex(EMbmContextcommonUser_inactive_lvl_1) );
			name->Des().Append(icon_int);
		}
		else if (minutes.Int() <= 60)
		{
			TBuf<5> icon_int;
			icon_int.Format(_L("\t%02d"), GetIconIndex(EMbmContextcommonUser_inactive_lvl_2) );
			name->Des().Append(icon_int);
		}
		else if (minutes.Int() <= 240)
		{
			TBuf<5> icon_int;
			icon_int.Format(_L("\t%02d"), GetIconIndex(EMbmContextcommonUser_inactive_lvl_3) );
			name->Des().Append(icon_int);
		}
		else
		{
			// no icon
			name->Des().Append(_L("\t0"));
		}
	}
	
	
	TInt ringtype=data->iProfile.iRingingType();
	// - Speaker Info -----------------------------------------------------
	if ( ringtype == TBBProfile::ERingingTypeSilent )
	{
		if (out_of_date) {
			TBuf<5> icon_int;
			icon_int.Format(_L("\t%02d"), GetIconIndex(EMbmContextcommonSpeaker_off_grey) );
			name->Des().Append(icon_int);	
		} else {
			TBuf<5> icon_int;
			icon_int.Format(_L("\t%02d"), GetIconIndex(EMbmContextcommonSpeaker_off) );
			name->Des().Append(icon_int);	
		}
		
	} else {
		if (out_of_date) {
			TBuf<5> icon_int;
			icon_int.Format(_L("\t%02d"), GetIconIndex(EMbmContextcommonSpeaker_on_grey) );
			name->Des().Append(icon_int);		
		} else {
			TBuf<5> icon_int;
			icon_int.Format(_L("\t%02d"), GetIconIndex(EMbmContextcommonSpeaker_on) );
			name->Des().Append(icon_int);				
		}
	}
	
	// - Vibrator Info -----------------------------------------------------
	if ( data->iProfile.iVibra() )
	{
		if (out_of_date) {
			TBuf<5> icon_int;
			icon_int.Format(_L("\t%02d"), GetIconIndex(EMbmContextcommonVibrator_on_grey) );
			name->Des().Append(icon_int);		
		} else {
			TBuf<5> icon_int;
			icon_int.Format(_L("\t%02d"), GetIconIndex(EMbmContextcommonVibrator_on) );
			name->Des().Append(icon_int);
			
		}
	} else {
		if (out_of_date) {
			TBuf<5> icon_int;
			icon_int.Format(_L("\t%02d"), GetIconIndex(EMbmContextcommonVibrator_off_grey) );
			name->Des().Append(icon_int);		
		} else {
			TBuf<5> icon_int;
			icon_int.Format(_L("\t%02d"), GetIconIndex(EMbmContextcommonVibrator_off) );
			name->Des().Append(icon_int);	
		}
	}

	// - NeighbourhoodInfo -------------------

	TBuf<5> icon_int;
	if (data->iNeighbourhoodInfo.iDesktops() > 0) {
		if (out_of_date) {
			icon_int.Format(_L("\t%02d"), 
				GetIconIndex(EMbmContextcommonDesktop_grey));
		} else {
			icon_int.Format(_L("\t%02d"), 
				GetIconIndex(EMbmContextcommonDesktop));
		}
	} else {
		icon_int=_L("\t0");
	}
	name->Des().Append(icon_int);
	if (data->iNeighbourhoodInfo.iLaptops() > 0) {
		if (out_of_date) {
			icon_int.Format(_L("\t%02d"), 
				GetIconIndex(EMbmContextcommonLaptop_grey));
		} else {
			icon_int.Format(_L("\t%02d"), 
				GetIconIndex(EMbmContextcommonLaptop));
		}
	} else {
		icon_int=_L("\t0");
	}
	name->Des().Append(icon_int);
	if (data->iNeighbourhoodInfo.iPDAs() > 0) {
		if (out_of_date) {
			icon_int.Format(_L("\t%02d"), 
				GetIconIndex(EMbmContextcommonPda_grey));
		} else {
			icon_int.Format(_L("\t%02d"), 
				GetIconIndex(EMbmContextcommonPda));
		}
	} else {
		icon_int=_L("\t0");
	}
	name->Des().Append(icon_int);

	// - Buddies -----------------------------
	TInt idx = 0;

	switch (data->iNeighbourhoodInfo.iBuddies())
	{
		case 0:
			idx = 0;
			break;
		case 1:
			if (out_of_date) {
				idx = GetIconIndex(EMbmContextcommonBuddy1_grey);
			} else {
				idx = GetIconIndex(EMbmContextcommonBuddy1);
			}
			break;
		case 2:
			if (out_of_date) {
				idx = GetIconIndex(EMbmContextcommonBuddy2_grey);
			} else {
				idx = GetIconIndex(EMbmContextcommonBuddy2);
			}
			break;
		case 3:
			if (out_of_date) {
				idx = GetIconIndex(EMbmContextcommonBuddy3_grey);
			} else {
				idx = GetIconIndex(EMbmContextcommonBuddy3);
			}
			break;
		default:
			if (out_of_date) {
				idx = GetIconIndex(EMbmContextcommonBuddy4_grey);
			} else {
				idx = GetIconIndex(EMbmContextcommonBuddy4);
			}
			break;
	}
	icon_int.Format(_L("\t%02d"), idx );
	name->Des().Append(icon_int);
	
	// - Other_phones -----------------------------
	idx=0;
	icon_int.Zero();
	
	switch (data->iNeighbourhoodInfo.iOtherPhones())
	{
		case 0:
			idx = 0;
			break;
		case 1:
			if (out_of_date) {
				idx = GetIconIndex(EMbmContextcommonOther1_grey);
			} else {
				idx = GetIconIndex(EMbmContextcommonOther1);
			}
			break;
		case 2:
			if (out_of_date) {
				idx = GetIconIndex(EMbmContextcommonOther2_grey);
			} else {
				idx = GetIconIndex(EMbmContextcommonOther2);
			}
			break;
		case 3:
			if (out_of_date) {
				idx = GetIconIndex(EMbmContextcommonOther3_grey);
			} else {
				idx = GetIconIndex(EMbmContextcommonOther3);
			}
			break;
		default:
			if (out_of_date) {
				idx = GetIconIndex(EMbmContextcommonOther4_grey);
			} else {
				idx = GetIconIndex(EMbmContextcommonOther4);
			}
			break;
	}
	icon_int.Format(_L("\t%02d"), idx );
	name->Des().Append(icon_int);

	// - marked icon - has to be the final one! -------------------------------------

	idx = GetIconIndex(EMbmAvkonQgn_indi_marked_add);
	icon_int.Format(_L("\t%02d"), idx );
	name->Des().Append(icon_int);
}


EXPORT_C void TimeSinceStamp(TDes& aInto, TTime stamp, TInt minuteInterval)
{
	TTime now; now=GetTime();
	TBuf<128> ret;

	TTimeIntervalYears years = now.YearsFrom(stamp);
	TTimeIntervalMonths months = now.MonthsFrom(stamp);
	TTimeIntervalDays days = now.DaysFrom(stamp);
	if (years.Int() > 0 )
	{
		ret.Append(_L(">2D"));
	}
	else if (months.Int() > 0 )
	{
		ret.Append(_L(">2D"));
	}
	else if (days.Int() >= 2)
	{
		ret.Append(_L(">2D"));
	}
	else if (days.Int() >= 1)
	{
		ret.Append(_L(">1D"));
	}
	else
	{
		TTimeIntervalHours hours;
		now.HoursFrom(stamp, hours);
		TTimeIntervalMinutes minutes;
		now.MinutesFrom(stamp, minutes);
				
		if (hours.Int() < 0 ) hours=TTimeIntervalHours(0);
		ret.Format(_L("%d:"), hours.Int());
				
		TInt min = (minutes.Int() - (hours.Int() * 60));
		if (minuteInterval==0) minuteInterval=10;

		TInt32 result = 0;
		TInt err = Math::Int(result, min/minuteInterval);
		if (err==KErrNone)
		{
			result = result*minuteInterval;	
		}
		else
		{
			result = min;
		}
		ret.AppendFormat(_L("%02d"), result);
	}

	aInto.Append(ret);
}

EXPORT_C TBool IsOutOfDate(TTime stamp, TInt freshness_interval)
{
	//const TInt KFreshnessInterval = 10; // in minutes 
	
	TTime now = GetTime();

	TTimeIntervalMinutes m;
	now.MinutesFrom(stamp, m);
	if (m.Int() > freshness_interval)
	{
		return ETrue;	
	}
	else
	{
		return EFalse;
	}
}

class CPresenceArrayImpl : public CPresenceArray {
public:
	CPresenceArrayImpl(phonebook_i* aPhoneBook);
	void ConstructL();
	virtual TInt MdcaCount() const;
	virtual TPtrC16 MdcaPoint(TInt aIndex) const;
	~CPresenceArrayImpl();
private:
	TBuf<11> prev; TBuf<30> not_avail;
	bool	last_name_first;
	phonebook_i*	iPhoneBook;
	mutable HBufC*	iBuf;
};

EXPORT_C CPresenceArray* CPresenceArray::NewL(phonebook_i* aPhoneBook)
{
	CPresenceArrayImpl* ret=new (ELeave) CPresenceArrayImpl(aPhoneBook);
	CleanupStack::PushL(ret);
	ret->ConstructL();
	CleanupStack::Pop();
	return ret;
}

CPresenceArrayImpl::CPresenceArrayImpl(phonebook_i* aPhoneBook) : iPhoneBook(aPhoneBook)
{
}

CPresenceArrayImpl::~CPresenceArrayImpl()
{
	delete iBuf;
}

void CPresenceArrayImpl::ConstructL()
{
	iBuf=HBufC::NewL(256);

	CEikonEnv::Static()->ReadResourceAsDes16(prev, R_PREVIOUS_CAPTION);
	CEikonEnv::Static()->ReadResourceAsDes16(not_avail, R_JABBER_NOT_AVAIL);

	last_name_first=true;

#ifdef __S60V2__
	CPbkContactEngine *eng = CPbkContactEngine::Static();
	CPbkContactEngine::TPbkNameOrder order;
	if (!eng) {order = CPbkContactEngine::EPbkNameOrderLastNameFirstName;}
	else {order = eng->NameDisplayOrderL();}
	if (order != CPbkContactEngine::EPbkNameOrderLastNameFirstName) last_name_first=false;
#endif
}

TInt CPresenceArrayImpl::MdcaCount() const
{
	return iPhoneBook->Count();
}

TPtrC16 CPresenceArrayImpl::MdcaPoint(TInt aIndex) const
{
	contact* c=iPhoneBook->GetContact(aIndex);

	if (!c) {
		iBuf->Des().Zero();
		iBuf->Des().AppendFormat(_L("\t \t0\t0\t0\t0\t0\t0\t0\t0\t%02d"), 
			GetIconIndex(EMbmAvkonQgn_indi_marked_add)); 
	} else {
		if (c->has_nick) {
			PresenceToListBoxL(c->presence, iBuf, 
				 c->last_name, c->first_name, prev, not_avail,
				 last_name_first);
		} else {
			c->Name(iBuf, last_name_first);

			iBuf->Des().AppendFormat(_L("\t \t0\t0\t0\t0\t0\t0\t0\t0\t%02d"), 
				GetIconIndex(EMbmAvkonQgn_indi_marked_add)); 
			//type No_icon_to_display = 0 + last one for mark sign
		}
	}

	return iBuf->Des();
}

class CNameArrayImpl : public CNameArray {
public:
	CNameArrayImpl(phonebook_i* aPhoneBook);
	void ConstructL();
	virtual TInt MdcaCount() const;
	virtual TPtrC16 MdcaPoint(TInt aIndex) const;
	~CNameArrayImpl();
private:
	bool	last_name_first;
	phonebook_i*	iPhoneBook;
	mutable HBufC*	iBuf;
};

EXPORT_C CNameArray* CNameArray::NewL(phonebook_i* aPhoneBook)
{
	CNameArrayImpl* ret=new (ELeave) CNameArrayImpl(aPhoneBook);
	CleanupStack::PushL(ret);
	ret->ConstructL();
	CleanupStack::Pop();
	return ret;
}

CNameArrayImpl::CNameArrayImpl(phonebook_i* aPhoneBook) : iPhoneBook(aPhoneBook)
{
}

CNameArrayImpl::~CNameArrayImpl()
{
	delete iBuf;
}

void CNameArrayImpl::ConstructL()
{
	iBuf=HBufC::NewL(256);

	last_name_first=true;

#ifdef __S60V2__
	CPbkContactEngine *eng = CPbkContactEngine::Static();
	CPbkContactEngine::TPbkNameOrder order;
	if (!eng) {order = CPbkContactEngine::EPbkNameOrderLastNameFirstName;}
	else {order = eng->NameDisplayOrderL();}
	if (order != CPbkContactEngine::EPbkNameOrderLastNameFirstName) last_name_first=false;
#endif
}

TInt CNameArrayImpl::MdcaCount() const
{
	return iPhoneBook->Count();
}

TPtrC16 CNameArrayImpl::MdcaPoint(TInt aIndex) const
{
	contact* c=iPhoneBook->GetContact(aIndex);

	if (!c) iBuf->Des().Zero();
	else {
		c->Name( iBuf, last_name_first);
	}
	
	return iBuf->Des();
}

