#include "presencedescriptionview.h"
#include <aknviewappui.h>
#include <aknnavi.h>
#include <akntitle.h> 
#include "csd_presence.h"
#include <eikedwin.h>
#include <eiklabel.h>
#include <bautils.h>
#include <contextcommon.rsg>

const TInt KScreenWidth=176;
const TInt KLabelHeight=15;
const TInt KOffset = 4;

_LIT(KQuestion, "?");

typedef CList<CEikLabel*> CLabelGroup;

class CPresenceDescriptionContainer : public CCoeControl, public MEikEdwinObserver, 
	public MEikScrollBarObserver {
public:
	CPresenceDescriptionContainer(CAknView *aView);
	~CPresenceDescriptionContainer();
	void ConstructL(const TRect& aRect, const TDesC& Name, const CBBPresence* PresenceData);
private:
	void Draw(const TRect& aRect) const;
	void HandleScrollEventL(CEikScrollBar* aScrollBar, TEikScrollEvent aEventType);
	TKeyResponse OfferKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType);
	void HandleEdwinEventL(CEikEdwin* aEdwin,TEdwinEvent aEventType) { }
	TInt CountComponentControls() const;
	CCoeControl* ComponentControl(TInt aIndex) const;

	TEikScrollBarModel iModel;
	CEikScrollBarFrame * iSBFrame; 

	CEikLabel	*iTitle;
	CEikEdwin	*iEdit;
	CAknView	*iView;

	TInt iMaxScrollPos; 
	TInt iCurrentScrollPos; 
};

class CPresenceDescriptionViewImpl : public CPresenceDescriptionView {
private:
	CPresenceDescriptionViewImpl();
	void ConstructL();

	virtual void SetData(const TDesC& Name, const CBBPresence* PresenceData);
	
	TUid Id() const;

	void ShowDescription();
	
        void HandleCommandL(TInt aCommand);
        void DoActivateL(const TVwsViewId& aPrevViewId,
		TUid aCustomMessageId,
		const TDesC8& aCustomMessage);
        void DoDeactivate();

	friend class CPresenceDescriptionView;

	TBuf<100>	iName;
	const CBBPresence*	iPresence;
	CPresenceDescriptionContainer* iContainer;
	TVwsViewId	iPrevView;
	TInt		iResource;
public:
	virtual ~CPresenceDescriptionViewImpl();
};

EXPORT_C CPresenceDescriptionView* CPresenceDescriptionView::NewL()
{
	CALLSTACKITEM_N(_CL("CPresenceDescriptionView"), _CL("NewL"));

	auto_ptr<CPresenceDescriptionViewImpl> ret(new (ELeave) CPresenceDescriptionViewImpl);
	ret->ConstructL();
	return ret.release();
}

CPresenceDescriptionContainer::CPresenceDescriptionContainer(CAknView *aView) : 
	iView(aView) { }

CPresenceDescriptionContainer::~CPresenceDescriptionContainer()
{
	CALLSTACKITEM_N(_CL("CPresenceDescriptionContainer"), _CL("~CPresenceDescriptionContainer"));

	delete iEdit;
	delete iTitle;
	delete iSBFrame;
}


void CPresenceDescriptionContainer::ConstructL(const TRect& aRect, const TDesC& Name, 
					       const CBBPresence* PresenceData)
{
	CALLSTACKITEM_N(_CL("CPresenceDescriptionContainer"), _CL("ConstructL"));

	CreateWindowL(); 

	iTitle=new (ELeave) CEikLabel;
	iTitle->SetContainerWindowL(*this);
	iTitle->SetFont(CEikonEnv::Static()->DenseFont());
	iTitle->SetUnderlining(ETrue);
	iTitle->SetTextL(Name);
	iTitle->SetAlignment(TGulAlignment(EHCenterVCenter));
	
	TRect t=aRect;
	t.Move(0, 4);
	t.Resize(0, -(t.Height()-15));
	iTitle->SetRect(t);

	iEdit=new (ELeave) CEikEdwin;
	iEdit->SetContainerWindowL(*this);
	iEdit->ConstructL(CEikEdwin::ENoAutoSelection|CEikEdwin::EDisplayOnly);
	iEdit->AddEdwinObserverL(this);
	iEdit->ActivateL();
	TRgb light_gray  = TRgb(210,210,210);
	iEdit->OverrideColorL(EColorControlBackground, light_gray);
	iEdit->OverrideColorL(EColorControlText, KRgbBlack);

	if (PresenceData && PresenceData->iUserGiven.iDescription().Length()>0) {
		iEdit->SetTextL(& (PresenceData->iUserGiven.iDescription()));
	} else {
		iEdit->SetTextL(&(KQuestion()));
	}
	TRect e=aRect;
	e.Resize(0, -19);
	e.Move(0, 19);
	iEdit->SetRect(e);

	SetRect(aRect);
	ActivateL();

	iEdit->MoveCursorL(TCursorPosition::EFPageUp, EFalse);
	while (iEdit->CursorPos()!=iEdit->TextLength()) {
		iEdit->MoveCursorL(TCursorPosition::EFLineDown, EFalse);
		iMaxScrollPos++;
	}
	iEdit->MoveCursorL(TCursorPosition::EFPageUp, EFalse);

	iCurrentScrollPos = 0;

	iModel = TEikScrollBarModel(iMaxScrollPos, iCurrentScrollPos, 0);
	iSBFrame = new (ELeave) CEikScrollBarFrame(this, this, ETrue);
	iSBFrame->SetScrollBarVisibilityL(CEikScrollBarFrame::EOn, CEikScrollBarFrame::EAuto);
	iSBFrame->SetScrollBarManagement(CEikScrollBar::EVertical, CEikScrollBarFrame::EFloating);
	iSBFrame->Tile(&iModel);
	iSBFrame->DrawScrollBarsNow();
}


TInt CPresenceDescriptionContainer::CountComponentControls() const {
	if (iEdit)
		return 2;
	return 1;
}

void CPresenceDescriptionContainer::HandleScrollEventL(CEikScrollBar* aScrollBar, 
						       TEikScrollEvent aEventType)
{
}

TKeyResponse CPresenceDescriptionContainer::OfferKeyEventL(const TKeyEvent& aKeyEvent,
							   TEventCode aType)
{
	CALLSTACKITEM_N(_CL("CPresenceDescriptionContainer"), _CL("OfferKeyEventL"));

	if (aType!=EEventKey) return EKeyWasNotConsumed;

	if ( aKeyEvent.iCode==EKeyLeftArrow ) {
		iView->HandleCommandL(EAknCmdExit);
		return EKeyWasConsumed;
	} else if ( aKeyEvent.iCode==EKeyDownArrow ) {
		if (iCurrentScrollPos+1<iMaxScrollPos) {
			iSBFrame->MoveThumbsBy(0, 1);
			iEdit->MoveDisplayL(TCursorPosition::EFLineDown);
			iSBFrame->DrawScrollBarsNow();
			iCurrentScrollPos++;
		}
	} else if ( aKeyEvent.iCode==EKeyUpArrow ) {
		if (iCurrentScrollPos>0) {
			iSBFrame->MoveThumbsBy(0, -1);
			iEdit->MoveDisplayL(TCursorPosition::EFLineUp);
			iSBFrame->DrawScrollBarsNow();
			iCurrentScrollPos--;
		}
	}
	return EKeyWasNotConsumed;
}


CCoeControl* CPresenceDescriptionContainer::ComponentControl(TInt aIndex) const
{
	CALLSTACKITEM_N(_CL("CPresenceDescriptionContainer"), _CL("ComponentControl"));

	if (aIndex==0) return iTitle;
	else if (aIndex==1) return iEdit;
	return 0;
}

void CPresenceDescriptionContainer::Draw(const TRect& aRect) const
{
	CALLSTACKITEM_N(_CL("CPresenceDescriptionContainer"), _CL("Draw"));

	CWindowGc& gc = SystemGc();
	gc.SetPenStyle(CGraphicsContext::ENullPen);
	gc.SetBrushStyle(CGraphicsContext::ESolidBrush);

	gc.SetBrushColor(KRgbWhite);
	gc.DrawRect(aRect);
}

CPresenceDescriptionViewImpl::CPresenceDescriptionViewImpl() { }

void CPresenceDescriptionViewImpl::ConstructL()
{
	CALLSTACKITEM_N(_CL("CPresenceDescriptionViewImpl"), _CL("ConstructL"));
#ifndef __WINS__
	TFileName resfile=_L("c:\\System\\data\\contextcommon.rsc");
	if (! BaflUtils::FileExists(iEikonEnv->FsSession(), resfile) ) {
		resfile.Replace(0, 1, _L("e"));
	}
#else
	TFileName resfile=_L("z:\\System\\data\\contextcommon.rsc");
	BaflUtils::NearestLanguageFile(iEikonEnv->FsSession(), resfile); //for localization
#endif
	TRAPD(err, iResource=iEikonEnv->AddResourceFileL(resfile));
	User::LeaveIfError(err);

	BaseConstructL( R_PRESENCEDESCRIPTION_VIEW );
}

TUid CPresenceDescriptionViewImpl::Id() const
{
	CALLSTACKITEM_N(_CL("CPresenceDescriptionViewImpl"), _CL("Id"));

	return KPresenceDescriptionView;
}

void CPresenceDescriptionViewImpl::HandleCommandL(TInt aCommand)
{
	CALLSTACKITEM_N(_CL("CPresenceDescriptionViewImpl"), _CL("HandleCommandL"));

	switch (aCommand) {
		case EAknSoftkeyShow:
			break;
		default:
			ActivateViewL(iPrevView);
	}
}

void CPresenceDescriptionViewImpl::DoActivateL(const TVwsViewId& aPrevViewId,
	TUid /*aCustomMessageId*/,
	const TDesC8& /*aCustomMessage*/)
{
	CALLSTACKITEM_N(_CL("CPresenceDescriptionViewImpl"), _CL("DoActivateL"));

	iPrevView=aPrevViewId;
	if (!iContainer) {
		iContainer=new (ELeave) CPresenceDescriptionContainer(this);
		iContainer->ConstructL( TRect(TPoint(0,0),TSize(176,188)), iName, iPresence);
		iContainer->SetMopParent(this);
	
		AppUi()->AddToStackL( *this, iContainer );
        }
}

void CPresenceDescriptionViewImpl::DoDeactivate()
{
	CALLSTACKITEM_N(_CL("CPresenceDescriptionViewImpl"), _CL("DoDeactivate"));

	if ( iContainer )
        {
		AppUi()->RemoveFromViewStack( *this, iContainer );
        }
	
	delete iContainer;
	iContainer = 0;
}

CPresenceDescriptionViewImpl::~CPresenceDescriptionViewImpl()
{
	CALLSTACKITEM_N(_CL("CPresenceDescriptionViewImpl"), _CL("~CPresenceDescriptionViewImpl"));

	if (iResource) iEikonEnv->DeleteResourceFile(iResource);
	delete iContainer;
}

void CPresenceDescriptionViewImpl::SetData(const TDesC& Name, const CBBPresence* PresenceData)
{
	CALLSTACKITEM_N(_CL("CPresenceDescriptionViewImpl"), _CL("SetData"));

	iName=Name;
	iPresence=PresenceData;
}
