/*
* ============================================================================
*  Name     : CTaskListContainer from TaskListContainer.h
*  Part of  : TaskList
*  Created  : 13.4.2004 by 
*  Description:
*     Declares container control for application.
*  Version  :
*  Copyright: 
* ============================================================================
*/

#ifndef TASKLISTCONTAINER_H
#define TASKLISTCONTAINER_H

// INCLUDES
#include <coecntrl.h>
#include <eiktxlbx.h>
   
// FORWARD DECLARATIONS
class CEikLabel;        // for example labels

// CLASS DECLARATION

/**
*  CTaskListContainer  container control class.
*  
*/
class CTaskListContainer : public CCoeControl, MCoeControlObserver
    {
    public: // Constructors and destructor
        
        /**
        * EPOC default constructor.
        * @param aRect Frame rectangle for container.
        */
        void ConstructL(const TRect& aRect, MDesCArray* Contents, MEikListBoxObserver* ListBoxObserver);

        /**
        * Destructor.
        */
        ~CTaskListContainer();

    public: // New functions
	    void ContentsChanged();
	    TInt GetCurrentIdx();

    public: // Functions from base classes

    private: // Functions from base classes

       /**
        * From CoeControl,SizeChanged.
        */
        void SizeChanged();

       /**
        * From CoeControl,CountComponentControls.
        */
        TInt CountComponentControls() const;

       /**
        * From CCoeControl,ComponentControl.
        */
        CCoeControl* ComponentControl(TInt aIndex) const;

       /**
        * From CCoeControl,Draw.
        */
        void Draw(const TRect& aRect) const;

       /**
        * From ?base_class ?member_description
        */
        // event handling section
        // e.g Listbox events
        void HandleControlEventL(CCoeControl* aControl,TCoeEvent aEventType);
	TKeyResponse OfferKeyEventL(const TKeyEvent &aKeyEvent, TEventCode aType);
        
    private: //data
        
        CEikTextListBox* iListBox;
	MDesCArray*	 iContents;

    };

#endif

// End of File
