/*
* ============================================================================
*  Name     : CTaskListContainer from TaskListContainer.h
*  Part of  : TaskList
*  Created  : 13.4.2004 by 
*  Implementation notes:
*     Initial content was generated by Series 60 AppWizard.
*  Version  :
*  Copyright: 
* ============================================================================
*/

// INCLUDE FILES
#include "TaskListContainer.h"

#include <eiktxlbm.h>

// ================= MEMBER FUNCTIONS =======================

// ---------------------------------------------------------
// CTaskListContainer::ConstructL(const TRect& aRect)
// EPOC two phased constructor
// ---------------------------------------------------------
//
void CTaskListContainer::ConstructL(const TRect& aRect, MDesCArray* Contents, MEikListBoxObserver* ListBoxObserver)
{
	CreateWindowL();
	
	iContents=Contents;
	
	iListBox = new (ELeave) CEikTextListBox;
	iListBox->SetMopParent(this);
	iListBox->ConstructL(this, 0);
	
	iListBox->Model()->SetItemTextArray(Contents);
	iListBox->Model()->SetOwnershipType(ELbmDoesNotOwnItemArray);
	iListBox->CreateScrollBarFrameL(ETrue);
	iListBox->ScrollBarFrame()->SetScrollBarVisibilityL( CEikScrollBarFrame::EOff, CEikScrollBarFrame::EAuto);
	
	iListBox->MakeVisible(ETrue);
	iListBox->SetRect(aRect);
	iListBox->ActivateL();
	iListBox->DrawNow();
	
	iListBox->SetListBoxObserver(ListBoxObserver);
	
	iListBox->SetCurrentItemIndexAndDraw(Contents->MdcaCount()-1);	

	SetRect(aRect);
	ActivateL();
}

// Destructor
CTaskListContainer::~CTaskListContainer()
{
	delete iListBox;
}

// ---------------------------------------------------------
// CTaskListContainer::SizeChanged()
// Called by framework when the view size is changed
// ---------------------------------------------------------
//
void CTaskListContainer::SizeChanged()
{
	iListBox->SetRect(Rect());
}

// ---------------------------------------------------------
// CTaskListContainer::CountComponentControls() const
// ---------------------------------------------------------
//
TInt CTaskListContainer::CountComponentControls() const
{
	return 1; // return nbr of controls inside this container
}

// ---------------------------------------------------------
// CTaskListContainer::ComponentControl(TInt aIndex) const
// ---------------------------------------------------------
//
CCoeControl* CTaskListContainer::ComponentControl(TInt aIndex) const
{
	switch ( aIndex )
        {
        case 0:
		return iListBox;
        default:
		return NULL;
        }
}

// ---------------------------------------------------------
// CTaskListContainer::Draw(const TRect& aRect) const
// ---------------------------------------------------------
//
void CTaskListContainer::Draw(const TRect& aRect) const
{
	CWindowGc& gc = SystemGc();
	// TODO: Add your drawing code here
	// example code...
	gc.SetPenStyle(CGraphicsContext::ENullPen);
	gc.SetBrushColor(KRgbWhite);
	gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
	gc.DrawRect(aRect);
}

// ---------------------------------------------------------
// CTaskListContainer::HandleControlEventL(
//     CCoeControl* aControl,TCoeEvent aEventType)
// ---------------------------------------------------------
//
void CTaskListContainer::HandleControlEventL(
					     CCoeControl* /*aControl*/,TCoeEvent /*aEventType*/)
{
	// TODO: Add your control event handler code here
}

void CTaskListContainer::ContentsChanged()
{
	TRAPD(err,
		if (iListBox) iListBox->HandleItemRemovalL();
		iListBox->DrawNow());
}

TInt CTaskListContainer::GetCurrentIdx()
{
	return iListBox->CurrentItemIndex();
}

TKeyResponse CTaskListContainer::OfferKeyEventL(const TKeyEvent &aKeyEvent, TEventCode aType)
{
	return iListBox->OfferKeyEventL(aKeyEvent, aType);
}

// End of File  
