/*
 * $Id: ClusterInfo.h,v 1.1.1.1 2004/08/06 10:53:19 mraento Exp $
 *
 * Visual Codes for Symbian OS
 * Copyright (C) 2004 Beat Gfeller, Michael Rohs (rohs@inf.ethz.ch)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef CLUSTERINFO_H
#define CLUSTERINFO_H


// INCLUDES

#include <e32base.h>

// CONSTANTS

// FORWARD DECLARATIONS

// CLASS DECLARATION

/**
 * Represents a contiguous region of 4-connected pixels in the image.
 * Contains information about the identifying label, the center of gravity,
 * the bounding box, the size, the orientation of the main axis, and the
 * ratio of minor to major axis of the bounding ellipsis of the cluster.
 * The axes have been computed using the notion of second-order moments.
 */
class TClusterInfo {

public:

	/** Center of gravity. */
	TInt c_x, c_y;

	/** Bounding box. */
	TInt min_x, max_x, min_y, max_y;

	/** Identification number of the cluster (in the p array). */
	TInt label;

	/** Number of pixels in this cluster. */
	TInt size;

	/** Orientation of the main axis of the bounding ellipsis. */
	TReal alpha;

	/** Ratio of the lengths of minor to major axis of the bounding ellipsis. 
	 *  This value is 1.0 for perfect squares and circles and 0.0 for ideal lines.
	 */
	TReal ratio;

public:

	/** Create object. (inline constructor) */
	inline TClusterInfo() {
		c_x = -1; // "hack": this is used to denote that this cluster was not set yet.
	}

	/** Initalize fields. (inline function) */
	inline void SetValues(TInt l, TInt x, TInt y, 
		TInt minx, TInt maxx, TInt miny, TInt maxy, 
		TReal r, TReal a, TInt s)
	{
		c_x = x;
		c_y = y;
		min_x = minx;
		max_x = maxx;
		min_y = miny;
		max_y = maxy;
		ratio = r;
		alpha = a;
		label = l;
		size = s;
	}

};



#endif

// End of File
