/*
 * $Id: PictureTaker.h,v 1.2 2005/06/02 15:15:43 mraento Exp $
 *
 * Visual Codes for Symbian OS
 * Copyright (C) 2004 Beat Gfeller, Michael Rohs (rohs@inf.ethz.ch)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef PICTURETAKER_H
#define PICTURETAKER_H

// INCLUDES

#include <e32base.h>
#include <ecam.h>
#include <app_context.h>

// CONSTANTS

// FORWARD DECLARATIONS

class CFbsBitmap;
class CVisualCodeSystem;

// CLASS DECLARATION

class CPictureTaker : public CBase, MCameraObserver, public MContextBase {

public:

	CPictureTaker(MApp_context& aContext, CVisualCodeSystem& aObserver);
	void ConstructL();
	virtual ~CPictureTaker();
	void StartL(
		TBool aSendUpdates, 
		TBool aSendTranslation,
		TBool aSendRotation);
	void StopL(); 

	inline CFbsBitmap* GetBitmap() { return iBitmap; }

	void SetSendTranslation(TBool aSendTranslation);
	void SetSendRotation(TBool aSendRotation);

private:

	virtual void ReserveComplete(TInt aError);
	virtual void PowerOnComplete(TInt aError);
	virtual void ViewFinderFrameReady(CFbsBitmap& aFrame);
	virtual void ImageReady(CFbsBitmap* aBitmap, HBufC8* aData, TInt aError);
	virtual void FrameBufferReady(MFrameBuffer* aFrameBuffer, TInt aError);

private: 

	TBool GetImageMovement(CFbsBitmap& iBmp);

	TUint8* scanline;

	TInt (*blocks1)[10];
	TInt (*blocks2)[10];
	TInt currentBlock;

	TInt iMinDiffTranslation;
	TInt iMinDiffRotation;

private:

	CCamera* iCamera;
	CVisualCodeSystem& iObserver;

	enum TCameraState {
		EReleased,
		EStarted,
		EReserveComplete,
		EPowerOnComplete,
		EStopping
	};

	TCameraState iCameraState;

	TBool iStopRequest;

	CFbsBitmap* iBitmap;

	TBool iSendUpdates;
	TBool iSendTranslation;
	TBool iSendRotation;

	TPoint iTranslation;
	TInt iRotation;

	TInt iFrameCounter;

public:

	TInt debugTInt;
	TBuf<256> debugTBuf;

};

#endif

// End of File
