<?php

/*
 * $Id: enc.php,v 1.1 2005/10/03 13:21:43 mraento Exp $
 *
 * Visual Codes for Symbian OS
 * Copyright (C) 2004 Beat Gfeller, Michael Rohs (rohs@inf.ethz.ch)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/**
 * Linear (83,76,3) encoder.
 * It encodes a 76-bit message m to an 83-bit code word x using the
 * generating matrix G in the following way:<br><br>
 *
 * x = mG<br><br>
 *
 * x [1x83], m [1x76], G [76x83], G = (I<sub>76</sub> | A)<br>
 * <br><br>
 *
 * @author  Michael Rohs
 */

/** Generating matrix. */
$G = array(
	array("0x80000000", "0x0", "0x0"),
	array("0x40000000", "0x0", "0x0"),
	array("0x20000000", "0x0", "0x0"),
	array("0x10000000", "0x0", "0x0"),
	array("0x8000000", "0x0", "0x0"),
	array("0x4000000", "0x0", "0x0"),
	array("0x2000000", "0x0", "0x0"),
	array("0x1000000", "0x0", "0x0"),
	array("0x800000", "0x0", "0x0"),
	array("0x400000", "0x0", "0x0"),
	array("0x200000", "0x0", "0x0"),
	array("0x100000", "0x0", "0x0"),
	array("0x80000", "0x0", "0x0"),
	array("0x40000", "0x0", "0x0"),
	array("0x20000", "0x0", "0x0"),
	array("0x10000", "0x0", "0x0"),
	array("0x8000", "0x0", "0x0"),
	array("0x4000", "0x0", "0x0"),
	array("0x2000", "0x0", "0x0"),
	array("0x1000", "0x0", "0x0"),
	array("0x800", "0x0", "0x0"),
	array("0x400", "0x0", "0x0"),
	array("0x200", "0x0", "0x0"),
	array("0x100", "0x0", "0x0"),
	array("0x80", "0x0", "0x0"),
	array("0x40", "0x0", "0x0"),
	array("0x20", "0x0", "0x0"),
	array("0x10", "0x0", "0x0"),
	array("0x8", "0x0", "0x0"),
	array("0x4", "0x0", "0x0"),
	array("0x2", "0x0", "0x0"),
	array("0x1", "0x0", "0x0"),
	array("0x0", "0x80000000", "0x0"),
	array("0x0", "0x40000000", "0x0"),
	array("0x0", "0x20000000", "0x0"),
	array("0x0", "0x10000000", "0x0"),
	array("0x0", "0x8000000", "0x0"),
	array("0x0", "0x4000000", "0x0"),
	array("0x0", "0x2000000", "0x0"),
	array("0x0", "0x1000000", "0x0"),
	array("0x0", "0x800000", "0x0"),
	array("0x0", "0x400000", "0x0"),
	array("0x0", "0x200000", "0x0"),
	array("0x0", "0x100000", "0x0"),
	array("0x0", "0x80000", "0x80000000"),
	array("0x0", "0x40000", "0x40000000"),
	array("0x0", "0x20000", "0x20000000"),
	array("0x0", "0x10000", "0x10000000"),
	array("0x0", "0x8000", "0x8000000"),
	array("0x0", "0x4000", "0x4000000"),
	array("0x0", "0x2000", "0x2000000"),
	array("0x0", "0x1000", "0x1000000"),
	array("0x0", "0x800", "0x800000"),
	array("0x0", "0x400", "0x400000"),
	array("0x0", "0x200", "0x200000"),
	array("0x0", "0x100", "0x100000"),
	array("0x0", "0x80", "0x80000"),
	array("0x0", "0x40", "0x40000"),
	array("0x0", "0x20", "0x20000"),
	array("0x0", "0x10", "0x10000"),
	array("0x0", "0x8", "0x8000"),
	array("0x0", "0x4", "0x4000"),
	array("0x0", "0x2", "0x2000"),
	array("0x0", "0x1", "0x1000"),
	array("0x0", "0x0", "0x800"),
	array("0x0", "0x0", "0x400"),
	array("0x0", "0x0", "0x200"),
	array("0x0", "0x0", "0x100"),
	array("0x0", "0x0", "0x80"),
	array("0x0", "0x0", "0x40"),
	array("0x0", "0x0", "0x20"),
	array("0x0", "0x0", "0x10"),
	array("0x0", "0x0", "0x8"),
	array("0x0", "0x0", "0x4"),
	array("0x0", "0x0", "0x2"),
	array("0x0", "0x0", "0x1"),
	array("0x0", "0x7f", "0x7ffff"),
	array("0x3f", "0xffffff80", "0xfff80000"),
	array("0x1fffc0", "0x7fff80", "0xfff8000f"),
	array("0xfe03fc0", "0x7f807f80", "0x7f80ff0"),
	array("0x71e3c3c7", "0x8787878f", "0x7878f0f0"),
	array("0xb66cccd9", "0x999999b3", "0x999b3333"),
	array("0xdab5556a", "0xaaaaaad5", "0xaaad5555")
);



/**
 * Encode the 76-bit message to an 83-bit code word.
 * @param   bim	76-bit message
 * @return  83-bit code word
 */
function encode($message) 
{
//	print("encode: message = " . gmp_strval($message, 16) . "\n");

	global $G;
	$rows = count($G[0]);
	$cols = count($G);
//	print("rows = " . $rows . ", cols = " . $cols . "\n");

	$code = gmp_init("0");
	$shift = gmp_init("0x0100000000");
	$x = 64;

	while (1) {
		$onesCount = 0;
		$g = gmp_init($G[$x][$rows - 1]);
		for ($y = $rows - 2; $y >= 0; $y--) {
			$g = gmp_or(gmp_mul($g, $shift), gmp_init($G[$x][$y]));
		}
		$v = gmp_and($message, $g);
		
		while (gmp_cmp($v, 0) != 0) {
			if (gmp_cmp(gmp_and($v, 1), 1) == 0) {
				$onesCount = $onesCount + 1;
			}
			$v = gmp_div_q($v, 2);
		}
		
		$code = gmp_mul($code, 2);
		if ($onesCount & 1) $code = gmp_or($code, 1);
		
		$x++;
		if ($x == $cols) {
			$x = 32;
		} else if ($x == 64) {
			$x = 0;
		} else if ($x == 32) {
			break;
		}		
	}

//	print("encode: code = " . gmp_strval($code, 16) . "\n");
	return $code;
}



?>
