#!/usr/local/bin/php
<?php
define('FPDF_FONTPATH','/home/petit/public_html/cgi-bin/fpdf/font/');
require('fpdf.php');

# adding functionalities
class PDF extends FPDF
{
    function RoundedRect($x, $y, $w, $h,$r, $style = '')
    {
        $k = $this->k;
        $hp = $this->h;
        if($style=='F')
            $op='f';
        elseif($style=='FD' or $style=='DF')
            $op='B';
        else
            $op='S';
        $MyArc = 4/3 * (sqrt(2) - 1);
        $this->_out(sprintf('%.2f %.2f m',($x+$r)*$k,($hp-$y)*$k ));
        $xc = $x+$w-$r ;
        $yc = $y+$r;
        $this->_out(sprintf('%.2f %.2f l', $xc*$k,($hp-$y)*$k ));

        $this->_Arc($xc + $r*$MyArc, $yc - $r, $xc + $r, $yc - $r*$MyArc, $xc + $r, $yc);
        $xc = $x+$w-$r ;
        $yc = $y+$h-$r;
        $this->_out(sprintf('%.2f %.2f l',($x+$w)*$k,($hp-$yc)*$k));
        $this->_Arc($xc + $r, $yc + $r*$MyArc, $xc + $r*$MyArc, $yc + $r, $xc, $yc + $r);
        $xc = $x+$r ;
        $yc = $y+$h-$r;
        $this->_out(sprintf('%.2f %.2f l',$xc*$k,($hp-($y+$h))*$k));
        $this->_Arc($xc - $r*$MyArc, $yc + $r, $xc - $r, $yc + $r*$MyArc, $xc - $r, $yc);
        $xc = $x+$r ;
        $yc = $y+$r;
        $this->_out(sprintf('%.2f %.2f l',($x)*$k,($hp-$yc)*$k ));
        $this->_Arc($xc - $r, $yc - $r*$MyArc, $xc - $r*$MyArc, $yc - $r, $xc, $yc - $r);
        $this->_out($op);
    }

    function _Arc($x1, $y1, $x2, $y2, $x3, $y3)
    {
        $h = $this->h;
        $this->_out(sprintf('%.2f %.2f %.2f %.2f %.2f %.2f c ', $x1*$this->k, ($h-$y1)*$this->k,
            $x2*$this->k, ($h-$y2)*$this->k, $x3*$this->k, ($h-$y3)*$this->k));
    }

    var $angle=0;

    function Rotate($angle,$x=-1,$y=-1)
    {
        if($x==-1)
            $x=$this->x;
        if($y==-1)
            $y=$this->y;
        if($this->angle!=0)
            $this->_out('Q');
        $this->angle=$angle;
        if($angle!=0)
        {
           $angle*=M_PI/180;
           $c=cos($angle);
           $s=sin($angle);
           $cx=$x*$this->k;
           $cy=($this->h-$y)*$this->k;
           $this->_out(sprintf('q %.5f %.5f %.5f %.5f %.2f %.2f cm 1 0 0 1 %.2f %.2f cm',$c,$s,-$s,$c,$cx,$cy,-$cx,-$cy));
       }
   }

   function _endpage()
   {
       if($this->angle!=0)
       {
           $this->angle=0;
           $this->_out('Q');
       }
       parent::_endpage();
   }

   function RotatedText($x,$y,$txt,$angle)
   {
       //Text rotated around its origin
       $this->Rotate($angle,$x,$y);
       $this->Text($x,$y,$txt);
       $this->Rotate(0);
   }

   function RotatedImage($file,$x,$y,$w,$h,$angle)
   {
       //Image rotated around its upper-left corner
       $this->Rotate($angle,$x,$y);
       $this->Image($file,$x,$y,$w,$h);
       $this->Rotate(0);
   }
}

##############################################################
# Main parameters of the script

$scale=1; # scale of individual sticker
$r=0; #red colour component
$g=0; # green " "
$b=0; # blue " "
$image_file = '/home/petit/public_html/cgi-bin/test.png'; # default
$text = 'C'; # default text within the code
$title='ContextMedia'; # text on the left hand side
$url='http://www.cs.helsinki.fi/group/context/'; # url on the bottom right
$code=0; # code value
###############################################################

$full_url = getenv("REQUEST_URI");
$queryFull = parse_url($full_url);
$query = $queryFull['query'];
parse_str($query,$output);
if($output['red']) $r=$output['red'];
if($output['green']) $g=$output['green'];
if($output['blue']) $b=$output['blue'];
if($output['title']) $title=$output['title'];
if($output['url']) $url=$output['url'];
if($output['scale']) $scale=$output['scale'];
if($output['code']) $code=$output['code'];
if($output['text']) $text=$output['text'];
###############################################################3


#some const
$o_x=5;
$o_y=5;
$interspacing=5;
$page_height=297;
$page_width=210;
$sticker_length=160*$scale;
$sticker_height=50*$scale;
$nb_stickers_v = (int)($page_height/($sticker_height+$interspacing));
$nb_stickers_h = (int)($page_width/($sticker_length+$interspacing)); 



$pdf=new PDF();
$pdf->Open();
$pdf->AddPage();
for($i=0; $i<$nb_stickers_v; $i++) {
	$origin_y= $o_y + ($i*($sticker_height+$interspacing));

	for ($j=0; $j<$nb_stickers_h; $j++) {
		$origin_x = $o_x + ($j*($sticker_length + $interspacing));
		$code = $code +$i+$j;

		$r = $r - 10; if($r<0) $r=0;
		$g = $g - 10; if($g<0) $g=0;
		$b = $b - 10; if($b<0) $b=0;
	
		$y = $i % 4;
		if ($y==0) $text= '------ceci-n-est-ni-un-objet-ni-un-espace.';
		if ($y==1) $text='------remove-before-flight.-remove-before-flight.';
		if ($y==2) $text='------do-not-photograph.-do-not-photograph.';
		if ($y==3) $text='------these-are-not-the-codes-you-are-looking-for.';

		$call ='wget -O ' .$code .'.png http://db.cs.helsinki.fi/~mraento/vcgen/visualcode2.php?code=' .$code .'&text=' .$text .'&red=' .$r .'&green=' .$g .'&blue=' .$b;

		system(escapeshellcmd($call));

		$image_file =  $code .'.png';

		$font_size_1=16*$scale;
		$font_size_2=$font_size_1 / 2;
		$image_width=$sticker_height;
		$image_height=$sticker_height;
		$column_width= 2* $image_width / 11;
		$column_height =$image_height;
		$rr = 6 * $scale;

		$text_1_offset_x=$origin_x +(7*$scale);
		$text_1_offset_y=$origin_y +(43*$scale);
		$text_2_offset_x=$origin_x +(84*$scale);
		$text_2_offset_y=$origin_y +(49*$scale);
		$image_offset_x=$origin_x + (20*$scale);
		$image_offset_y=$origin_y;

		$pdf->SetFillColor($r, $g, $b);
		$pdf->SetDrawColor($r, $g, $b);
		$pdf->SetTextColor(255,255,255);

		$pdf->RoundedRect($origin_x, $origin_y, $sticker_length, $sticker_height, $rr, 'DF');
		$pdf->SetFont('Arial','',$font_size_1);
		$pdf->RotatedText($text_1_offset_x, $text_1_offset_y, $title, 90);
		$pdf->SetFont('Arial','',$font_size_2);
		$pdf->Text($text_2_offset_x, $text_2_offset_y, $url);
		$pdf->Image($image_file, $image_offset_x, $image_offset_y, $image_width, $image_height);
		$pdf->SetFillColor(255);
		$pdf->SetDrawColor(255);
		$pdf->Rect($image_offset_x-$column_width, $image_offset_y, $column_width, $image_height, 'DF');
		$pdf->Rect($image_offset_x+$image_width, $image_offset_y, $column_width, $image_height, 'DF');
	}
}
$pdf->Output();
?>
