#!/home/mraento/extras/bin/php
<?php

/*
 * $Id: visualcode2.php,v 1.1 2005/10/03 13:21:43 mraento Exp $
 *
 * Visual Codes for Symbian OS
 * Copyright (C) 2004 Beat Gfeller, Michael Rohs (rohs@inf.ethz.ch)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/**
 * Purpose: Generate a .png image of a visual code from the supplied argument.
 *          Encodes the least significant 76 bits of the argument, which is
 *          interpreted as a decimal or hexacecimal (0x...) integer. The 
 *          76-bit message is encoded to an 83-bit code word.
 *
 * Invocation:
 *     http://<host[:port]>/visualcode.php?code=<decimal or hexdecimal code value>
 *
 * Invocation example:
 *     http://vs6.inf.ethz.ch:8080/visualcode.php?code=0x123abc
 *
 * From within an HTML form:
 *
 *     <head>
 *     ...
 *     <script type="text/javascript">
 *     <!--
 *     function ShowVisualCode() {
 *       document.images["DynamicVisualCode"].src =
 *         "http://vs6.inf.ethz.ch:8080/visualcode.php?code=" +
 *         document.VisualCodeForm.Code.value;
 *     }
 *     //-->
 *     </script>
 *     </head>
 *
 *     ...
 *
 *     <img src="http://vs6.inf.ethz.ch:8080/visualcode.php?code=0x123abc"
 *          name="DynamicVisualCode">
 *     <form name="VisualCodeForm" action="" method="POST">
 *     <input type="text" name="Code" size="25"  maxlength="25"
 *            onKeyup="ShowVisualCode()" value="0x123abc">
 *     <!-- <input type="button" value="Show" onClick="ShowVisualCode()"> -->
 *     </form>
 *
 * PHP installation note:
 *
 *     The PHP module has to be configured with support for
 *     - the GD library of image functions and
 *     - the GNU MP library (for arbitrary-length integers).
 *
 *     $ cd php-NN
 *     $ ./configure --with-apxs2=/usr/local/apache2/bin/apxs
 *                   --with-gd
 *                   --with-ttf
 *                   --enable-gd-native-ttf
 *                   --with-zlib-dir
 *                   --with-gmp
 *
 * @author: Michael Rohs (rohs@inf.ethz.ch)
 *
 */

header("Content-type: image/png");
//header("Content-type: text/plain");

// retrive the code value

function getfont($char)
{
	if ($char == "!") $char="em";
	if ($char == ".") $char="pd";
	if ($char == "?") $char="qm";
	if ($char == ",") $char="cm";

	return "font/" . $char . ".png";
}

$code_str = substr($_REQUEST["code"], 0, 256);
$code_str = ereg_replace("[^0-9a-fA-FxX]", "", $code_str);
$code = gmp_init($code_str);

$text = $_REQUEST["text"];
if (strlen($text)==0) {
	$text="powered by ContextPhone";
}
$text = ereg_replace("[^a-zA-Z0-9.,!?]", "_", $text);
$text = strtolower($text);
$text .= "_____________________________________________________________________";
$textpos = 0;

// encode number with an error detection code

require "enc.php";
$code = encode($code);

// apply 10-byte mask

$mask = gmp_init("0x7fa7ea7fa7ea7fa7ea7f");
$code = gmp_xor($code, $mask);

// set dimensions of code elements and surrounding margin

$t = 16; // width and height of a single code element in pixels
$margin = 0; // margin around the image in pixels
$w = 2 * $margin + 11 * $t;
$h = $w;

// create image

$img = @imagecreate($w-1, $h-1)
	or die("Cannot initialize new GD image stream.");

$bg = imagecolorallocate($img, 255, 255, 255);
$red = $_REQUEST["red"];
$green = $_REQUEST["green"];
$blue = $_REQUEST["blue"];
$fg = imagecolorallocate($img, $red, $green, $blue);

// display code value as text
// imagestring($img, 1, 0, 0, $code_str, $fg);

// cornerstones

imagefilledrectangle($img, $margin, $margin, $margin+$t-1, $margin+$t-1, $fg);
imagefilledrectangle($img, $margin+10*$t, $margin, $margin+11*$t-2, $margin+$t-1, $fg);
imagefilledrectangle($img, $margin, $margin+10*$t, $margin+$t-1, $margin+11*$t-2, $fg);

// orientation bars

imagefilledrectangle($img, $margin+6*$t, $margin+10*$t, $margin+11*$t-2, $margin+11*$t-2, $fg);
imagefilledrectangle($img, $margin+10*$t, $margin+2*$t, $margin+11*$t-2, $margin+9*$t-1, $fg);

$index = 0;
$next_set_bit = gmp_scan1($code, 0);

// top (14 bits)

for ($j=0; $j<2; $j++) {
	for ($i=2; $i<9; $i++) {
		if ($index == $next_set_bit) {
			$x = $margin+$i*$t;
			$y = $margin+$j*$t;
			$char = substr($text, $charpos, 1);
			$charpos++;
			imagefilledrectangle($img, $x, $y, $x+$t-1, $y+$t-1, $fg);
			if (strlen($char)==1) {
				$filen = getfont($char);
				$font = imagecreatefrompng($filen);
				imagecopymerge($img, $font, $x, $y, 0, 0, 16, 16, 30);
			}
			$next_set_bit = gmp_scan1($code, $index+1);
		}
		$index++;
	}
}

// middle

for ($j=2; $j<9; $j++) {
	for ($i=0; $i<9; $i++) {
		if ($index == $next_set_bit) {
			$x = $margin+$i*$t;
			$y = $margin+$j*$t;
			imagefilledrectangle($img, $x, $y, $x+$t-1, $y+$t-1, $fg);
			$char = substr($text, $charpos, 1);
			$charpos++;
			if (strlen($char)==1) {
				$filen = getfont($char);
				$font = imagecreatefrompng($filen);
				imagecopymerge($img, $font, $x, $y, 0, 0, 16, 16, 30);
			}
			$next_set_bit = gmp_scan1($code, $index+1);
		}
		$index++;
	}
}

// bottom (10 bits)

for ($j=9; $j<11; $j++) {
	for ($i=2; $i<5; $i++) {
		if ($index == $next_set_bit) {
			$x = $margin+$i*$t;
			$y = $margin+$j*$t;
			imagefilledrectangle($img, $x, $y, $x+$t-1, $y+$t-1, $fg);
			$char = substr($text, $charpos, 1);
			$charpos++;
			if (strlen($char)==1) {
				$filen = getfont($char);
				$font = imagecreatefrompng($filen);
				imagecopymerge($img, $font, $x, $y, 0, 0, 16, 16, 30);
			}
			$next_set_bit = gmp_scan1($code, $index+1);
		}
		$index++;
	}
}

imagepng($img);
imagedestroy($img);



?>
