#!/usr/bin/perl

@dirs=qw( autostart ContextNotify ContextNotifyClient ContextCommon
starter ContextClient BlackBoard BlackBoardClient ContextSensors ContextNetwork
BlackBoardServer ContextCommon2 ContextMedia ContextSensors ContextUI ContextMedia
Recognizer ContextServer ContextMediaApp Context_log ContextContacts 
ContextCallLog );

$hs{"context_uids.h"}=1;
$hs{"context_uids.rh"}=1;

$|=1;
print "processing directories for includes";
foreach $dir (@dirs) {
	print ".";
	unless (chdir("$dir/inc")) {
		print STDERR "cannot chdir to $dir/inc";
		next;
	}
	foreach my $h (<*.h *.H>) {
		$hs{$h}=1;
	}
	chdir("../..");
}
print "\n";

print "processing directories for code\n";
#@dirs=qw(starter);
foreach $dir (@dirs) {
	print "  $dir/src";
	unless (chdir("$dir/src")) {
		print STDERR "cannot chdir to $dir/src";
		next;
	}
	foreach my $cpp (<*.cpp>) {
		print ".";
		unless (open(IN, "<$cpp")) {
			print STDERR "cannot open $dir/src/$cpp for reading";
			next;
		}
		unless (open(OUT, ">${cpp}.bak")) {
			close(IN);
			print STDERR "cannot open $dir/src/${cpp}.bar for writing";
			next;
		}
		while(<IN>) {
			if (/^#include\s+<([^>]+)>\s+$/) {
				$f=$1;
				if ($hs{$f}) {
					print OUT '#include "', $f, '"', "\n";
					next;
				}
			}
			print OUT $_;
		}
		close(IN); close(OUT);
		system("cp ${cpp}.bak $cpp");
	}
	print "\n";
	chdir("../..");
}
