/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/

#ifndef CONTEXT_LOGAPPUI_H
#define CONTEXT_LOGAPPUI_H

#define NULL 0

#include "ver.h"

// INCLUDES
#include <eikapp.h>
#include <eikdoc.h>
#include <e32std.h>
#include <coeccntx.h>
#include <aknappui.h>
#include <aknviewappui.h>
#include <akntabgrp.h>
#include <aknnavide.h>

#include <aknglobalnote.h>
#include <sendui.h>
#include <AknQueryDialog.h>
#include <aknkeylock.h>


#include "log_cellid.h"
#include "log_profile.h"
#include "file_logger.h"
#include "bb_logger.h"
//#include "log_test.h"
#include "log_sms.h"

#include "log_base_impl.h"

#include "log_comm.h"
#include "transfer.h"
#include "discover.h"

#include "bases.h"
//#include "answering.h"
#include "independent.h"

#include "locationing.h"
#include "status_notif.h"
#include "app_context.h"

//#include "log_soundlevel.h"
#include "call_recorder.h"
#include "log_local.h"
#include "log_idle.h"
#include "log_appuse.h"

#include "presence_publisher.h"

#include "context_logcontainer.h"
#include "statusview.h"
#include "settingsview.h"
#include "applogview.h"

#include "db.h"
#include "cellmap.h"

#include "circular.h"
#include "timeout.h"
#include "list.h"

#include "keycapture.h"

//#include "route.h"
#include "user_notifier.h"

#include "codeprompt.h"

#include "alerter.h"
#include "log_gps.h"
#include <sendas.h>
#include "bt_dev_ap_view.h"
#include "bt_access_point.h"

#include <csd_cell.h>
#include "operatormap.h"
#include "uploadview.h"
#include <reporting.h>

class CSmsSocket;
class CSmsSnapshot;

class name_cell_callback;
class keylock_observer;
class CAppLogView;
class CApSettingMaintainer;
class CNotifyState;
class CBTDeviceList;
class CTransferDir;
class CPicturePublisher;
class CPresenceDetailView;
class CPresenceDescriptionView;

// CONSTANTS
//const ?type ?constant_var = ?constant;


// CLASS DECLARATION

/**
* Application UI class.
* Provides support for the following features:
* - EIKON control architecture
* 
*/
class CContext_logAppUi : public CAknViewAppUi, public i_status_notif,
	public Mlogger, 
	public MCoeForegroundObserver, 
	public MSendAsObserver, 
	public MContextBase, 
	public MNaming,
	public MSocketObserver, public MTimeOut, public MPresencePublisherListener, 
	public MActiveErrorReporter,
	public MSettingListener
{
public: // // Constructors and destructor
	
	CContext_logAppUi(MApp_context& Context) : MContextBase(Context) { initialising=true; }
        /**
        * EPOC default constructor.
        */      
        void ConstructL();
	
        /**
        * Destructor.
        */      
        ~CContext_logAppUi();
        
public: // New functions
	void name_cell(const CAknQueryDialog::TTone tone=CAknQueryDialog::ENoTone, const TBBCellId & cell=TBBCellId(KCell),
		TTime time=TTime());
	void name_context();
	void record_description();
	void SetUserGiven();
	void RestoreUserGiven();
	
public: // Functions from base classes
	
private:
        // From MEikMenuObserver
        void DynInitMenuPaneL(TInt aResourceId,CEikMenuPane* aMenuPane);
public:
	// From MPresencPublisherListener
	void NotifyNewPresence(const CBBPresence*);

private:
	// i_Clog_comm_notif
	void finished();
	void error(const TDesC& descr);
	void status_change(const TDesC& status);
	
	// MActiveErrorReporter
	virtual void ReportError(const TDesC& Source,
		const TDesC& Reason, TInt Code);

	// MSocketObserver
	virtual void success(CBase* source) {
		if (source==iLastErrorFrom) {
			iLastErrorFrom=0;
			error(_L(""));
		}
	}
	virtual void error(CBase* source, TInt /*code*/, const TDesC& reason) { 
		iLastErrorFrom=source;
		error(reason);
	}
	virtual void info(CBase* source, const TDesC& msg) {
		if (source==iLastErrorFrom) {
			iLastErrorFrom=0;
			error(_L(""));
		}
		status_change(msg);
	}
	
	void now_at_location(const TBBCellId* Cell, TInt id, bool is_base, bool loc_changed, TTime time);

	virtual void NewSensorEventL(const TTupleName& aName, const TDesC& aSubName, const CBBSensorEvent& aEvent);

	// MSettingListener
	virtual void SettingChanged(TInt Setting);

        /**
        * From CEikAppUi, takes care of command handling.
        * @param aCommand command to be handled
        */
        void HandleCommandL(TInt aCommand);
	void HandleWsEventL(const TWsEvent& aEvent, CCoeControl* aDestination);
	
        /**
        * From CEikAppUi, handles key events.
        * @param aKeyEvent Event to handled.
        * @param aType Type of the key event. 
        * @return Response code (EKeyWasConsumed, EKeyWasNotConsumed). 
        */
        virtual TKeyResponse HandleKeyEventL(
		const TKeyEvent& aKeyEvent,TEventCode aType);
	void HandleSystemEventL  (  const TWsEvent &    aEvent  );
	
	virtual TErrorHandlerResponse HandleError
	    (TInt aError,
	     const SExtendedError& aExtErr,
	     TDes& aErrorText,
	     TDes& aContextText);

	void add_cellid_name(const TBBCellId& cellid, const TDesC& name);
	void write_to_output(const TDesC& str);
	void read_cellid_names(TUint version);

public:
	void hide();
	void unhide();

private:
	void LogAppEvent(const TDesC& msg);

public:
	void name_cells();
	void start_app(TUid app, TInt view);
	void DialogTest();	
	void PresenceDetails();
	void PresenceDescription();
private:
	//MCoeForegroundObserver
	void HandleGainingForeground();
	void HandleLosingForeground();

	// MSendAsObserver
	virtual TBool CapabilityOK(TUid /*aCapabilty*/, TInt /*aResponse*/) { return ETrue; }

	virtual void ProcessMessageL(TUid aUid,const TDesC8& aParams);

	void AddMediaPublisher(CPicturePublisher* aPublisher);
	void PublishOldMedia();
private: //Data
        
	CContext_logContainer* iAppContainer; 
	CStatusView*		iStatusView;

	HBufC * iCaptionMyContext;


	Cfile_logger* fl;
	CBBLogger*	bbl;
	Clog_cellid* lc;
	Clog_profile* lp;
	//Clog_soundlevel* ls;
	CLog_local*	ll;
	CLog_idle*	li;
	CLog_AppUse*	lau;
	CLog_sms*	lsms;

	CPresencePublisher*	iPresencePublisher;
	CCircularLog * iUserContextLog;
	HBufC* iUserContext;

	CUserNotifier * iUserNotifier;

	//log_test* lt;
	Mlog_base_impl * cell_ann, * context_ann, *app_log;
	
	RThread* t;
	independent_worker keycapture, bases_worker;
	
	RFile cellid_name_file, cellid_name_file_v1;
	TBuf8<128> buf;
	
	Clog_comm* comml;
	
	CSendUITransfer* transferer;

	CDiscover* discoverer;
	
	CAknGlobalNote* globalNote;
	
	bases* base_counter;
	CArrayFixFlat<TTime>* name_times;
	CArrayFixFlat<TBBCellId>* name_names;
	name_cell_callback* caller;
	
	bool initialising;
	
	enum ui_state { IDLE, NAME_CELLS };
	ui_state current_state;

	RAknKeyLock keylock;

	bool case_closed;
	bool ringing;

	//Canswering* answerer;
	Clocationing* loc;
	// ADD
	sms * smsh;

	CCall_record *in_recorder, *out_recorder;

	CPeriodicTransfer* iPeriodicTransfer;
	CConnectionOpener* iConnectionOpener;

	CDb		*iCellDb;
	CCellMap	*iCellMap;

	CBase		*iLastErrorFrom;
	CCircularLog	*iLastLog;
	bool		iShowingDialog;

	RSocketServ	iServ;
#ifdef __S60V2__
	RConnection	iConnection;
#endif

	TBuf<30> state;

	typedef void (CContext_logAppUi::*TCallBack)(void);
	CList<TCallBack> *iWaitingOps;
	CTimeOut	 *iWait;
	void QueueOp(TCallBack Op, int AfterSeconds=0);
	void expired(CBase*);

	TKeycaptureArgs	 iKeycaptureArgs;

	CArrayPtrFlat<CPicturePublisher> *iMediaPublishers;

	TBuf<6> prev; TBuf<30> not_avail;

	CPresenceDetailView	*iPresenceDetailView; // OWNED BY FRAMEWORK
	CPresenceDescriptionView	*iPresenceDescriptionView; // OWNED BY FRAMEWORK
	CUploadView		*iUploadView, *iUploadViewTagOnly; // OWNED BY FRAMEWORK
	CBTDevApView		*iBTDevApView, *iBTBuddiesView; // OWNED BY FRAMEWORK
	CAppLogView		*iLogView; // OWNED BY FRAMEWORK
	CVisualCodePrompt	*iCodePrompt;
	CMultiPrompt		*iMultiPrompt;
	CArrayPtrFlat<Mlog_base_impl>	*iLoggers;

	RFile			iTestFile; bool iTestFileOpen;

	//CRouteRecorder * iRouteRecorder;
	CAlerter*		iAlerter;
	CLogGps*		iGps;
	CNotifyState		*iContextRunning, *iLoggingRunning;
	CDb			*iBTDb;
	CBTDeviceList		*iBuddyBTs, *iLaptopBTs, *iDesktopBTs, *iPDABTs;
	CTransferDir		*iTransferDir;
	COperatorMap		*iOpMap;
	class CLocaSender	*iLocaSender;
	class CSmsStatusReplier	*iSmsStatus;

	class TOldPrompt	*iOldPrompt;
	CTimeOut		*iWatchDogTimer;
	class CNTPConnection	*iNTPConnection;
};

class name_cell_callback : public CCheckedActive {
public:
	name_cell_callback(CContext_logAppUi* i_ui);
	~name_cell_callback();
	void ConstructL();
	void call();
private:
	void CheckedRunL();
	void DoCancel();
	CContext_logAppUi* ui;
	RTimer timer;
	bool is_active;
};

#endif

class keylock_observer : public CCheckedActive {
public:
	keylock_observer() : CCheckedActive(EPriorityIdle, _L("keylock_observer")) { }
	~keylock_observer() { }
	void ConstructL() {
		User::LeaveIfError(keylock.Connect());
	}
private:
	RAknKeyLock keylock;
	};

// End of File
